set linesize 200
/****************************************************************************************#
#*                                                                                       #
#* Purpose: STATA program to create 3 permanent DTA data sets with the                   #     
#*          CPS July 2018, January 2019, and May 2019 data.                              #
#*                                                                                       #
#*          The program reads the files jul18pub.dat, jan19pub.dat, and may19pub.dat     #
#*          The output files are jul18pub_beta.dta, jan19pub_beta.dta, and               #
#*          may19pub_beta.dta                                                            # 
#*                                                                                       #
#*          The program does NOT use STATA dictionaries                                  #
#*                                                                                       #
#*****************************************************************************************/

/*****************************************************************************************
 Set working directory
 Input and output files are saved here
*****************************************************************************************/

cd "\\westat.com\DFS\NCIDCCPS\DCCPS - Global\Scientific Projects\TUS-CPS\Statistician\ifc\STATA work\prg"


//*****************************************************************************************
// Read CPS July 2018 file
//
// Create dictionary of CPS July 2018 file
file open dictionary  using ".\dictionary.dct", write replace

// Dictionary for CPS July 2018
//
set more off
file write dictionary   /// 
"infile dictionary {" _n ///
"_column(1)"    _tab  "str15  "  _tab  "HRHHID     "  _tab "%15s   "  _tab `""Household identifier (part 1)""' _n ///
"_column(16)"   _tab  "byte   "  _tab  "HRMONTH    "  _tab "%2f    "  _tab `""Month of interview""' _n ///
"_column(18)"   _tab  "int    "  _tab  "HRYEAR4    "  _tab "%4f    "  _tab `""Year of interview""' _n ///
"_column(22)"   _tab  "byte   "  _tab  "HURESPLI   "  _tab "%2f    "  _tab `""Line number of the current respondent""' _n ///
"_column(24)"   _tab  "int    "  _tab  "HUFINAL    "  _tab "%3f    "  _tab `""Final outcome code""' _n ///
"_column(29)"   _tab  "byte   "  _tab  "HETENURE   "  _tab "%2f    "  _tab `""Are your living quarters...""' _n ///
"_column(31)"   _tab  "byte   "  _tab  "HEHOUSUT   "  _tab "%2f    "  _tab `""Type of housing unit""' _n ///
"_column(33)"   _tab  "byte   "  _tab  "HETELHHD   "  _tab "%2f    "  _tab `""Is there a telephone in this house/apartment?""' _n ///
"_column(35)"   _tab  "byte   "  _tab  "HETELAVL   "  _tab "%2f    "  _tab `""Is there a telephone elsewhere on which people in this household can be contacted?""' _n ///
"_column(37)"   _tab  "byte   "  _tab  "HEPHONEO   "  _tab "%2f    "  _tab `""Is a telephone interview acceptable?""' _n ///
"_column(39)"   _tab  "byte   "  _tab  "HEFAMINC   "  _tab "%2f    "  _tab `""Family income""' _n ///
"_column(41)"   _tab  "byte   "  _tab  "HUTYPEA    "  _tab "%2f    "  _tab `""Type A non-interview reason""' _n ///
"_column(43)"   _tab  "byte   "  _tab  "HUTYPB     "  _tab "%2f    "  _tab `""Type B non-interview reason""' _n ///
"_column(45)"   _tab  "byte   "  _tab  "HUTYPC     "  _tab "%2f    "  _tab `""Type C non-interview reason""' _n ///
"_column(47)"   _tab  "double "  _tab  "HWHHWGT    "  _tab "%10.4f "  _tab `""Household weight""' _n /// 
"_column(57)"   _tab  "byte   "  _tab  "HRINTSTA   "  _tab "%2f    "  _tab `""Interview status""' _n ///
"_column(59)"   _tab  "byte   "  _tab  "HRNUMHOU   "  _tab "%2f    "  _tab `""Total number of persons living in the household (household members)""' _n ///
"_column(61)"   _tab  "byte   "  _tab  "HRHTYPE    "  _tab "%2f    "  _tab `""Household type""' _n ///
"_column(63)"   _tab  "byte   "  _tab  "HRMIS      "  _tab "%2f    "  _tab `""Month-in-sample""' _n ///
"_column(65)"   _tab  "byte   "  _tab  "HUINTTYP   "  _tab "%2f    "  _tab `""Type of interview""' _n ///
"_column(67)"   _tab  "byte   "  _tab  "HUPRSCNT   "  _tab "%2f    "  _tab `""Number of actual and attempted personal contacts""' _n ///
"_column(69)"   _tab  "byte   "  _tab  "HRLONGLK   "  _tab "%2f    "  _tab `""Longitudinal link indicator""' _n ///
"_column(71)"   _tab  "str5   "  _tab  "HRHHID2    "  _tab "%5s    "  _tab `""Household identifier (part 2)""' _n ///
"_column(76)"   _tab  "byte   "  _tab  "HWHHWTLN   "  _tab "%2f    "  _tab `""Line number (PULINENO) of the person whose PWSSWGT was donated as HWHHWGT for the household""' _n ///
"_column(79)"   _tab  "byte   "  _tab  "HUBUS      "  _tab "%2f    "  _tab `""Does anyone in this household have a business or a farm?""' _n ///
"_column(81)"   _tab  "byte   "  _tab  "HUBUSL1    "  _tab "%2f    "  _tab `""Enter line number for hubus = 1""' _n ///
"_column(83)"   _tab  "byte   "  _tab  "HUBUSL2    "  _tab "%2f    "  _tab `""Enter line number for hubus = 1""' _n ///
"_column(85)"   _tab  "byte   "  _tab  "HUBUSL3    "  _tab "%2f    "  _tab `""Enter line number for hubus = 1""' _n ///
"_column(87)"   _tab  "byte   "  _tab  "HUBUSL4    "  _tab "%2f    "  _tab `""Enter line number for hubus = 1""' _n ///
"_column(89)"   _tab  "byte   "  _tab  "GEREG      "  _tab "%2f    "  _tab `""Region""' _n ///
"_column(91)"   _tab  "byte   "  _tab  "GEDIV      "  _tab "%2f    "  _tab `""Division""' _n ///
"_column(93)"   _tab  "str2   "  _tab  "GESTFIPS   "  _tab "%2f    "  _tab `""Federal Information Processing Standards (FIPS) State code""' _n ///
"_column(96)"   _tab  "str5   "  _tab  "GTCBSA     "  _tab "%5f    "  _tab `""Specific metropolitan CBSA code""' _n ///
"_column(101)"  _tab  "str3   "  _tab  "GTCO       "  _tab "%3f    "  _tab `""FIPS county code""' _n ///
"_column(104)"  _tab  "byte   "  _tab  "GTCBSAST   "  _tab "%1f    "  _tab `""Principal city/balance status""' _n ///
"_column(105)"  _tab  "byte   "  _tab  "GTMETSTA   "  _tab "%1f    "  _tab `""Metropolitan status""' _n ///
"_column(106)"  _tab  "byte   "  _tab  "GTINDVPC   "  _tab "%1f    "  _tab `""Individual principal city""' _n ///
"_column(107)"  _tab  "byte   "  _tab  "GTCBSASZ   "  _tab "%1f    "  _tab `""Metropolitan area (CBSA) size""' _n ///
"_column(108)"  _tab  "str3   "  _tab  "GTCSA      "  _tab "%3f    "  _tab `""Consolidated Statistical Area (CSA) FIPS code""' _n ///
"_column(118)"  _tab  "byte   "  _tab  "PERRP      "  _tab "%2f    "  _tab `""Relationship to reference person""' _n ///
"_column(120)"  _tab  "byte   "  _tab  "PEPARENT   "  _tab "%2f    "  _tab `""Line number of parent""' _n ///
"_column(122)"  _tab  "byte   "  _tab  "PRTAGE     "  _tab "%2f    "  _tab `""Persons age""' _n ///
"_column(124)"  _tab  "byte   "  _tab  "PRTFAGE    "  _tab "%1f    "  _tab `""Top code flag for age""' _n ///
"_column(125)"  _tab  "byte   "  _tab  "PEMARITL   "  _tab "%2f    "  _tab `""Marital status""' _n ///
"_column(127)"  _tab  "byte   "  _tab  "PESPOUSE   "  _tab "%2f    "  _tab `""Line number of spouse""' _n ///
"_column(129)"  _tab  "byte   "  _tab  "PESEX      "  _tab "%2f    "  _tab `""Sex""' _n ///
"_column(131)"  _tab  "byte   "  _tab  "PEAFEVER   "  _tab "%2f    "  _tab `""Did you ever serve on active duty in the U.S. armed forces?""' _n ///
"_column(135)"  _tab  "byte   "  _tab  "PEAFNOW    "  _tab "%2f    "  _tab `""Are you now in the armed forces?""' _n ///
"_column(137)"  _tab  "byte   "  _tab  "PEEDUCA    "  _tab "%2f    "  _tab `""Highest level of school completed or degree received""' _n ///
"_column(139)"  _tab  "byte   "  _tab  "PTDTRACE   "  _tab "%2f    "  _tab `""Race""' _n ///
"_column(141)"  _tab  "byte   "  _tab  "PRDTHSP    "  _tab "%2f    "  _tab `""Detailed Hispanic origin group (Revised January 2014)""' _n ///
"_column(143)"  _tab  "byte   "  _tab  "PUCHINHH   "  _tab "%2f    "  _tab `""Change in household composition""' _n ///
"_column(147)"  _tab  "byte   "  _tab  "PULINENO   "  _tab "%2f    "  _tab `""Person's line number""' _n ///
"_column(151)"  _tab  "byte   "  _tab  "PRFAMNUM   "  _tab "%2f    "  _tab `""Family number recode""' _n ///
"_column(153)"  _tab  "byte   "  _tab  "PRFAMREL   "  _tab "%2f    "  _tab `""Family relationship recode""' _n ///
"_column(155)"  _tab  "byte   "  _tab  "PRFAMTYP   "  _tab "%2f    "  _tab `""Family type recode""' _n ///
"_column(157)"  _tab  "byte   "  _tab  "PEHSPNON   "  _tab "%2f    "  _tab `""Hispanic or non-Hispanic""' _n ///
"_column(159)"  _tab  "byte   "  _tab  "PRMARSTA   "  _tab "%2f    "  _tab `""Marital status based on Armed Forces participation""' _n ///
"_column(161)"  _tab  "byte   "  _tab  "PRPERTYP   "  _tab "%2f    "  _tab `""Type of person record recode""' _n ///
"_column(163)"  _tab  "int    "  _tab  "ENATVTY    "  _tab "%3f    "  _tab `""Country of birth""' _n ///
"_column(166)"  _tab  "int    "  _tab  "EMNTVTY    "  _tab "%3f    "  _tab `""Mother's country of birth""' _n ///
"_column(169)"  _tab  "int    "  _tab  "EFNTVTY    "  _tab "%3f    "  _tab `""Father's country of birth""' _n ///
"_column(172)"  _tab  "byte   "  _tab  "PRCITSHP   "  _tab "%2f    "  _tab `""Citizenship status""' _n ///
"_column(174)"  _tab  "byte   "  _tab  "PRCITFLG   "  _tab "%2f    "  _tab `""Citizenship allocation flag""' _n ///
"_column(176)"  _tab  "byte   "  _tab  "PRINUSYR   "  _tab "%2f    "  _tab `""Immigrant's year of entry""' _n ///
"_column(178)"  _tab  "byte   "  _tab  "PUSLFPRX   "  _tab "%2f    "  _tab `""Labor force information collected by self or proxy response""' _n ///
"_column(180)"  _tab  "byte   "  _tab  "PEMLR      "  _tab "%2f    "  _tab `""Monthly labor force recode""' _n ///
"_column(182)"  _tab  "byte   "  _tab  "PUWK       "  _tab "%2f    "  _tab `""Last week, did you do any work for (either) pay (or profit)?""' _n ///
"_column(184)"  _tab  "byte   "  _tab  "PUBUS1     "  _tab "%2f    "  _tab `""Last week, did you do any unpaid work in the family business or farm?""' _n ///
"_column(186)"  _tab  "byte   "  _tab  "PUBUS2OT   "  _tab "%2f    "  _tab `""Do you receive any payments or profits from the business?""' _n ///
"_column(188)"  _tab  "byte   "  _tab  "PUBUSCK1   "  _tab "%2f    "  _tab `""Check item 1 filter for questions on unpaid work""' _n ///
"_column(190)"  _tab  "byte   "  _tab  "PUBUSCK2   "  _tab "%2f    "  _tab `""Check item 2 skips owners of family busines who did not work last week""' _n ///
"_column(192)"  _tab  "byte   "  _tab  "PUBUSCK3   "  _tab "%2f    "  _tab `""Check item 3""' _n ///
"_column(194)"  _tab  "byte   "  _tab  "PUBUSCK4   "  _tab "%2f    "  _tab `""Check item 4""' _n ///
"_column(196)"  _tab  "byte   "  _tab  "PURETOT    "  _tab "%2f    "  _tab `""Retirement status (last month you were reported to be retired, are you still retired this month?)""' _n ///
"_column(198)"  _tab  "byte   "  _tab  "PUDIS      "  _tab "%2f    "  _tab `""Disability status (last month you were reported to have a disability.) Does your disability continue to prevent you from doing any kind of work for the next 6 months?""' _n ///
"_column(200)"  _tab  "byte   "  _tab  "PERET1     "  _tab "%2f    "  _tab `""Do you currently want a job, either full or part-time?""' _n ///
"_column(202)"  _tab  "byte   "  _tab  "PUDIS1     "  _tab "%2f    "  _tab `""Does your disability prevent you from accepting any kind of work during the next six months?""' _n ///
"_column(204)"  _tab  "byte   "  _tab  "PUDIS2     "  _tab "%2f    "  _tab `""Do you have a disability that prevents you from accepting any kind of work during the next six months?""' _n ///
"_column(206)"  _tab  "byte   "  _tab  "PUABSOT    "  _tab "%2f    "  _tab `""Last week did you have a job either full or part-time?""' _n ///
"_column(208)"  _tab  "byte   "  _tab  "PULAY      "  _tab "%2f    "  _tab `""Last week, were you on layoff from a job?""' _n ///
"_column(210)"  _tab  "byte   "  _tab  "PEABSRSN   "  _tab "%2f    "  _tab `""What is the main reason you were absent from work last week?""' _n ///
"_column(212)"  _tab  "byte   "  _tab  "PEABSPDO   "  _tab "%2f    "  _tab `""Are you being paid by your employer for any of the time off last week?""' _n ///
"_column(214)"  _tab  "byte   "  _tab  "PEMJOT     "  _tab "%2f    "  _tab `""Do you have more than one job?""' _n ///
"_column(216)"  _tab  "byte   "  _tab  "PEMJNUM    "  _tab "%2f    "  _tab `""Altogether, how many jobs did you have?""' _n ///
"_column(218)"  _tab  "byte   "  _tab  "PEHRUSL1   "  _tab "%2f    "  _tab `""How many hours per week do you usually work at your main job?""' _n ///
"_column(220)"  _tab  "byte   "  _tab  "PEHRUSL2   "  _tab "%2f    "  _tab `""How many hours per week do you usually work at your other (job/jobs)?""' _n ///
"_column(222)"  _tab  "byte   "  _tab  "PEHRFTPT   "  _tab "%2f    "  _tab `""Do you usually work 35 hours or more per week?""' _n ///
"_column(224)"  _tab  "int    "  _tab  "PEHRUSLT   "  _tab "%3f    "  _tab `""Sum of HRUSL1 and HRUSL2.""' _n ///
"_column(227)"  _tab  "byte   "  _tab  "PEHRWANT   "  _tab "%2f    "  _tab `""Do you want to work a full-time work week of 35 hours or more per week?""' _n ///
"_column(229)"  _tab  "byte   "  _tab  "PEHRRSN1   "  _tab "%2f    "  _tab `""What is your main reason for working part-time?""' _n ///
"_column(231)"  _tab  "byte   "  _tab  "PEHRRSN2   "  _tab "%2f    "  _tab `""What is the main reason you do not want to work full-time?""' _n ///
"_column(233)"  _tab  "byte   "  _tab  "PEHRRSN3   "  _tab "%2f    "  _tab `""What is the main reason you worked less than 35 hours last week?""' _n ///
"_column(235)"  _tab  "byte   "  _tab  "PUHROFF1   "  _tab "%2f    "  _tab `""Last week, did you lose or take off any hours from your job, for any reason such as illness, slack work, vacation, or holiday?""' _n ///
"_column(237)"  _tab  "byte   "  _tab  "PUHROFF2   "  _tab "%2f    "  _tab `""How many hours did you take off?""' _n ///
"_column(239)"  _tab  "byte   "  _tab  "PUHROT1    "  _tab "%2f    "  _tab `""Last week, did you work any overtime or extra hours (at your main job) that you do not usually work?""' _n ///
"_column(241)"  _tab  "byte   "  _tab  "PUHROT2    "  _tab "%2f    "  _tab `""How many additional hours did you work?""' _n ///
"_column(243)"  _tab  "byte   "  _tab  "PEHRACT1   "  _tab "%2f    "  _tab `""Last week, how many hours did you actually work at your job?""' _n ///
"_column(245)"  _tab  "byte   "  _tab  "PEHRACT2   "  _tab "%2f    "  _tab `""Last week, how many hours did you actually work at your other (job/jobs)""' _n ///
"_column(247)"  _tab  "int    "  _tab  "PEHRACTT   "  _tab "%3f    "  _tab `""Sum of PEHRACT1 and PEHRACT2""' _n ///
"_column(250)"  _tab  "byte   "  _tab  "PEHRAVL    "  _tab "%2f    "  _tab `""Last week, could you have worked full-time if the hours had been available?""' _n ///     
"_column(257)"  _tab  "byte   "  _tab  "PUHRCK1    "  _tab "%2f    "  _tab `""Check item 1""' _n ///                                                        
"_column(259)"  _tab  "byte   "  _tab  "PUHRCK2    "  _tab "%2f    "  _tab `""Check item 2 skips persons responding yes to HRFTPT out of PT series""' _n ///
"_column(261)"  _tab  "byte   "  _tab  "PUHRCK3    "  _tab "%2f    "  _tab `""Check item 3""' _n ///                                                        
"_column(263)"  _tab  "byte   "  _tab  "PUHRCK4    "  _tab "%2f    "  _tab `""Check item 4""' _n ///                                                        
"_column(265)"  _tab  "byte   "  _tab  "PUHRCK5    "  _tab "%2f    "  _tab `""Check item 5""' _n ///                                                        
"_column(267)"  _tab  "byte   "  _tab  "PUHRCK6    "  _tab "%2f    "  _tab `""Check item 6""' _n ///                                                        
"_column(269)"  _tab  "byte   "  _tab  "PUHRCK7    "  _tab "%2f    "  _tab `""Check item 7""' _n ///                                                        
"_column(271)"  _tab  "byte   "  _tab  "PUHRCK12   "  _tab "%2f    "  _tab `""Check item 12""' _n ///
"_column(273)"  _tab  "byte   "  _tab  "PULAYDT    "  _tab "%2f    "  _tab `""Has your employer given you a date to return to work?""' _n ///
"_column(275)"  _tab  "byte   "  _tab  "PULAY6M    "  _tab "%2f    "  _tab `""Have you been given any indication that you will be recalled to work within the next 6 months?""' _n ///
"_column(277)"  _tab  "byte   "  _tab  "PELAYAVL   "  _tab "%2f    "  _tab `""Could you have returned to work last week if you had been recalled?""' _n ///
"_column(279)"  _tab  "byte   "  _tab  "PULAYAVR   "  _tab "%2f    "  _tab `""Why is that?""' _n ///
"_column(281)"  _tab  "byte   "  _tab  "PELAYLK    "  _tab "%2f    "  _tab `""Even though you are to be called back to work, have you been looking for work during the last 4 weeks.""' _n ///
"_column(283)"  _tab  "int    "  _tab  "PELAYDUR   "  _tab "%3f    "  _tab `""Duration of layoff""' _n ///
"_column(286)"  _tab  "byte   "  _tab  "PELAYFTO   "  _tab "%2f    "  _tab `""FT/PT status of job from which sample person was on layoff from""' _n ///
"_column(288)"  _tab  "byte   "  _tab  "PULAYCK1   "  _tab "%2f    "  _tab `""Check item 1""' _n ///
"_column(290)"  _tab  "byte   "  _tab  "PULAYCK2   "  _tab "%2f    "  _tab `""Check item 2 screen for dependent layoff""' _n ///
"_column(292)"  _tab  "byte   "  _tab  "PULAYCK3   "  _tab "%2f    "  _tab `""Check item 3 filter for dependent I & O""' _n ///
"_column(294)"  _tab  "byte   "  _tab  "PULK       "  _tab "%2f    "  _tab `""Have you been doing anything to find work during the last 4 weeks?""' _n ///
"_column(296)"  _tab  "byte   "  _tab  "PELKM1     "  _tab "%2f    "  _tab `""What are all of the things you have done to find work during the last 4 weeks? (first method)""' _n ///
"_column(298)"  _tab  "byte   "  _tab  "PULKM2     "  _tab "%2f    "  _tab `""Anything else? (second method)""' _n ///
"_column(300)"  _tab  "byte   "  _tab  "PULKM3     "  _tab "%2f    "  _tab `""Anything else? (third method)""' _n ///
"_column(302)"  _tab  "byte   "  _tab  "PULKM4     "  _tab "%2f    "  _tab `""Anything else? (fourth method)""' _n ///
"_column(304)"  _tab  "byte   "  _tab  "PULKM5     "  _tab "%2f    "  _tab `""Anything else? (fifth method)""' _n ///
"_column(306)"  _tab  "byte   "  _tab  "PULKM6     "  _tab "%2f    "  _tab `""Anything else? (sixth method)""' _n ///
"_column(308)"  _tab  "byte   "  _tab  "PULKDK1    "  _tab "%2f    "  _tab `""You said you have been trying to find work. How did you go about looking? (first method)""' _n ///
"_column(310)"  _tab  "byte   "  _tab  "PULKDK2    "  _tab "%2f    "  _tab `""Anything else? (second method)""' _n ///
"_column(312)"  _tab  "byte   "  _tab  "PULKDK3    "  _tab "%2f    "  _tab `""Anything else? (third method)""' _n ///
"_column(314)"  _tab  "byte   "  _tab  "PULKDK4    "  _tab "%2f    "  _tab `""Anything else? (fourth method)""' _n ///
"_column(316)"  _tab  "byte   "  _tab  "PULKDK5    "  _tab "%2f    "  _tab `""Anything else? (fifth method)""' _n ///
"_column(318)"  _tab  "byte   "  _tab  "PULKDK6    "  _tab "%2f    "  _tab `""Anything else? (sixth method)""' _n ///
"_column(320)"  _tab  "byte   "  _tab  "PULKPS1    "  _tab "%2f    "  _tab `""Can you tell me more about what you did to search for work? (first method)""' _n ///
"_column(322)"  _tab  "byte   "  _tab  "PULKPS2    "  _tab "%2f    "  _tab `""Anything else? (second method)""' _n ///
"_column(324)"  _tab  "byte   "  _tab  "PULKPS3    "  _tab "%2f    "  _tab `""Anything else? (third method)""' _n ///
"_column(326)"  _tab  "byte   "  _tab  "PULKPS4    "  _tab "%2f    "  _tab `""Anything else? (fourth method)""' _n ///
"_column(328)"  _tab  "byte   "  _tab  "PULKPS5    "  _tab "%2f    "  _tab `""Anything else? (fifth method)""' _n ///
"_column(330)"  _tab  "byte   "  _tab  "PULKPS6    "  _tab "%2f    "  _tab `""Anything else? (sixth method)""' _n ///
"_column(332)"  _tab  "byte   "  _tab  "PELKAVL    "  _tab "%2f    "  _tab `""Last week, could you have started a job if one had been offered?""' _n ///
"_column(334)"  _tab  "byte   "  _tab  "PULKAVR    "  _tab "%2f    "  _tab `""Why is that?""' _n ///
"_column(336)"  _tab  "byte   "  _tab  "PELKLL1O   "  _tab "%2f    "  _tab `""Before you started looking for work, what were you doing: working, going to school, or something else?""' _n ///
"_column(338)"  _tab  "byte   "  _tab  "PELKLL2O   "  _tab "%2f    "  _tab `""Did you lose or quit that job, or was it a temporary job that ended?""' _n ///
"_column(340)"  _tab  "byte   "  _tab  "PELKLWO    "  _tab "%2f    "  _tab `""When last worked""' _n ///
"_column(342)"  _tab  "int    "  _tab  "PELKDUR    "  _tab "%3f    "  _tab `""Duration of job seeking""' _n ///
"_column(345)"  _tab  "byte   "  _tab  "PELKFTO    "  _tab "%2f    "  _tab `""FT/PT status of jobseeker""' _n ///
"_column(347)"  _tab  "byte   "  _tab  "PEDWWNTO   "  _tab "%2f    "  _tab `""Do you currently want a job, either full or part time?""' _n ///
"_column(349)"  _tab  "byte   "  _tab  "PEDWRSN    "  _tab "%2f    "  _tab `""What is the main reason you were not looking for work during the last 4 weeks?""' _n ///
"_column(351)"  _tab  "byte   "  _tab  "PEDWLKO    "  _tab "%2f    "  _tab `""Did you look for work at any time in the last 12 months""' _n ///
"_column(353)"  _tab  "byte   "  _tab  "PEDWWK     "  _tab "%2f    "  _tab `""Did you actually work at a job or business during the last 12 months?""' _n ///
"_column(355)"  _tab  "byte   "  _tab  "PEDW4WK    "  _tab "%2f    "  _tab `""Did you do any of this work during the last 4 weeks?""' _n ///
"_column(357)"  _tab  "byte   "  _tab  "PEDWLKWK   "  _tab "%2f    "  _tab `""Since you left that job or business have you looked for work?""' _n ///
"_column(359)"  _tab  "byte   "  _tab  "PEDWAVL    "  _tab "%2f    "  _tab `""Last week, could you have started a job if one had been offered?""' _n ///
"_column(361)"  _tab  "byte   "  _tab  "PEDWAVR    "  _tab "%2f    "  _tab `""Why is that?""' _n ///
"_column(363)"  _tab  "byte   "  _tab  "PUDWCK1    "  _tab "%2f    "  _tab `""Screen for discouraged workers""' _n ///
"_column(365)"  _tab  "byte   "  _tab  "PUDWCK2    "  _tab "%2f    "  _tab `""Screen for disabled""' _n ///
"_column(367)"  _tab  "byte   "  _tab  "PUDWCK3    "  _tab "%2f    "  _tab `""Filter for retired""' _n ///
"_column(369)"  _tab  "byte   "  _tab  "PUDWCK4    "  _tab "%2f    "  _tab `""Filter for passive job seekers""' _n ///
"_column(371)"  _tab  "byte   "  _tab  "PUDWCK5    "  _tab "%2f    "  _tab `""Filter for passive job seekers""' _n ///
"_column(373)"  _tab  "byte   "  _tab  "PEJHWKO    "  _tab "%2f    "  _tab `""Have you worked at a job or business at any time during the past 12 months?""' _n ///
"_column(375)"  _tab  "byte   "  _tab  "PUJHDP1O   "  _tab "%2f    "  _tab `""Did you do any of this work in the last 4 weeks?""' _n ///
"_column(377)"  _tab  "byte   "  _tab  "PEJHRSN    "  _tab "%2f    "  _tab `""What is the main reason you left your last job?""' _n ///
"_column(379)"  _tab  "byte   "  _tab  "PEJHWANT   "  _tab "%2f    "  _tab `""Do you intend to look for work during the next 12 months?""' _n ///
"_column(381)"  _tab  "byte   "  _tab  "PUJHCK1    "  _tab "%2f    "  _tab `""Filter for outgoing rotations""' _n ///
"_column(383)"  _tab  "byte   "  _tab  "PUJHCK2    "  _tab "%2f    "  _tab `""Filter for persons going through the I and O series""' _n ///
"_column(385)"  _tab  "byte   "  _tab  "PRABSREA   "  _tab "%2f    "  _tab `""Reason not at work and pay status""' _n ///
"_column(387)"  _tab  "byte   "  _tab  "PRCIVLF    "  _tab "%2f    "  _tab `""Civilian labor force""' _n ///
"_column(389)"  _tab  "byte   "  _tab  "PRDISC     "  _tab "%2f    "  _tab `""Discouraged worker recode""' _n ///
"_column(391)"  _tab  "byte   "  _tab  "PREMPHRS   "  _tab "%2f    "  _tab `""Reason not at work or hours at work""' _n ///
"_column(393)"  _tab  "byte   "  _tab  "PREMPNOT   "  _tab "%2f    "  _tab `""MLR - employed, unemployed, or NILF""' _n ///
"_column(395)"  _tab  "byte   "  _tab  "PREXPLF    "  _tab "%2f    "  _tab `""Experienced labor force employment""' _n ///
"_column(397)"  _tab  "byte   "  _tab  "PRFTLF     "  _tab "%2f    "  _tab `""Full time labor force""' _n /// 
"_column(399)"  _tab  "byte   "  _tab  "PRHRUSL    "  _tab "%2f    "  _tab `""Usual hours worked weekly""' _n ///
"_column(401)"  _tab  "byte   "  _tab  "PRJOBSEA   "  _tab "%2f    "  _tab `""Job search recode""' _n ///
"_column(403)"  _tab  "byte   "  _tab  "PRPTHRS    "  _tab "%2f    "  _tab `""At work 1-34 by hours at work""' _n ///
"_column(405)"  _tab  "byte   "  _tab  "PRPTREA    "  _tab "%2f    "  _tab `""Detailed reason for part-time""' _n ///
"_column(407)"  _tab  "int    "  _tab  "PRUNEDUR   "  _tab "%3f    "  _tab `""Duration of unemployment for layoff and looking records""' _n ///
"_column(412)"  _tab  "byte   "  _tab  "PRUNTYPE   "  _tab "%2f    "  _tab `""Reason for unemployment""' _n ///
"_column(414)"  _tab  "byte   "  _tab  "PRWKSCH    "  _tab "%2f    "  _tab `""Labor force by time worked or lost""' _n ///
"_column(416)"  _tab  "byte   "  _tab  "PRWKSTAT   "  _tab "%2f    "  _tab `""Full/part-time work status""' _n ///
"_column(418)"  _tab  "byte   "  _tab  "PRWNTJOB   "  _tab "%2f    "  _tab `""NILF recode - want a job or other NILF""' _n ///
"_column(420)"  _tab  "byte   "  _tab  "PUJHCK3    "  _tab "%2f    "  _tab `""Job history check item""' _n ///
"_column(422)"  _tab  "byte   "  _tab  "PUJHCK4    "  _tab "%2f    "  _tab `""Screen for dependent NILF""' _n ///
"_column(424)"  _tab  "byte   "  _tab  "PUJHCK5    "  _tab "%2f    "  _tab `""Screen for dependent NILF""' _n ///
"_column(426)"  _tab  "byte   "  _tab  "PUIODP1    "  _tab "%2f    "  _tab `""Last month, it was reported that you worked for (employer's name). Do still work for (employer's name) (at your main job)?""' _n ///
"_column(428)"  _tab  "byte   "  _tab  "PUIODP2    "  _tab "%2f    "  _tab `""Have the usual activities and duties of your job changed since last month?""' _n ///
"_column(430)"  _tab  "byte   "  _tab  "PUIODP3    "  _tab "%2f    "  _tab `""Last month you were reported as (a/an) (occupation) and your usual activities were (description). Is this an accurate description of your current job?""' _n ///
"_column(432)"  _tab  "byte   "  _tab  "PEIO1COW   "  _tab "%2f    "  _tab `""Individual class of worker code on first job""' _n ///
"_column(434)"  _tab  "byte   "  _tab  "PUIO1MFG   "  _tab "%2f    "  _tab `""Is this business or organization mainly manufacturing, retail trade, wholesale trade, or something else?""' _n ///
"_column(442)"  _tab  "byte   "  _tab  "PEIO2COW   "  _tab "%2f    "  _tab `""Individual class of worker on second job.""' _n ///
"_column(444)"  _tab  "byte   "  _tab  "PUIO2MFG   "  _tab "%2f    "  _tab `""Is this business or organization mainly manufacturing, retail trade, wholesale trade, or something else?""' _n ///
"_column(452)"  _tab  "byte   "  _tab  "PUIOCK1    "  _tab "%2f    "  _tab `""I & O check item 1 screen for dependent I and O""' _n ///
"_column(454)"  _tab  "byte   "  _tab  "PUIOCK2    "  _tab "%2f    "  _tab `""I & O check item 2 screen for previous months I and O cases""' _n ///
"_column(456)"  _tab  "byte   "  _tab  "PUIOCK3    "  _tab "%2f    "  _tab `""I & O check item 3""' _n ///
"_column(458)"  _tab  "byte   "  _tab  "PRIOELG    "  _tab "%2f    "  _tab `""Industry and occupation eligibility flag""' _n ///
"_column(460)"  _tab  "byte   "  _tab  "PRAGNA     "  _tab "%2f    "  _tab `""Agriculture/non-agriculture industry""' _n ///
"_column(462)"  _tab  "byte   "  _tab  "PRCOW1     "  _tab "%2f    "  _tab `""Class of worker recode - job 1""' _n ///
"_column(464)"  _tab  "byte   "  _tab  "PRCOW2     "  _tab "%2f    "  _tab `""Class of worker recode - job 2""' _n ///
"_column(466)"  _tab  "byte   "  _tab  "PRCOWPG    "  _tab "%2f    "  _tab `""COW - private or government""' _n ///
"_column(468)"  _tab  "byte   "  _tab  "PRDTCOW1   "  _tab "%2f    "  _tab `""Detailed class of worker recode - job 1""' _n ///
"_column(470)"  _tab  "byte   "  _tab  "PRDTCOW2   "  _tab "%2f    "  _tab `""Detailed class of worker recode - job 2""' _n ///
"_column(472)"  _tab  "byte   "  _tab  "PRDTIND1   "  _tab "%2f    "  _tab `""Detailed industry recode - job 1""' _n ///
"_column(474)"  _tab  "byte   "  _tab  "PRDTIND2   "  _tab "%2f    "  _tab `""Detailed industry recode - job 2""' _n ///
"_column(476)"  _tab  "byte   "  _tab  "PRDTOCC1   "  _tab "%2f    "  _tab `""Detailed occupation recode - job 1""' _n ///
"_column(478)"  _tab  "byte   "  _tab  "PRDTOCC2   "  _tab "%2f    "  _tab `""Detailed occupation recode - job 2""' _n ///
"_column(480)"  _tab  "byte   "  _tab  "PREMP      "  _tab "%2f    "  _tab `""Employed persons (non-farm & non-private hhld) recode""' _n ///
"_column(482)"  _tab  "byte   "  _tab  "PRMJIND1   "  _tab "%2f    "  _tab `""Major industry recode - job 1""' _n ///
"_column(484)"  _tab  "byte   "  _tab  "PRMJIND2   "  _tab "%2f    "  _tab `""Major industry recode - job 2""' _n ///
"_column(486)"  _tab  "byte   "  _tab  "PRMJOCC1   "  _tab "%2f    "  _tab `""Major occupation recode - job 1""' _n ///
"_column(488)"  _tab  "byte   "  _tab  "PRMJOCC2   "  _tab "%2f    "  _tab `""Major occupation recode - job 2""' _n ///
"_column(490)"  _tab  "byte   "  _tab  "PRMJOCGR   "  _tab "%2f    "  _tab `""Major occupation categories""' _n ///
"_column(492)"  _tab  "byte   "  _tab  "PRNAGPWS   "  _tab "%2f    "  _tab `""Non-agriculture, private wage and salary workers recode""' _n ///
"_column(494)"  _tab  "byte   "  _tab  "PRNAGWS    "  _tab "%2f    "  _tab `""Non-agriculture wage and salary workers recode""' _n ///
"_column(496)"  _tab  "byte   "  _tab  "PRSJMJ     "  _tab "%2f    "  _tab `""Single/multiple jobholder recode""' _n ///
"_column(498)"  _tab  "byte   "  _tab  "PRERELG    "  _tab "%2f    "  _tab `""Earnings eligibility flag""' _n ///
"_column(500)"  _tab  "byte   "  _tab  "PEERNUOT   "  _tab "%2f    "  _tab `""Do you usually receive overtime pay, tips, or commissions at your job?""' _n ///
"_column(502)"  _tab  "byte   "  _tab  "PEERNPER   "  _tab "%2f    "  _tab `""Periodicity""' _n ///
"_column(504)"  _tab  "byte   "  _tab  "PEERNRT    "  _tab "%2f    "  _tab `""(Even though you told me it is easier to report your earnings (periodicity); Are you paid at an hourly rate on your (main/this) job?""' _n ///
"_column(506)"  _tab  "byte   "  _tab  "PEERNHRY   "  _tab "%2f    "  _tab `""Hourly/nonhourly status""' _n ///
"_column(508)"  _tab  "int    "  _tab  "PUERNH1C   "  _tab "%4f    "  _tab `""What is your hourly rate of pay on this job, excluding overtime pay, tips or commission?""' _n ///
"_column(512)"  _tab  "int    "  _tab  "PEERNH2    "  _tab "%4f    "  _tab `""(Excluding overtime pay, tips and commissions) what is your hourly rate of pay on your (main/this) job?""' _n ///
"_column(516)"  _tab  "int    "  _tab  "PEERNH1O   "  _tab "%4f    "  _tab `""Out variable for hourly rate of pay""' _n ///
"_column(520)"  _tab  "int    "  _tab  "PRERNHLY   "  _tab "%4f    "  _tab `""Recode for hourly rate""' _n ///
"_column(524)"  _tab  "byte   "  _tab  "PTHR       "  _tab "%1f    "  _tab `""Hourly pay - top code""' _n ///
"_column(525)"  _tab  "byte   "  _tab  "PEERNHRO   "  _tab "%2f    "  _tab `""Usual hours""' _n ///
"_column(527)"  _tab  "long   "  _tab  "PRERNWA    "  _tab "%8f    "  _tab `""Weekly earnings recode""' _n ///
"_column(535)"  _tab  "byte   "  _tab  "PTWK       "  _tab "%1f    "  _tab `""Weekly earnings - top code""' _n ///
"_column(540)"  _tab  "long   "  _tab  "PEERN      "  _tab "%8f    "  _tab `""Calculated weekly overtime amount""' _n ///
"_column(548)"  _tab  "long   "  _tab  "PUERN2     "  _tab "%8f    "  _tab `""Calculated weekly overtime amount""' _n ///
"_column(556)"  _tab  "byte   "  _tab  "PTOT       "  _tab "%1f    "  _tab `""Weekly overtime amount - top code""' _n ///
"_column(559)"  _tab  "byte   "  _tab  "PEERNWKP   "  _tab "%2f    "  _tab `""How many weeks a year do you get paid for?""' _n ///
"_column(561)"  _tab  "byte   "  _tab  "PEERNLAB   "  _tab "%2f    "  _tab `""On this job, are you a member of a labor union or of an employee association similar to a union?""' _n ///
"_column(563)"  _tab  "byte   "  _tab  "PEERNCOV   "  _tab "%2f    "  _tab `""On this job are you covered by a union or employee association contract?""' _n ///
"_column(565)"  _tab  "byte   "  _tab  "PENLFJH    "  _tab "%2f    "  _tab `""When did you last work at a job or business?""' _n ///
"_column(567)"  _tab  "byte   "  _tab  "PENLFRET   "  _tab "%2f    "  _tab `""Are you retired from a job or business?""' _n ///
"_column(569)"  _tab  "byte   "  _tab  "PENLFACT   "  _tab "%2f    "  _tab `""What best describes your situation at this time? For example, are you disabled, ill, in school, taking care of house or family, or something else?""' _n ///
"_column(571)"  _tab  "byte   "  _tab  "PUNLFCK1   "  _tab "%2f    "  _tab `""Not in labor force check item - 1""' _n ///
"_column(573)"  _tab  "byte   "  _tab  "PUNLFCK2   "  _tab "%2f    "  _tab `""Not in labor force check item - 2""' _n ///
"_column(575)"  _tab  "byte   "  _tab  "PESCHENR   "  _tab "%2f    "  _tab `""Last week, were you enrolled in a high school, college, or university?""' _n ///
"_column(577)"  _tab  "byte   "  _tab  "PESCHFT    "  _tab "%2f    "  _tab `""Are you enrolled in school as a full-time or part-time student?""' _n ///
"_column(579)"  _tab  "byte   "  _tab  "PESCHLVL   "  _tab "%2f    "  _tab `""Would that be high school, college, or university?""' _n ///
"_column(581)"  _tab  "byte   "  _tab  "PRNLFSCH   "  _tab "%2f    "  _tab `""NLF activity - in school or not in school""' _n ///
"_column(583)"  _tab  "double "  _tab  "PWFMWGT    "  _tab "%10.4f "  _tab `""Family weight""' _n ///
"_column(593)"  _tab  "double "  _tab  "PWLGWGT    "  _tab "%10.4f "  _tab `""Longitudinal weight""' _n /// 
"_column(603)"  _tab  "double "  _tab  "PWORWGT    "  _tab "%10.4f "  _tab `""Outgoing rotation weight""' _n ///
"_column(613)"  _tab  "double "  _tab  "PWSSWGT    "  _tab "%10.4f "  _tab `""Final weight""' _n ///
"_column(623)"  _tab  "double "  _tab  "PWVETWGT   "  _tab "%10.4f "  _tab `""Veterans weight""' _n ///
"_column(633)"  _tab  "byte   "  _tab  "PRCHLD     "  _tab "%2f    "  _tab `""Presence of own children < 18 years of age by selected age group""' _n ///
"_column(635)"  _tab  "byte   "  _tab  "PRNMCHLD   "  _tab "%2f    "  _tab `""Number of own children < 18 years of age""' _n ///       
"_column(637)"  _tab  "byte   "  _tab  "PXPDEMP1   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(639)"  _tab  "byte   "  _tab  "PRWERNAL   "  _tab "%2f    "  _tab `""Allocation flag weekly earnings recode (PRERNWA)""' _n ///
"_column(641)"  _tab  "byte   "  _tab  "PRHERNAL   "  _tab "%2f    "  _tab `""Allocation flag hourly earnings recode (PRERNHLY)""' _n ///
"_column(643)"  _tab  "byte   "  _tab  "HXTENURE   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(645)"  _tab  "byte   "  _tab  "HXHOUSUT   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(647)"  _tab  "byte   "  _tab  "HXTELHHD   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(649)"  _tab  "byte   "  _tab  "HXTELAVL   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///  
"_column(651)"  _tab  "byte   "  _tab  "HXPHONEO   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///                                        
"_column(653)"  _tab  "byte   "  _tab  "PXINUSYR   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(655)"  _tab  "byte   "  _tab  "PXRRP      "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(657)"  _tab  "byte   "  _tab  "PXPARENT   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///  
"_column(659)"  _tab  "byte   "  _tab  "PXAGE      "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(661)"  _tab  "byte   "  _tab  "PXMARITL   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(663)"  _tab  "byte   "  _tab  "PXSPOUSE   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(665)"  _tab  "byte   "  _tab  "PXSEX      "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(667)"  _tab  "byte   "  _tab  "PXAFWHN1   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(669)"  _tab  "byte   "  _tab  "PXAFNOW    "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(671)"  _tab  "byte   "  _tab  "PXEDUCA    "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(673)"  _tab  "byte   "  _tab  "PXRACE1    "  _tab "%2f    "  _tab `""Allocation flag""' _n ///        
"_column(675)"  _tab  "byte   "  _tab  "PXNATVTY   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(677)"  _tab  "byte   "  _tab  "PXMNTVTY   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(679)"  _tab  "byte   "  _tab  "PXFNTVTY   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(681)"  _tab  "byte   "  _tab  "PXNMEMP1   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(683)"  _tab  "byte   "  _tab  "PXHSPNON   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(685)"  _tab  "byte   "  _tab  "PXMLR      "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(687)"  _tab  "byte   "  _tab  "PXRET1     "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(689)"  _tab  "byte   "  _tab  "PXABSRSN   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(691)"  _tab  "byte   "  _tab  "PXABSPDO   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(693)"  _tab  "byte   "  _tab  "PXMJOT     "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(695)"  _tab  "byte   "  _tab  "PXMJNUM    "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(697)"  _tab  "byte   "  _tab  "PXHRUSL1   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(699)"  _tab  "byte   "  _tab  "PXHRUSL2   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///                              
"_column(701)"  _tab  "byte   "  _tab  "PXHRFTPT   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(703)"  _tab  "byte   "  _tab  "PXHRUSLT   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(705)"  _tab  "byte   "  _tab  "PXHRWANT   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(707)"  _tab  "byte   "  _tab  "PXHRRSN1   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(709)"  _tab  "byte   "  _tab  "PXHRRSN2   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(711)"  _tab  "byte   "  _tab  "PXHRACT1   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(713)"  _tab  "byte   "  _tab  "PXHRACT2   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(715)"  _tab  "byte   "  _tab  "PXHRACTT   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(717)"  _tab  "byte   "  _tab  "PXHRRSN3   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(719)"  _tab  "byte   "  _tab  "PXHRAVL    "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(721)"  _tab  "byte   "  _tab  "PXLAYAVL   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(723)"  _tab  "byte   "  _tab  "PXLAYLK    "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(725)"  _tab  "byte   "  _tab  "PXLAYDUR   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(727)"  _tab  "byte   "  _tab  "PXLAYFTO   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(729)"  _tab  "byte   "  _tab  "PXLKM1     "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(731)"  _tab  "byte   "  _tab  "PXLKAVL    "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(733)"  _tab  "byte   "  _tab  "PXLKLL1O   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(735)"  _tab  "byte   "  _tab  "PXLKLL2O   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(737)"  _tab  "byte   "  _tab  "PXLKLWO    "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(739)"  _tab  "byte   "  _tab  "PXLKDUR    "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(741)"  _tab  "byte   "  _tab  "PXLKFTO    "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(743)"  _tab  "byte   "  _tab  "PXDWWNTO   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(745)"  _tab  "byte   "  _tab  "PXDWRSN    "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(747)"  _tab  "byte   "  _tab  "PXDWLKO    "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(749)"  _tab  "byte   "  _tab  "PXDWWK     "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(751)"  _tab  "byte   "  _tab  "PXDW4WK    "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(753)"  _tab  "byte   "  _tab  "PXDWLKWK   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(755)"  _tab  "byte   "  _tab  "PXDWAVL    "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(757)"  _tab  "byte   "  _tab  "PXDWAVR    "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(759)"  _tab  "byte   "  _tab  "PXJHWKO    "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(761)"  _tab  "byte   "  _tab  "PXJHRSN    "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(763)"  _tab  "byte   "  _tab  "PXJHWANT   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(765)"  _tab  "byte   "  _tab  "PXIO1COW   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(767)"  _tab  "byte   "  _tab  "PXIO1ICD   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(769)"  _tab  "byte   "  _tab  "PXIO1OCD   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(771)"  _tab  "byte   "  _tab  "PXIO2COW   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(773)"  _tab  "byte   "  _tab  "PXIO2ICD   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(775)"  _tab  "byte   "  _tab  "PXIO2OCD   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(777)"  _tab  "byte   "  _tab  "PXERNUOT   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(779)"  _tab  "byte   "  _tab  "PXERNPER   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(781)"  _tab  "byte   "  _tab  "PXERNH1O   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(783)"  _tab  "byte   "  _tab  "PXERNHRO   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(785)"  _tab  "byte   "  _tab  "PXERN      "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(787)"  _tab  "byte   "  _tab  "PXPDEMP2   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(789)"  _tab  "byte   "  _tab  "PXNMEMP2   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///                               
"_column(791)"  _tab  "byte   "  _tab  "PXERNWKP   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(793)"  _tab  "byte   "  _tab  "PXERNRT    "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(795)"  _tab  "byte   "  _tab  "PXERNHRY   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(797)"  _tab  "byte   "  _tab  "PXERNH2    "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(799)"  _tab  "byte   "  _tab  "PXERNLAB   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(801)"  _tab  "byte   "  _tab  "PXERNCOV   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///  
"_column(803)"  _tab  "byte   "  _tab  "PXNLFJH    "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(805)"  _tab  "byte   "  _tab  "PXNLFRET   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(807)"  _tab  "byte   "  _tab  "PXNLFACT   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(809)"  _tab  "byte   "  _tab  "PXSCHENR   "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(811)"  _tab  "byte   "  _tab  "PXSCHFT    "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(813)"  _tab  "byte   "  _tab  "PXSCHLVL   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///    
"_column(815)"  _tab  "long   "  _tab  "QSTNUM     "  _tab "%5f    "  _tab `""Unique household identifier.""' _n ///
"_column(820)"  _tab  "byte   "  _tab  "OCCURNUM   "  _tab "%2f    "  _tab `""Unique person identifier.""' _n ///
"_column(822)"  _tab  "byte   "  _tab  "PEDIPGED   "  _tab "%2f    "  _tab `""How did...get...'s high school diploma?""' _n ///
"_column(824)"  _tab  "byte   "  _tab  "PEHGCOMP   "  _tab "%2f    "  _tab `""What was the highest grade of regular school...completed before receiving...'s GED?""' _n ///
"_column(826)"  _tab  "byte   "  _tab  "PECYC      "  _tab "%2f    "  _tab `""How many years of college credit has...completed?""' _n ///
"_column(834)"  _tab  "byte   "  _tab  "PXDIPGED   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(836)"  _tab  "byte   "  _tab  "PXHGCOMP   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(838)"  _tab  "byte   "  _tab  "PXCYC      "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(846)"  _tab  "double "  _tab  "PWCMPWGT   "  _tab "%10.4f "  _tab `""Composited final weight. Used to create BLS's published labor force statistics""' _n ///
"_column(856)"  _tab  "int    "  _tab  "PEIO1ICD   "  _tab "%4f    "  _tab `""Industry code for primary job""' _n ///
"_column(860)"  _tab  "int    "  _tab  "PEIO1OCD   "  _tab "%4f    "  _tab `""Occupation code for primary job.""' _n ///
"_column(864)"  _tab  "int    "  _tab  "PEIO2ICD   "  _tab "%4f    "  _tab `""Industry code for second job.""' _n ///
"_column(868)"  _tab  "int    "  _tab  "PEIO2OCD   "  _tab "%4f    "  _tab `""Occupation code for second job.""' _n ///
"_column(872)"  _tab  "byte   "  _tab  "PRIMIND1   "  _tab "%2f    "  _tab `""Intermediate industry recode (job 1)""' _n ///
"_column(874)"  _tab  "byte   "  _tab  "PRIMIND2   "  _tab "%2f    "  _tab `""Intermediate industry recode (job 2)""' _n ///
"_column(876)"  _tab  "byte   "  _tab  "PEAFWHN1   "  _tab "%2f    "  _tab `""When did you serve?""' _n ///
"_column(878)"  _tab  "byte   "  _tab  "PEAFWHN2   "  _tab "%2f    "  _tab `""When did you serve?""' _n ///
"_column(880)"  _tab  "byte   "  _tab  "PEAFWHN3   "  _tab "%2f    "  _tab `""When did you serve?""' _n ///
"_column(882)"  _tab  "byte   "  _tab  "PEAFWHN4   "  _tab "%2f    "  _tab `""When did you serve?""' _n ///
"_column(884)"  _tab  "byte   "  _tab  "PXAFEVER   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(886)"  _tab  "byte   "  _tab  "PELNDAD    "  _tab "%2f    "  _tab `""Line number of father""' _n ///            
"_column(888)"  _tab  "byte   "  _tab  "PELNMOM    "  _tab "%2f    "  _tab `""Line number of mother""' _n ///      
"_column(890)"  _tab  "byte   "  _tab  "PEDADTYP   "  _tab "%2f    "  _tab `""Type of father""' _n /// 
"_column(892)"  _tab  "byte   "  _tab  "PEMOMTYP   "  _tab "%2f    "  _tab `""Type of mother""' _n /// 
"_column(894)"  _tab  "byte   "  _tab  "PECOHAB    "  _tab "%2f    "  _tab `""Line number of cohabiting partner""' _n ///
"_column(896)"  _tab  "byte   "  _tab  "PXLNDAD    "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(898)"  _tab  "byte   "  _tab  "PXLNMOM    "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(900)"  _tab  "byte   "  _tab  "PXDADTYP   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(902)"  _tab  "byte   "  _tab  "PXMOMTYP   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(904)"  _tab  "byte   "  _tab  "PXCOHAB    "  _tab "%2f    "  _tab `""Allocation flag""' _n /// 
"_column(906)"  _tab  "byte   "  _tab  "PEDISEAR   "  _tab "%2f    "  _tab `""Is...deaf or does ...have serious difficulty hearing?""' _n ///
"_column(908)"  _tab  "byte   "  _tab  "PEDISEYE   "  _tab "%2f    "  _tab `""Is...blind or does...have serious difficulty seeing even when wearing glasses?""' _n ///
"_column(910)"  _tab  "byte   "  _tab  "PEDISREM   "  _tab "%2f    "  _tab `""Because of a physical, mental, or emotional condition, does...have serious difficulty concentrating, remembering, or making decisions?""' _n ///
"_column(912)"  _tab  "byte   "  _tab  "PEDISPHY   "  _tab "%2f    "  _tab `""Does...have serious difficulty walking or climbing stairs?""' _n ///
"_column(914)"  _tab  "byte   "  _tab  "PEDISDRS   "  _tab "%2f    "  _tab `""Does...have difficulty dressing or bathing?""' _n ///
"_column(916)"  _tab  "byte   "  _tab  "PEDISOUT   "  _tab "%2f    "  _tab `""Because of a physical, mental, or emotional condition, does...have difficulty doing errands alone such as visiting a doctor’s office or shopping?""' _n ///
"_column(918)"  _tab  "byte   "  _tab  "PRDISFLG   "  _tab "%2f    "  _tab `""Does this person have any of these disability conditions?""' _n ///
"_column(920)"  _tab  "byte   "  _tab  "PXDISEAR   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(922)"  _tab  "byte   "  _tab  "PXDISEYE   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(924)"  _tab  "byte   "  _tab  "PXDISREM   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(926)"  _tab  "byte   "  _tab  "PXDISPHY   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(928)"  _tab  "byte   "  _tab  "PXDISDRS   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(930)"  _tab  "byte   "  _tab  "PXDISOUT   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(932)"  _tab  "byte   "  _tab  "HXFAMINC   "  _tab "%2f    "  _tab `""Allocation flag""' _n ///    
"_column(934)"  _tab  "byte   "  _tab  "PRDASIAN   "  _tab "%2f    "  _tab `""Detailed Asian race recode""' _n ///
"_column(936)"  _tab  "byte   "  _tab  "PEPDEMP1   "  _tab "%2f    "  _tab `""Does this person usually have any paid employees?""' _n ///
"_column(938)"  _tab  "byte   "  _tab  "PTNMEMP1   "  _tab "%2f    "  _tab `""Excluding all owners, how many paid employees does this person usually have?""' _n ///
"_column(940)"  _tab  "byte   "  _tab  "PEPDEMP2   "  _tab "%2f    "  _tab `""Does this person usually have any paid employees?""' _n ///
"_column(942)"  _tab  "byte   "  _tab  "PTNMEMP2   "  _tab "%2f    "  _tab `""Excluding all owners, how many paid employees does this person usually have?""' _n ///
"_column(944)"  _tab  "byte   "  _tab  "PECERT1    "  _tab "%2f    "  _tab `""Does...have a currently active professional certification or a state or industry license?""' _n ///        
"_column(946)"  _tab  "byte   "  _tab  "PECERT2    "  _tab "%2f    "  _tab `""Were any of …s certifications or licenses issued by the federal, state, or local government?""' _n ///
"_column(948)"  _tab  "byte   "  _tab  "PECERT3    "  _tab "%2f    "  _tab `""Earlier you told me that you had a currently active professional certification or license.  Is your certification or license required for your …""' _n ///
"_column(950)"  _tab  "byte   "  _tab  "PXCERT1    "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(952)"  _tab  "byte   "  _tab  "PXCERT2    "  _tab "%2f    "  _tab `""Allocation flag""' _n ///          
"_column(954)"  _tab  "byte   "  _tab  "PXCERT3    "  _tab "%2f    "  _tab `""Allocation flag""' _n ///
"_column(1001)" _tab  "byte   "  _tab  "PENXTPR    "  _tab "%2f    "  _tab `""Line number of person being interviewed""' _n ///        
"_column(1003)" _tab  "byte   "  _tab  "PENXTPR3   "  _tab "%2f    "  _tab `""Is this self or proxy?""' _n ///
"_column(1005)" _tab  "byte   "  _tab  "PEA1       "  _tab "%2f    "  _tab `""(Have/Has) (you/ name) smoked at least 100 cigarettes in (your/his/her) entire life? 100 cigarettes = approximately 5 packs""' _n ///
"_column(1007)" _tab  "int    "  _tab  "PEA2       "  _tab "%3f    "  _tab `""How old (were/was) (you/name) when (you/he/she) first started smoking cigarettes FAIRLY REGULARLY?""' _n ///
"_column(1010)" _tab  "int    "  _tab  "PEA2A      "  _tab "%3f    "  _tab `""You said that (you/name) never smoked regularly.  How old (were/was) (you/name) the first time (you/he/she) smoked part or all of a cigarette?""' _n ///
"_column(1013)" _tab  "byte   "  _tab  "PEA3       "  _tab "%2f    "  _tab `""(Do/Does) (you/name) now smoke cigarettes every day, some days, or not at all?""' _n ///
"_column(1015)" _tab  "int    "  _tab  "PTB1       "  _tab "%3f    "  _tab `""On the average, about how many cigarettes do you now smoke each day?""' _n ///        
"_column(1018)" _tab  "byte   "  _tab  "PEB1A      "  _tab "%2f    "  _tab `""Would you say that, on average, you now smoke more or less than 20 cigarettes each day?""' _n ///
"_column(1020)" _tab  "byte   "  _tab  "PEB2       "  _tab "%2f    "  _tab `""Do you usually smoke menthol or non-menthol cigarettes?""' _n /// 
"_column(1022)" _tab  "byte   "  _tab  "PEB5ANUM   "  _tab "%2f    "  _tab `""How soon after you wake up do you typically smoke your first cigarette of the day? (number)""' _n ///
"_column(1024)" _tab  "byte   "  _tab  "PEB5AUNT   "  _tab "%2f    "  _tab `""How soon after you wake up do you typically smoke your first cigarette of the day? (unit)""' _n ///
"_column(1026)" _tab  "byte   "  _tab  "PEB5B      "  _tab "%2f    "  _tab `""Would you say you smoke your first cigarette of the day within the first 30 minutes?""' _n ///
"_column(1028)" _tab  "byte   "  _tab  "PEBA6A     "  _tab "%2f    "  _tab `""Do you usually buy your own cigarettes?""' _n ///
"_column(1030)" _tab  "byte   "  _tab  "PEB6A      "  _tab "%2f    "  _tab `""Do you USUALLY buy your cigarettes by the pack or by the carton?""' _n ///
"_column(1032)" _tab  "double "  _tab  "PTB6B      "  _tab "%5f    "  _tab `""What price did you pay for the LAST pack of cigarettes you bought? Please report the cost after using discounts or coupons.""' _n ///
"_column(1037)" _tab  "double "  _tab  "PTB6C      "  _tab "%6f    "  _tab `""What price did you pay for the LAST carton of cigarettes you bought? Please report the cost after using discounts or coupons.""' _n ///
"_column(1043)" _tab  "byte   "  _tab  "PEB6C4     "  _tab "%2f    "  _tab `""Did you use coupons, rebates, or any other special promotions when you bought your LAST (B6a fill PACK/CARTON) of cigarettes?""' _n ///
"_column(1045)" _tab  "byte   "  _tab  "PEB6D1     "  _tab "%2f    "  _tab `""Did you buy your LAST (pack/carton) of cigarettes in (fill respondents state of residence) or in some other state?""' _n ///
"_column(1047)" _tab  "byte   "  _tab  "PEB6D21    "  _tab "%2f    "  _tab `""In what other state did you buy your LAST (pack/carton) of cigarettes?""' _n ///
"_column(1049)" _tab  "byte   "  _tab  "PEB6D3     "  _tab "%2f    "  _tab `""Did you buy you LAST (pack/carton) of cigarettes from an Indian reservation?""' _n ///
"_column(1051)" _tab  "byte   "  _tab  "PEB6DOTH   "  _tab "%2f    "  _tab `""Was the Other Way in which you purchased your LAST (pack/carton) of cigarettes:""' _n ///
"_column(1053)" _tab  "byte   "  _tab  "PEB6E1     "  _tab "%2f    "  _tab `""In the LAST 2 months, have you bought any SINGLE or INDIVIDUAL cigarettes?""' _n ///
"_column(1055)" _tab  "byte   "  _tab  "PEB6E31    "  _tab "%2f    "  _tab `""Did you buy your LAST SINGLE or INDIVIDUAL cigarette in [fill respondents state of residence] or in some other state or country?""' _n ///
"_column(1057)" _tab  "int    "  _tab  "PRB6E32A   "  _tab "%3f    "  _tab `""In what OTHER state or country did you buy your LAST SINGLE OR INDIVIDUAL cigarette?""' _n ///
"_column(1060)" _tab  "byte   "  _tab  "PEB6E4     "  _tab "%2f    "  _tab `""In the LAST 2 months, have you bought loose tobacco to roll-your-own cigarettes?""' _n ///
"_column(1062)" _tab  "byte   "  _tab  "PEB7C      "  _tab "%2f    "  _tab `""For how long have you smoked EVERY DAY?""' _n ///
"_column(1064)" _tab  "byte   "  _tab  "PEB7C2     "  _tab "%2f    "  _tab `""Have you EVER smoked MENTHOL cigarettes for 6 months or more?""' _n ///
"_column(1066)" _tab  "byte   "  _tab  "PEB7C3     "  _tab "%2f    "  _tab `""For how long (have you smoked/did you smoke) MENTHOL cigarettes?""' _n ///
"_column(1068)" _tab  "byte   "  _tab  "PEB8       "  _tab "%2f    "  _tab `""Around this time 12 MONTHS AGO, were you smoking cigarettes every day, some days, or not at all?""' _n ///
"_column(1070)" _tab  "int    "  _tab  "PTB9       "  _tab "%3f    "  _tab `""Around this time 12 months ago, on the average about how many cigarettes did you smoke each day?""' _n ///
"_column(1073)" _tab  "byte   "  _tab  "PEB10A     "  _tab "%2f    "  _tab `""Around this time 12 months age, on how many of 30 days in the month did you smoke cigarettes?""' _n ///
"_column(1075)" _tab  "int    "  _tab  "PTB10B     "  _tab "%3f    "  _tab `""On the average, on those (fill entry B10a) days, how many cigarettes did you usually smoke each day?""' _n ///
"_column(1078)" _tab  "byte   "  _tab  "PEC1       "  _tab "%2f    "  _tab `""On how many of the past 30 days did you smoke cigarettes?""' _n ///
"_column(1080)" _tab  "byte   "  _tab  "PEC1I      "  _tab "%2f    "  _tab `""Would you say you smoked on at least 12 days in the past 30 days?""' _n ///
"_column(1082)" _tab  "int    "  _tab  "PTC1A      "  _tab "%3f    "  _tab `""On the average, on those (fill entry C1) days, how many cigarettes did you usually smoke each day?""' _n ///
"_column(1085)" _tab  "byte   "  _tab  "PEC2       "  _tab "%2f    "  _tab `""Do you usually smoke menthol or non-menthol cigarettes?""' _n ///
"_column(1087)" _tab  "byte   "  _tab  "PEC5ANUM   "  _tab "%2f    "  _tab `""On the days that you smoke, how soon after you wake up do you typically smoke your first cigarette of the day? (number)""' _n ///        
"_column(1089)" _tab  "byte   "  _tab  "PEC5AUNT   "  _tab "%2f    "  _tab `""On the days that you smoke, how soon after you wake up do you typically smoke your first cigarette of the day? (unit)""' _n ///
"_column(1091)" _tab  "byte   "  _tab  "PEC5B      "  _tab "%2f    "  _tab `""On the days that you smoke, would you say you smoke your first cigarette of the day within the first 30 minutes?""' _n ///
"_column(1093)" _tab  "byte   "  _tab  "PECA6A     "  _tab "%2f    "  _tab `""Do you usually buy your own cigarettes?""' _n ///
"_column(1095)" _tab  "byte   "  _tab  "PEC6A      "  _tab "%2f    "  _tab `""Do you USUALLY buy your cigarettes by the pack or by the carton?""' _n ///
"_column(1097)" _tab  "double "  _tab  "PTC6B      "  _tab "%5f    "  _tab `""What price did you pay for the LAST pack of cigarettes you bought? Please report the cost after using discounts or coupons.""' _n ///
"_column(1102)" _tab  "double "  _tab  "PTC6C      "  _tab "%6f    "  _tab `""What price did you pay for the LAST carton of cigarettes you bought? Please report the cost after using discounts or coupons.""' _n ///
"_column(1108)" _tab  "byte   "  _tab  "PEC6C4     "  _tab "%2f    "  _tab `""Did you use coupons, rebates, or any other special promotions when you bought your LAST (pack/carton) of cigarettes?""' _n ///
"_column(1110)" _tab  "byte   "  _tab  "PEC6D1     "  _tab "%2f    "  _tab `""Did you buy your LAST (pack/carton) of cigarettes in (fill respondent's state of residence) or in some other state?""' _n ///
"_column(1112)" _tab  "byte   "  _tab  "PEC6D21    "  _tab "%2f    "  _tab `""In what other state did you buy your LAST (pack/carton) of cigarettes?""' _n ///
"_column(1114)" _tab  "byte   "  _tab  "PEC6D3     "  _tab "%2f    "  _tab `""Did you buy your LAST (pack/carton) of cigarettes from an Indian reservation?""' _n ///
"_column(1116)" _tab  "byte   "  _tab  "PEC6DOTH   "  _tab "%2f    "  _tab `""Was the 'Other Way' in which you purchased your Last (pack/carton) of cigarettes.""' _n ///
"_column(1118)" _tab  "byte   "  _tab  "PEC6E1     "  _tab "%2f    "  _tab `""In the LAST 2 months, have you bought any SINGLE or INDIVIDUAL cigarettes?""' _n ///
"_column(1120)" _tab  "byte   "  _tab  "PEC6E31    "  _tab "%2f    "  _tab `""Did you buy your LAST SINGLE or INDIVIDUAL cigarette in (fill respondents state of residence) or in some other state or other country?""' _n ///
"_column(1122)" _tab  "int    "  _tab  "PRC6E32A   "  _tab "%3f    "  _tab `""In what OTHER state or country did you buy your LAST SINGLE OR INDIVIDUAL cigarette?""' _n ///
"_column(1125)" _tab  "byte   "  _tab  "PEC6E4     "  _tab "%2f    "  _tab `""In the LAST 2 months, have you bought loose tobacco to roll-your-own cigarettes?""' _n ///
"_column(1127)" _tab  "byte   "  _tab  "PEC7A      "  _tab "%2f    "  _tab `""Have you EVER smoked cigarettes EVERY DAY for at least 6 months?""' _n ///
"_column(1129)" _tab  "byte   "  _tab  "PEC7D      "  _tab "%2f    "  _tab `""For how long did you smoke EVERY DAY?""' _n ///
"_column(1131)" _tab  "byte   "  _tab  "PEC7D2     "  _tab "%2f    "  _tab `""Have you EVER smoked MENTHOL cigarettes for 6 months or more?""' _n ///
"_column(1133)" _tab  "byte   "  _tab  "PEC7D3     "  _tab "%2f    "  _tab `""For how long (have you smoked/did you smoke) MENTHOL cigarettes?""' _n ///
"_column(1135)" _tab  "byte   "  _tab  "PTC7E      "  _tab "%2f    "  _tab `""When you last smoked every day, on average how many cigarettes did you smoke each day?""' _n ///
"_column(1137)" _tab  "byte   "  _tab  "PEC8       "  _tab "%2f    "  _tab `""Around this time 12 MONTHS AGO, were you smoking cigarettes every day, some days, or not at all?""' _n ///
"_column(1139)" _tab  "int    "  _tab  "PTC9       "  _tab "%3f    "  _tab `""Around this time 12 months ago, on the average about how many cigarettes did you smoke each day?""' _n ///
"_column(1142)" _tab  "byte   "  _tab  "PEC10A     "  _tab "%2f    "  _tab `""Around this time 12 months age, on how many of 30 days in the month did you smoke cigarettes?""' _n ///
"_column(1144)" _tab  "int    "  _tab  "PTC10B     "  _tab "%3f    "  _tab `""On the average, on those (fill entry c10a) days, how many cigarettes did you usually smoke each day?""' _n ///
"_column(1147)" _tab  "byte   "  _tab  "PEDa       "  _tab "%2f    "  _tab `""During the PAST 12 MONTHS, have you TRIED to QUIT smoking COMPLETELY?""' _n ///                                                                                                                                          
"_column(1149)" _tab  "byte   "  _tab  "PEDB       "  _tab "%2f    "  _tab `""Have you EVER TRIED to QUIT smoking COMPLETELY?""' _n ///
"_column(1151)" _tab  "byte   "  _tab  "PED1R      "  _tab "%2f    "  _tab `""During the PAST 12 MONTHS, have you stopped smoking for one day or longer BECAUSE YOU WERE TRYING TO QUIT SMOKING?""' _n ///                                                                                 
"_column(1153)" _tab  "byte   "  _tab  "PED3       "  _tab "%2f    "  _tab `""How many TIMES during the past 12 months have you stopped smoking for one day or longer BECAUSE YOU WERE TRYING TO QUIT SMOKING?""' _n ///                                                                   
"_column(1155)" _tab  "byte   "  _tab  "PED3B      "  _tab "%2f    "  _tab `""Would you say that during the past 12 months it was MORE THAN 3 TIMES that you have stopped smoking for one day or longer BECAUSE YOU WERE TRYING TO QUIT SMOKING/TRIED to QUIT smoking COMPLETELY?""' _n ///
"_column(1157)" _tab  "byte   "  _tab  "PED6NUM    "  _tab "%2f    "  _tab `""During the PAST 12 MONTHS, what is the length of this single quit attempt where you stopped smoking because you were TRYING to quit smoking? (number)""' _n ///
"_column(1159)" _tab  "byte   "  _tab  "PED6UNT    "  _tab "%2f    "  _tab `""During the PAST 12 MONTHS, what is the length of this single quit attempt where you stopped smoking because you were TRYING to quit smoking? (unit)""' _n ///
"_column(1161)" _tab  "byte   "  _tab  "PED6B      "  _tab "%2f    "  _tab `""Was it more or less than one week?""' _n ///
"_column(1163)" _tab  "byte   "  _tab  "PED6CNUM   "  _tab "%2f    "  _tab `""Thinking of those attempts during the past 12 months, what was the length of time of the ONE attempt that lasted the longest? (number)""' _n ///
"_column(1165)" _tab  "byte   "  _tab  "PED6CUNT   "  _tab "%2f    "  _tab `""Thinking of those attempts during the past 12 months, what was the length of time of the ONE attempt that lasted the longest? (unit)""' _n ///
"_column(1167)" _tab  "byte   "  _tab  "PED6C2     "  _tab "%2f    "  _tab `""Was it more or less than one week?""' _n ///
"_column(1169)" _tab  "byte   "  _tab  "PED7R      "  _tab "%2f    "  _tab `""DURING THE PAST 12 MONTHS, have you made a serious attempt to stop smoking because you were TRYING to quit – even if you stopped for less than a day?""' _n ///
"_column(1171)" _tab  "byte   "  _tab  "PED8R      "  _tab "%2f    "  _tab `""Have you EVER made a serious attempt to stop smoking because you were 'TRYING to quit'; even if you stopped for less than a day?""' _n ///
"_column(1173)" _tab  "byte   "  _tab  "PEE1A123   "  _tab "%2f    "  _tab `""Thinking back to the (LAST TIME/time) you tried to QUIT smoking in the past 12 months: Did you use ANY of the following PRODUCTS: A NICOTINE … patch, gum, lozenge, nasal spray or inhaler?""' _n ///
"_column(1175)" _tab  "byte   "  _tab  "PEE1A7AB   "  _tab "%2f    "  _tab `""Thinking back to the (LAST TIME/time) you tried to QUIT smoking in the past 12 months: Did you use ANY of the following PRODUCTS: A prescription pill, called Chantix, Varenicline, Zyban, Bupropion, or Wellbutrin?""' _n ///
"_column(1177)" _tab  "byte   "  _tab  "PEE1B1     "  _tab "%2f    "  _tab `""Thinking back to the (last time/time) you tried to QUIT smoking in the past 12 months. Did you use ANY of the following: A telephone help line or quit line?""' _n ///
"_column(1179)" _tab  "byte   "  _tab  "PEE1B2     "  _tab "%2f    "  _tab `""Thinking back to the (last time/time) you tried to QUIT smoking in the past 12 months. Did you use ANY of the following: One-on-one IN-PERSON counseling by a health professional?""' _n ///
"_column(1181)" _tab  "byte   "  _tab  "PEE1B3     "  _tab "%2f    "  _tab `""Thinking back to the (last time/time) you tried to QUIT smoking in the past 12 months. Did you use ANY of the following: A stop smoking clinic, class, or support group?""' _n ///
"_column(1183)" _tab  "byte   "  _tab  "PEE1B5     "  _tab "%2f    "  _tab `""Thinking back to the (last time/time) you tried to QUIT smoking in the past 12 months. Did you use ANY of the following: Internet or a web-based program or tool including smartphone apps and text messaging programs?""' _n ///
"_column(1185)" _tab  "byte   "  _tab  "PEE1C2     "  _tab "%2f    "  _tab `""The (last time/time) you tried to QUIT smoking in the past 12 months: Did you do ANY of the following: Try to quit by SWITCHING to smokeless tobacco such as chewing tobacco, snuff, or snus?""' _n ///
"_column(1187)" _tab  "byte   "  _tab  "PEE1C2B    "  _tab "%2f    "  _tab `""The (last time/time) you tried to QUIT smoking in the past 12 months. Did you do ANY of the following: Try to quit by SWITCHING to regular cigars, cigarillos, little filtered cigars or any pipes filled with tobacco?""' _n ///
"_column(1189)" _tab  "byte   "  _tab  "PEE1C2C    "  _tab "%2f    "  _tab `""The (last time/time) you tried to QUIT smoking in the past 12 months. Did you do ANY of the following: Try to quit by SWITCHING to electronic or E-cigarettes? You may also know them as vape-pens, e-hookah, vapes or mods.""' _n ///
"_column(1191)" _tab  "byte   "  _tab  "PEE1C2D1   "  _tab "%2f    "  _tab `""Did you switch to? Cigars, cigarillos, little filtered cigars.""' _n ///
"_column(1193)" _tab  "byte   "  _tab  "PEE1C2D2   "  _tab "%2f    "  _tab `""Did you switch to? Regular pipes filled with tobacco.""' _n ///
"_column(1195)" _tab  "byte   "  _tab  "PEE1C2D3   "  _tab "%2f    "  _tab `""Did you switch to? Water or hookah (pronounced who-kah) pipes filled with tobacco.""' _n ///
"_column(1197)" _tab  "byte   "  _tab  "PEE1CZ2C   "  _tab "%2f    "  _tab `""The (LAST TIME/TIME) you tried to quit smoking in the past 12 months, did you try to quit by SWITCHING to electronic or E-Cigarettes? You may also know them as vape-pens, e-hookah, vapes or mods.""' _n ///
"_column(1199)" _tab  "byte   "  _tab  "PEF1A      "  _tab "%2f    "  _tab `""In the PAST 12 MONTHS, have you seen a medical doctor?""' _n ///                                                                                                                                    
"_column(1201)" _tab  "byte   "  _tab  "PEF1B      "  _tab "%2f    "  _tab `""During the PAST 12 MONTHS, did any medical doctor ADVISE you to stop smoking?""' _n ///                                                                                                 
"_column(1203)" _tab  "byte   "  _tab  "PEG1       "  _tab "%2f    "  _tab `""Are you seriously considering quitting smoking within the next 6 months?""' _n ///                                                                                                      
"_column(1205)" _tab  "byte   "  _tab  "PEG2       "  _tab "%2f    "  _tab `""Are you planning to quit within the next 30 days?""' _n ///                                                                                                                             
"_column(1207)" _tab  "byte   "  _tab  "PEG3       "  _tab "%2f    "  _tab `""Overall, on a scale from 1 to 10 where 1 is NOT AT ALL interested and 10 is EXTREMELY interested, how interested are you in quitting smoking?""' _n ///                                 
"_column(1209)" _tab  "byte   "  _tab  "PEG4       "  _tab "%2f    "  _tab `""If you did try to quit smoking altogether in the next 6 months, how LIKELY do you think you would be to succeed --not at all, a little likely, somewhat likely or very likely?""' _n ///
"_column(1211)" _tab  "byte   "  _tab  "PEH1NUM    "  _tab "%2f    "  _tab `""About how long has it been since you COMPLETELY quit smoking cigarettes? (number)""' _n ///
"_column(1213)" _tab  "byte   "  _tab  "PEH1UNT    "  _tab "%2f    "  _tab `""About how long has it been since you COMPLETELY quit smoking cigarettes? (unit)""' _n ///
"_column(1215)" _tab  "byte   "  _tab  "PEH1B      "  _tab "%2f    "  _tab `""In the PAST 12 months, was H1 the longest time you stopped smoking cigarettes because you were trying to quit?""' _n ///
"_column(1217)" _tab  "byte   "  _tab  "PEH1CNUM   "  _tab "%2f    "  _tab `""During the PAST 12 MONTHS, what WAS the LONGEST length of time you stopped smoking because you were TRYING to quit smoking... (number)""' _n ///
"_column(1219)" _tab  "byte   "  _tab  "PEH1CUnt   "  _tab "%2f    "  _tab `""During the PAST 12 MONTHS, what WAS the LONGEST length of time you stopped smoking because you were TRYING to quit smoking... (unit)""' _n ///          
"_column(1221)" _tab  "byte   "  _tab  "PEH2       "  _tab "%2f    "  _tab `""Have you EVER smoked cigarettes EVERY DAY for at least 6 months?""' _n ///
"_column(1223)" _tab  "byte   "  _tab  "PEH5       "  _tab "%2f    "  _tab `""For how long did you smoke EVERY DAY?""' _n ///
"_column(1225)" _tab  "byte   "  _tab  "PTH5A      "  _tab "%2f    "  _tab `""When you last smoked every day, on average how many cigarettes did you smoke each day?""' _n ///
"_column(1227)" _tab  "byte   "  _tab  "PEH6       "  _tab "%2f    "  _tab `""Around this time 12 MONTHS AGO, were you smoking cigarettes every day, some days, or not at all?""' _n ///
"_column(1229)" _tab  "byte   "  _tab  "PTH6A      "  _tab "%2f    "  _tab `""Around this time 12 MONTHS AGO, on the average, about how many cigarettes did you smoke each day?""' _n ///
"_column(1231)" _tab  "byte   "  _tab  "PEH6B      "  _tab "%2f    "  _tab `""Around this time 12 MONTHS AGO, on how many of 30 days in the month did you smoke cigarettes?""' _n ///
"_column(1233)" _tab  "byte   "  _tab  "PTH6C      "  _tab "%2f    "  _tab `""On the average, on those (Fill PEH6b entry), how many cigarettes did you usually smoke each day?""' _n ///
"_column(1235)" _tab  "byte   "  _tab  "PEH6C2     "  _tab "%2f    "  _tab `""We are still talking about Around this time 12 months ago. Thinking back to the 12 MONTHS BEFORE YOU QUIT SMOKING CIGARETTES, during that time, did you usually smoke menthol or non-menthol cigarettes?""' _n ///
"_column(1237)" _tab  "byte   "  _tab  "PEH6C4     "  _tab "%2f    "  _tab `""Have you EVER smoked MENTHOL cigarettes for 6 months or more?""' _n ///
"_column(1239)" _tab  "byte   "  _tab  "PEH6C5     "  _tab "%2f    "  _tab `""For how long have you smoked MENTHOL cigarettes?""' _n ///
"_column(1241)" _tab  "byte   "  _tab  "PEH6D123   "  _tab "%2f    "  _tab `""Now I would like to ask about HOW you went about completely quitting smoking.  When you quit smoking completely, did you use ANY of the following PRODUCTS: A NICOTINE…patch, gum, lozenge, nasal spray or inhaler?""' _n ///
"_column(1243)" _tab  "byte   "  _tab  "PEH6D7AB   "  _tab "%2f    "  _tab `""Now I would like to ask about HOW you went about completely quitting smoking.  When you quit smoking completely, did you use ANY of the following PRODUCTS: A prescription pill, called Chantix, Varenicline, Zyban, Bupropion, or Wellbutrin?""' _n ///
"_column(1245)" _tab  "byte   "  _tab  "PEH6E1     "  _tab "%2f    "  _tab `""When you quit smoking completely, did you use ANY of the following: A telephone help line or quit line?""' _n ///
"_column(1247)" _tab  "byte   "  _tab  "PEH6E2     "  _tab "%2f    "  _tab `""When you quit smoking completely, did you use ANY of the following: One-on-one IN-PERSON counseling by a health professional?""' _n ///
"_column(1249)" _tab  "byte   "  _tab  "PEH6E3     "  _tab "%2f    "  _tab `""When you quit smoking completely, did you use ANY of the following: A stop smoking clinic, class, or support group?""' _n ///
"_column(1251)" _tab  "byte   "  _tab  "PEH6E5     "  _tab "%2f    "  _tab `""When you quit smoking completely, did you use ANY of the following: Internet or a web-based program or tool including smartphone apps and text messaging programs?""' _n ///
"_column(1253)" _tab  "byte   "  _tab  "PEH6FA2    "  _tab "%2f    "  _tab `""When you quit smoking completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to smokeless tobacco such as chewing tobacco, snuff, or snus?""' _n ///
"_column(1255)" _tab  "byte   "  _tab  "PEH6FA2B   "  _tab "%2f    "  _tab `""When you quit smoking completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to regular cigars, cigarillos, little filtered cigars or ANY pipes filled with tobacco?""' _n ///
"_column(1257)" _tab  "byte   "  _tab  "PEH6FA2C   "  _tab "%2f    "  _tab `""When you quit smoking completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to electronic or E-Cigarettes? You may also know them as vape-pens, e-hookahs, vapes or mods.""' _n ///
"_column(1259)" _tab  "byte   "  _tab  "PEH6FA2D1  "  _tab "%2f    "  _tab `""Did you switch to? Cigars, cigarillos, little filtered cigars.""' _n ///
"_column(1261)" _tab  "byte   "  _tab  "PEH6FA2D2  "  _tab "%2f    "  _tab `""Did you switch to? Regular pipes filled with tobacco.""' _n ///
"_column(1263)" _tab  "byte   "  _tab  "PEH6FA2D3  "  _tab "%2f    "  _tab `""Did you switch to? Water or hookah pipes filled with tobacco.""' _n ///
"_column(1265)" _tab  "byte   "  _tab  "PEH6FAZ2C  "  _tab "%2f    "  _tab `""When you quit smoking completely, did you try to quit by SWITCHING to electronic or E-cigarettes? You may also know them as vape-pens, e-hookahs, vapes or mods.""' _n ///
"_column(1267)" _tab  "byte   "  _tab  "PEH61A     "  _tab "%2f    "  _tab `""In the 12 MONTHS BEFORE you COMPLETELY quit smoking, did you SEE a medical doctor?""' _n ///
"_column(1269)" _tab  "byte   "  _tab  "PEH61B     "  _tab "%2f    "  _tab `""During the 12 MONTHS BEFORE you completely quit smoking, did any medical doctor ADVISE you to stop smoking?""' _n ///
"_column(1271)" _tab  "byte   "  _tab  "PEH8ANUM   "  _tab "%2f    "  _tab `""During the 12 MONTHS before you quit smoking, how soon after you woke up did you typically smoke your first cigarette of the day? (number)""' _n ///
"_column(1273)" _tab  "byte   "  _tab  "PEH8AUNT   "  _tab "%2f    "  _tab `""During the 12 MONTHS before you quit smoking, how soon after you woke up did you typically smoke your first cigarette of the day? (unit)""' _n ///
"_column(1275)" _tab  "byte   "  _tab  "PEH8B      "  _tab "%2f    "  _tab `""During the 12 months before you quit smoking, would you say you smoked your first cigarette of the day within the first 30 minutes of awakening?""' _n ///
"_column(1277)" _tab  "byte   "  _tab  "PEH11A     "  _tab "%2f    "  _tab `""Thinking back to the 12 MONTHS BEFORE YOU COMPLETELY QUIT SMOKING CIGARETTES. During that time, DID YOU USUALLY SMOKE menthol or non-menthol cigarettes?""' _n ///
"_column(1279)" _tab  "byte   "  _tab  "PEH11C     "  _tab "%2f    "  _tab `""Have you EVER smoked MENTHOL cigarettes for 6 months or more?""' _n ///
"_column(1281)" _tab  "byte   "  _tab  "PEH11D     "  _tab "%2f    "  _tab `""For how long did you smoked MENTHOL cigarettes?""' _n ///  
"_column(1283)" _tab  "byte   "  _tab  "PEJ1a1     "  _tab "%2f    "  _tab `""(Have/Has) (you/name) EVER used any of the following EVEN ONE TIME? ... A regular cigar or cigarillo OR a little filtered cigar?""' _n ///
"_column(1285)" _tab  "byte   "  _tab  "PEJ1a2     "  _tab "%2f    "  _tab `""(Have/Has) (you/name) EVER used any of the following EVEN ONE TIME? ... A regular pipe filled with tobacco?""' _n ///
"_column(1287)" _tab  "byte   "  _tab  "PEJ1A3     "  _tab "%2f    "  _tab `""(Have/Has) (you/name) EVER used any of the following EVEN ONE TIME? ... a water pipe or hookah (who-kah) pipe filled with tobacco?""' _n ///
"_column(1289)" _tab  "byte   "  _tab  "PEJ1A3_5   "  _tab "%2f    "  _tab `""(Have/Has) (you/name) EVER used E-cigarettes EVEN ONE TIME?""' _n ///
"_column(1291)" _tab  "byte   "  _tab  "PEJ1A4     "  _tab "%2f    "  _tab `""(Have/Has) (you/name) EVER used any of the following EVEN ONE TIME? ... Smokeless tobacco, such as moist snuff, dip, spit, chew tobacco or snus?""' _n ///    
"_column(1293)" _tab  "byte   "  _tab  "PEJ1A5     "  _tab "%2f    "  _tab `""(Have/Has) (you/name) EVER used disolvable tobacco EVEN ONE TIME?""' _n ///
"_column(1295)" _tab  "byte   "  _tab  "PEJ2A1     "  _tab "%2f    "  _tab `""(Do you/Does name) NOW smoke regular cigars or cigarillos or little filtered cigars every day, some days or not at all?""' _n ///
"_column(1297)" _tab  "byte   "  _tab  "PEJ2B1     "  _tab "%2f    "  _tab `""On how many of the past 30 days did you smoke regular cigars or cigarillos or little filtered cigars?""' _n ///
"_column(1299)" _tab  "byte   "  _tab  "PEJ2A2     "  _tab "%2f    "  _tab `""(Do you/Does name) NOW smoke a regular pipe every day, some days or not at all?""' _n ///
"_column(1301)" _tab  "byte   "  _tab  "PEJ2B2     "  _tab "%2f    "  _tab `""On how many of the past 30 days did you smoke a regular pipe?""' _n ///
"_column(1303)" _tab  "byte   "  _tab  "PEJ2A3     "  _tab "%2f    "  _tab `""(Do you/Does name) NOW use a water pipe or hookah pipe filled with tobacco every day, some days or not at all?""' _n ///
"_column(1305)" _tab  "byte   "  _tab  "PEJ2B3     "  _tab "%2f    "  _tab `""On how many of the past 30 days did you use a water pipe or hookah pipe filled with tobacco?""' _n ///
"_column(1307)" _tab  "byte   "  _tab  "PEJ2A3_5   "  _tab "%2f    "  _tab `""(Do you /Does name) NOW use an E-cigarette every day, some days or not at all?""' _n ///
"_column(1309)" _tab  "byte   "  _tab  "PEJ2B3_5   "  _tab "%2f    "  _tab `""On how many of the past 30 days did you use an E-cigarette?""' _n ///
"_column(1311)" _tab  "byte   "  _tab  "PEJ2A4     "  _tab "%2f    "  _tab `""(Do you /Does name) NOW use smokeless tobacco such as moist snuff, dip, spit, chew tobacco or snus every day, some days or not at all?""' _n ///
"_column(1313)" _tab  "byte   "  _tab  "PEJ2B4     "  _tab "%2f    "  _tab `""On how many of the past 30 days did you use smokeless tobacco?""' _n ///
"_column(1315)" _tab  "byte   "  _tab  "PEJ2A5     "  _tab "%2f    "  _tab `""(Do you /Does name) NOW use dissolvable tobacco every day, some days or not at all?""' _n ///
"_column(1317)" _tab  "byte   "  _tab  "PEJ2B5     "  _tab "%2f    "  _tab `""On how many of the past 30 days did you use dissolvable tobacco?""' _n ///
"_column(1319)" _tab  "byte   "  _tab  "PEJA       "  _tab "%2f    "  _tab `""During the past 30 days, what BRAND of smokeless tobacco (If necessary: moist snuff, dip, spit, chew or snus) did you use MOST OFTEN?""' _n ///
"_column(1321)" _tab  "byte   "  _tab  "PEJB       "  _tab "%2f    "  _tab `""During the PAST 30 days, what type of CIGAR did you use MOST OFTEN?""' _n ///
"_column(1323)" _tab  "byte   "  _tab  "PEJC       "  _tab "%2f    "  _tab `""During the PAST 30 days, what BRAND of CIGAR did you smoke MOST OFTEN?""' _n ///
"_column(1325)" _tab  "byte   "  _tab  "PEJNFLVIN  "  _tab "%2f    "  _tab `""Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol,or other flavors.""' _n ///
"_column(1327)" _tab  "byte   "  _tab  "PEJNFLVR1  "  _tab "%2f    "  _tab `""Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you smoke a cigar is it usually flavored?""' _n ///
"_column(1329)" _tab  "byte   "  _tab  "PEJNFLA1B  "  _tab "%2f    "  _tab `""Is it usually menthol or mint flavored?""' _n ///
"_column(1331)" _tab  "byte   "  _tab  "PEJNFLA1C  "  _tab "%2f    "  _tab `""Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?""' _n ///
"_column(1333)" _tab  "byte   "  _tab  "PEJNFLA1D  "  _tab "%2f    "  _tab `""Is it usually some other type of flavor?""' _n ///
"_column(1335)" _tab  "byte   "  _tab  "PEJNFLVR2  "  _tab "%2f    "  _tab `""Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you smoke a regular pipe filled with tobacco is it usually flavored?""' _n ///
"_column(1337)" _tab  "byte   "  _tab  "PEJNFLA2B  "  _tab "%2f    "  _tab `""Is it usually menthol or mint flavored?""' _n ///
"_column(1339)" _tab  "byte   "  _tab  "PEJNFLA2C  "  _tab "%2f    "  _tab `""Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?""' _n ///
"_column(1341)" _tab  "byte   "  _tab  "PEJNFLA2D  "  _tab "%2f    "  _tab `""Is it usually some other type of flavor?""' _n ///                                                                                                                                                                                                                                  
"_column(1343)" _tab  "byte   "  _tab  "PEJNFLVR3  "  _tab "%2f    "  _tab `""Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you smoke a water/hookah pipe filled with tobacco is it usually flavored?""' _n ///
"_column(1345)" _tab  "byte   "  _tab  "PEJNFLA3B  "  _tab "%2f    "  _tab `""Is it usually menthol or mint flavored?""' _n ///                                                                                                                                                                  
"_column(1347)" _tab  "byte   "  _tab  "PEJNFLA3C  "  _tab "%2f    "  _tab `""Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?""' _n ///                                                                                                             
"_column(1349)" _tab  "byte   "  _tab  "PEJNFLA3D  "  _tab "%2f    "  _tab `""Is it usually some other type of flavor?""' _n ///                                                                                                                                                                 
"_column(1351)" _tab  "byte   "  _tab  "PEJNFLV35  "  _tab "%2f    "  _tab `""Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you use an E-cigarette is it usually flavored?""' _n ///                           
"_column(1353)" _tab  "byte   "  _tab  "PEJNFA35A  "  _tab "%2f    "  _tab `""Is it usually tobacco flavored?""' _n ///                                                                                                                                                                          
"_column(1355)" _tab  "byte   "  _tab  "PEJNFA35B  "  _tab "%2f    "  _tab `""Is it usually menthol or mint flavored?""' _n ///                                                                                                                                                                  
"_column(1357)" _tab  "byte   "  _tab  "PEJNFA35C  "  _tab "%2f    "  _tab `""Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?""' _n ///
"_column(1359)" _tab  "byte   "  _tab  "PEJNFA35D  "  _tab "%2f    "  _tab `""Is it usually some other type of flavor?""' _n ///
"_column(1361)" _tab  "byte   "  _tab  "PEJNFVB35  "  _tab "%2f    "  _tab `""When you use an e-cigarette, is it usually tobacco flavored?""' _n ///                                                                                                
"_column(1363)" _tab  "byte   "  _tab  "PEJNFLVR4  "  _tab "%2f    "  _tab `""Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you use smokeless tobacco is it usually flavored?""' _n ///
"_column(1365)" _tab  "byte   "  _tab  "PEJNFLA4B  "  _tab "%2f    "  _tab `""Is it usually menthol or mint flavored?""' _n ///                                                                                                                                          
"_column(1367)" _tab  "byte   "  _tab  "PEJNFLA4C  "  _tab "%2f    "  _tab `""Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?""' _n ///                                                                                     
"_column(1369)" _tab  "byte   "  _tab  "PEJNFLA4D  "  _tab "%2f    "  _tab `""Is it usually some other type of flavor?""' _n ///                                                                                                                                         
"_column(1371)" _tab  "byte   "  _tab  "PEJECIGRA  "  _tab "%2f    "  _tab `""Do you use e-cigarettes because you can use them at times when or in places where smoking cigarettes isn’t allowed?""' _n ///                                                              
"_column(1373)" _tab  "byte   "  _tab  "PEJECIGRD  "  _tab "%2f    "  _tab `""Do you use e-cigarettes to help you quit smoking cigarettes?""' _n ///                                                                                                                     
"_column(1375)" _tab  "byte   "  _tab  "PEJECIG2   "  _tab "%2f    "  _tab `""Which of the following best describes the type of e-cigarette you currently use?""' _n ///                                                                                                 
"_column(1377)" _tab  "byte   "  _tab  "PEJECIG3   "  _tab "%2f    "  _tab `""Do you usually buy your own {e-cigarettes/e-cigarette cartridges/e-liquid}?""' _n ///                                                                                                      
"_column(1379)" _tab  "byte   "  _tab  "PEJECIG4   "  _tab "%2f    "  _tab `""How do you usually buy your own {e-cigarettes/e-cigarette cartridges/e-liquid}?""' _n ///
"_column(1381)" _tab  "byte   "  _tab  "PEJCOST1   "  _tab "%2f    "  _tab `""Do you usually buy {e-cigarettes/e-cigarette cartridges/bottles of e-liquid} by the box or pack, or as {single e-cigarettes/single e-cigarette cartridges/a single bottle of e-liquid}?""' _n ///
"_column(1383)" _tab  "double "  _tab  "PTJCOST2   "  _tab "%5f    "  _tab `""What price did you pay for the LAST BOX OR PACK of {e-cigarettes/e-cigarette cartridges/bottles of e-liquid} you bought?  Please report the cost after using discounts or coupons.""' _n ///     
"_column(1388)" _tab  "int    "  _tab  "PEJCOST3   "  _tab "%3f    "  _tab `""How many {e-cigarettes/e-cigarette cartridges/bottles of e-liquid} came in the LAST BOX OR PACK you bought?""' _n ///                                                                            
"_column(1391)" _tab  "double "  _tab  "PTJCOST4   "  _tab "%5f    "  _tab `""What price did you pay for the LAST {e-cigarette/e-cigarette cartridge/bottle of e-liquid} you bought?  Please report the cost after using discounts or coupons.""' _n ///                       
"_column(1396)" _tab  "int    "  _tab  "PEJCOST5   "  _tab "%4f    "  _tab `""How many MILLILITERS of liquid were in a SINGLE bottle you LAST bought?""' _n ///                                                                                                                
"_column(1400)" _tab  "byte   "  _tab  "PEJD11     "  _tab "%2f    "  _tab `""About how long has it been since you COMPLETELY quit smoking cigars, cigarillos or little filter cigars? (number)""' _n ///
"_column(1402)" _tab  "byte   "  _tab  "PEJD21     "  _tab "%2f    "  _tab `""About how long has it been since you COMPLETELY quit smoking cigars, cigarillos or little filter cigars? (unit)""' _n ///
"_column(1404)" _tab  "byte   "  _tab  "PEJD12     "  _tab "%2f    "  _tab `""About how long has it been since you COMPLETELY quit smoking a regular pipe filled with tobacco? (number)""' _n ///
"_column(1406)" _tab  "byte   "  _tab  "PEJD22     "  _tab "%2f    "  _tab `""About how long has it been since you COMPLETELY quit smoking a regular pipe filled with tobacco? (unit)""' _n ///
"_column(1408)" _tab  "byte   "  _tab  "PEJD13     "  _tab "%2f    "  _tab `""About how long has it been since you COMPLETELY quit smoking a water pipe or hookah pipe filled with tobacco? (number)""' _n ///
"_column(1410)" _tab  "byte   "  _tab  "PEJD23     "  _tab "%2f    "  _tab `""About how long has it been since you COMPLETELY quit smoking a water pipe or hookah pipe filled with tobacco? (unit)""' _n ///
"_column(1412)" _tab  "byte   "  _tab  "PEJD13_5   "  _tab "%2f    "  _tab `""About how long has it been since you COMPLETELY quit using E-cigarettes? (number)""' _n ///
"_column(1414)" _tab  "byte   "  _tab  "PEJD23_5   "  _tab "%2f    "  _tab `""About how long has it been since you COMPLETELY quit using E-cigarettes? (unit)""' _n ///
"_column(1416)" _tab  "byte   "  _tab  "PEJD14     "  _tab "%2f    "  _tab `""About how long has it been since you COMPLETELY quit using a smokeless tobacco? (number)""' _n ///
"_column(1418)" _tab  "byte   "  _tab  "PEJD24     "  _tab "%2f    "  _tab `""About how long has it been since you COMPLETELY quit using a smokeless tobacco? (unit)""' _n ///
"_column(1420)" _tab  "byte   "  _tab  "PEJD31     "  _tab "%2f    "  _tab `""In total, how many years (have you smoked/did you smoke) cigars or cigarillos or little filtered cigars?""' _n /// 
"_column(1422)" _tab  "byte   "  _tab  "PEJD32     "  _tab "%2f    "  _tab `""In total, how many years (have you smoked/did you smoke) a regular pipe filled with tobacco?""' _n ///             
"_column(1424)" _tab  "byte   "  _tab  "PEJD33     "  _tab "%2f    "  _tab `""In total, how many years (have you smoked/did you smoke) a water pipe or hookah pipe filled with tobacco?""' _n ///
"_column(1426)" _tab  "byte   "  _tab  "PEJD33_5   "  _tab "%2f    "  _tab `""In total, how many years (have you used/did you use) an E-cigarette?""' _n ///                                     
"_column(1428)" _tab  "byte   "  _tab  "PEJD34     "  _tab "%2f    "  _tab `""In total, how many years (have you used/did you use) smokeless tobacco?""' _n ///
"_column(1430)" _tab  "byte   "  _tab  "PEJFECGRA  "  _tab "%2f    "  _tab `""Did you use E-cigarettes because you could use them at times when or in places where smoking cigarettes wasn't allowed?""' _n ///
"_column(1432)" _tab  "byte   "  _tab  "PEJFECGRD  "  _tab "%2f    "  _tab `""Did you use e-cigarettes to help you quit smoking cigarettes? ""' _n ///
"_column(1434)" _tab  "byte   "  _tab  "PEJFECG2   "  _tab "%2f    "  _tab `""Which of the following best describes the type of e-cigarette you used to use?  If you used more than one type, please think of the one you used most often.""' _n ///
"_column(1436)" _tab  "byte   "  _tab  "PEJ3A1     "  _tab "%2f    "  _tab `""How soon after you wake up do you typically (fill text from PRJ3A1F recode)? (number)""' _n ///
"_column(1438)" _tab  "byte   "  _tab  "PEJ3A2     "  _tab "%2f    "  _tab `""How soon after you wake up do you typically (fill text from PRJ3A1F recode)? (unit)""' _n ///
"_column(1440)" _tab  "byte   "  _tab  "PEJ3D      "  _tab "%2f    "  _tab `""Would you say you first (fill text from PRJ3DF recode) within the first 30 minutes of awakening?""' _n ///
"_column(1442)" _tab  "byte   "  _tab  "PEJ3F1     "  _tab "%2f    "  _tab `""In the 12 months BEFORE YOU COMPLETELY QUIT (Fill text from PRJ3F1F recode), how soon after you woke up did you typically (Fill text from PRJ3F1F recode)? (number)""' _n ///
"_column(1444)" _tab  "byte   "  _tab  "PEJ3F2     "  _tab "%2f    "  _tab `""In the 12 months BEFORE YOU COMPLETELY QUIT (Fill text from PRJ3F1F recode), how soon after you woke up did you typically (Fill text from PRJ3F1F recode)? (unit)""' _n ///
"_column(1446)" _tab  "byte   "  _tab  "PEJ3G      "  _tab "%2f    "  _tab `""Would you say you first used (Fill text from PRJ3GF recode) within the first 30 minutes of awakening?""' _n ///
"_column(1448)" _tab  "byte   "  _tab  "PEJ4       "  _tab "%2f    "  _tab `""During the PAST 12 MONTHS, have you stopped (Fill text from PRJ4F recode) for one day or longer BECAUSE YOU WERE TRYING TO QUIT?""' _n ///
"_column(1450)" _tab  "byte   "  _tab  "PEJ6BNUM   "  _tab "%2f    "  _tab `""Thinking of ANY attempts to stop (fill text from PRJ6BNMF) because you were trying to quit, during the past 12 MONTHS, what is the LONGEST length of time of the ONE attempt that lasted the longest? (number)""' _n ///
"_column(1452)" _tab  "byte   "  _tab  "PEJ6BUNT   "  _tab "%2f    "  _tab `""Thinking of ANY attempts to stop (fill text from PRJ6BNMF) because you were trying to quit, during the past 12 MONTHS, what is the LONGEST length of time of the ONE attempt that lasted the longest? (unit)""' _n ///
"_column(1454)" _tab  "byte   "  _tab  "PEJ7CINT   "  _tab "%2f    "  _tab `""The LAST TIME you tried to QUIT smoking CIGARS in the past 12 months: Did you:""' _n ///
"_column(1456)" _tab  "byte   "  _tab  "PEJ7C      "  _tab "%2f    "  _tab `""The LAST TIME you tried to QUIT smoking CIGARS in the past 12 months: Did you: Try to quit by SWITCHING to smokeless tobacco such as chewing  tobacco, snuff, or snus?""' _n ///
"_column(1458)" _tab  "byte   "  _tab  "PEJ7D      "  _tab "%2f    "  _tab `""The LAST TIME you tried to QUIT smoking CIGARS in the past 12 months: Did you: Try to quit by SWITCHING to electronic or E-cigarettes?""' _n ///
"_column(1460)" _tab  "byte   "  _tab  "PEJ7ALTIN  "  _tab "%2f    "  _tab `""When you quit smoking CIGARS completely, did you do ANY of the following, whether or not you think they were effective:""' _n ///
"_column(1462)" _tab  "byte   "  _tab  "PEJ7CALT   "  _tab "%2f    "  _tab `""When you quit smoking CIGARS completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to smokeless tobacco such as chewing tobacco, snuff, or snus?""' _n ///
"_column(1464)" _tab  "byte   "  _tab  "PEJ7DALT   "  _tab "%2f    "  _tab `""When you quit smoking CIGARS completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to electronic or E-cigarette?""' _n ///
"_column(1466)" _tab  "byte   "  _tab  "PEK1A      "  _tab "%2f    "  _tab `""Do you mainly work indoors or outdoors?""' _n ///
"_column(1468)" _tab  "byte   "  _tab  "PEK1B      "  _tab "%2f    "  _tab `""Do you mainly work in an office building, your own home, in someone else's home, or in another indoor place?""' _n ///
"_column(1470)" _tab  "byte   "  _tab  "PEK1B11    "  _tab "%2f    "  _tab `""In which State (including DC), do you work?""' _n ///
"_column(1472)" _tab  "byte   "  _tab  "PEK1B2     "  _tab "%2f    "  _tab `""When you work INDOORS: Do you mainly work in an office building, in your own home, in someone else's home, or in another indoor place?""' _n ///
"_column(1474)" _tab  "byte   "  _tab  "PEK1C1     "  _tab "%2f    "  _tab `""In which State (including DC), do you work on your main indoor job or business?""' _n ///
"_column(1476)" _tab  "byte   "  _tab  "PEK2A      "  _tab "%2f    "  _tab `""Is smoking restricted in ANY WAY at your place of work?""' _n ///
"_column(1478)" _tab  "byte   "  _tab  "PEK3A      "  _tab "%2f    "  _tab `""Which of these best describes the smoking policy at your place of work for INDOOR PUBLIC OR COMMON AREAS, such as lobbies, rest rooms, and lunch rooms?""' _n ///
"_column(1480)" _tab  "byte   "  _tab  "PEK3B      "  _tab "%2f    "  _tab `""Which of these best describes the smoking policy at your place of work for INDOOR WORK AREAS?""' _n ///
"_column(1482)" _tab  "byte   "  _tab  "PEK3C      "  _tab "%2f    "  _tab `""During the PAST TWO WEEKS, has anyone smoked in the area in which you work?""' _n ///
"_column(1484)" _tab  "byte   "  _tab  "PEK3B1     "  _tab "%2f    "  _tab `""Which of these best describes the vaping or e-cigarette policy at your place of work for INDOOR PUBLIC OR COMMON AREAS AND INDOOR WORK AREAS?""' _n ///
"_column(1486)" _tab  "byte   "  _tab  "PEK3C1     "  _tab "%2f    "  _tab `""During the PAST TWO WEEKS, has anyone vaped or used e-cigarettes in the area in which you work?""' _n ///
"_column(1488)" _tab  "byte   "  _tab  "PEK4       "  _tab "%2f    "  _tab `""Which statement best describes the rules about smoking INSIDE YOUR HOME?""' _n ///
"_column(1490)" _tab  "byte   "  _tab  "PEK4A      "  _tab "%2f    "  _tab `""Which statement best describes the rules about vaping or using e-cigarettes INSIDE YOUR HOME?""' _n ///
"_column(1492)" _tab  "byte   "  _tab  "PEK5A      "  _tab "%2f    "  _tab `""In buildings with MULTIPLE apartments or living areas, do you THINK that smoking should be ... ALLOWED INSIDE ALL apartments or living areas, ALLOWED inside SOME apartments ..., or NOT ALLOWED at ALL inside apartments?""' _n ///
"_column(1494)" _tab  "byte   "  _tab  "PEK6B      "  _tab "%2f    "  _tab `""In indoor work areas, do you THINK that smoking SHOULD be allowed in ALL areas, allowed in SOME areas, or NOT allowed at ALL?""' _n ///
"_column(1496)" _tab  "byte   "  _tab  "PEK6C      "  _tab "%2f    "  _tab `""Inside bars, cocktail lounges, and clubs, do you THINK that smoking SHOULD be allowed in ALL areas, allowed in SOME areas, or NOT allowed at ALL?""' _n ///
"_column(1498)" _tab  "byte   "  _tab  "PEK6G      "  _tab "%2f    "  _tab `""Inside casinos, do you THINK that smoking SHOULD be allowed in ALL areas, allowed in SOME areas, or NOT allowed at ALL?""' _n ///
"_column(1500)" _tab  "byte   "  _tab  "PEK6H      "  _tab "%2f    "  _tab `""Inside a car, when there are other people present, do you THINK that smoking SHOULD...""' _n ///
"_column(1502)" _tab  "byte   "  _tab  "PEK6H2     "  _tab "%2f    "  _tab `""If children are present inside the car, do you think that smoking SHOULD...""' _n ///
"_column(1504)" _tab  "byte   "  _tab  "PEK8       "  _tab "%2f    "  _tab `""In the past 6 months, have you seen messages in newspapers or on television that say that a Federal Court has ordered tobacco companies to make statements about the dangers of smoking cigarettes?""' _n ///
"_column(1506)" _tab  "byte   "  _tab  "PES78      "  _tab "%2f    "  _tab `""Respondent relationship recode - relationship of respondent to the sample person""' _n ///
"_column(1508)" _tab  "byte   "  _tab  "PESINTTP   "  _tab "%2f    "  _tab `""In what language was the interview conducted for this person?""' _n ///
"_column(1510)" _tab  "byte   "  _tab  "PES81A     "  _tab "%2f    "  _tab `""Method of Interview""' _n ///
"_column(1512)" _tab  "byte   "  _tab  "INTRVIEW   "  _tab "%2f    "  _tab `""Interview Status Recode""' _n ///
"_column(1514)" _tab  "byte   "  _tab  "HRMODE     "  _tab "%2f    "  _tab `""Method of Interview""' _n ///
"_column(1516)" _tab  "byte   "  _tab  "SMOKSTAT   "  _tab "%2f    "  _tab `""Type of smoker recode""' _n ///
"_column(1518)" _tab  "byte   "  _tab  "PRS35      "  _tab "%2f    "  _tab `""Respondent and Smoker Type""' _n ///
"_column(1520)" _tab  "byte   "  _tab  "PRS60      "  _tab "%2f    "  _tab `""Self responding 'Not at all' smokers- smoking less than or equal to 1 year or don't know""' _n ///
"_column(1522)" _tab  "byte   "  _tab  "PRS64      "  _tab "%2f    "  _tab `""Who is responding for the supplement""' _n ///
"_column(1524)" _tab  "byte   "  _tab  "PRS65      "  _tab "%2f    "  _tab `""Monthly Labor Force recode of Self respondents""' _n ///
"_column(1526)" _tab  "byte   "  _tab  "PRS66      "  _tab "%2f    "  _tab `""Employed self respondents' class of worker on first job""' _n ///
"_column(1528)" _tab  "byte   "  _tab  "PRJ3A1F    "  _tab "%2f    "  _tab `""Recode from fill in PEJ3a1 and PEJ3a2 to determine which tobacco product is being discussed in PEJ3a1 and PEJ3a2""' _n ///
"_column(1530)" _tab  "byte   "  _tab  "PRJ3DF     "  _tab "%2f    "  _tab `""Recode from fill in PEJ3d to determine which tobacco product is being discussed in PEJ3d""' _n ///
"_column(1532)" _tab  "byte   "  _tab  "PRJ3F1F    "  _tab "%2f    "  _tab `""Recode from fill in PEJ3f1 and PEJ3f2 to determine which tobacco product is being discussed in PEJ3f1 and PEJ3f2""' _n ///
"_column(1534)" _tab  "byte   "  _tab  "PRJ3GF     "  _tab "%2f    "  _tab `""Recode from fill in PEJ3g to determine which tobacco product is being discussed in PEJ3g""' _n ///
"_column(1536)" _tab  "byte   "  _tab  "PRJ4F      "  _tab "%2f    "  _tab `""Recode from fill in PEJ4 to determine which tobacco product is being discussed in PEJ4""' _n ///
"_column(1538)" _tab  "byte   "  _tab  "PRJ6BNMF   "  _tab "%2f    "  _tab `""Recode from fill in PEJ6bnum and PEJ6bunt to see which tobacco product is being discussed in PEJ6bnum and PEJ6bunt""' _n ///
"_column(1540)" _tab  "byte   "  _tab  "PRSIFLG    "  _tab "%2f    "  _tab `""Recode identifies person answering their own questions on the shorter proxy path.""' _n ///
"_column(1542)" _tab  "double "  _tab  "PWNRWGT    "  _tab "%10.4f "  _tab `""Nonresponse weight""' _n ///
"_column(1552)" _tab  "double "  _tab  "PWSRWGT    "  _tab "%10.4f "  _tab `""Self response weight""' _n ///
"_column(1562)" _tab  "byte   "  _tab  "PEELGFLG   "  _tab "%2f    "  _tab `""Eligibility Flag""' _n ///
"}"
set more on
file close dictionary 

quietly infile using dictionary.dct, using ("jul18pub.dat") clear

replace PUERNH1C = PUERNH1C / 100 if PUERNH1C > 0
replace PEERNH2 = PEERNH2 / 100 if PEERNH2 > 0
replace PEERNH1O = PEERNH1O / 100 if PEERNH1O > 0
replace PRERNHLY = PRERNHLY / 100 if PRERNHLY > 0
replace PRERNWA = PRERNWA / 100 if PRERNWA > 0
replace PEERN = PEERN / 100 if PEERN > 0
replace PUERN2 = PUERN2 / 100 if PUERN2 > 0

replace PTB6B = PTB6B /100 if PTB6B > 0
replace PTB6C = PTB6C /100 if PTB6C > 0

replace PTC6B = PTC6B /100 if PTC6B > 0
replace PTC6C = PTC6C /100 if PTC6C > 0

replace PTJCOST2 = PTJCOST2 /100 if PTJCOST2 > 0
replace PTJCOST4 = PTJCOST4 /100 if PTJCOST4 > 0

describe

save "jul18pub_beta", replace


//*****************************************************************************************
// Read CPS January 2019 file

// Create dictionary of CPS January 2019 file
file open dictionary  using ".\dictionary.dct", write replace

// Dictionary for CPS Jnuary 2019
//
set more off
file write dictionary   /// 
"infile dictionary {" _n ///
"_column(1)"    _tab "str15  " _tab "HRHHID          " _tab "%15s   " _tab `""Household identifier (part 1)""' _n ///
"_column(16)"   _tab "byte   " _tab "HRMONTH         " _tab "%2f    " _tab `""Month of interview""' _n ///
"_column(18)"   _tab "int    " _tab "HRYEAR4         " _tab "%4f    " _tab `""Year of interview""' _n ///
"_column(22)"   _tab "byte   " _tab "HURESPLI        " _tab "%2f    " _tab `""Line number of the current respondent""' _n ///
"_column(24)"   _tab "int    " _tab "HUFINAL         " _tab "%3f    " _tab `""Final outcome code""' _n ///
"_column(29)"   _tab "byte   " _tab "HETENURE        " _tab "%2f    " _tab `""Are your living quarters...""' _n ///
"_column(31)"   _tab "byte   " _tab "HEHOUSUT        " _tab "%2f    " _tab `""Type of housing unit""' _n ///
"_column(33)"   _tab "byte   " _tab "HETELHHD        " _tab "%2f    " _tab `""Is there a telephone in this house/apartment?""' _n ///
"_column(35)"   _tab "byte   " _tab "HETELAVL        " _tab "%2f    " _tab `""Is there a telephone elsewhere on which people in this household can be contacted?""' _n ///
"_column(37)"   _tab "byte   " _tab "HEPHONEO        " _tab "%2f    " _tab `""Is a telephone interview acceptable?""' _n ///
"_column(39)"   _tab "byte   " _tab "HEFAMINC        " _tab "%2f    " _tab `""Family income""' _n ///
"_column(41)"   _tab "byte   " _tab "HUTYPEA         " _tab "%2f    " _tab `""Type A non-interview reason""' _n ///
"_column(43)"   _tab "byte   " _tab "HUTYPB          " _tab "%2f    " _tab `""Type B non-interview reason""' _n ///
"_column(45)"   _tab "byte   " _tab "HUTYPC          " _tab "%2f    " _tab `""Type C non-interview reason""' _n ///
"_column(47)"   _tab "double " _tab "HWHHWGT         " _tab "%10.4f " _tab `""Household weight""' _n /// 
"_column(57)"   _tab "byte   " _tab "HRINTSTA        " _tab "%2f    " _tab `""Interview status""' _n ///
"_column(59)"   _tab "byte   " _tab "HRNUMHOU        " _tab "%2f    " _tab `""Total number of persons living in the household (household members)""' _n ///
"_column(61)"   _tab "byte   " _tab "HRHTYPE         " _tab "%2f    " _tab `""Household type""' _n ///
"_column(63)"   _tab "byte   " _tab "HRMIS           " _tab "%2f    " _tab `""Month-in-sample""' _n ///
"_column(65)"   _tab "byte   " _tab "HUINTTYP        " _tab "%2f    " _tab `""Type of interview""' _n ///
"_column(67)"   _tab "byte   " _tab "HUPRSCNT        " _tab "%2f    " _tab `""Number of actual and attempted personal contacts""' _n ///
"_column(69)"   _tab "byte   " _tab "HRLONGLK        " _tab "%2f    " _tab `""Longitudinal link indicator""' _n ///
"_column(71)"   _tab "str5   " _tab "HRHHID2         " _tab "%5s    " _tab `""Household identifier (part 2)""' _n ///
"_column(76)"   _tab "byte   " _tab "HWHHWTLN        " _tab "%2f    " _tab `""Line number (PULINENO) of the person whose PWSSWGT was donated as HWHHWGT for the household""' _n ///
"_column(79)"   _tab "byte   " _tab "HUBUS           " _tab "%2f    " _tab `""Does anyone in this household have a business or a farm?""' _n ///
"_column(81)"   _tab "byte   " _tab "HUBUSL1         " _tab "%2f    " _tab `""Enter line number for hubus = 1""' _n ///
"_column(83)"   _tab "byte   " _tab "HUBUSL2         " _tab "%2f    " _tab `""Enter line number for hubus = 1""' _n ///
"_column(85)"   _tab "byte   " _tab "HUBUSL3         " _tab "%2f    " _tab `""Enter line number for hubus = 1""' _n ///
"_column(87)"   _tab "byte   " _tab "HUBUSL4         " _tab "%2f    " _tab `""Enter line number for hubus = 1""' _n ///
"_column(89)"   _tab "byte   " _tab "GEREG           " _tab "%2f    " _tab `""Region""' _n ///
"_column(91)"   _tab "byte   " _tab "GEDIV           " _tab "%2f    " _tab `""Division""' _n ///
"_column(93)"   _tab "str2   " _tab "GESTFIPS        " _tab "%2f    " _tab `""Federal Information Processing Standards (FIPS) State code""' _n ///
"_column(96)"   _tab "str5   " _tab "GTCBSA          " _tab "%5f    " _tab `""Specific metropolitan CBSA code""' _n ///
"_column(101)"  _tab "str3   " _tab "GTCO            " _tab "%3f    " _tab `""FIPS county code""' _n ///
"_column(104)"  _tab "byte   " _tab "GTCBSAST        " _tab "%1f    " _tab `""Principal city/balance status""' _n ///
"_column(105)"  _tab "byte   " _tab "GTMETSTA        " _tab "%1f    " _tab `""Metropolitan status""' _n ///
"_column(106)"  _tab "byte   " _tab "GTINDVPC        " _tab "%1f    " _tab `""Individual principal city""' _n ///
"_column(107)"  _tab "byte   " _tab "GTCBSASZ        " _tab "%1f    " _tab `""Metropolitan area (CBSA) size""' _n ///
"_column(108)"  _tab "str3   " _tab "GTCSA           " _tab "%3f    " _tab `""Consolidated Statistical Area (CSA) FIPS code""' _n ///
"_column(118)"  _tab "byte   " _tab "PERRP           " _tab "%2f    " _tab `""Relationship to reference person""' _n ///
"_column(120)"  _tab "byte   " _tab "PEPARENT        " _tab "%2f    " _tab `""Line number of parent""' _n ///
"_column(122)"  _tab "byte   " _tab "PRTAGE          " _tab "%2f    " _tab `""Persons age""' _n ///
"_column(124)"  _tab "byte   " _tab "PRTFAGE         " _tab "%1f    " _tab `""Top code flag for age""' _n ///
"_column(125)"  _tab "byte   " _tab "PEMARITL        " _tab "%2f    " _tab `""Marital status""' _n ///
"_column(127)"  _tab "byte   " _tab "PESPOUSE        " _tab "%2f    " _tab `""Line number of spouse""' _n ///
"_column(129)"  _tab "byte   " _tab "PESEX           " _tab "%2f    " _tab `""Sex""' _n ///
"_column(131)"  _tab "byte   " _tab "PEAFEVER        " _tab "%2f    " _tab `""Did you ever serve on active duty in the U.S. armed forces?""' _n ///
"_column(135)"  _tab "byte   " _tab "PEAFNOW         " _tab "%2f    " _tab `""Are you now in the armed forces?""' _n ///
"_column(137)"  _tab "byte   " _tab "PEEDUCA         " _tab "%2f    " _tab `""Highest level of school completed or degree received""' _n ///
"_column(139)"  _tab "byte   " _tab "PTDTRACE        " _tab "%2f    " _tab `""Race"' _n ///
"_column(141)"  _tab "byte   " _tab "PRDTHSP         " _tab "%2f    " _tab `""Detailed Hispanic origin group (Revised January 2014)""' _n ///
"_column(143)"  _tab "byte   " _tab "PUCHINHH        " _tab "%2f    " _tab `""Change in household composition""' _n ///
"_column(147)"  _tab "byte   " _tab "PULINENO        " _tab "%2f    " _tab `""Person's line number""' _n ///
"_column(151)"  _tab "byte   " _tab "PRFAMNUM        " _tab "%2f    " _tab `""Family number recode""' _n ///
"_column(153)"  _tab "byte   " _tab "PRFAMREL        " _tab "%2f    " _tab `""Family relationship recode""' _n ///
"_column(155)"  _tab "byte   " _tab "PRFAMTYP        " _tab "%2f    " _tab `""Family type recode""' _n ///
"_column(157)"  _tab "byte   " _tab "PEHSPNON        " _tab "%2f    " _tab `""Hispanic or non-Hispanic""' _n ///
"_column(159)"  _tab "byte   " _tab "PRMARSTA        " _tab "%2f    " _tab `""Marital status based on Armed Forces participation""' _n ///
"_column(161)"  _tab "byte   " _tab "PRPERTYP        " _tab "%2f    " _tab `""Type of person record recode""' _n ///
"_column(163)"  _tab "int    " _tab "PENATVTY        " _tab "%3f    " _tab `""Country of birth""' _n ///
"_column(166)"  _tab "int    " _tab "PEMNTVTY        " _tab "%3f    " _tab `""Mother's country of birth""' _n ///
"_column(169)"  _tab "int    " _tab "PEFNTVTY        " _tab "%3f    " _tab `""Father's country of birth""' _n ///
"_column(172)"  _tab "byte   " _tab "PRCITSHP        " _tab "%2f    " _tab `""Citizenship status""' _n ///
"_column(174)"  _tab "byte   " _tab "PRCITFLG        " _tab "%2f    " _tab `""Citizenship allocation flag""' _n ///
"_column(176)"  _tab "byte   " _tab "PRINUSYR        " _tab "%2f    " _tab `""Immigrant's year of entry""' _n ///
"_column(178)"  _tab "byte   " _tab "PUSLFPRX        " _tab "%2f    " _tab `""Labor force information collected by self or proxy response""' _n ///
"_column(180)"  _tab "byte   " _tab "PEMLR           " _tab "%2f    " _tab `""Monthly labor force recode""' _n ///
"_column(182)"  _tab "byte   " _tab "PUWK            " _tab "%2f    " _tab `""Last week, did you do any work for (either) pay (or profit)?""' _n ///
"_column(184)"  _tab "byte   " _tab "PUBUS1          " _tab "%2f    " _tab `""Last week, did you do any unpaid work in the family business or farm?""' _n ///
"_column(186)"  _tab "byte   " _tab "PUBUS2OT        " _tab "%2f    " _tab `""Do you receive any payments or profits from the business?""' _n ///
"_column(188)"  _tab "byte   " _tab "PUBUSCK1        " _tab "%2f    " _tab `""Check item 1 filter for questions on unpaid work""' _n ///
"_column(190)"  _tab "byte   " _tab "PUBUSCK2        " _tab "%2f    " _tab `""Check item 2 skips owners of family busines who did not work last week""' _n ///
"_column(192)"  _tab "byte   " _tab "PUBUSCK3        " _tab "%2f    " _tab `""Check item 3""' _n ///
"_column(194)"  _tab "byte   " _tab "PUBUSCK4        " _tab "%2f    " _tab `""Check item 4""' _n ///
"_column(196)"  _tab "byte   " _tab "PURETOT         " _tab "%2f    " _tab `""Retirement status (last month you were reported to be retired, are you still retired this month?)""' _n ///
"_column(198)"  _tab "byte   " _tab "PUDIS           " _tab "%2f    " _tab `""Disability status (last month you were reported to have a disability.) Does your disability continue to prevent you from doing any kind of work for the next 6 months?""' _n ///
"_column(200)"  _tab "byte   " _tab "PERET1          " _tab "%2f    " _tab `""Do you currently want a job, either full or part-time?""' _n ///
"_column(202)"  _tab "byte   " _tab "PUDIS1          " _tab "%2f    " _tab `""Does your disability prevent you from accepting any kind of work during the next six months?""' _n ///
"_column(204)"  _tab "byte   " _tab "PUDIS2          " _tab "%2f    " _tab `""Do you have a disability that prevents you from accepting any kind of work during the next six months?""' _n ///
"_column(206)"  _tab "byte   " _tab "PUABSOT         " _tab "%2f    " _tab `""Last week did you have a job either full or part-time?""' _n ///
"_column(208)"  _tab "byte   " _tab "PULAY           " _tab "%2f    " _tab `""Last week, were you on layoff from a job?""' _n ///
"_column(210)"  _tab "byte   " _tab "PEABSRSN        " _tab "%2f    " _tab `""What is the main reason you were absent from work last week?""' _n ///
"_column(212)"  _tab "byte   " _tab "PEABSPDO        " _tab "%2f    " _tab `""Are you being paid by your employer for any of the time off last week?""' _n ///
"_column(214)"  _tab "byte   " _tab "PEMJOT          " _tab "%2f    " _tab `""Do you have more than one job?""' _n ///
"_column(216)"  _tab "byte   " _tab "PEMJNUM         " _tab "%2f    " _tab `""Altogether, how many jobs did you have?""' _n ///
"_column(218)"  _tab "byte   " _tab "PEHRUSL1        " _tab "%2f    " _tab `""How many hours per week do you usually work at your main job?""' _n ///
"_column(220)"  _tab "byte   " _tab "PEHRUSL2        " _tab "%2f    " _tab `""How many hours per week do you usually work at your other (job/jobs)?""' _n ///
"_column(222)"  _tab "byte   " _tab "PEHRFTPT        " _tab "%2f    " _tab `""Do you usually work 35 hours or more per week?""' _n ///
"_column(224)"  _tab "int    " _tab "PEHRUSLT        " _tab "%3f    " _tab `""Sum of HRUSL1 and HRUSL2.""' _n ///
"_column(227)"  _tab "byte   " _tab "PEHRWANT        " _tab "%2f    " _tab `""Do you want to work a full-time work week of 35 hours or more per week?""' _n ///
"_column(229)"  _tab "byte   " _tab "PEHRRSN1        " _tab "%2f    " _tab `""What is your main reason for working part-time?""' _n ///
"_column(231)"  _tab "byte   " _tab "PEHRRSN2        " _tab "%2f    " _tab `""What is the main reason you do not want to work full-time?""' _n ///
"_column(233)"  _tab "byte   " _tab "PEHRRSN3        " _tab "%2f    " _tab `""What is the main reason you worked less than 35 hours last week?""' _n ///
"_column(235)"  _tab "byte   " _tab "PUHROFF1        " _tab "%2f    " _tab `""Last week, did you lose or take off any hours from your job, for any reason such as illness, slack work, vacation, or holiday?""' _n ///
"_column(237)"  _tab "byte   " _tab "PUHROFF2        " _tab "%2f    " _tab `""How many hours did you take off?""' _n ///
"_column(239)"  _tab "byte   " _tab "PUHROT1         " _tab "%2f    " _tab `""Last week, did you work any overtime or extra hours (at your main job) that you do not usually work?""' _n ///
"_column(241)"  _tab "byte   " _tab "PUHROT2         " _tab "%2f    " _tab `""How many additional hours did you work?""' _n ///
"_column(243)"  _tab "byte   " _tab "PEHRACT1        " _tab "%2f    " _tab `""Last week, how many hours did you actually work at your job?""' _n ///
"_column(245)"  _tab "byte   " _tab "PEHRACT2        " _tab "%2f    " _tab `""Last week, how many hours did you actually work at your other (job/jobs)""' _n ///
"_column(247)"  _tab "int    " _tab "PEHRACTT        " _tab "%3f    " _tab `""Sum of PEHRACT1 and PEHRACT2""' _n ///
"_column(250)"  _tab "byte   " _tab "PEHRAVL         " _tab "%2f    " _tab `""Last week, could you have worked full-time if the hours had been available?""' _n ///     
"_column(257)"  _tab "byte   " _tab "PUHRCK1         " _tab "%2f    " _tab `""Check item 1""' _n ///                                                        
"_column(259)"  _tab "byte   " _tab "PUHRCK2         " _tab "%2f    " _tab `""Check item 2 skips persons responding yes to HRFTPT out of PT series""' _n ///
"_column(261)"  _tab "byte   " _tab "PUHRCK3         " _tab "%2f    " _tab `""Check item 3""' _n ///                                                        
"_column(263)"  _tab "byte   " _tab "PUHRCK4         " _tab "%2f    " _tab `""Check item 4""' _n ///                                                        
"_column(265)"  _tab "byte   " _tab "PUHRCK5         " _tab "%2f    " _tab `""Check item 5""' _n ///                                                        
"_column(267)"  _tab "byte   " _tab "PUHRCK6         " _tab "%2f    " _tab `""Check item 6""' _n ///                                                        
"_column(269)"  _tab "byte   " _tab "PUHRCK7         " _tab "%2f    " _tab `""Check item 7""' _n ///                                                        
"_column(271)"  _tab "byte   " _tab "PUHRCK12        " _tab "%2f    " _tab `""Check item 12""' _n ///
"_column(273)"  _tab "byte   " _tab "PULAYDT         " _tab "%2f    " _tab `""Has your employer given you a date to return to work?""' _n ///
"_column(275)"  _tab "byte   " _tab "PULAY6M         " _tab "%2f    " _tab `""Have you been given any indication that you will be recalled to work within the next 6 months?""' _n ///
"_column(277)"  _tab "byte   " _tab "PELAYAVL        " _tab "%2f    " _tab `""Could you have returned to work last week if you had been recalled?""' _n ///
"_column(279)"  _tab "byte   " _tab "PULAYAVR        " _tab "%2f    " _tab `""Why is that?""' _n ///
"_column(281)"  _tab "byte   " _tab "PELAYLK         " _tab "%2f    " _tab `""Even though you are to be called back to work, have you been looking for work during the last 4 weeks.""' _n ///
"_column(283)"  _tab "int    " _tab "PELAYDUR        " _tab "%3f    " _tab `""Duration of layoff""' _n ///
"_column(286)"  _tab "byte   " _tab "PELAYFTO        " _tab "%2f    " _tab `""FT/PT status of job from which sample person was on layoff from""' _n ///
"_column(288)"  _tab "byte   " _tab "PULAYCK1        " _tab "%2f    " _tab `""Check item 1""' _n ///
"_column(290)"  _tab "byte   " _tab "PULAYCK2        " _tab "%2f    " _tab `""Check item 2 screen for dependent layoff""' _n ///
"_column(292)"  _tab "byte   " _tab "PULAYCK3        " _tab "%2f    " _tab `""Check item 3 filter for dependent I & O""' _n ///
"_column(294)"  _tab "byte   " _tab "PULK            " _tab "%2f    " _tab `""Have you been doing anything to find work during the last 4 weeks?""' _n ///
"_column(296)"  _tab "byte   " _tab "PELKM1          " _tab "%2f    " _tab `""What are all of the things you have done to find work during the last 4 weeks? (first method)""' _n ///
"_column(298)"  _tab "byte   " _tab "PULKM2          " _tab "%2f    " _tab `""Anything else? (second method)""' _n ///
"_column(300)"  _tab "byte   " _tab "PULKM3          " _tab "%2f    " _tab `""Anything else? (third method)""' _n ///
"_column(302)"  _tab "byte   " _tab "PULKM4          " _tab "%2f    " _tab `""Anything else? (fourth method)""' _n ///
"_column(304)"  _tab "byte   " _tab "PULKM5          " _tab "%2f    " _tab `""Anything else? (fifth method)""' _n ///
"_column(306)"  _tab "byte   " _tab "PULKM6          " _tab "%2f    " _tab `""Anything else? (sixth method)""' _n ///
"_column(308)"  _tab "byte   " _tab "PULKDK1         " _tab "%2f    " _tab `""You said you have been trying to find work. How did you go about looking? (first method)""' _n ///
"_column(310)"  _tab "byte   " _tab "PULKDK2         " _tab "%2f    " _tab `""Anything else? (second method)""' _n ///
"_column(312)"  _tab "byte   " _tab "PULKDK3         " _tab "%2f    " _tab `""Anything else? (third method)""' _n ///
"_column(314)"  _tab "byte   " _tab "PULKDK4         " _tab "%2f    " _tab `""Anything else? (fourth method)""' _n ///
"_column(316)"  _tab "byte   " _tab "PULKDK5         " _tab "%2f    " _tab `""Anything else? (fifth method)""' _n ///
"_column(318)"  _tab "byte   " _tab "PULKDK6         " _tab "%2f    " _tab `""Anything else? (sixth method)""' _n ///
"_column(320)"  _tab "byte   " _tab "PULKPS1         " _tab "%2f    " _tab `""Can you tell me more about what you did to search for work? (first method)""' _n ///
"_column(322)"  _tab "byte   " _tab "PULKPS2         " _tab "%2f    " _tab `""Anything else? (second method)""' _n ///
"_column(324)"  _tab "byte   " _tab "PULKPS3         " _tab "%2f    " _tab `""Anything else? (third method)""' _n ///
"_column(326)"  _tab "byte   " _tab "PULKPS4         " _tab "%2f    " _tab `""Anything else? (fourth method)""' _n ///
"_column(328)"  _tab "byte   " _tab "PULKPS5         " _tab "%2f    " _tab `""Anything else? (fifth method)""' _n ///
"_column(330)"  _tab "byte   " _tab "PULKPS6         " _tab "%2f    " _tab `""Anything else? (sixth method)""' _n ///
"_column(332)"  _tab "byte   " _tab "PELKAVL         " _tab "%2f    " _tab `""Last week, could you have started a job if one had been offered?""' _n ///
"_column(334)"  _tab "byte   " _tab "PULKAVR         " _tab "%2f    " _tab `""Why is that?""' _n ///
"_column(336)"  _tab "byte   " _tab "PELKLL1O        " _tab "%2f    " _tab `""Before you started looking for work, what were you doing: working, going to school, or something else?""' _n ///
"_column(338)"  _tab "byte   " _tab "PELKLL2O        " _tab "%2f    " _tab `""Did you lose or quit that job, or was it a temporary job that ended?""' _n ///
"_column(340)"  _tab "byte   " _tab "PELKLWO         " _tab "%2f    " _tab `""When last worked""' _n ///
"_column(342)"  _tab "int    " _tab "PELKDUR         " _tab "%3f    " _tab `""Duration of job seeking""' _n ///
"_column(345)"  _tab "byte   " _tab "PELKFTO         " _tab "%2f    " _tab `""FT/PT status of jobseeker""' _n ///
"_column(347)"  _tab "byte   " _tab "PEDWWNTO        " _tab "%2f    " _tab `""Do you currently want a job, either full or part time?""' _n ///
"_column(349)"  _tab "byte   " _tab "PEDWRSN         " _tab "%2f    " _tab `""What is the main reason you were not looking for work during the last 4 weeks?""' _n ///
"_column(351)"  _tab "byte   " _tab "PEDWLKO         " _tab "%2f    " _tab `""Did you look for work at any time in the last 12 months""' _n ///
"_column(353)"  _tab "byte   " _tab "PEDWWK          " _tab "%2f    " _tab `""Did you actually work at a job or business during the last 12 months?""' _n ///
"_column(355)"  _tab "byte   " _tab "PEDW4WK         " _tab "%2f    " _tab `""Did you do any of this work during the last 4 weeks?""' _n ///
"_column(357)"  _tab "byte   " _tab "PEDWLKWK        " _tab "%2f    " _tab `""Since you left that job or business have you looked for work?""' _n ///
"_column(359)"  _tab "byte   " _tab "PEDWAVL         " _tab "%2f    " _tab `""Last week, could you have started a job if one had been offered?""' _n ///
"_column(361)"  _tab "byte   " _tab "PEDWAVR         " _tab "%2f    " _tab `""Why is that?""' _n ///
"_column(363)"  _tab "byte   " _tab "PUDWCK1         " _tab "%2f    " _tab `""Screen for discouraged workers""' _n ///
"_column(365)"  _tab "byte   " _tab "PUDWCK2         " _tab "%2f    " _tab `""Screen for disabled""' _n ///
"_column(367)"  _tab "byte   " _tab "PUDWCK3         " _tab "%2f    " _tab `""Filter for retired""' _n ///
"_column(369)"  _tab "byte   " _tab "PUDWCK4         " _tab "%2f    " _tab `""Filter for passive job seekers""' _n ///
"_column(371)"  _tab "byte   " _tab "PUDWCK5         " _tab "%2f    " _tab `""Filter for passive job seekers""' _n ///
"_column(373)"  _tab "byte   " _tab "PEJHWKO         " _tab "%2f    " _tab `""Have you worked at a job or business at any time during the past 12 months?""' _n ///
"_column(375)"  _tab "byte   " _tab "PUJHDP1O        " _tab "%2f    " _tab `""Did you do any of this work in the last 4 weeks?""' _n ///
"_column(377)"  _tab "byte   " _tab "PEJHRSN         " _tab "%2f    " _tab `""What is the main reason you left your last job?""' _n ///
"_column(379)"  _tab "byte   " _tab "PEJHWANT        " _tab "%2f    " _tab `""Do you intend to look for work during the next 12 months?""' _n ///
"_column(381)"  _tab "byte   " _tab "PUJHCK1         " _tab "%2f    " _tab `""Filter for outgoing rotations""' _n ///
"_column(383)"  _tab "byte   " _tab "PUJHCK2         " _tab "%2f    " _tab `""Filter for persons going through the I and O series""' _n ///
"_column(385)"  _tab "byte   " _tab "PRABSREA        " _tab "%2f    " _tab `""Reason not at work and pay status""' _n ///
"_column(387)"  _tab "byte   " _tab "PRCIVLF         " _tab "%2f    " _tab `""Civilian labor force""' _n ///
"_column(389)"  _tab "byte   " _tab "PRDISC          " _tab "%2f    " _tab `""Discouraged worker recode""' _n ///
"_column(391)"  _tab "byte   " _tab "PREMPHRS        " _tab "%2f    " _tab `""Reason not at work or hours at work""' _n ///
"_column(393)"  _tab "byte   " _tab "PREMPNOT        " _tab "%2f    " _tab `""MLR - employed, unemployed, or NILF""' _n ///
"_column(395)"  _tab "byte   " _tab "PREXPLF         " _tab "%2f    " _tab `""Experienced labor force employment""' _n ///
"_column(397)"  _tab "byte   " _tab "PRFTLF          " _tab "%2f    " _tab `""Full time labor force""' _n /// 
"_column(399)"  _tab "byte   " _tab "PRHRUSL         " _tab "%2f    " _tab `""Usual hours worked weekly""' _n ///
"_column(401)"  _tab "byte   " _tab "PRJOBSEA        " _tab "%2f    " _tab `""Job search recode""' _n ///
"_column(403)"  _tab "byte   " _tab "PRPTHRS         " _tab "%2f    " _tab `""At work 1-34 by hours at work""' _n ///
"_column(405)"  _tab "byte   " _tab "PRPTREA         " _tab "%2f    " _tab `""Detailed reason for part-time""' _n ///
"_column(407)"  _tab "int    " _tab "PRUNEDUR        " _tab "%3f    " _tab `""Duration of unemployment for layoff and looking records""' _n ///
"_column(412)"  _tab "byte   " _tab "PRUNTYPE        " _tab "%2f    " _tab `""Reason for unemployment""' _n ///
"_column(414)"  _tab "byte   " _tab "PRWKSCH         " _tab "%2f    " _tab `""Labor force by time worked or lost""' _n ///
"_column(416)"  _tab "byte   " _tab "PRWKSTAT        " _tab "%2f    " _tab `""Full/part-time work status""' _n ///
"_column(418)"  _tab "byte   " _tab "PRWNTJOB        " _tab "%2f    " _tab `""NILF recode - want a job or other NILF""' _n ///
"_column(420)"  _tab "byte   " _tab "PUJHCK3         " _tab "%2f    " _tab `""Job history check item""' _n ///
"_column(422)"  _tab "byte   " _tab "PUJHCK4         " _tab "%2f    " _tab `""Screen for dependent NILF""' _n ///
"_column(424)"  _tab "byte   " _tab "PUJHCK5         " _tab "%2f    " _tab `""Screen for dependent NILF""' _n ///
"_column(426)"  _tab "byte   " _tab "PUIODP1         " _tab "%2f    " _tab `""Last month, it was reported that you worked for (employer's name). Do still work for (employer's name) (at your main job)?""' _n ///
"_column(428)"  _tab "byte   " _tab "PUIODP2         " _tab "%2f    " _tab `""Have the usual activities and duties of your job changed since last month?""' _n ///
"_column(430)"  _tab "byte   " _tab "PUIODP3         " _tab "%2f    " _tab `""Last month you were reported as (a/an) (occupation) and your usual activities were (description). Is this an accurate description of your current job?""' _n ///
"_column(432)"  _tab "byte   " _tab "PEIO1COW        " _tab "%2f    " _tab `""Individual class of worker code on first job""' _n ///
"_column(434)"  _tab "byte   " _tab "PUIO1MFG        " _tab "%2f    " _tab `""Is this business or organization mainly manufacturing, retail trade, wholesale trade, or something else?""' _n ///
"_column(442)"  _tab "byte   " _tab "PEIO2COW        " _tab "%2f    " _tab `""Individual class of worker on second job.""' _n ///
"_column(444)"  _tab "byte   " _tab "PUIO2MFG        " _tab "%2f    " _tab `""Is this business or organization mainly manufacturing, retail trade, wholesale trade, or something else?""' _n ///
"_column(452)"  _tab "byte   " _tab "PUIOCK1         " _tab "%2f    " _tab `""I & O check item 1 screen for dependent I and O""' _n ///
"_column(454)"  _tab "byte   " _tab "PUIOCK2         " _tab "%2f    " _tab `""I & O check item 2 screen for previous months I and O cases""' _n ///
"_column(456)"  _tab "byte   " _tab "PUIOCK3         " _tab "%2f    " _tab `""I & O check item 3""' _n ///
"_column(458)"  _tab "byte   " _tab "PRIOELG         " _tab "%2f    " _tab `""Industry and occupation eligibility flag""' _n ///
"_column(460)"  _tab "byte   " _tab "PRAGNA          " _tab "%2f    " _tab `""Agriculture/non-agriculture industry""' _n ///
"_column(462)"  _tab "byte   " _tab "PRCOW1          " _tab "%2f    " _tab `""Class of worker recode - job 1""' _n ///
"_column(464)"  _tab "byte   " _tab "PRCOW2          " _tab "%2f    " _tab `""Class of worker recode - job 2""' _n ///
"_column(466)"  _tab "byte   " _tab "PRCOWPG         " _tab "%2f    " _tab `""COW - private or government""' _n ///
"_column(468)"  _tab "byte   " _tab "PRDTCOW1        " _tab "%2f    " _tab `""Detailed class of worker recode - job 1""' _n ///
"_column(470)"  _tab "byte   " _tab "PRDTCOW2        " _tab "%2f    " _tab `""Detailed class of worker recode - job 2""' _n ///
"_column(472)"  _tab "byte   " _tab "PRDTIND1        " _tab "%2f    " _tab `""Detailed industry recode - job 1""' _n ///
"_column(474)"  _tab "byte   " _tab "PRDTIND2        " _tab "%2f    " _tab `""Detailed industry recode - job 2""' _n ///
"_column(476)"  _tab "byte   " _tab "PRDTOCC1        " _tab "%2f    " _tab `""Detailed occupation recode - job 1""' _n ///
"_column(478)"  _tab "byte   " _tab "PRDTOCC2        " _tab "%2f    " _tab `""Detailed occupation recode - job 2""' _n ///
"_column(480)"  _tab "byte   " _tab "PREMP           " _tab "%2f    " _tab `""Employed persons (non-farm & non-private hhld) recode""' _n ///
"_column(482)"  _tab "byte   " _tab "PRMJIND1        " _tab "%2f    " _tab `""Major industry recode - job 1""' _n ///
"_column(484)"  _tab "byte   " _tab "PRMJIND2        " _tab "%2f    " _tab `""Major industry recode - job 2""' _n ///
"_column(486)"  _tab "byte   " _tab "PRMJOCC1        " _tab "%2f    " _tab `""Major occupation recode - job 1""' _n ///
"_column(488)"  _tab "byte   " _tab "PRMJOCC2        " _tab "%2f    " _tab `""Major occupation recode - job 2""' _n ///
"_column(490)"  _tab "byte   " _tab "PRMJOCGR        " _tab "%2f    " _tab `""Major occupation categories""' _n ///
"_column(492)"  _tab "byte   " _tab "PRNAGPWS        " _tab "%2f    " _tab `""Non-agriculture, private wage and salary workers recode""' _n ///
"_column(494)"  _tab "byte   " _tab "PRNAGWS         " _tab "%2f    " _tab `""Non-agriculture wage and salary workers recode""' _n ///
"_column(496)"  _tab "byte   " _tab "PRSJMJ          " _tab "%2f    " _tab `""Single/multiple jobholder recode""' _n ///
"_column(498)"  _tab "byte   " _tab "PRERELG         " _tab "%2f    " _tab `""Earnings eligibility flag""' _n ///
"_column(500)"  _tab "byte   " _tab "PEERNUOT        " _tab "%2f    " _tab `""Do you usually receive overtime pay, tips, or commissions at your job?""' _n ///
"_column(502)"  _tab "byte   " _tab "PEERNPER        " _tab "%2f    " _tab `""Periodicity""' _n ///
"_column(504)"  _tab "byte   " _tab "PEERNRT         " _tab "%2f    " _tab `""(Even though you told me it is easier to report your earnings (periodicity); Are you paid at an hourly rate on your (main/this) job?""' _n ///
"_column(506)"  _tab "byte   " _tab "PEERNHRY        " _tab "%2f    " _tab `""Hourly/nonhourly status""' _n ///
"_column(508)"  _tab "int    " _tab "PUERNH1C        " _tab "%4f    " _tab `""What is your hourly rate of pay on this job, excluding overtime pay, tips or commission?""' _n ///
"_column(512)"  _tab "int    " _tab "PEERNH2         " _tab "%4f    " _tab `""(Excluding overtime pay, tips and commissions) what is your hourly rate of pay on your (main/this) job?""' _n ///
"_column(516)"  _tab "int    " _tab "PEERNH1O        " _tab "%4f    " _tab `""Out variable for hourly rate of pay""' _n ///
"_column(520)"  _tab "int    " _tab "PRERNHLY        " _tab "%4f    " _tab `""Recode for hourly rate""' _n ///
"_column(524)"  _tab "byte   " _tab "PTHR            " _tab "%1f    " _tab `""Hourly pay - top code""' _n ///
"_column(525)"  _tab "byte   " _tab "PEERNHRO        " _tab "%2f    " _tab `""Usual hours""' _n ///
"_column(527)"  _tab "long   " _tab "PRERNWA         " _tab "%8f    " _tab `""Weekly earnings recode""' _n ///
"_column(535)"  _tab "byte   " _tab "PTWK            " _tab "%1f    " _tab `""Weekly earnings - top code""' _n ///
"_column(540)"  _tab "long   " _tab "PEERN           " _tab "%8f    " _tab `""Calculated weekly overtime amount""' _n ///
"_column(548)"  _tab "long   " _tab "PUERN2          " _tab "%8f    " _tab `""Calculated weekly overtime amount""' _n ///
"_column(556)"  _tab "byte   " _tab "PTOT            " _tab "%1f    " _tab `""Weekly overtime amount - top code""' _n ///
"_column(559)"  _tab "byte   " _tab "PEERNWKP        " _tab "%2f    " _tab `""How many weeks a year do you get paid for?""' _n ///
"_column(561)"  _tab "byte   " _tab "PEERNLAB        " _tab "%2f    " _tab `""On this job, are you a member of a labor union or of an employee association similar to a union?""' _n ///
"_column(563)"  _tab "byte   " _tab "PEERNCOV        " _tab "%2f    " _tab `""On this job are you covered by a union or employee association contract?""' _n ///
"_column(565)"  _tab "byte   " _tab "PENLFJH         " _tab "%2f    " _tab `""When did you last work at a job or business?""' _n ///
"_column(567)"  _tab "byte   " _tab "PENLFRET        " _tab "%2f    " _tab `""Are you retired from a job or business?""' _n ///
"_column(569)"  _tab "byte   " _tab "PENLFACT        " _tab "%2f    " _tab `""What best describes your situation at this time? For example, are you disabled, ill, in school, taking care of house or family, or something else?""' _n ///
"_column(571)"  _tab "byte   " _tab "PUNLFCK1        " _tab "%2f    " _tab `""Not in labor force check item - 1""' _n ///
"_column(573)"  _tab "byte   " _tab "PUNLFCK2        " _tab "%2f    " _tab `""Not in labor force check item - 2""' _n ///
"_column(575)"  _tab "byte   " _tab "PESCHENR        " _tab "%2f    " _tab `""Last week, were you enrolled in a high school, college, or university?""' _n ///
"_column(577)"  _tab "byte   " _tab "PESCHFT         " _tab "%2f    " _tab `""Are you enrolled in school as a full-time or part-time student?""' _n ///
"_column(579)"  _tab "byte   " _tab "PESCHLVL        " _tab "%2f    " _tab `""Would that be high school, college, or university?""' _n ///
"_column(581)"  _tab "byte   " _tab "PRNLFSCH        " _tab "%2f    " _tab `""NLF activity - in school or not in school""' _n ///
"_column(583)"  _tab "double " _tab "PWFMWGT         " _tab "%10.4f " _tab `""Family weight""' _n ///
"_column(593)"  _tab "double " _tab "PWLGWGT         " _tab "%10.4f " _tab `""Longitudinal weight""' _n /// 
"_column(603)"  _tab "double " _tab "PWORWGT         " _tab "%10.4f " _tab `""Outgoing rotation weight""' _n ///
"_column(613)"  _tab "double " _tab "PWSSWGT         " _tab "%10.4f " _tab `""Final weight""' _n ///
"_column(623)"  _tab "double " _tab "PWVETWGT        " _tab "%10.4f " _tab `""Veterans weight""' _n ///
"_column(633)"  _tab "byte   " _tab "PRCHLD          " _tab "%2f    " _tab `""Presence of own children < 18 years of age by selected age group""' _n ///
"_column(635)"  _tab "byte   " _tab "PRNMCHLD        " _tab "%2f    " _tab `""Number of own children < 18 years of age""' _n ///       
"_column(637)"  _tab "byte   " _tab "PXPDEMP1        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(639)"  _tab "byte   " _tab "PRWERNAL        " _tab "%2f    " _tab `""Allocation flag weekly earnings recode (PRERNWA)""' _n ///
"_column(641)"  _tab "byte   " _tab "PRHERNAL        " _tab "%2f    " _tab `""Allocation flag hourly earnings recode (PRERNHLY)""' _n ///
"_column(643)"  _tab "byte   " _tab "HXTENURE        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(645)"  _tab "byte   " _tab "HXHOUSUT        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(647)"  _tab "byte   " _tab "HXTELHHD        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(649)"  _tab "byte   " _tab "HXTELAVL        " _tab "%2f    " _tab `""Allocation flag""' _n ///  
"_column(651)"  _tab "byte   " _tab "HXPHONEO        " _tab "%2f    " _tab `""Allocation flag""' _n ///                                        
"_column(653)"  _tab "byte   " _tab "PXINUSYR        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(655)"  _tab "byte   " _tab "PXRRP           " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(657)"  _tab "byte   " _tab "PXPARENT        " _tab "%2f    " _tab `""Allocation flag""' _n ///  
"_column(659)"  _tab "byte   " _tab "PXAGE           " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(661)"  _tab "byte   " _tab "PXMARITL        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(663)"  _tab "byte   " _tab "PXSPOUSE        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(665)"  _tab "byte   " _tab "PXSEX           " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(667)"  _tab "byte   " _tab "PXAFWHN1        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(669)"  _tab "byte   " _tab "PXAFNOW         " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(671)"  _tab "byte   " _tab "PXEDUCA         " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(673)"  _tab "byte   " _tab "PXRACE1         " _tab "%2f    " _tab `""Allocation flag""' _n ///        
"_column(675)"  _tab "byte   " _tab "PXNATVTY        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(677)"  _tab "byte   " _tab "PXMNTVTY        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(679)"  _tab "byte   " _tab "PXFNTVTY        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(681)"  _tab "byte   " _tab "PXNMEMP1        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(683)"  _tab "byte   " _tab "PXHSPNON        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(685)"  _tab "byte   " _tab "PXMLR           " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(687)"  _tab "byte   " _tab "PXRET1          " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(689)"  _tab "byte   " _tab "PXABSRSN        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(691)"  _tab "byte   " _tab "PXABSPDO        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(693)"  _tab "byte   " _tab "PXMJOT          " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(695)"  _tab "byte   " _tab "PXMJNUM         " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(697)"  _tab "byte   " _tab "PXHRUSL1        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(699)"  _tab "byte   " _tab "PXHRUSL2        " _tab "%2f    " _tab `""Allocation flag""' _n ///                              
"_column(701)"  _tab "byte   " _tab "PXHRFTPT        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(703)"  _tab "byte   " _tab "PXHRUSLT        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(705)"  _tab "byte   " _tab "PXHRWANT        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(707)"  _tab "byte   " _tab "PXHRRSN1        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(709)"  _tab "byte   " _tab "PXHRRSN2        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(711)"  _tab "byte   " _tab "PXHRACT1        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(713)"  _tab "byte   " _tab "PXHRACT2        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(715)"  _tab "byte   " _tab "PXHRACTT        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(717)"  _tab "byte   " _tab "PXHRRSN3        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(719)"  _tab "byte   " _tab "PXHRAVL         " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(721)"  _tab "byte   " _tab "PXLAYAVL        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(723)"  _tab "byte   " _tab "PXLAYLK         " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(725)"  _tab "byte   " _tab "PXLAYDUR        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(727)"  _tab "byte   " _tab "PXLAYFTO        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(729)"  _tab "byte   " _tab "PXLKM1          " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(731)"  _tab "byte   " _tab "PXLKAVL         " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(733)"  _tab "byte   " _tab "PXLKLL1O        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(735)"  _tab "byte   " _tab "PXLKLL2O        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(737)"  _tab "byte   " _tab "PXLKLWO         " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(739)"  _tab "byte   " _tab "PXLKDUR         " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(741)"  _tab "byte   " _tab "PXLKFTO         " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(743)"  _tab "byte   " _tab "PXDWWNTO        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(745)"  _tab "byte   " _tab "PXDWRSN         " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(747)"  _tab "byte   " _tab "PXDWLKO         " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(749)"  _tab "byte   " _tab "PXDWWK          " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(751)"  _tab "byte   " _tab "PXDW4WK         " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(753)"  _tab "byte   " _tab "PXDWLKWK        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(755)"  _tab "byte   " _tab "PXDWAVL         " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(757)"  _tab "byte   " _tab "PXDWAVR         " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(759)"  _tab "byte   " _tab "PXJHWKO         " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(761)"  _tab "byte   " _tab "PXJHRSN         " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(763)"  _tab "byte   " _tab "PXJHWANT        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(765)"  _tab "byte   " _tab "PXIO1COW        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(767)"  _tab "byte   " _tab "PXIO1ICD        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(769)"  _tab "byte   " _tab "PXIO1OCD        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(771)"  _tab "byte   " _tab "PXIO2COW        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(773)"  _tab "byte   " _tab "PXIO2ICD        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(775)"  _tab "byte   " _tab "PXIO2OCD        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(777)"  _tab "byte   " _tab "PXERNUOT        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(779)"  _tab "byte   " _tab "PXERNPER        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(781)"  _tab "byte   " _tab "PXERNH1O        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(783)"  _tab "byte   " _tab "PXERNHRO        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(785)"  _tab "byte   " _tab "PXERN           " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(787)"  _tab "byte   " _tab "PXPDEMP2        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(789)"  _tab "byte   " _tab "PXNMEMP2        " _tab "%2f    " _tab `""Allocation flag""' _n ///                               
"_column(791)"  _tab "byte   " _tab "PXERNWKP        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(793)"  _tab "byte   " _tab "PXERNRT         " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(795)"  _tab "byte   " _tab "PXERNHRY        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(797)"  _tab "byte   " _tab "PXERNH2         " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(799)"  _tab "byte   " _tab "PXERNLAB        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(801)"  _tab "byte   " _tab "PXERNCOV        " _tab "%2f    " _tab `""Allocation flag""' _n ///  
"_column(803)"  _tab "byte   " _tab "PXNLFJH         " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(805)"  _tab "byte   " _tab "PXNLFRET        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(807)"  _tab "byte   " _tab "PXNLFACT        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(809)"  _tab "byte   " _tab "PXSCHENR        " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(811)"  _tab "byte   " _tab "PXSCHFT         " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(813)"  _tab "byte   " _tab "PXSCHLVL        " _tab "%2f    " _tab `""Allocation flag""' _n ///    
"_column(815)"  _tab "long   " _tab "QSTNUM          " _tab "%5f    " _tab `""Unique household identifier.""' _n ///
"_column(820)"  _tab "byte   " _tab "OCCURNUM        " _tab "%2f    " _tab `""Unique person identifier.""' _n ///
"_column(822)"  _tab "byte   " _tab "PEDIPGED        " _tab "%2f    " _tab `""How did...get...'s high school diploma?""' _n ///
"_column(824)"  _tab "byte   " _tab "PEHGCOMP        " _tab "%2f    " _tab `""What was the highest grade of regular school...completed before receiving...'s GED?""' _n ///
"_column(826)"  _tab "byte   " _tab "PECYC           " _tab "%2f    " _tab `""How many years of college credit has...completed?""' _n ///
"_column(834)"  _tab "byte   " _tab "PXDIPGED        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(836)"  _tab "byte   " _tab "PXHGCOMP        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(838)"  _tab "byte   " _tab "PXCYC           " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(846)"  _tab "double " _tab "PWCMPWGT        " _tab "%10.4f " _tab `""Composited final weight. Used to create BLS's published labor force statistics""' _n ///
"_column(856)"  _tab "int    " _tab "PEIO1ICD        " _tab "%4f    " _tab `""Industry code for primary job""' _n ///
"_column(860)"  _tab "int    " _tab "PEIO1OCD        " _tab "%4f    " _tab `""Occupation code for primary job.""' _n ///
"_column(864)"  _tab "int    " _tab "PEIO2ICD        " _tab "%4f    " _tab `""Industry code for second job.""' _n ///
"_column(868)"  _tab "int    " _tab "PEIO2OCD        " _tab "%4f    " _tab `""Occupation code for second job.""' _n ///
"_column(872)"  _tab "byte   " _tab "PRIMIND1        " _tab "%2f    " _tab `""Intermediate industry recode (job 1)""' _n ///
"_column(874)"  _tab "byte   " _tab "PRIMIND2        " _tab "%2f    " _tab `""Intermediate industry recode (job 2)""' _n ///
"_column(876)"  _tab "byte   " _tab "PEAFWHN1        " _tab "%2f    " _tab `""When did you serve?""' _n ///
"_column(878)"  _tab "byte   " _tab "PEAFWHN2        " _tab "%2f    " _tab `""When did you serve?""' _n ///
"_column(880)"  _tab "byte   " _tab "PEAFWHN3        " _tab "%2f    " _tab `""When did you serve?""' _n ///
"_column(882)"  _tab "byte   " _tab "PEAFWHN4        " _tab "%2f    " _tab `""When did you serve?""' _n ///
"_column(884)"  _tab "byte   " _tab "PXAFEVER        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(886)"  _tab "byte   " _tab "PELNDAD         " _tab "%2f    " _tab `""Line number of father""' _n ///            
"_column(888)"  _tab "byte   " _tab "PELNMOM         " _tab "%2f    " _tab `""Line number of mother""' _n ///      
"_column(890)"  _tab "byte   " _tab "PEDADTYP        " _tab "%2f    " _tab `""Type of father""' _n /// 
"_column(892)"  _tab "byte   " _tab "PEMOMTYP        " _tab "%2f    " _tab `""Type of mother""' _n /// 
"_column(894)"  _tab "byte   " _tab "PECOHAB         " _tab "%2f    " _tab `""Line number of cohabiting partner""' _n ///
"_column(896)"  _tab "byte   " _tab "PXLNDAD         " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(898)"  _tab "byte   " _tab "PXLNMOM         " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(900)"  _tab "byte   " _tab "PXDADTYP        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(902)"  _tab "byte   " _tab "PXMOMTYP        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(904)"  _tab "byte   " _tab "PXCOHAB         " _tab "%2f    " _tab `""Allocation flag""' _n /// 
"_column(906)"  _tab "byte   " _tab "PEDISEAR        " _tab "%2f    " _tab `""Is...deaf or does ...have serious difficulty hearing?""' _n ///
"_column(908)"  _tab "byte   " _tab "PEDISEYE        " _tab "%2f    " _tab `""Is...blind or does...have serious difficulty seeing even when wearing glasses?""' _n ///
"_column(910)"  _tab "byte   " _tab "PEDISREM        " _tab "%2f    " _tab `""Because of a physical, mental, or emotional condition, does...have serious difficulty concentrating, remembering, or making decisions?""' _n ///
"_column(912)"  _tab "byte   " _tab "PEDISPHY        " _tab "%2f    " _tab `""Does...have serious difficulty walking or climbing stairs?""' _n ///
"_column(914)"  _tab "byte   " _tab "PEDISDRS        " _tab "%2f    " _tab `""Does...have difficulty dressing or bathing?""' _n ///
"_column(916)"  _tab "byte   " _tab "PEDISOUT        " _tab "%2f    " _tab `""Because of a physical, mental, or emotional condition, does...have difficulty doing errands alone such as visiting a doctor’s office or shopping?""' _n ///
"_column(918)"  _tab "byte   " _tab "PRDISFLG        " _tab "%2f    " _tab `""Does this person have any of these disability conditions?""' _n ///
"_column(920)"  _tab "byte   " _tab "PXDISEAR        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(922)"  _tab "byte   " _tab "PXDISEYE        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(924)"  _tab "byte   " _tab "PXDISREM        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(926)"  _tab "byte   " _tab "PXDISPHY        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(928)"  _tab "byte   " _tab "PXDISDRS        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(930)"  _tab "byte   " _tab "PXDISOUT        " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(932)"  _tab "byte   " _tab "HXFAMINC        " _tab "%2f    " _tab `""Allocation flag""' _n ///    
"_column(934)"  _tab "byte   " _tab "PRDASIAN        " _tab "%2f    " _tab `""Detailed Asian race recode""' _n ///
"_column(936)"  _tab "byte   " _tab "PEPDEMP1        " _tab "%2f    " _tab `""Does this person usually have any paid employees?""' _n ///
"_column(938)"  _tab "byte   " _tab "PTNMEMP1        " _tab "%2f    " _tab `""Excluding all owners, how many paid employees does this person usually have?""' _n ///
"_column(940)"  _tab "byte   " _tab "PEPDEMP2        " _tab "%2f    " _tab `""Does this person usually have any paid employees?""' _n ///
"_column(942)"  _tab "byte   " _tab "PTNMEMP2        " _tab "%2f    " _tab `""Excluding all owners, how many paid employees does this person usually have?""' _n ///
"_column(944)"  _tab "byte   " _tab "PECERT1         " _tab "%2f    " _tab `""Does...have a currently active professional certification or a state or industry license?""' _n ///        
"_column(946)"  _tab "byte   " _tab "PECERT2         " _tab "%2f    " _tab `""Were any of …s certifications or licenses issued by the federal, state, or local government?""' _n ///
"_column(948)"  _tab "byte   " _tab "PECERT3         " _tab "%2f    " _tab `""Earlier you told me that you had a currently active professional certification or license.  Is your certification or license required for your …""' _n ///
"_column(950)"  _tab "byte   " _tab "PXCERT1         " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(952)"  _tab "byte   " _tab "PXCERT2         " _tab "%2f    " _tab `""Allocation flag""' _n ///          
"_column(954)"  _tab "byte   " _tab "PXCERT3         " _tab "%2f    " _tab `""Allocation flag""' _n ///
"_column(1001)" _tab "byte   " _tab "PENXTPR         " _tab "%2f    " _tab `""Line number of person being interviewed""' _n ///        
"_column(1003)" _tab "byte   " _tab "PENXTPR3        " _tab "%2f    " _tab `""Is this self or proxy?""' _n ///
"_column(1005)" _tab "byte   " _tab "PEA1            " _tab "%2f    " _tab `""(Have/Has) (you/ name) smoked at least 100 cigarettes in (your/his/her) entire life? 100 cigarettes = approximately 5 packs""' _n ///
"_column(1007)" _tab "int    " _tab "PEA2            " _tab "%3f    " _tab `""How old (were/was) (you/name) when (you/he/she) first started smoking cigarettes FAIRLY REGULARLY?""' _n ///
"_column(1010)" _tab "int    " _tab "PEA2A           " _tab "%3f    " _tab `""You said that (you/name) never smoked regularly.  How old (were/was) (you/name) the first time (you/he/she) smoked part or all of a cigarette?""' _n ///
"_column(1013)" _tab "byte   " _tab "PEA3            " _tab "%2f    " _tab `""(Do/Does) (you/name) now smoke cigarettes every day, some days, or not at all?""' _n ///
"_column(1015)" _tab "int    " _tab "PTB1            " _tab "%3f    " _tab `""On the average, about how many cigarettes do you now smoke each day?""' _n ///        
"_column(1018)" _tab "byte   " _tab "PEB1A           " _tab "%2f    " _tab `""Would you say that, on average, you now smoke more or less than 20 cigarettes each day?""' _n ///
"_column(1020)" _tab "byte   " _tab "PEB2            " _tab "%2f    " _tab `""Do you usually smoke menthol or non-menthol cigarettes?""' _n /// 
"_column(1022)" _tab "byte   " _tab "PEB5ANUM        " _tab "%2f    " _tab `""How soon after you wake up do you typically smoke your first cigarette of the day? (number)""' _n ///
"_column(1024)" _tab "byte   " _tab "PEB5AUNT        " _tab "%2f    " _tab `""How soon after you wake up do you typically smoke your first cigarette of the day? (unit)""' _n ///
"_column(1026)" _tab "byte   " _tab "PEB5B           " _tab "%2f    " _tab `""Would you say you smoke your first cigarette of the day within the first 30 minutes?""' _n ///
"_column(1028)" _tab "byte   " _tab "PEBA6A          " _tab "%2f    " _tab `""Do you usually buy your own cigarettes?""' _n ///
"_column(1030)" _tab "byte   " _tab "PEB6A           " _tab "%2f    " _tab `""Do you USUALLY buy your cigarettes by the pack or by the carton?""' _n ///
"_column(1032)" _tab "double " _tab "PTB6B           " _tab "%5f    " _tab `""What price did you pay for the LAST pack of cigarettes you bought? Please report the cost after using discounts or coupons.""' _n ///
"_column(1037)" _tab "double " _tab "PTB6C           " _tab "%6f    " _tab `""What price did you pay for the LAST carton of cigarettes you bought? Please report the cost after using discounts or coupons.""' _n ///
"_column(1043)" _tab "byte   " _tab "PEB6C4          " _tab "%2f    " _tab `""Did you use coupons, rebates, or any other special promotions when you bought your LAST (B6a fill PACK/CARTON) of cigarettes?""' _n ///
"_column(1045)" _tab "byte   " _tab "PEB6D1          " _tab "%2f    " _tab `""Did you buy your LAST (pack/carton) of cigarettes in (fill respondents state of residence) or in some other state?""' _n ///
"_column(1047)" _tab "byte   " _tab "PEB6D21         " _tab "%2f    " _tab `""In what other state did you buy your LAST (pack/carton) of cigarettes?""' _n ///
"_column(1049)" _tab "byte   " _tab "PEB6D3          " _tab "%2f    " _tab `""Did you buy you LAST (pack/carton) of cigarettes from an Indian reservation?""' _n ///
"_column(1051)" _tab "byte   " _tab "PEB6DOTH        " _tab "%2f    " _tab `""Was the Other Way in which you purchased your LAST (pack/carton) of cigarettes:""' _n ///
"_column(1053)" _tab "byte   " _tab "PEB6E1          " _tab "%2f    " _tab `""In the LAST 2 months, have you bought any SINGLE or INDIVIDUAL cigarettes?""' _n ///
"_column(1055)" _tab "byte   " _tab "PEB6E31         " _tab "%2f    " _tab `""Did you buy your LAST SINGLE or INDIVIDUAL cigarette in [fill respondents state of residence] or in some other state or country?""' _n ///
"_column(1057)" _tab "int    " _tab "PRB6E32A        " _tab "%3f    " _tab `""In what OTHER state or country did you buy your LAST SINGLE OR INDIVIDUAL cigarette?""' _n ///
"_column(1060)" _tab "byte   " _tab "PEB6E4          " _tab "%2f    " _tab `""In the LAST 2 months, have you bought loose tobacco to roll-your-own cigarettes?""' _n ///
"_column(1062)" _tab "byte   " _tab "PEB7C           " _tab "%2f    " _tab `""For how long have you smoked EVERY DAY?""' _n ///
"_column(1064)" _tab "byte   " _tab "PEB7C2          " _tab "%2f    " _tab `""Have you EVER smoked MENTHOL cigarettes for 6 months or more?""' _n ///
"_column(1066)" _tab "byte   " _tab "PEB7C3          " _tab "%2f    " _tab `""For how long (have you smoked/did you smoke) MENTHOL cigarettes?""' _n ///
"_column(1068)" _tab "byte   " _tab "PEB8            " _tab "%2f    " _tab `""Around this time 12 MONTHS AGO, were you smoking cigarettes every day, some days, or not at all?""' _n ///
"_column(1070)" _tab "int    " _tab "PTB9            " _tab "%3f    " _tab `""Around this time 12 months ago, on the average about how many cigarettes did you smoke each day?""' _n ///
"_column(1073)" _tab "byte   " _tab "PEB10A          " _tab "%2f    " _tab `""Around this time 12 months age, on how many of 30 days in the month did you smoke cigarettes?""' _n ///
"_column(1075)" _tab "int    " _tab "PTB10B          " _tab "%3f    " _tab `""On the average, on those (fill entry B10a) days, how many cigarettes did you usually smoke each day?""' _n ///
"_column(1078)" _tab "byte   " _tab "PEC1            " _tab "%2f    " _tab `""On how many of the past 30 days did you smoke cigarettes?""' _n ///
"_column(1080)" _tab "byte   " _tab "PEC1I           " _tab "%2f    " _tab `""Would you say you smoked on at least 12 days in the past 30 days?""' _n ///
"_column(1082)" _tab "int    " _tab "PTC1A           " _tab "%3f    " _tab `""On the average, on those (fill entry C1) days, how many cigarettes did you usually smoke each day?""' _n ///
"_column(1085)" _tab "byte   " _tab "PEC2            " _tab "%2f    " _tab `""Do you usually smoke menthol or non-menthol cigarettes?""' _n ///
"_column(1087)" _tab "byte   " _tab "PEC5ANUM        " _tab "%2f    " _tab `""On the days that you smoke, how soon after you wake up do you typically smoke your first cigarette of the day? (number)""' _n ///        
"_column(1089)" _tab "byte   " _tab "PEC5AUNT        " _tab "%2f    " _tab `""On the days that you smoke, how soon after you wake up do you typically smoke your first cigarette of the day? (unit)""' _n ///
"_column(1091)" _tab "byte   " _tab "PEC5B           " _tab "%2f    " _tab `""On the days that you smoke, would you say you smoke your first cigarette of the day within the first 30 minutes?""' _n ///
"_column(1093)" _tab "byte   " _tab "PECA6A          " _tab "%2f    " _tab `""Do you usually buy your own cigarettes?""' _n ///
"_column(1095)" _tab "byte   " _tab "PEC6A           " _tab "%2f    " _tab `""Do you USUALLY buy your cigarettes by the pack or by the carton?""' _n ///
"_column(1097)" _tab "double " _tab "PTC6B           " _tab "%5f    " _tab `""What price did you pay for the LAST pack of cigarettes you bought? Please report the cost after using discounts or coupons.""' _n ///
"_column(1102)" _tab "double " _tab "PTC6C           " _tab "%6f    " _tab `""What price did you pay for the LAST carton of cigarettes you bought? Please report the cost after using discounts or coupons.""' _n ///
"_column(1108)" _tab "byte   " _tab "PEC6C4          " _tab "%2f    " _tab `""Did you use coupons, rebates, or any other special promotions when you bought your LAST (pack/carton) of cigarettes?""' _n ///
"_column(1110)" _tab "byte   " _tab "PEC6D1          " _tab "%2f    " _tab `""Did you buy your LAST (pack/carton) of cigarettes in (fill respondent's state of residence) or in some other state?""' _n ///
"_column(1112)" _tab "byte   " _tab "PEC6D21         " _tab "%2f    " _tab `""In what other state did you buy your LAST (pack/carton) of cigarettes?""' _n ///
"_column(1114)" _tab "byte   " _tab "PEC6D3          " _tab "%2f    " _tab `""Did you buy your LAST (pack/carton) of cigarettes from an Indian reservation?""' _n ///
"_column(1116)" _tab "byte   " _tab "PEC6DOTH        " _tab "%2f    " _tab `""Was the 'Other Way' in which you purchased your Last (pack/carton) of cigarettes.""' _n ///
"_column(1118)" _tab "byte   " _tab "PEC6E1          " _tab "%2f    " _tab `""In the LAST 2 months, have you bought any SINGLE or INDIVIDUAL cigarettes?""' _n ///
"_column(1120)" _tab "byte   " _tab "PEC6E31         " _tab "%2f    " _tab `""Did you buy your LAST SINGLE or INDIVIDUAL cigarette in (fill respondents state of residence) or in some other state or other country?""' _n ///
"_column(1122)" _tab "int    " _tab "PRC6E32A        " _tab "%3f    " _tab `""In what OTHER state or country did you buy your LAST SINGLE OR INDIVIDUAL cigarette?""' _n ///
"_column(1125)" _tab "byte   " _tab "PEC6E4          " _tab "%2f    " _tab `""In the LAST 2 months, have you bought loose tobacco to roll-your-own cigarettes?""' _n ///
"_column(1127)" _tab "byte   " _tab "PEC7A           " _tab "%2f    " _tab `""Have you EVER smoked cigarettes EVERY DAY for at least 6 months?""' _n ///
"_column(1129)" _tab "byte   " _tab "PEC7D           " _tab "%2f    " _tab `""For how long did you smoke EVERY DAY?""' _n ///
"_column(1131)" _tab "byte   " _tab "PEC7D2          " _tab "%2f    " _tab `""Have you EVER smoked MENTHOL cigarettes for 6 months or more?""' _n ///
"_column(1133)" _tab "byte   " _tab "PEC7D3          " _tab "%2f    " _tab `""For how long (have you smoked/did you smoke) MENTHOL cigarettes?""' _n ///
"_column(1135)" _tab "byte   " _tab "PTC7E           " _tab "%2f    " _tab `""When you last smoked every day, on average how many cigarettes did you smoke each day?""' _n ///
"_column(1137)" _tab "byte   " _tab "PEC8            " _tab "%2f    " _tab `""Around this time 12 MONTHS AGO, were you smoking cigarettes every day, some days, or not at all?""' _n ///
"_column(1139)" _tab "int    " _tab "PTC9            " _tab "%3f    " _tab `""Around this time 12 months ago, on the average about how many cigarettes did you smoke each day?""' _n ///
"_column(1142)" _tab "byte   " _tab "PEC10A          " _tab "%2f    " _tab `""Around this time 12 months age, on how many of 30 days in the month did you smoke cigarettes?""' _n ///
"_column(1144)" _tab "int    " _tab "PTC10B          " _tab "%3f    " _tab `""On the average, on those (fill entry c10a) days, how many cigarettes did you usually smoke each day?""' _n ///
"_column(1147)" _tab "byte   " _tab "PEDa            " _tab "%2f    " _tab `""During the PAST 12 MONTHS, have you TRIED to QUIT smoking COMPLETELY?""' _n ///                                                                                                                                          
"_column(1149)" _tab "byte   " _tab "PEDB            " _tab "%2f    " _tab `""Have you EVER TRIED to QUIT smoking COMPLETELY?""' _n ///
"_column(1151)" _tab "byte   " _tab "PED1R           " _tab "%2f    " _tab `""During the PAST 12 MONTHS, have you stopped smoking for one day or longer BECAUSE YOU WERE TRYING TO QUIT SMOKING?""' _n ///                                                                                 
"_column(1153)" _tab "byte   " _tab "PED3            " _tab "%2f    " _tab `""How many TIMES during the past 12 months have you stopped smoking for one day or longer BECAUSE YOU WERE TRYING TO QUIT SMOKING?""' _n ///                                                                   
"_column(1155)" _tab "byte   " _tab "PED3B           " _tab "%2f    " _tab `""Would you say that during the past 12 months it was MORE THAN 3 TIMES that you have stopped smoking for one day or longer BECAUSE YOU WERE TRYING TO QUIT SMOKING/TRIED to QUIT smoking COMPLETELY?""' _n ///
"_column(1157)" _tab "byte   " _tab "PED6NUM         " _tab "%2f    " _tab `""During the PAST 12 MONTHS, what is the length of this single quit attempt where you stopped smoking because you were TRYING to quit smoking? (number)""' _n ///
"_column(1159)" _tab "byte   " _tab "PED6UNT         " _tab "%2f    " _tab `""During the PAST 12 MONTHS, what is the length of this single quit attempt where you stopped smoking because you were TRYING to quit smoking? (unit)""' _n ///
"_column(1161)" _tab "byte   " _tab "PED6B           " _tab "%2f    " _tab `""Was it more or less than one week?""' _n ///
"_column(1163)" _tab "byte   " _tab "PED6CNUM        " _tab "%2f    " _tab `""Thinking of those attempts during the past 12 months, what was the length of time of the ONE attempt that lasted the longest? (number)""' _n ///
"_column(1165)" _tab "byte   " _tab "PED6CUNT        " _tab "%2f    " _tab `""Thinking of those attempts during the past 12 months, what was the length of time of the ONE attempt that lasted the longest? (unit)""' _n ///
"_column(1167)" _tab "byte   " _tab "PED6C2          " _tab "%2f    " _tab `""Was it more or less than one week?""' _n ///
"_column(1169)" _tab "byte   " _tab "PED7R           " _tab "%2f    " _tab `""DURING THE PAST 12 MONTHS, have you made a serious attempt to stop smoking because you were TRYING to quit – even if you stopped for less than a day?""' _n ///
"_column(1171)" _tab "byte   " _tab "PED8R           " _tab "%2f    " _tab `""Have you EVER made a serious attempt to stop smoking because you were 'TRYING to quit'; even if you stopped for less than a day?""' _n ///
"_column(1173)" _tab "byte   " _tab "PEE1A123        " _tab "%2f    " _tab `""Thinking back to the (LAST TIME/time) you tried to QUIT smoking in the past 12 months: Did you use ANY of the following PRODUCTS: A NICOTINE … patch, gum, lozenge, nasal spray or inhaler?""' _n ///
"_column(1175)" _tab "byte   " _tab "PEE1A7AB        " _tab "%2f    " _tab `""Thinking back to the (LAST TIME/time) you tried to QUIT smoking in the past 12 months: Did you use ANY of the following PRODUCTS: A prescription pill, called Chantix, Varenicline, Zyban, Bupropion, or Wellbutrin?""' _n ///
"_column(1177)" _tab "byte   " _tab "PEE1B1          " _tab "%2f    " _tab `""Thinking back to the (last time/time) you tried to QUIT smoking in the past 12 months. Did you use ANY of the following: A telephone help line or quit line?""' _n ///
"_column(1179)" _tab "byte   " _tab "PEE1B2          " _tab "%2f    " _tab `""Thinking back to the (last time/time) you tried to QUIT smoking in the past 12 months. Did you use ANY of the following: One-on-one IN-PERSON counseling by a health professional?""' _n ///
"_column(1181)" _tab "byte   " _tab "PEE1B3          " _tab "%2f    " _tab `""Thinking back to the (last time/time) you tried to QUIT smoking in the past 12 months. Did you use ANY of the following: A stop smoking clinic, class, or support group?""' _n ///
"_column(1183)" _tab "byte   " _tab "PEE1B5          " _tab "%2f    " _tab `""Thinking back to the (last time/time) you tried to QUIT smoking in the past 12 months. Did you use ANY of the following: Internet or a web-based program or tool including smartphone apps and text messaging programs?""' _n ///
"_column(1185)" _tab "byte   " _tab "PEE1C2          " _tab "%2f    " _tab `""The (last time/time) you tried to QUIT smoking in the past 12 months: Did you do ANY of the following: Try to quit by SWITCHING to smokeless tobacco such as chewing tobacco, snuff, or snus?""' _n ///
"_column(1187)" _tab "byte   " _tab "PEE1C2B         " _tab "%2f    " _tab `""The (last time/time) you tried to QUIT smoking in the past 12 months. Did you do ANY of the following: Try to quit by SWITCHING to regular cigars, cigarillos, little filtered cigars or any pipes filled with tobacco?""' _n ///
"_column(1189)" _tab "byte   " _tab "PEE1C2C         " _tab "%2f    " _tab `""The (last time/time) you tried to QUIT smoking in the past 12 months. Did you do ANY of the following: Try to quit by SWITCHING to electronic or E-cigarettes? You may also know them as vape-pens, e-hookah, vapes or mods.""' _n ///
"_column(1191)" _tab "byte   " _tab "PEE1C2D1        " _tab "%2f    " _tab `""Did you switch to? Cigars, cigarillos, little filtered cigars.""' _n ///
"_column(1193)" _tab "byte   " _tab "PEE1C2D2        " _tab "%2f    " _tab `""Did you switch to? Regular pipes filled with tobacco.""' _n ///
"_column(1195)" _tab "byte   " _tab "PEE1C2D3        " _tab "%2f    " _tab `""Did you switch to? Water or hookah (pronounced who-kah) pipes filled with tobacco.""' _n ///
"_column(1197)" _tab "byte   " _tab "PEE1CZ2C        " _tab "%2f    " _tab `""The (LAST TIME/TIME) you tried to quit smoking in the past 12 months, did you try to quit by SWITCHING to electronic or E-Cigarettes? You may also know them as vape-pens, e-hookah, vapes or mods.""' _n ///
"_column(1199)" _tab "byte   " _tab "PEF1A           " _tab "%2f    " _tab `""In the PAST 12 MONTHS, have you seen a medical doctor?""' _n ///                                                                                                                                    
"_column(1201)" _tab "byte   " _tab "PEF1B           " _tab "%2f    " _tab `""During the PAST 12 MONTHS, did any medical doctor ADVISE you to stop smoking?""' _n ///                                                                                                 
"_column(1203)" _tab "byte   " _tab "PEG1            " _tab "%2f    " _tab `""Are you seriously considering quitting smoking within the next 6 months?""' _n ///                                                                                                      
"_column(1205)" _tab "byte   " _tab "PEG2            " _tab "%2f    " _tab `""Are you planning to quit within the next 30 days?""' _n ///                                                                                                                             
"_column(1207)" _tab "byte   " _tab "PEG3            " _tab "%2f    " _tab `""Overall, on a scale from 1 to 10 where 1 is NOT AT ALL interested and 10 is EXTREMELY interested, how interested are you in quitting smoking?""' _n ///                                 
"_column(1209)" _tab "byte   " _tab "PEG4            " _tab "%2f    " _tab `""If you did try to quit smoking altogether in the next 6 months, how LIKELY do you think you would be to succeed --not at all, a little likely, somewhat likely or very likely?""' _n ///
"_column(1211)" _tab "byte   " _tab "PEH1NUM         " _tab "%2f    " _tab `""About how long has it been since you COMPLETELY quit smoking cigarettes? (number)""' _n ///
"_column(1213)" _tab "byte   " _tab "PEH1UNT         " _tab "%2f    " _tab `""About how long has it been since you COMPLETELY quit smoking cigarettes? (unit)""' _n ///
"_column(1215)" _tab "byte   " _tab "PEH1B           " _tab "%2f    " _tab `""In the PAST 12 months, was H1 the longest time you stopped smoking cigarettes because you were trying to quit?""' _n ///
"_column(1217)" _tab "byte   " _tab "PEH1CNUM        " _tab "%2f    " _tab `""During the PAST 12 MONTHS, what WAS the LONGEST length of time you stopped smoking because you were TRYING to quit smoking... (number)""' _n ///
"_column(1219)" _tab "byte   " _tab "PEH1CUnt        " _tab "%2f    " _tab `""During the PAST 12 MONTHS, what WAS the LONGEST length of time you stopped smoking because you were TRYING to quit smoking... (unit)""' _n ///          
"_column(1221)" _tab "byte   " _tab "PEH2            " _tab "%2f    " _tab `""Have you EVER smoked cigarettes EVERY DAY for at least 6 months?""' _n ///
"_column(1223)" _tab "byte   " _tab "PEH5            " _tab "%2f    " _tab `""For how long did you smoke EVERY DAY?""' _n ///
"_column(1225)" _tab "byte   " _tab "PTH5A           " _tab "%2f    " _tab `""When you last smoked every day, on average how many cigarettes did you smoke each day?""' _n ///
"_column(1227)" _tab "byte   " _tab "PEH6            " _tab "%2f    " _tab `""Around this time 12 MONTHS AGO, were you smoking cigarettes every day, some days, or not at all?""' _n ///
"_column(1229)" _tab "byte   " _tab "PTH6A           " _tab "%2f    " _tab `""Around this time 12 MONTHS AGO, on the average, about how many cigarettes did you smoke each day?""' _n ///
"_column(1231)" _tab "byte   " _tab "PEH6B           " _tab "%2f    " _tab `""Around this time 12 MONTHS AGO, on how many of 30 days in the month did you smoke cigarettes?""' _n ///
"_column(1233)" _tab "byte   " _tab "PTH6C           " _tab "%2f    " _tab `""On the average, on those (Fill PEH6b entry), how many cigarettes did you usually smoke each day?""' _n ///
"_column(1235)" _tab "byte   " _tab "PEH6C2          " _tab "%2f    " _tab `""We are still talking about Around this time 12 months ago. Thinking back to the 12 MONTHS BEFORE YOU QUIT SMOKING CIGARETTES, during that time, did you usually smoke menthol or non-menthol cigarettes?""' _n ///
"_column(1237)" _tab "byte   " _tab "PEH6C4          " _tab "%2f    " _tab `""Have you EVER smoked MENTHOL cigarettes for 6 months or more?""' _n ///
"_column(1239)" _tab "byte   " _tab "PEH6C5          " _tab "%2f    " _tab `""For how long have you smoked MENTHOL cigarettes?""' _n ///
"_column(1241)" _tab "byte   " _tab "PEH6D123        " _tab "%2f    " _tab `""Now I would like to ask about HOW you went about completely quitting smoking.  When you quit smoking completely, did you use ANY of the following PRODUCTS: A NICOTINE…patch, gum, lozenge, nasal spray or inhaler?""' _n ///
"_column(1243)" _tab "byte   " _tab "PEH6D7AB        " _tab "%2f    " _tab `""Now I would like to ask about HOW you went about completely quitting smoking.  When you quit smoking completely, did you use ANY of the following PRODUCTS: A prescription pill, called Chantix, Varenicline, Zyban, Bupropion, or Wellbutrin?""' _n ///
"_column(1245)" _tab "byte   " _tab "PEH6E1          " _tab "%2f    " _tab `""When you quit smoking completely, did you use ANY of the following: A telephone help line or quit line?""' _n ///
"_column(1247)" _tab "byte   " _tab "PEH6E2          " _tab "%2f    " _tab `""When you quit smoking completely, did you use ANY of the following: One-on-one IN-PERSON counseling by a health professional?""' _n ///
"_column(1249)" _tab "byte   " _tab "PEH6E3          " _tab "%2f    " _tab `""When you quit smoking completely, did you use ANY of the following: A stop smoking clinic, class, or support group?""' _n ///
"_column(1251)" _tab "byte   " _tab "PEH6E5          " _tab "%2f    " _tab `""When you quit smoking completely, did you use ANY of the following: Internet or a web-based program or tool including smartphone apps and text messaging programs?""' _n ///
"_column(1253)" _tab "byte   " _tab "PEH6FA2         " _tab "%2f    " _tab `""When you quit smoking completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to smokeless tobacco such as chewing tobacco, snuff, or snus?""' _n ///
"_column(1255)" _tab "byte   " _tab "PEH6FA2B        " _tab "%2f    " _tab `""When you quit smoking completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to regular cigars, cigarillos, little filtered cigars or ANY pipes filled with tobacco?""' _n ///
"_column(1257)" _tab "byte   " _tab "PEH6FA2C        " _tab "%2f    " _tab `""When you quit smoking completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to electronic or E-Cigarettes? You may also know them as vape-pens, e-hookahs, vapes or mods.""' _n ///
"_column(1259)" _tab "byte   " _tab "PEH6FA2D1       " _tab "%2f    " _tab `""Did you switch to? Cigars, cigarillos, little filtered cigars.""' _n ///
"_column(1261)" _tab "byte   " _tab "PEH6FA2D2       " _tab "%2f    " _tab `""Did you switch to? Regular pipes filled with tobacco.""' _n ///
"_column(1263)" _tab "byte   " _tab "PEH6FA2D3       " _tab "%2f    " _tab `""Did you switch to? Water or hookah pipes filled with tobacco.""' _n ///
"_column(1265)" _tab "byte   " _tab "PEH6FAZ2C       " _tab "%2f    " _tab `""When you quit smoking completely, did you try to quit by SWITCHING to electronic or E-cigarettes? You may also know them as vape-pens, e-hookahs, vapes or mods.""' _n ///
"_column(1267)" _tab "byte   " _tab "PEH61A          " _tab "%2f    " _tab `""In the 12 MONTHS BEFORE you COMPLETELY quit smoking, did you SEE a medical doctor?""' _n ///
"_column(1269)" _tab "byte   " _tab "PEH61B          " _tab "%2f    " _tab `""During the 12 MONTHS BEFORE you completely quit smoking, did any medical doctor ADVISE you to stop smoking?""' _n ///
"_column(1271)" _tab "byte   " _tab "PEH8ANUM        " _tab "%2f    " _tab `""During the 12 MONTHS before you quit smoking, how soon after you woke up did you typically smoke your first cigarette of the day? (number)""' _n ///
"_column(1273)" _tab "byte   " _tab "PEH8AUNT        " _tab "%2f    " _tab `""During the 12 MONTHS before you quit smoking, how soon after you woke up did you typically smoke your first cigarette of the day? (unit)""' _n ///
"_column(1275)" _tab "byte   " _tab "PEH8B           " _tab "%2f    " _tab `""During the 12 months before you quit smoking, would you say you smoked your first cigarette of the day within the first 30 minutes of awakening?""' _n ///
"_column(1277)" _tab "byte   " _tab "PEH11A          " _tab "%2f    " _tab `""Thinking back to the 12 MONTHS BEFORE YOU COMPLETELY QUIT SMOKING CIGARETTES. During that time, DID YOU USUALLY SMOKE menthol or non-menthol cigarettes?""' _n ///
"_column(1279)" _tab "byte   " _tab "PEH11C          " _tab "%2f    " _tab `""Have you EVER smoked MENTHOL cigarettes for 6 months or more?""' _n ///
"_column(1281)" _tab "byte   " _tab "PEH11D          " _tab "%2f    " _tab `""For how long did you smoked MENTHOL cigarettes?""' _n ///  
"_column(1283)" _tab "byte   " _tab "PEJ1a1          " _tab "%2f    " _tab `""(Have/Has) (you/name) EVER used any of the following EVEN ONE TIME? ... A regular cigar or cigarillo OR a little filtered cigar?""' _n ///
"_column(1285)" _tab "byte   " _tab "PEJ1a2          " _tab "%2f    " _tab `""(Have/Has) (you/name) EVER used any of the following EVEN ONE TIME? ... A regular pipe filled with tobacco?""' _n ///
"_column(1287)" _tab "byte   " _tab "PEJ1A3          " _tab "%2f    " _tab `""(Have/Has) (you/name) EVER used any of the following EVEN ONE TIME? ... a water pipe or hookah (who-kah) pipe filled with tobacco?""' _n ///
"_column(1289)" _tab "byte   " _tab "PEJ1A3_5        " _tab "%2f    " _tab `""(Have/Has) (you/name) EVER used E-cigarettes EVEN ONE TIME?""' _n ///
"_column(1291)" _tab "byte   " _tab "PEJ1A4          " _tab "%2f    " _tab `""(Have/Has) (you/name) EVER used any of the following EVEN ONE TIME? ... Smokeless tobacco, such as moist snuff, dip, spit, chew tobacco or snus?""' _n ///    
"_column(1293)" _tab "byte   " _tab "PEJ1A5          " _tab "%2f    " _tab `""(Have/Has) (you/name) EVER used disolvable tobacco EVEN ONE TIME?""' _n ///
"_column(1295)" _tab "byte   " _tab "PEJ2A1          " _tab "%2f    " _tab `""(Do you/Does name) NOW smoke regular cigars or cigarillos or little filtered cigars every day, some days or not at all?""' _n ///
"_column(1297)" _tab "byte   " _tab "PEJ2B1          " _tab "%2f    " _tab `""On how many of the past 30 days did you smoke regular cigars or cigarillos or little filtered cigars?""' _n ///
"_column(1299)" _tab "byte   " _tab "PEJ2A2          " _tab "%2f    " _tab `""(Do you/Does name) NOW smoke a regular pipe every day, some days or not at all?""' _n ///
"_column(1301)" _tab "byte   " _tab "PEJ2B2          " _tab "%2f    " _tab `""On how many of the past 30 days did you smoke a regular pipe?""' _n ///
"_column(1303)" _tab "byte   " _tab "PEJ2A3          " _tab "%2f    " _tab `""(Do you/Does name) NOW use a water pipe or hookah pipe filled with tobacco every day, some days or not at all?""' _n ///
"_column(1305)" _tab "byte   " _tab "PEJ2B3          " _tab "%2f    " _tab `""On how many of the past 30 days did you use a water pipe or hookah pipe filled with tobacco?""' _n ///
"_column(1307)" _tab "byte   " _tab "PEJ2A3_5        " _tab "%2f    " _tab `""(Do you /Does name) NOW use an E-cigarette every day, some days or not at all?""' _n ///
"_column(1309)" _tab "byte   " _tab "PEJ2B3_5        " _tab "%2f    " _tab `""On how many of the past 30 days did you use an E-cigarette?""' _n ///
"_column(1311)" _tab "byte   " _tab "PEJ2A4          " _tab "%2f    " _tab `""(Do you /Does name) NOW use smokeless tobacco such as moist snuff, dip, spit, chew tobacco or snus every day, some days or not at all?""' _n ///
"_column(1313)" _tab "byte   " _tab "PEJ2B4          " _tab "%2f    " _tab `""On how many of the past 30 days did you use smokeless tobacco?""' _n ///
"_column(1315)" _tab "byte   " _tab "PEJ2A5          " _tab "%2f    " _tab `""(Do you /Does name) NOW use dissolvable tobacco every day, some days or not at all?""' _n ///
"_column(1317)" _tab "byte   " _tab "PEJ2B5          " _tab "%2f    " _tab `""On how many of the past 30 days did you use dissolvable tobacco?""' _n ///
"_column(1319)" _tab "byte   " _tab "PEJA            " _tab "%2f    " _tab `""During the past 30 days, what BRAND of smokeless tobacco (If necessary: moist snuff, dip, spit, chew or snus) did you use MOST OFTEN?""' _n ///
"_column(1321)" _tab "byte   " _tab "PEJB            " _tab "%2f    " _tab `""During the PAST 30 days, what type of CIGAR did you use MOST OFTEN?""' _n ///
"_column(1323)" _tab "byte   " _tab "PEJC            " _tab "%2f    " _tab `""During the PAST 30 days, what BRAND of CIGAR did you smoke MOST OFTEN?""' _n ///
"_column(1325)" _tab "byte   " _tab "PEJNFLVIN       " _tab "%2f    " _tab `""Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol,or other flavors.""' _n ///
"_column(1327)" _tab "byte   " _tab "PEJNFLVR1       " _tab "%2f    " _tab `""Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you smoke a cigar is it usually flavored?""' _n ///
"_column(1329)" _tab "byte   " _tab "PEJNFLA1B       " _tab "%2f    " _tab `""Is it usually menthol or mint flavored?""' _n ///
"_column(1331)" _tab "byte   " _tab "PEJNFLA1C       " _tab "%2f    " _tab `""Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?""' _n ///
"_column(1333)" _tab "byte   " _tab "PEJNFLA1D       " _tab "%2f    " _tab `""Is it usually some other type of flavor?""' _n ///
"_column(1335)" _tab "byte   " _tab "PEJNFLVR2       " _tab "%2f    " _tab `""Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you smoke a regular pipe filled with tobacco is it usually flavored?""' _n ///
"_column(1337)" _tab "byte   " _tab "PEJNFLA2B       " _tab "%2f    " _tab `""Is it usually menthol or mint flavored?""' _n ///
"_column(1339)" _tab "byte   " _tab "PEJNFLA2C       " _tab "%2f    " _tab `""Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?""' _n ///
"_column(1341)" _tab "byte   " _tab "PEJNFLA2D       " _tab "%2f    " _tab `""Is it usually some other type of flavor?""' _n ///                                                                                                                                                                                                                                  
"_column(1343)" _tab "byte   " _tab "PEJNFLVR3       " _tab "%2f    " _tab `""Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you smoke a water/hookah pipe filled with tobacco is it usually flavored?""' _n ///
"_column(1345)" _tab "byte   " _tab "PEJNFLA3B       " _tab "%2f    " _tab `""Is it usually menthol or mint flavored?""' _n ///                                                                                                                                                                  
"_column(1347)" _tab "byte   " _tab "PEJNFLA3C       " _tab "%2f    " _tab `""Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?""' _n ///                                                                                                             
"_column(1349)" _tab "byte   " _tab "PEJNFLA3D       " _tab "%2f    " _tab `""Is it usually some other type of flavor?""' _n ///                                                                                                                                                                 
"_column(1351)" _tab "byte   " _tab "PEJNFLV35       " _tab "%2f    " _tab `""Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you use an E-cigarette is it usually flavored?""' _n ///                           
"_column(1353)" _tab "byte   " _tab "PEJNFA35A       " _tab "%2f    " _tab `""Is it usually tobacco flavored?""' _n ///                                                                                                                                                                          
"_column(1355)" _tab "byte   " _tab "PEJNFA35B       " _tab "%2f    " _tab `""Is it usually menthol or mint flavored?""' _n ///                                                                                                                                                                  
"_column(1357)" _tab "byte   " _tab "PEJNFA35C       " _tab "%2f    " _tab `""Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?""' _n ///
"_column(1359)" _tab "byte   " _tab "PEJNFA35D       " _tab "%2f    " _tab `""Is it usually some other type of flavor?""' _n ///
"_column(1361)" _tab "byte   " _tab "PEJNFVB35       " _tab "%2f    " _tab `""When you use an e-cigarette, is it usually tobacco flavored?""' _n ///                                                                                                
"_column(1363)" _tab "byte   " _tab "PEJNFLVR4       " _tab "%2f    " _tab `""Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you use smokeless tobacco is it usually flavored?""' _n ///
"_column(1365)" _tab "byte   " _tab "PEJNFLA4B       " _tab "%2f    " _tab `""Is it usually menthol or mint flavored?""' _n ///                                                                                                                                          
"_column(1367)" _tab "byte   " _tab "PEJNFLA4C       " _tab "%2f    " _tab `""Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?""' _n ///                                                                                     
"_column(1369)" _tab "byte   " _tab "PEJNFLA4D       " _tab "%2f    " _tab `""Is it usually some other type of flavor?""' _n ///                                                                                                                                         
"_column(1371)" _tab "byte   " _tab "PEJECIGRA       " _tab "%2f    " _tab `""Do you use e-cigarettes because you can use them at times when or in places where smoking cigarettes isn’t allowed?""' _n ///                                                              
"_column(1373)" _tab "byte   " _tab "PEJECIGRD       " _tab "%2f    " _tab `""Do you use e-cigarettes to help you quit smoking cigarettes?""' _n ///                                                                                                                     
"_column(1375)" _tab "byte   " _tab "PEJECIG2        " _tab "%2f    " _tab `""Which of the following best describes the type of e-cigarette you currently use?""' _n ///                                                                                                 
"_column(1377)" _tab "byte   " _tab "PEJECIG3        " _tab "%2f    " _tab `""Do you usually buy your own {e-cigarettes/e-cigarette cartridges/e-liquid}?""' _n ///                                                                                                      
"_column(1379)" _tab "byte   " _tab "PEJECIG4        " _tab "%2f    " _tab `""How do you usually buy your own {e-cigarettes/e-cigarette cartridges/e-liquid}?""' _n ///
"_column(1381)" _tab "byte   " _tab "PEJCOST1        " _tab "%2f    " _tab `""Do you usually buy {e-cigarettes/e-cigarette cartridges/bottles of e-liquid} by the box or pack, or as {single e-cigarettes/single e-cigarette cartridges/a single bottle of e-liquid}?""' _n ///
"_column(1383)" _tab "double " _tab "PTJCOST2        " _tab "%5f    " _tab `""What price did you pay for the LAST BOX OR PACK of {e-cigarettes/e-cigarette cartridges/bottles of e-liquid} you bought?  Please report the cost after using discounts or coupons.""' _n ///     
"_column(1388)" _tab "int    " _tab "PEJCOST3        " _tab "%3f    " _tab `""How many {e-cigarettes/e-cigarette cartridges/bottles of e-liquid} came in the LAST BOX OR PACK you bought?""' _n ///                                                                            
"_column(1391)" _tab "double " _tab "PTJCOST4        " _tab "%5f    " _tab `""What price did you pay for the LAST {e-cigarette/e-cigarette cartridge/bottle of e-liquid} you bought?  Please report the cost after using discounts or coupons.""' _n ///                       
"_column(1396)" _tab "int    " _tab "PEJCOST5        " _tab "%4f    " _tab `""How many MILLILITERS of liquid were in a SINGLE bottle you LAST bought?""' _n ///                                                                                                                
"_column(1400)" _tab "byte   " _tab "PEJD11          " _tab "%2f    " _tab `""About how long has it been since you COMPLETELY quit smoking cigars, cigarillos or little filter cigars? (number)""' _n ///
"_column(1402)" _tab "byte   " _tab "PEJD21          " _tab "%2f    " _tab `""About how long has it been since you COMPLETELY quit smoking cigars, cigarillos or little filter cigars? (unit)""' _n ///
"_column(1404)" _tab "byte   " _tab "PEJD12          " _tab "%2f    " _tab `""About how long has it been since you COMPLETELY quit smoking a regular pipe filled with tobacco? (number)""' _n ///
"_column(1406)" _tab "byte   " _tab "PEJD22          " _tab "%2f    " _tab `""About how long has it been since you COMPLETELY quit smoking a regular pipe filled with tobacco? (unit)""' _n ///
"_column(1408)" _tab "byte   " _tab "PEJD13          " _tab "%2f    " _tab `""About how long has it been since you COMPLETELY quit smoking a water pipe or hookah pipe filled with tobacco? (number)""' _n ///
"_column(1410)" _tab "byte   " _tab "PEJD23          " _tab "%2f    " _tab `""About how long has it been since you COMPLETELY quit smoking a water pipe or hookah pipe filled with tobacco? (unit)""' _n ///
"_column(1412)" _tab "byte   " _tab "PEJD13_5        " _tab "%2f    " _tab `""About how long has it been since you COMPLETELY quit using E-cigarettes? (number)""' _n ///
"_column(1414)" _tab "byte   " _tab "PEJD23_5        " _tab "%2f    " _tab `""About how long has it been since you COMPLETELY quit using E-cigarettes? (unit)""' _n ///
"_column(1416)" _tab "byte   " _tab "PEJD14          " _tab "%2f    " _tab `""About how long has it been since you COMPLETELY quit using a smokeless tobacco? (number)""' _n ///
"_column(1418)" _tab "byte   " _tab "PEJD24          " _tab "%2f    " _tab `""About how long has it been since you COMPLETELY quit using a smokeless tobacco? (unit)""' _n ///
"_column(1420)" _tab "byte   " _tab "PEJD31          " _tab "%2f    " _tab `""In total, how many years (have you smoked/did you smoke) cigars or cigarillos or little filtered cigars?""' _n /// 
"_column(1422)" _tab "byte   " _tab "PEJD32          " _tab "%2f    " _tab `""In total, how many years (have you smoked/did you smoke) a regular pipe filled with tobacco?""' _n ///             
"_column(1424)" _tab "byte   " _tab "PEJD33          " _tab "%2f    " _tab `""In total, how many years (have you smoked/did you smoke) a water pipe or hookah pipe filled with tobacco?""' _n ///
"_column(1426)" _tab "byte   " _tab "PEJD33_5        " _tab "%2f    " _tab `""In total, how many years (have you used/did you use) an E-cigarette?""' _n ///                                     
"_column(1428)" _tab "byte   " _tab "PEJD34          " _tab "%2f    " _tab `""In total, how many years (have you used/did you use) smokeless tobacco?""' _n ///
"_column(1430)" _tab "byte   " _tab "PEJFECGRA       " _tab "%2f    " _tab `""Did you use E-cigarettes because you could use them at times when or in places where smoking cigarettes wasn't allowed?""' _n ///
"_column(1432)" _tab "byte   " _tab "PEJFECGRD       " _tab "%2f    " _tab `""Did you use e-cigarettes to help you quit smoking cigarettes? ""' _n ///
"_column(1434)" _tab "byte   " _tab "PEJFECG2        " _tab "%2f    " _tab `""Which of the following best describes the type of e-cigarette you used to use?  If you used more than one type, please think of the one you used most often.""' _n ///
"_column(1436)" _tab "byte   " _tab "PEJ3A1          " _tab "%2f    " _tab `""How soon after you wake up do you typically (fill text from PRJ3A1F recode)? (number)""' _n ///
"_column(1438)" _tab "byte   " _tab "PEJ3A2          " _tab "%2f    " _tab `""How soon after you wake up do you typically (fill text from PRJ3A1F recode)? (unit)""' _n ///
"_column(1440)" _tab "byte   " _tab "PEJ3D           " _tab "%2f    " _tab `""Would you say you first (fill text from PRJ3DF recode) within the first 30 minutes of awakening?""' _n ///
"_column(1442)" _tab "byte   " _tab "PEJ3F1          " _tab "%2f    " _tab `""In the 12 months BEFORE YOU COMPLETELY QUIT (Fill text from PRJ3F1F recode), how soon after you woke up did you typically (Fill text from PRJ3F1F recode)? (number)""' _n ///
"_column(1444)" _tab "byte   " _tab "PEJ3F2          " _tab "%2f    " _tab `""In the 12 months BEFORE YOU COMPLETELY QUIT (Fill text from PRJ3F1F recode), how soon after you woke up did you typically (Fill text from PRJ3F1F recode)? (unit)""' _n ///
"_column(1446)" _tab "byte   " _tab "PEJ3G           " _tab "%2f    " _tab `""Would you say you first used (Fill text from PRJ3GF recode) within the first 30 minutes of awakening?""' _n ///
"_column(1448)" _tab "byte   " _tab "PEJ4            " _tab "%2f    " _tab `""During the PAST 12 MONTHS, have you stopped (Fill text from PRJ4F recode) for one day or longer BECAUSE YOU WERE TRYING TO QUIT?""' _n ///
"_column(1450)" _tab "byte   " _tab "PEJ6BNUM        " _tab "%2f    " _tab `""Thinking of ANY attempts to stop (fill text from PRJ6BNMF) because you were trying to quit, during the past 12 MONTHS, what is the LONGEST length of time of the ONE attempt that lasted the longest? (number)""' _n ///
"_column(1452)" _tab "byte   " _tab "PEJ6BUNT        " _tab "%2f    " _tab `""Thinking of ANY attempts to stop (fill text from PRJ6BNMF) because you were trying to quit, during the past 12 MONTHS, what is the LONGEST length of time of the ONE attempt that lasted the longest? (unit)""' _n ///
"_column(1454)" _tab "byte   " _tab "PEJ7CINT        " _tab "%2f    " _tab `""The LAST TIME you tried to QUIT smoking CIGARS in the past 12 months: Did you:""' _n ///
"_column(1456)" _tab "byte   " _tab "PEJ7C           " _tab "%2f    " _tab `""The LAST TIME you tried to QUIT smoking CIGARS in the past 12 months: Did you: Try to quit by SWITCHING to smokeless tobacco such as chewing  tobacco, snuff, or snus?""' _n ///
"_column(1458)" _tab "byte   " _tab "PEJ7D           " _tab "%2f    " _tab `""The LAST TIME you tried to QUIT smoking CIGARS in the past 12 months: Did you: Try to quit by SWITCHING to electronic or E-cigarettes?""' _n ///
"_column(1460)" _tab "byte   " _tab "PEJ7ALTIN       " _tab "%2f    " _tab `""When you quit smoking CIGARS completely, did you do ANY of the following, whether or not you think they were effective:""' _n ///
"_column(1462)" _tab "byte   " _tab "PEJ7CALT        " _tab "%2f    " _tab `""When you quit smoking CIGARS completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to smokeless tobacco such as chewing tobacco, snuff, or snus?""' _n ///
"_column(1464)" _tab "byte   " _tab "PEJ7DALT        " _tab "%2f    " _tab `""When you quit smoking CIGARS completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to electronic or E-cigarette?""' _n ///
"_column(1466)" _tab "byte   " _tab "PEK1A           " _tab "%2f    " _tab `""Do you mainly work indoors or outdoors?""' _n ///
"_column(1468)" _tab "byte   " _tab "PEK1B           " _tab "%2f    " _tab `""Do you mainly work in an office building, your own home, in someone else's home, or in another indoor place?""' _n ///
"_column(1470)" _tab "byte   " _tab "PEK1B11         " _tab "%2f    " _tab `""In which State (including DC), do you work?""' _n ///
"_column(1472)" _tab "byte   " _tab "PEK1B2          " _tab "%2f    " _tab `""When you work INDOORS: Do you mainly work in an office building, in your own home, in someone else's home, or in another indoor place?""' _n ///
"_column(1474)" _tab "byte   " _tab "PEK1C1          " _tab "%2f    " _tab `""In which State (including DC), do you work on your main indoor job or business?""' _n ///
"_column(1476)" _tab "byte   " _tab "PEK2A           " _tab "%2f    " _tab `""Is smoking restricted in ANY WAY at your place of work?""' _n ///
"_column(1478)" _tab "byte   " _tab "PEK3A           " _tab "%2f    " _tab `""Which of these best describes the smoking policy at your place of work for INDOOR PUBLIC OR COMMON AREAS, such as lobbies, rest rooms, and lunch rooms?""' _n ///
"_column(1480)" _tab "byte   " _tab "PEK3B           " _tab "%2f    " _tab `""Which of these best describes the smoking policy at your place of work for INDOOR WORK AREAS?""' _n ///
"_column(1482)" _tab "byte   " _tab "PEK3C           " _tab "%2f    " _tab `""During the PAST TWO WEEKS, has anyone smoked in the area in which you work?""' _n ///
"_column(1484)" _tab "byte   " _tab "PEK3B1          " _tab "%2f    " _tab `""Which of these best describes the vaping or e-cigarette policy at your place of work for INDOOR PUBLIC OR COMMON AREAS AND INDOOR WORK AREAS?""' _n ///
"_column(1486)" _tab "byte   " _tab "PEK3C1          " _tab "%2f    " _tab `""During the PAST TWO WEEKS, has anyone vaped or used e-cigarettes in the area in which you work?""' _n ///
"_column(1488)" _tab "byte   " _tab "PEK4            " _tab "%2f    " _tab `""Which statement best describes the rules about smoking INSIDE YOUR HOME?""' _n ///
"_column(1490)" _tab "byte   " _tab "PEK4A           " _tab "%2f    " _tab `""Which statement best describes the rules about vaping or using e-cigarettes INSIDE YOUR HOME?""' _n ///
"_column(1492)" _tab "byte   " _tab "PEK5A           " _tab "%2f    " _tab `""In buildings with MULTIPLE apartments or living areas, do you THINK that smoking should be ... ALLOWED INSIDE ALL apartments or living areas, ALLOWED inside SOME apartments ..., or NOT ALLOWED at ALL inside apartments?""' _n ///
"_column(1494)" _tab "byte   " _tab "PEK6B           " _tab "%2f    " _tab `""In indoor work areas, do you THINK that smoking SHOULD be allowed in ALL areas, allowed in SOME areas, or NOT allowed at ALL?""' _n ///
"_column(1496)" _tab "byte   " _tab "PEK6C           " _tab "%2f    " _tab `""Inside bars, cocktail lounges, and clubs, do you THINK that smoking SHOULD be allowed in ALL areas, allowed in SOME areas, or NOT allowed at ALL?""' _n ///
"_column(1498)" _tab "byte   " _tab "PEK6G           " _tab "%2f    " _tab `""Inside casinos, do you THINK that smoking SHOULD be allowed in ALL areas, allowed in SOME areas, or NOT allowed at ALL?""' _n ///
"_column(1500)" _tab "byte   " _tab "PEK6H           " _tab "%2f    " _tab `""Inside a car, when there are other people present, do you THINK that smoking SHOULD...""' _n ///
"_column(1502)" _tab "byte   " _tab "PEK6H2          " _tab "%2f    " _tab `""If children are present inside the car, do you think that smoking SHOULD...""' _n ///
"_column(1504)" _tab "byte   " _tab "PEK8            " _tab "%2f    " _tab `""In the past 6 months, have you seen messages in newspapers or on television that say that a Federal Court has ordered tobacco companies to make statements about the dangers of smoking cigarettes?""' _n ///
"_column(1506)" _tab "byte   " _tab "PES78           " _tab "%2f    " _tab `""Respondent relationship recode - relationship of respondent to the sample person""' _n ///
"_column(1508)" _tab "byte   " _tab "PESINTTP        " _tab "%2f    " _tab `""In what language was the interview conducted for this person?""' _n ///
"_column(1510)" _tab "byte   " _tab "PES81A          " _tab "%2f    " _tab `""Method of Interview""' _n ///
"_column(1512)" _tab "byte   " _tab "INTRVIEW        " _tab "%2f    " _tab `""Interview Status Recode""' _n ///
"_column(1514)" _tab "byte   " _tab "HRMODE          " _tab "%2f    " _tab `""Method of Interview""' _n ///
"_column(1516)" _tab "byte   " _tab "SMOKSTAT        " _tab "%2f    " _tab `""Type of smoker recode""' _n ///
"_column(1518)" _tab "byte   " _tab "PRS35           " _tab "%2f    " _tab `""Respondent and Smoker Type""' _n ///
"_column(1520)" _tab "byte   " _tab "PRS60           " _tab "%2f    " _tab `""Self responding 'Not at all' smokers- smoking less than or equal to 1 year or don't know""' _n ///
"_column(1522)" _tab "byte   " _tab "PRS64           " _tab "%2f    " _tab `""Who is responding for the supplement""' _n ///
"_column(1524)" _tab "byte   " _tab "PRS65           " _tab "%2f    " _tab `""Monthly Labor Force recode of Self respondents""' _n ///
"_column(1526)" _tab "byte   " _tab "PRS66           " _tab "%2f    " _tab `""Employed self respondents' class of worker on first job""' _n ///
"_column(1528)" _tab "byte   " _tab "PRJ3A1F         " _tab "%2f    " _tab `""Recode from fill in PEJ3a1 and PEJ3a2 to determine which tobacco product is being discussed in PEJ3a1 and PEJ3a2""' _n ///
"_column(1530)" _tab "byte   " _tab "PRJ3DF          " _tab "%2f    " _tab `""Recode from fill in PEJ3d to determine which tobacco product is being discussed in PEJ3d""' _n ///
"_column(1532)" _tab "byte   " _tab "PRJ3F1F         " _tab "%2f    " _tab `""Recode from fill in PEJ3f1 and PEJ3f2 to determine which tobacco product is being discussed in PEJ3f1 and PEJ3f2""' _n ///
"_column(1534)" _tab "byte   " _tab "PRJ3GF          " _tab "%2f    " _tab `""Recode from fill in PEJ3g to determine which tobacco product is being discussed in PEJ3g""' _n ///
"_column(1536)" _tab "byte   " _tab "PRJ4F           " _tab "%2f    " _tab `""Recode from fill in PEJ4 to determine which tobacco product is being discussed in PEJ4""' _n ///
"_column(1538)" _tab "byte   " _tab "PRJ6BNMF        " _tab "%2f    " _tab `""Recode from fill in PEJ6bnum and PEJ6bunt to see which tobacco product is being discussed in PEJ6bnum and PEJ6bunt""' _n ///
"_column(1540)" _tab "byte   " _tab "PRSIFLG         " _tab "%2f    " _tab `""Recode identifies person answering their own questions on the shorter proxy path.""' _n ///
"_column(1542)" _tab "double " _tab "PWNRWGT         " _tab "%10.4f " _tab `""Nonresponse weight""' _n ///
"_column(1552)" _tab "double " _tab "PWSRWGT         " _tab "%10.4f " _tab `""Self response weight""' _n ///
"_column(1562)" _tab "byte   " _tab "PEELGFLG        " _tab "%2f    " _tab `""Eligibility Flag""' _n ///
"}"
set more on
file close dictionary 

quietly infile using dictionary.dct, using ("jan19pub.dat") clear

replace PUERNH1C = PUERNH1C / 100 if PUERNH1C > 0
replace PEERNH2 = PEERNH2 / 100 if PEERNH2 > 0
replace PEERNH1O = PEERNH1O / 100 if PEERNH1O > 0
replace PRERNHLY = PRERNHLY / 100 if PRERNHLY > 0
replace PRERNWA = PRERNWA / 100 if PRERNWA > 0
replace PEERN = PEERN / 100 if PEERN > 0
replace PUERN2 = PUERN2 / 100 if PUERN2 > 0

replace PTB6B = PTB6B /100 if PTB6B > 0
replace PTB6C = PTB6C /100 if PTB6C > 0

replace PTC6B = PTC6B /100 if PTC6B > 0
replace PTC6C = PTC6C /100 if PTC6C > 0

replace PTJCOST2 = PTJCOST2 /100 if PTJCOST2 > 0
replace PTJCOST4 = PTJCOST4 /100 if PTJCOST4 > 0

save "jan19pub_beta", replace


//*****************************************************************************************
// Read CPS May 2019 file

//*****************************************************************************************
// Create dictionary of CPS May 2019 file
file open dictionary  using ".\dictionary.dct", write replace

// Dictionary for CPS May 2019
//
set more off
file write dictionary   /// 
"infile dictionary {" _n  ///
"_column(1)"    _tab "str15  " _tab "HRHHID   " _tab  "%15s  " _tab `""Household identifier (part 1)""' _n  ///
"_column(16)"   _tab "byte   " _tab "HRMONTH  " _tab  "%2f   " _tab `""Month of interview""' _n  ///                                                                                                                                                                                                                                 
"_column(18)"   _tab "int    " _tab "HRYEAR4  " _tab  "%4f   " _tab `""Year of interview""' _n  ///                                                                                                                                                                                                                                  
"_column(22)"   _tab "byte   " _tab "HURESPLI " _tab  "%2f   " _tab `""Line number of the current respondent""' _n  ///                                                                                                                                                                                                              
"_column(24)"   _tab "int    " _tab "HUFINAL  " _tab  "%3f   " _tab `""Final outcome code""' _n  ///                                                                                                                                                                                                                                 
"_column(29)"   _tab "byte   " _tab "HETENURE " _tab  "%2f   " _tab `""Are your living quarters...""' _n  ///                                                                                                                                                                                                                        
"_column(31)"   _tab "byte   " _tab "HEHOUSUT " _tab  "%2f   " _tab `""Type of housing unit""' _n  ///                                                                                                                                                                                                                               
"_column(33)"   _tab "byte   " _tab "HETELHHD " _tab  "%2f   " _tab `""Is there a telephone in this house/apartment?""' _n  ///                                                                                                                                                                                                      
"_column(35)"   _tab "byte   " _tab "HETELAVL " _tab  "%2f   " _tab `""Is there a telephone elsewhere on which people in this household can be contacted?""' _n  ///                                                                                                                                                                 
"_column(37)"   _tab "byte   " _tab "HEPHONEO " _tab  "%2f   " _tab `""Is a telephone interview acceptable?""' _n  ///                                                                                                                                                                                                               
"_column(39)"   _tab "byte   " _tab "HEFAMINC " _tab  "%2f   " _tab `""Family income""' _n  ///                                                                                                                                                                                                                                      
"_column(41)"   _tab "byte   " _tab "HUTYPEA  " _tab  "%2f   " _tab `""Type A non-interview reason""' _n  ///                                                                                                                                                                                                                        
"_column(43)"   _tab "byte   " _tab "HUTYPB   " _tab  "%2f   " _tab `""Type B non-interview reason""' _n  ///                                                                                                                                                                                                                        
"_column(45)"   _tab "byte   " _tab "HUTYPC   " _tab  "%2f   " _tab `""Type C non-interview reason""' _n  ///                                                                                                                                                                                                                        
"_column(47)"   _tab "double " _tab "HWHHWGT  " _tab  "%10.4f" _tab `""Household weight""' _n  ///                                                                                                                                                                                                                                   
"_column(57)"   _tab "byte   " _tab "HRINTSTA " _tab  "%2f   " _tab `""Interview status""' _n  ///                                                                                                                                                                                                                                   
"_column(59)"   _tab "byte   " _tab "HRNUMHOU " _tab  "%2f   " _tab `""Total number of persons living in the household (household members)""' _n  ///                                                                                                                                                                                
"_column(61)"   _tab "byte   " _tab "HRHTYPE  " _tab  "%2f   " _tab `""Household type""' _n  ///                                                                                                                                                                                                                                     
"_column(63)"   _tab "byte   " _tab "HRMIS    " _tab  "%2f   " _tab `""Month-in-sample""' _n  ///                                                                                                                                                                                                                                    
"_column(65)"   _tab "byte   " _tab "HUINTTYP " _tab  "%2f   " _tab `""Type of interview""' _n  ///                                                                                                                                                                                                                                  
"_column(67)"   _tab "byte   " _tab "HUPRSCNT " _tab  "%2f   " _tab `""Number of actual and attempted personal contacts""' _n  ///                                                                                                                                                                                                   
"_column(69)"   _tab "byte   " _tab "HRLONGLK " _tab  "%2f   " _tab `""Longitudinal link indicator""' _n  ///                                                                                                                                                                                                                        
"_column(71)"   _tab "str5   " _tab "HRHHID2  " _tab  "%5s   " _tab `""Household identifier (part 2)""' _n  ///                                                                                                                                                                                                                      
"_column(76)"   _tab "byte   " _tab "HWHHWTLN " _tab  "%2f   " _tab `""Line number (PULINENO) of the person whose PWSSWGT was donated as HWHHWGT for the household""' _n  ///                                                                                                                                                        
"_column(79)"   _tab "byte   " _tab "HUBUS    " _tab  "%2f   " _tab `""Does anyone in this household have a business or a farm?""' _n  ///                                                                                                                                                                                           
"_column(81)"   _tab "byte   " _tab "HUBUSL1  " _tab  "%2f   " _tab `""Enter line number for hubus = 1""' _n  ///                                                                                                                                                                                                                    
"_column(83)"   _tab "byte   " _tab "HUBUSL2  " _tab  "%2f   " _tab `""Enter line number for hubus = 1""' _n  ///                                                                                                                                                                                                                    
"_column(85)"   _tab "byte   " _tab "HUBUSL3  " _tab  "%2f   " _tab `""Enter line number for hubus = 1""' _n  ///                                                                                                                                                                                                                    
"_column(87)"   _tab "byte   " _tab "HUBUSL4  " _tab  "%2f   " _tab `""Enter line number for hubus = 1""' _n  ///                                                                                                                                                                                                                    
"_column(89)"   _tab "byte   " _tab "GEREG    " _tab  "%2f   " _tab `""Region""' _n  ///                                                                                                                                                                                                                                             
"_column(91)"   _tab "byte   " _tab "GEDIV    " _tab  "%2f   " _tab `""Division""' _n  ///                                                                                                                                                                                                                                           
"_column(93)"   _tab "str2   " _tab "GESTFIPS " _tab  "%2f   " _tab `""Federal Information Processing Standards (FIPS) State code""' _n  ///                                                                                                                                                                                         
"_column(96)"   _tab "str5   " _tab "GTCBSA   " _tab  "%5f   " _tab `""Specific metropolitan CBSA code""' _n  ///                                                                                                                                                                                                                    
"_column(101)"  _tab "str3   " _tab "GTCO     " _tab  "%3f   " _tab `""FIPS county code""' _n  ///                                                                                                                                                                                                                                   
"_column(104)"  _tab "byte   " _tab "GTCBSAST " _tab  "%1f   " _tab `""Principal city/balance status""' _n  ///                                                                                                                                                                                                                      
"_column(105)"  _tab "byte   " _tab "GTMETSTA " _tab  "%1f   " _tab `""Metropolitan status""' _n  ///                                                                                                                                                                                                                                
"_column(106)"  _tab "byte   " _tab "GTINDVPC " _tab  "%1f   " _tab `""Individual principal city""' _n  ///                                                                                                                                                                                                                          
"_column(107)"  _tab "byte   " _tab "GTCBSASZ " _tab  "%1f   " _tab `""Metropolitan area (CBSA) size""' _n  ///                                                                                                                                                                                                                      
"_column(108)"  _tab "str3   " _tab "GTCSA    " _tab  "%3f   " _tab `""Consolidated Statistical Area (CSA) FIPS code""' _n  ///                                                                                                                                                                                                      
"_column(118)"  _tab "byte   " _tab "PERRP    " _tab  "%2f   " _tab `""Relationship to reference person""' _n  ///                                                                                                                                                                                                                   
"_column(120)"  _tab "byte   " _tab "PEPARENT " _tab  "%2f   " _tab `""Line number of parent""' _n  ///                                                                                                                                                                                                                              
"_column(122)"  _tab "byte   " _tab "PRTAGE   " _tab  "%2f   " _tab `""Persons age""' _n  ///                                                                                                                                                                                                                                        
"_column(124)"  _tab "byte   " _tab "PRTFAGE  " _tab  "%1f   " _tab `""Top code flag for age""' _n  ///                                                                                                                                                                                                                              
"_column(125)"  _tab "byte   " _tab "PEMARITL " _tab  "%2f   " _tab `""Marital status""' _n  ///                                                                                                                                                                                                                                     
"_column(127)"  _tab "byte   " _tab "PESPOUSE " _tab  "%2f   " _tab `""Line number of spouse""' _n  ///                                                                                                                                                                                                                              
"_column(129)"  _tab "byte   " _tab "PESEX    " _tab  "%2f   " _tab `""Sex""' _n  ///                                                                                                                                                                                                                                                
"_column(131)"  _tab "byte   " _tab "PEAFEVER " _tab  "%2f   " _tab `""Did you ever serve on active duty in the U.S. armed forces?""' _n  ///                                                                                                                                                                                        
"_column(135)"  _tab "byte   " _tab "PEAFNOW  " _tab  "%2f   " _tab `""Are you now in the armed forces?""' _n  ///                                                                                                                                                                                                                   
"_column(137)"  _tab "byte   " _tab "PEEDUCA  " _tab  "%2f   " _tab `""Highest level of school completed or degree received""' _n  ///                                                                                                                                                                                               
"_column(139)"  _tab "byte   " _tab "PTDTRACE " _tab  "%2f   " _tab `""Race""' _n  ///                                                                                                                                                                                                                                               
"_column(141)"  _tab "byte   " _tab "PRDTHSP  " _tab  "%2f   " _tab `""Detailed Hispanic origin group (Revised January 2014)""' _n  ///                                                                                                                                                                                              
"_column(143)"  _tab "byte   " _tab "PUCHINHH " _tab  "%2f   " _tab `""Change in household composition""' _n  ///                                                                                                                                                                                                                    
"_column(147)"  _tab "byte   " _tab "PULINENO " _tab  "%2f   " _tab `""Person's line number""' _n  ///                                                                                                                                                                                                                               
"_column(151)"  _tab "byte   " _tab "PRFAMNUM " _tab  "%2f   " _tab `""Family number recode""' _n  ///                                                                                                                                                                                                                               
"_column(153)"  _tab "byte   " _tab "PRFAMREL " _tab  "%2f   " _tab `""Family relationship recode""' _n  ///                                                                                                                                                                                                                         
"_column(155)"  _tab "byte   " _tab "PRFAMTYP " _tab  "%2f   " _tab `""Family type recode""' _n  ///                                                                                                                                                                                                                                 
"_column(157)"  _tab "byte   " _tab "PEHSPNON " _tab  "%2f   " _tab `""Hispanic or non-Hispanic""' _n  ///                                                                                                                                                                                                                           
"_column(159)"  _tab "byte   " _tab "PRMARSTA " _tab  "%2f   " _tab `""Marital status based on Armed Forces participation""' _n  ///                                                                                                                                                                                                 
"_column(161)"  _tab "byte   " _tab "PRPERTYP " _tab  "%2f   " _tab `""Type of person record recode""' _n  ///                                                                                                                                                                                                                       
"_column(163)"  _tab " int   " _tab "PENATVTY " _tab  "%3f   " _tab `""Country of birth""' _n  ///                                                                                                                                                                                                                                   
"_column(166)"  _tab " int   " _tab "PEMNTVTY " _tab  "%3f   " _tab `""Mother's country of birth""' _n  ///                                                                                                                                                                                                                          
"_column(169)"  _tab " int   " _tab "PEFNTVTY " _tab  "%3f   " _tab `""Father's country of birth""' _n  ///                                                                                                                                                                                                                          
"_column(172)"  _tab "byte   " _tab "PRCITSHP " _tab  "%2f   " _tab `""Citizenship status""' _n  ///                                                                                                                                                                                                                                 
"_column(174)"  _tab "byte   " _tab "PRCITFLG " _tab  "%2f   " _tab `""Citizenship allocation flag""' _n  ///                                                                                                                                                                                                                        
"_column(176)"  _tab "byte   " _tab "PRINUSYR " _tab  "%2f   " _tab `""Immigrant's year of entry""' _n  ///                                                                                                                                                                                                                          
"_column(178)"  _tab "byte   " _tab "PUSLFPRX " _tab  "%2f   " _tab `""Labor force information collected by self or proxy response""' _n  ///                                                                                                                                                                                        
"_column(180)"  _tab "byte   " _tab "PEMLR    " _tab  "%2f   " _tab `""Monthly labor force recode""' _n  ///                                                                                                                                                                                                                         
"_column(182)"  _tab "byte   " _tab "PUWK     " _tab  "%2f   " _tab `""Last week, did you do any work for (either) pay (or profit)?""' _n  ///                                                                                                                                                                                       
"_column(184)"  _tab "byte   " _tab "PUBUS1   " _tab  "%2f   " _tab `""Last week, did you do any unpaid work in the family business or farm?""' _n  ///                                                                                                                                                                              
"_column(186)"  _tab "byte   " _tab "PUBUS2OT " _tab  "%2f   " _tab `""Do you receive any payments or profits from the business?""' _n  ///                                                                                                                                                                                          
"_column(188)"  _tab "byte   " _tab "PUBUSCK1 " _tab  "%2f   " _tab `""Check item 1 filter for questions on unpaid work""' _n  ///                                                                                                                                                                                                   
"_column(190)"  _tab "byte   " _tab "PUBUSCK2 " _tab  "%2f   " _tab `""Check item 2 skips owners of family busines who did not work last week""' _n  ///                                                                                                                                                                             
"_column(192)"  _tab "byte   " _tab "PUBUSCK3 " _tab  "%2f   " _tab `""Check item 3""' _n  ///                                                                                                                                                                                                                                       
"_column(194)"  _tab "byte   " _tab "PUBUSCK4 " _tab  "%2f   " _tab `""Check item 4""' _n  ///                                                                                                                                                                                                                                       
"_column(196)"  _tab "byte   " _tab "PURETOT  " _tab  "%2f   " _tab `""Retirement status (last month you were reported to be retired, are you still retired this month?)""' _n  ///                                                                                                                                                  
"_column(198)"  _tab "byte   " _tab "PUDIS    " _tab  "%2f   " _tab `""Disability status (last month you were reported to have a disability.) Does your disability continue to prevent you from doing any kind of work for the next 6 months?""' _n  ///                                                                             
"_column(200)"  _tab "byte   " _tab "PERET1   " _tab  "%2f   " _tab `""Do you currently want a job, either full or part-time?""' _n  ///                                                                                                                                                                                             
"_column(202)"  _tab "byte   " _tab "PUDIS1   " _tab  "%2f   " _tab `""Does your disability prevent you from accepting any kind of work during the next six months?""' _n  ///                                                                                                                                                       
"_column(204)"  _tab "byte   " _tab "PUDIS2   " _tab  "%2f   " _tab `""Do you have a disability that prevents you from accepting any kind of work during the next six months?""' _n  ///                                                                                                                                             
"_column(206)"  _tab "byte   " _tab "PUABSOT  " _tab  "%2f   " _tab `""Last week did you have a job either full or part-time?""' _n  ///                                                                                                                                                                                             
"_column(208)"  _tab "byte   " _tab "PULAY    " _tab  "%2f   " _tab `""Last week, were you on layoff from a job?""' _n  ///                                                                                                                                                                                                          
"_column(210)"  _tab "byte   " _tab "PEABSRSN " _tab  "%2f   " _tab `""What is the main reason you were absent from work last week?""' _n  ///                                                                                                                                                                                       
"_column(212)"  _tab "byte   " _tab "PEABSPDO " _tab  "%2f   " _tab `""Are you being paid by your employer for any of the time off last week?""' _n  ///                                                                                                                                                                             
"_column(214)"  _tab "byte   " _tab "PEMJOT   " _tab  "%2f   " _tab `""Do you have more than one job?""' _n  ///                                                                                                                                                                                                                     
"_column(216)"  _tab "byte   " _tab "PEMJNUM  " _tab  "%2f   " _tab `""Altogether, how many jobs did you have?""' _n  ///                                                                                                                                                                                                            
"_column(218)"  _tab "byte   " _tab "PEHRUSL1 " _tab  "%2f   " _tab `""How many hours per week do you usually work at your main job?""' _n  ///                                                                                                                                                                                      
"_column(220)"  _tab "byte   " _tab "PEHRUSL2 " _tab  "%2f   " _tab `""How many hours per week do you usually work at your other (job/jobs)?""' _n  ///                                                                                                                                                                              
"_column(222)"  _tab "byte   " _tab "PEHRFTPT " _tab  "%2f   " _tab `""Do you usually work 35 hours or more per week?""' _n  ///                                                                                                                                                                                                     
"_column(224)"  _tab "int    " _tab "PEHRUSLT " _tab  "%3f   " _tab `""Sum of HRUSL1 and HRUSL2.""' _n  ///                                                                                                                                                                                                                          
"_column(227)"  _tab "byte   " _tab "PEHRWANT " _tab  "%2f   " _tab `""Do you want to work a full-time work week of 35 hours or more per week?""' _n  ///                                                                                                                                                                            
"_column(229)"  _tab "byte   " _tab "PEHRRSN1 " _tab  "%2f   " _tab `""What is your main reason for working part-time?""' _n  ///                                                                                                                                                                                                    
"_column(231)"  _tab "byte   " _tab "PEHRRSN2 " _tab  "%2f   " _tab `""What is the main reason you do not want to work full-time?""' _n  ///                                                                                                                                                                                         
"_column(233)"  _tab "byte   " _tab "PEHRRSN3 " _tab  "%2f   " _tab `""What is the main reason you worked less than 35 hours last week?""' _n  ///                                                                                                                                                                                   
"_column(235)"  _tab "byte   " _tab "PUHROFF1 " _tab  "%2f   " _tab `""Last week, did you lose or take off any hours from your job, for any reason such as illness, slack work, vacation, or holiday?""' _n  ///                                                                                                                     
"_column(237)"  _tab "byte   " _tab "PUHROFF2 " _tab  "%2f   " _tab `""How many hours did you take off?""' _n  ///                                                                                                                                                                                                                   
"_column(239)"  _tab "byte   " _tab "PUHROT1  " _tab  "%2f   " _tab `""Last week, did you work any overtime or extra hours (at your main job) that you do not usually work?""' _n  ///                                                                                                                                               
"_column(241)"  _tab "byte   " _tab "PUHROT2  " _tab  "%2f   " _tab `""How many additional hours did you work?""' _n  ///                                                                                                                                                                                                            
"_column(243)"  _tab "byte   " _tab "PEHRACT1 " _tab  "%2f   " _tab `""Last week, how many hours did you actually work at your job?""' _n  ///                                                                                                                                                                                       
"_column(245)"  _tab "byte   " _tab "PEHRACT2 " _tab  "%2f   " _tab `""Last week, how many hours did you actually work at your other (job/jobs)""' _n  ///                                                                                                                                                                           
"_column(247)"  _tab "int    " _tab "PEHRACTT " _tab  "%3f   " _tab `""Sum of PEHRACT1 and PEHRACT2""' _n  ///                                                                                                                                                                                                                       
"_column(250)"  _tab "byte   " _tab "PEHRAVL  " _tab  "%2f   " _tab `""Last week, could you have worked full-time if the hours had been available?""' _n  ///                                                                                                                                                                        
"_column(257)"  _tab "byte   " _tab "PUHRCK1  " _tab  "%2f   " _tab `""Check item 1""' _n  ///                                                                                                                                                                                                                                       
"_column(259)"  _tab "byte   " _tab "PUHRCK2  " _tab  "%2f   " _tab `""Check item 2 skips persons responding yes to HRFTPT out of PT series""' _n  ///                                                                                                                                                                               
"_column(261)"  _tab "byte   " _tab "PUHRCK3  " _tab  "%2f   " _tab `""Check item 3""' _n  ///                                                                                                                                                                                                                                       
"_column(263)"  _tab "byte   " _tab "PUHRCK4  " _tab  "%2f   " _tab `""Check item 4""' _n  ///                                                                                                                                                                                                                                       
"_column(265)"  _tab "byte   " _tab "PUHRCK5  " _tab  "%2f   " _tab `""Check item 5""' _n  ///                                                                                                                                                                                                                                       
"_column(267)"  _tab "byte   " _tab "PUHRCK6  " _tab  "%2f   " _tab `""Check item 6""' _n  ///                                                                                                                                                                                                                                       
"_column(269)"  _tab "byte   " _tab "PUHRCK7  " _tab  "%2f   " _tab `""Check item 7""' _n  ///                                                                                                                                                                                                                                       
"_column(271)"  _tab "byte   " _tab "PUHRCK12 " _tab  "%2f   " _tab `""Check item 12""' _n  ///                                                                                                                                                                                                                                      
"_column(273)"  _tab "byte   " _tab "PULAYDT  " _tab  "%2f   " _tab `""Has your employer given you a date to return to work?""' _n  ///                                                                                                                                                                                              
"_column(275)"  _tab "byte   " _tab "PULAY6M  " _tab  "%2f   " _tab `""Have you been given any indication that you will be recalled to work within the next 6 months?""' _n  ///                                                                                                                                                     
"_column(277)"  _tab "byte   " _tab "PELAYAVL " _tab  "%2f   " _tab `""Could you have returned to work last week if you had been recalled?""' _n  ///                                                                                                                                                                                
"_column(279)"  _tab "byte   " _tab "PULAYAVR " _tab  "%2f   " _tab `""Why is that?""' _n  ///                                                                                                                                                                                                                                       
"_column(281)"  _tab "byte   " _tab "PELAYLK  " _tab  "%2f   " _tab `""Even though you are to be called back to work, have you been looking for work during the last 4 weeks.""' _n  ///                                                                                                                                             
"_column(283)"  _tab "int    " _tab "PELAYDUR " _tab  "%3f   " _tab `""Duration of layoff""' _n  ///                                                                                                                                                                                                                                 
"_column(286)"  _tab "byte   " _tab "PELAYFTO " _tab  "%2f   " _tab `""FT/PT status of job from which sample person was on layoff from""' _n  ///                                                                                                                                                                                    
"_column(288)"  _tab "byte   " _tab "PULAYCK1 " _tab  "%2f   " _tab `""Check item 1""' _n  ///                                                                                                                                                                                                                                       
"_column(290)"  _tab "byte   " _tab "PULAYCK2 " _tab  "%2f   " _tab `""Check item 2 screen for dependent layoff""' _n  ///                                                                                                                                                                                                           
"_column(292)"  _tab "byte   " _tab "PULAYCK3 " _tab  "%2f   " _tab `""Check item 3 filter for dependent I & O""' _n  ///                                                                                                                                                                                                            
"_column(294)"  _tab "byte   " _tab "PULK     " _tab  "%2f   " _tab `""Have you been doing anything to find work during the last 4 weeks?""' _n  ///                                                                                                                                                                                 
"_column(296)"  _tab "byte   " _tab "PELKM1   " _tab  "%2f   " _tab `""What are all of the things you have done to find work during the last 4 weeks? (first method)""' _n  ///                                                                                                                                                      
"_column(298)"  _tab "byte   " _tab "PULKM2   " _tab  "%2f   " _tab `""Anything else? (second method)""' _n  ///                                                                                                                                                                                                                     
"_column(300)"  _tab "byte   " _tab "PULKM3   " _tab  "%2f   " _tab `""Anything else? (third method)""' _n  ///                                                                                                                                                                                                                      
"_column(302)"  _tab "byte   " _tab "PULKM4   " _tab  "%2f   " _tab `""Anything else? (fourth method)""' _n  ///                                                                                                                                                                                                                     
"_column(304)"  _tab "byte   " _tab "PULKM5   " _tab  "%2f   " _tab `""Anything else? (fifth method)""' _n  ///                                                                                                                                                                                                                      
"_column(306)"  _tab "byte   " _tab "PULKM6   " _tab  "%2f   " _tab `""Anything else? (sixth method)""' _n  ///                                                                                                                                                                                                                      
"_column(308)"  _tab "byte   " _tab "PULKDK1  " _tab  "%2f   " _tab `""You said you have been trying to find work. How did you go about looking? (first method)""' _n  ///                                                                                                                                                           
"_column(310)"  _tab "byte   " _tab "PULKDK2  " _tab  "%2f   " _tab `""Anything else? (second method)""' _n  ///                                                                                                                                                                                                                     
"_column(312)"  _tab "byte   " _tab "PULKDK3  " _tab  "%2f   " _tab `""Anything else? (third method)""' _n  ///                                                                                                                                                                                                                      
"_column(314)"  _tab "byte   " _tab "PULKDK4  " _tab  "%2f   " _tab `""Anything else? (fourth method)""' _n  ///                                                                                                                                                                                                                     
"_column(316)"  _tab "byte   " _tab "PULKDK5  " _tab  "%2f   " _tab `""Anything else? (fifth method)""' _n  ///                                                                                                                                                                                                                      
"_column(318)"  _tab "byte   " _tab "PULKDK6  " _tab  "%2f   " _tab `""Anything else? (sixth method)""' _n  ///                                                                                                                                                                                                                      
"_column(320)"  _tab "byte   " _tab "PULKPS1  " _tab  "%2f   " _tab `""Can you tell me more about what you did to search for work? (first method)""' _n  ///                                                                                                                                                                         
"_column(322)"  _tab "byte   " _tab "PULKPS2  " _tab  "%2f   " _tab `""Anything else? (second method)""' _n  ///                                                                                                                                                                                                                     
"_column(324)"  _tab "byte   " _tab "PULKPS3  " _tab  "%2f   " _tab `""Anything else? (third method)""' _n  ///                                                                                                                                                                                                                      
"_column(326)"  _tab "byte   " _tab "PULKPS4  " _tab  "%2f   " _tab `""Anything else? (fourth method)""' _n  ///                                                                                                                                                                                                                     
"_column(328)"  _tab "byte   " _tab "PULKPS5  " _tab  "%2f   " _tab `""Anything else? (fifth method)""' _n  ///                                                                                                                                                                                                                      
"_column(330)"  _tab "byte   " _tab "PULKPS6  " _tab  "%2f   " _tab `""Anything else? (sixth method)""' _n  ///                                                                                                                                                                                                                      
"_column(332)"  _tab "byte   " _tab "PELKAVL  " _tab  "%2f   " _tab `""Last week, could you have started a job if one had been offered?""' _n  ///                                                                                                                                                                                   
"_column(334)"  _tab "byte   " _tab "PULKAVR  " _tab  "%2f   " _tab `""Why is that?""' _n  ///                                                                                                                                                                                                                                       
"_column(336)"  _tab "byte   " _tab "PELKLL1O " _tab  "%2f   " _tab `""Before you started looking for work, what were you doing: working, going to school, or something else?""' _n  ///                                                                                                                                             
"_column(338)"  _tab "byte   " _tab "PELKLL2O " _tab  "%2f   " _tab `""Did you lose or quit that job, or was it a temporary job that ended?""' _n  ///                                                                                                                                                                               
"_column(340)"  _tab "byte   " _tab "PELKLWO  " _tab  "%2f   " _tab `""When last worked""' _n  ///                                                                                                                                                                                                                                   
"_column(342)"  _tab "int    " _tab "PELKDUR  " _tab  "%3f   " _tab `""Duration of job seeking""' _n  ///                                                                                                                                                                                                                            
"_column(345)"  _tab "byte   " _tab "PELKFTO  " _tab  "%2f   " _tab `""FT/PT status of jobseeker""' _n  ///                                                                                                                                                                                                                          
"_column(347)"  _tab "byte   " _tab "PEDWWNTO " _tab  "%2f   " _tab `""Do you currently want a job, either full or part time?""' _n  ///                                                                                                                                                                                             
"_column(349)"  _tab "byte   " _tab "PEDWRSN  " _tab  "%2f   " _tab `""What is the main reason you were not looking for work during the last 4 weeks?""' _n  ///                                                                                                                                                                     
"_column(351)"  _tab "byte   " _tab "PEDWLKO  " _tab  "%2f   " _tab `""Did you look for work at any time in the last 12 months""' _n  ///                                                                                                                                                                                            
"_column(353)"  _tab "byte   " _tab "PEDWWK   " _tab  "%2f   " _tab `""Did you actually work at a job or business during the last 12 months?""' _n  ///                                                                                                                                                                              
"_column(355)"  _tab "byte   " _tab "PEDW4WK  " _tab  "%2f   " _tab `""Did you do any of this work during the last 4 weeks?""' _n  ///                                                                                                                                                                                               
"_column(357)"  _tab "byte   " _tab "PEDWLKWK " _tab  "%2f   " _tab `""Since you left that job or business have you looked for work?""' _n  ///                                                                                                                                                                                      
"_column(359)"  _tab "byte   " _tab "PEDWAVL  " _tab  "%2f   " _tab `""Last week, could you have started a job if one had been offered?""' _n  ///                                                                                                                                                                                   
"_column(361)"  _tab "byte   " _tab "PEDWAVR  " _tab  "%2f   " _tab `""Why is that?""' _n  ///                                                                                                                                                                                                                                       
"_column(363)"  _tab "byte   " _tab "PUDWCK1  " _tab  "%2f   " _tab `""Screen for discouraged workers""' _n  ///                                                                                                                                                                                                                     
"_column(365)"  _tab "byte   " _tab "PUDWCK2  " _tab  "%2f   " _tab `""Screen for disabled""' _n  ///                                                                                                                                                                                                                                
"_column(367)"  _tab "byte   " _tab "PUDWCK3  " _tab  "%2f   " _tab `""Filter for retired""' _n  ///                                                                                                                                                                                                                                 
"_column(369)"  _tab "byte   " _tab "PUDWCK4  " _tab  "%2f   " _tab `""Filter for passive job seekers""' _n  ///                                                                                                                                                                                                                     
"_column(371)"  _tab "byte   " _tab "PUDWCK5  " _tab  "%2f   " _tab `""Filter for passive job seekers""' _n  ///                                                                                                                                                                                                                     
"_column(373)"  _tab "byte   " _tab "PEJHWKO  " _tab  "%2f   " _tab `""Have you worked at a job or business at any time during the past 12 months?""' _n  ///                                                                                                                                                                        
"_column(375)"  _tab "byte   " _tab "PUJHDP1O " _tab  "%2f   " _tab `""Did you do any of this work in the last 4 weeks?""' _n  ///                                                                                                                                                                                                   
"_column(377)"  _tab "byte   " _tab "PEJHRSN  " _tab  "%2f   " _tab `""What is the main reason you left your last job?""' _n  ///                                                                                                                                                                                                    
"_column(379)"  _tab "byte   " _tab "PEJHWANT " _tab  "%2f   " _tab `""Do you intend to look for work during the next 12 months?""' _n  ///                                                                                                                                                                                          
"_column(381)"  _tab "byte   " _tab "PUJHCK1  " _tab  "%2f   " _tab `""Filter for outgoing rotations""' _n  ///                                                                                                                                                                                                                      
"_column(383)"  _tab "byte   " _tab "PUJHCK2  " _tab  "%2f   " _tab `""Filter for persons going through the I and O series""' _n  ///                                                                                                                                                                                                
"_column(385)"  _tab "byte   " _tab "PRABSREA " _tab  "%2f   " _tab `""Reason not at work and pay status""' _n  ///                                                                                                                                                                                                                  
"_column(387)"  _tab "byte   " _tab "PRCIVLF  " _tab  "%2f   " _tab `""Civilian labor force""' _n  ///                                                                                                                                                                                                                               
"_column(389)"  _tab "byte   " _tab "PRDISC   " _tab  "%2f   " _tab `""Discouraged worker recode""' _n  ///                                                                                                                                                                                                                          
"_column(391)"  _tab "byte   " _tab "PREMPHRS " _tab  "%2f   " _tab `""Reason not at work or hours at work""' _n  ///                                                                                                                                                                                                                
"_column(393)"  _tab "byte   " _tab "PREMPNOT " _tab  "%2f   " _tab `""MLR - employed, unemployed, or NILF""' _n  ///                                                                                                                                                                                                                
"_column(395)"  _tab "byte   " _tab "PREXPLF  " _tab  "%2f   " _tab `""Experienced labor force employment""' _n  ///                                                                                                                                                                                                                 
"_column(397)"  _tab "byte   " _tab "PRFTLF   " _tab  "%2f   " _tab `""Full time labor force""' _n  ///                                                                                                                                                                                                                              
"_column(399)"  _tab "byte   " _tab "PRHRUSL  " _tab  "%2f   " _tab `""Usual hours worked weekly""' _n  ///                                                                                                                                                                                                                          
"_column(401)"  _tab "byte   " _tab "PRJOBSEA " _tab  "%2f   " _tab `""Job search recode""' _n  ///                                                                                                                                                                                                                                  
"_column(403)"  _tab "byte   " _tab "PRPTHRS  " _tab  "%2f   " _tab `""At work 1-34 by hours at work""' _n  ///                                                                                                                                                                                                                      
"_column(405)"  _tab "byte   " _tab "PRPTREA  " _tab  "%2f   " _tab `""Detailed reason for part-time""' _n  ///                                                                                                                                                                                                                      
"_column(407)"  _tab "int    " _tab "PRUNEDUR " _tab  "%3f   " _tab `""Duration of unemployment for layoff and looking records""' _n  ///                                                                                                                                                                                            
"_column(412)"  _tab "byte   " _tab "PRUNTYPE " _tab  "%2f   " _tab `""Reason for unemployment""' _n  ///                                                                                                                                                                                                                            
"_column(414)"  _tab "byte   " _tab "PRWKSCH  " _tab  "%2f   " _tab `""Labor force by time worked or lost""' _n  ///                                                                                                                                                                                                                 
"_column(416)"  _tab "byte   " _tab "PRWKSTAT " _tab  "%2f   " _tab `""Full/part-time work status""' _n  ///                                                                                                                                                                                                                         
"_column(418)"  _tab "byte   " _tab "PRWNTJOB " _tab  "%2f   " _tab `""NILF recode - want a job or other NILF""' _n  ///                                                                                                                                                                                                             
"_column(420)"  _tab "byte   " _tab "PUJHCK3  " _tab  "%2f   " _tab `""Job history check item""' _n  ///                                                                                                                                                                                                                             
"_column(422)"  _tab "byte   " _tab "PUJHCK4  " _tab  "%2f   " _tab `""Screen for dependent NILF""' _n  ///                                                                                                                                                                                                                          
"_column(424)"  _tab "byte   " _tab "PUJHCK5  " _tab  "%2f   " _tab `""Screen for dependent NILF""' _n  ///                                                                                                                                                                                                                          
"_column(426)"  _tab "byte   " _tab "PUIODP1  " _tab  "%2f   " _tab `""Last month, it was reported that you worked for (employer's name). Do still work for (employer's name) (at your main job)?""' _n  ///                                                                                                                         
"_column(428)"  _tab "byte   " _tab "PUIODP2  " _tab  "%2f   " _tab `""Have the usual activities and duties of your job changed since last month?""' _n  ///                                                                                                                                                                         
"_column(430)"  _tab "byte   " _tab "PUIODP3  " _tab  "%2f   " _tab `""Last month you were reported as (a/an) (occupation) and your usual activities were (description). Is this an accurate description of your current job?""' _n  ///                                                                                             
"_column(432)"  _tab "byte   " _tab "PEIO1COW " _tab  "%2f   " _tab `""Individual class of worker code on first job""' _n  ///                                                                                                                                                                                                       
"_column(434)"  _tab "byte   " _tab "PUIO1MFG " _tab  "%2f   " _tab `""Is this business or organization mainly manufacturing, retail trade, wholesale trade, or something else?""' _n  ///                                                                                                                                           
"_column(442)"  _tab "byte   " _tab "PEIO2COW " _tab  "%2f   " _tab `""Individual class of worker on second job.""' _n  ///                                                                                                                                                                                                          
"_column(444)"  _tab "byte   " _tab "PUIO2MFG " _tab  "%2f   " _tab `""Is this business or organization mainly manufacturing, retail trade, wholesale trade, or something else?""' _n  ///                                                                                                                                           
"_column(452)"  _tab "byte   " _tab "PUIOCK1  " _tab  "%2f   " _tab `""I & O check item 1 screen for dependent I and O""' _n  ///                                                                                                                                                                                                    
"_column(454)"  _tab "byte   " _tab "PUIOCK2  " _tab  "%2f   " _tab `""I & O check item 2 screen for previous months I and O cases""' _n  ///                                                                                                                                                                                        
"_column(456)"  _tab "byte   " _tab "PUIOCK3  " _tab  "%2f   " _tab `""I & O check item 3""' _n  ///                                                                                                                                                                                                                                 
"_column(458)"  _tab "byte   " _tab "PRIOELG  " _tab  "%2f   " _tab `""Industry and occupation eligibility flag""' _n  ///                                                                                                                                                                                                           
"_column(460)"  _tab "byte   " _tab "PRAGNA   " _tab  "%2f   " _tab `""Agriculture/non-agriculture industry""' _n  ///                                                                                                                                                                                                               
"_column(462)"  _tab "byte   " _tab "PRCOW1   " _tab  "%2f   " _tab `""Class of worker recode - job 1""' _n  ///                                                                                                                                                                                                                     
"_column(464)"  _tab "byte   " _tab "PRCOW2   " _tab  "%2f   " _tab `""Class of worker recode - job 2""' _n  ///                                                                                                                                                                                                                     
"_column(466)"  _tab "byte   " _tab "PRCOWPG  " _tab  "%2f   " _tab `""COW - private or government""' _n  ///                                                                                                                                                                                                                        
"_column(468)"  _tab "byte   " _tab "PRDTCOW1 " _tab  "%2f   " _tab `""Detailed class of worker recode - job 1""' _n  ///                                                                                                                                                                                                            
"_column(470)"  _tab "byte   " _tab "PRDTCOW2 " _tab  "%2f   " _tab `""Detailed class of worker recode - job 2""' _n  ///                                                                                                                                                                                                            
"_column(472)"  _tab "byte   " _tab "PRDTIND1 " _tab  "%2f   " _tab `""Detailed industry recode - job 1""' _n  ///                                                                                                                                                                                                                   
"_column(474)"  _tab "byte   " _tab "PRDTIND2 " _tab  "%2f   " _tab `""Detailed industry recode - job 2""' _n  ///                                                                                                                                                                                                                   
"_column(476)"  _tab "byte   " _tab "PRDTOCC1 " _tab  "%2f   " _tab `""Detailed occupation recode - job 1""' _n  ///                                                                                                                                                                                                                 
"_column(478)"  _tab "byte   " _tab "PRDTOCC2 " _tab  "%2f   " _tab `""Detailed occupation recode - job 2""' _n  ///                                                                                                                                                                                                                 
"_column(480)"  _tab "byte   " _tab "PREMP    " _tab  "%2f   " _tab `""Employed persons (non-farm & non-private hhld) recode""' _n  ///                                                                                                                                                                                              
"_column(482)"  _tab "byte   " _tab "PRMJIND1 " _tab  "%2f   " _tab `""Major industry recode - job 1""' _n  ///                                                                                                                                                                                                                      
"_column(484)"  _tab "byte   " _tab "PRMJIND2 " _tab  "%2f   " _tab `""Major industry recode - job 2""' _n  ///                                                                                                                                                                                                                      
"_column(486)"  _tab "byte   " _tab "PRMJOCC1 " _tab  "%2f   " _tab `""Major occupation recode - job 1""' _n  ///                                                                                                                                                                                                                    
"_column(488)"  _tab "byte   " _tab "PRMJOCC2 " _tab  "%2f   " _tab `""Major occupation recode - job 2""' _n  ///                                                                                                                                                                                                                    
"_column(490)"  _tab "byte   " _tab "PRMJOCGR " _tab  "%2f   " _tab `""Major occupation categories""' _n  ///                                                                                                                                                                                                                        
"_column(492)"  _tab "byte   " _tab "PRNAGPWS " _tab  "%2f   " _tab `""Non-agriculture, private wage and salary workers recode""' _n  ///                                                                                                                                                                                            
"_column(494)"  _tab "byte   " _tab "PRNAGWS  " _tab  "%2f   " _tab `""Non-agriculture wage and salary workers recode""' _n  ///                                                                                                                                                                                                     
"_column(496)"  _tab "byte   " _tab "PRSJMJ   " _tab  "%2f   " _tab `""Single/multiple jobholder recode""' _n  ///                                                                                                                                                                                                                   
"_column(498)"  _tab "byte   " _tab "PRERELG  " _tab  "%2f   " _tab `""Earnings eligibility flag""' _n  ///                                                                                                                                                                                                                          
"_column(500)"  _tab "byte   " _tab "PEERNUOT " _tab  "%2f   " _tab `""Do you usually receive overtime pay, tips, or commissions at your job?""' _n  ///                                                                                                                                                                             
"_column(502)"  _tab "byte   " _tab "PEERNPER " _tab  "%2f   " _tab `""Periodicity""' _n  ///                                                                                                                                                                                                                                        
"_column(504)"  _tab "byte   " _tab "PEERNRT  " _tab  "%2f   " _tab `""(Even though you told me it is easier to report your earnings (periodicity); Are you paid at an hourly rate on your (main/this) job?""' _n  ///                                                                                                               
"_column(506)"  _tab "byte   " _tab "PEERNHRY " _tab  "%2f   " _tab `""Hourly/nonhourly status""' _n  ///                                                                                                                                                                                                                            
"_column(508)"  _tab "int    " _tab "PUERNH1C " _tab  "%4f   " _tab `""What is your hourly rate of pay on this job, excluding overtime pay, tips or commission?""' _n  ///                                                                                                                                                           
"_column(512)"  _tab "int    " _tab "PEERNH2  " _tab  "%4f   " _tab `""(Excluding overtime pay, tips and commissions) what is your hourly rate of pay on your (main/this) job?""' _n  ///                                                                                                                                            
"_column(516)"  _tab "int    " _tab "PEERNH1O " _tab  "%4f   " _tab `""Out variable for hourly rate of pay""' _n  ///                                                                                                                                                                                                                
"_column(520)"  _tab "int    " _tab "PRERNHLY " _tab  "%4f   " _tab `""Recode for hourly rate""' _n  ///                                                                                                                                                                                                                             
"_column(524)"  _tab "byte   " _tab "PTHR     " _tab  "%1f   " _tab `""Hourly pay - top code""' _n  ///                                                                                                                                                                                                                              
"_column(525)"  _tab "byte   " _tab "PEERNHRO " _tab  "%2f   " _tab `""Usual hours""' _n  ///                                                                                                                                                                                                                                        
"_column(527)"  _tab "long   " _tab "PRERNWA  " _tab  "%8f   " _tab `""Weekly earnings recode""' _n  ///                                                                                                                                                                                                                             
"_column(535)"  _tab "byte   " _tab "PTWK     " _tab  "%1f   " _tab `""Weekly earnings - top code""' _n  ///                                                                                                                                                                                                                         
"_column(540)"  _tab "long   " _tab "PEERN    " _tab  "%8f   " _tab `""Calculated weekly overtime amount""' _n  ///                                                                                                                                                                                                                  
"_column(548)"  _tab "long   " _tab "PUERN2   " _tab  "%8f   " _tab `""Calculated weekly overtime amount""' _n  ///                                                                                                                                                                                                                  
"_column(556)"  _tab "byte   " _tab "PTOT     " _tab  "%1f   " _tab `""Weekly overtime amount - top code""' _n  ///                                                                                                                                                                                                                  
"_column(559)"  _tab "byte   " _tab "PEERNWKP " _tab  "%2f   " _tab `""How many weeks a year do you get paid for?""' _n  ///                                                                                                                                                                                                         
"_column(561)"  _tab "byte   " _tab "PEERNLAB " _tab  "%2f   " _tab `""On this job, are you a member of a labor union or of an employee association similar to a union?""' _n  ///                                                                                                                                                   
"_column(563)"  _tab "byte   " _tab "PEERNCOV " _tab  "%2f   " _tab `""On this job are you covered by a union or employee association contract?""' _n  ///                                                                                                                                                                           
"_column(565)"  _tab "byte   " _tab "PENLFJH  " _tab  "%2f   " _tab `""When did you last work at a job or business?""' _n  ///                                                                                                                                                                                                       
"_column(567)"  _tab "byte   " _tab "PENLFRET " _tab  "%2f   " _tab `""Are you retired from a job or business?""' _n  ///                                                                                                                                                                                                            
"_column(569)"  _tab "byte   " _tab "PENLFACT " _tab  "%2f   " _tab `""What best describes your situation at this time? For example, are you disabled, ill, in school, taking care of house or family, or something else?""' _n  ///                                                                                                 
"_column(571)"  _tab "byte   " _tab "PUNLFCK1 " _tab  "%2f   " _tab `""Not in labor force check item - 1""' _n  ///                                                                                                                                                                                                                  
"_column(573)"  _tab "byte   " _tab "PUNLFCK2 " _tab  "%2f   " _tab `""Not in labor force check item - 2""' _n  ///                                                                                                                                                                                                                  
"_column(575)"  _tab "byte   " _tab "PESCHENR " _tab  "%2f   " _tab `""Last week, were you enrolled in a high school, college, or university?""' _n  ///                                                                                                                                                                             
"_column(577)"  _tab "byte   " _tab "PESCHFT  " _tab  "%2f   " _tab `""Are you enrolled in school as a full-time or part-time student?""' _n  ///                                                                                                                                                                                    
"_column(579)"  _tab "byte   " _tab "PESCHLVL " _tab  "%2f   " _tab `""Would that be high school, college, or university?""' _n  ///                                                                                                                                                                                                 
"_column(581)"  _tab "byte   " _tab "PRNLFSCH " _tab  "%2f   " _tab `""NLF activity - in school or not in school""' _n  ///                                                                                                                                                                                                          
"_column(583)"  _tab "double " _tab "PWFMWGT  " _tab  "%10.4f" _tab `""Family weight""' _n  ///                                                                                                                                                                                                                                      
"_column(593)"  _tab "double " _tab "PWLGWGT  " _tab  "%10.4f" _tab `""Longitudinal weight""' _n  ///                                                                                                                                                                                                                                
"_column(603)"  _tab "double " _tab "PWORWGT  " _tab  "%10.4f" _tab `""Outgoing rotation weight""' _n  ///                                                                                                                                                                                                                           
"_column(613)"  _tab "double " _tab "PWSSWGT  " _tab  "%10.4f" _tab `""Final weight""' _n  ///                                                                                                                                                                                                                                       
"_column(623)"  _tab "double " _tab "PWVETWGT " _tab  "%10.4f" _tab `""Veterans weight""' _n  ///                                                                                                                                                                                                                                    
"_column(633)"  _tab "byte   " _tab "PRCHLD   " _tab  "%2f   " _tab `""Presence of own children < 18 years of age by selected age group""' _n  ///                                                                                                                                                                                   
"_column(635)"  _tab "byte   " _tab "PRNMCHLD " _tab  "%2f   " _tab `""Number of own children < 18 years of age""' _n  ///                                                                                                                                                                                                           
"_column(637)"  _tab "byte   " _tab "PXPDEMP1 " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(639)"  _tab "byte   " _tab "PRWERNAL " _tab  "%2f   " _tab `""Allocation flag weekly earnings recode (PRERNWA)""' _n  ///                                                                                                                                                                                                   
"_column(641)"  _tab "byte   " _tab "PRHERNAL " _tab  "%2f   " _tab `""Allocation flag hourly earnings recode (PRERNHLY)""' _n  ///                                                                                                                                                                                                  
"_column(643)"  _tab "byte   " _tab "HXTENURE " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(645)"  _tab "byte   " _tab "HXHOUSUT " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(647)"  _tab "byte   " _tab "HXTELHHD " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(649)"  _tab "byte   " _tab "HXTELAVL " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(651)"  _tab "byte   " _tab "HXPHONEO " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(653)"  _tab "byte   " _tab "PXINUSYR " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(655)"  _tab "byte   " _tab "PXRRP    " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(657)"  _tab "byte   " _tab "PXPARENT " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(659)"  _tab "byte   " _tab "PXAGE    " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(661)"  _tab "byte   " _tab "PXMARITL " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(663)"  _tab "byte   " _tab "PXSPOUSE " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(665)"  _tab "byte   " _tab "PXSEX    " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(667)"  _tab "byte   " _tab "PXAFWHN1 " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(669)"  _tab "byte   " _tab "PXAFNOW  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(671)"  _tab "byte   " _tab "PXEDUCA  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(673)"  _tab "byte   " _tab "PXRACE1  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(675)"  _tab "byte   " _tab "PXNATVTY " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(677)"  _tab "byte   " _tab "PXMNTVTY " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(679)"  _tab "byte   " _tab "PXFNTVTY " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(681)"  _tab "byte   " _tab "PXNMEMP1 " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(683)"  _tab "byte   " _tab "PXHSPNON " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(685)"  _tab "byte   " _tab "PXMLR    " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(687)"  _tab "byte   " _tab "PXRET1   " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(689)"  _tab "byte   " _tab "PXABSRSN " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(691)"  _tab "byte   " _tab "PXABSPDO " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(693)"  _tab "byte   " _tab "PXMJOT   " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(695)"  _tab "byte   " _tab "PXMJNUM  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(697)"  _tab "byte   " _tab "PXHRUSL1 " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(699)"  _tab "byte   " _tab "PXHRUSL2 " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(701)"  _tab "byte   " _tab "PXHRFTPT " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(703)"  _tab "byte   " _tab "PXHRUSLT " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(705)"  _tab "byte   " _tab "PXHRWANT " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(707)"  _tab "byte   " _tab "PXHRRSN1 " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(709)"  _tab "byte   " _tab "PXHRRSN2 " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(711)"  _tab "byte   " _tab "PXHRACT1 " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(713)"  _tab "byte   " _tab "PXHRACT2 " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(715)"  _tab "byte   " _tab "PXHRACTT " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(717)"  _tab "byte   " _tab "PXHRRSN3 " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(719)"  _tab "byte   " _tab "PXHRAVL  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(721)"  _tab "byte   " _tab "PXLAYAVL " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(723)"  _tab "byte   " _tab "PXLAYLK  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(725)"  _tab "byte   " _tab "PXLAYDUR " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(727)"  _tab "byte   " _tab "PXLAYFTO " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(729)"  _tab "byte   " _tab "PXLKM1   " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(731)"  _tab "byte   " _tab "PXLKAVL  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(733)"  _tab "byte   " _tab "PXLKLL1O " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(735)"  _tab "byte   " _tab "PXLKLL2O " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(737)"  _tab "byte   " _tab "PXLKLWO  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(739)"  _tab "byte   " _tab "PXLKDUR  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(741)"  _tab "byte   " _tab "PXLKFTO  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(743)"  _tab "byte   " _tab "PXDWWNTO " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(745)"  _tab "byte   " _tab "PXDWRSN  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(747)"  _tab "byte   " _tab "PXDWLKO  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(749)"  _tab "byte   " _tab "PXDWWK   " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(751)"  _tab "byte   " _tab "PXDW4WK  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(753)"  _tab "byte   " _tab "PXDWLKWK " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(755)"  _tab "byte   " _tab "PXDWAVL  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(757)"  _tab "byte   " _tab "PXDWAVR  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(759)"  _tab "byte   " _tab "PXJHWKO  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(761)"  _tab "byte   " _tab "PXJHRSN  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(763)"  _tab "byte   " _tab "PXJHWANT " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(765)"  _tab "byte   " _tab "PXIO1COW " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(767)"  _tab "byte   " _tab "PXIO1ICD " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(769)"  _tab "byte   " _tab "PXIO1OCD " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(771)"  _tab "byte   " _tab "PXIO2COW " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(773)"  _tab "byte   " _tab "PXIO2ICD " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(775)"  _tab "byte   " _tab "PXIO2OCD " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(777)"  _tab "byte   " _tab "PXERNUOT " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(779)"  _tab "byte   " _tab "PXERNPER " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(781)"  _tab "byte   " _tab "PXERNH1O " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(783)"  _tab "byte   " _tab "PXERNHRO " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(785)"  _tab "byte   " _tab "PXERN    " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(787)"  _tab "byte   " _tab "PXPDEMP2 " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(789)"  _tab "byte   " _tab "PXNMEMP2 " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(791)"  _tab "byte   " _tab "PXERNWKP " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(793)"  _tab "byte   " _tab "PXERNRT  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(795)"  _tab "byte   " _tab "PXERNHRY " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(797)"  _tab "byte   " _tab "PXERNH2  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(799)"  _tab "byte   " _tab "PXERNLAB " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(801)"  _tab "byte   " _tab "PXERNCOV " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(803)"  _tab "byte   " _tab "PXNLFJH  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(805)"  _tab "byte   " _tab "PXNLFRET " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(807)"  _tab "byte   " _tab "PXNLFACT " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(809)"  _tab "byte   " _tab "PXSCHENR " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(811)"  _tab "byte   " _tab "PXSCHFT  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(813)"  _tab "byte   " _tab "PXSCHLVL " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(815)"  _tab "long   " _tab "QSTNUM   " _tab  "%5f   " _tab `""Unique household identifier.""' _n  ///                                                                                                                                                                                                                       
"_column(820)"  _tab "byte   " _tab "OCCURNUM " _tab  "%2f   " _tab `""Unique person identifier.""' _n  ///                                                                                                                                                                                                                          
"_column(822)"  _tab "byte   " _tab "PEDIPGED " _tab  "%2f   " _tab `""How did...get...'s high school diploma?""' _n  ///                                                                                                                                                                                                            
"_column(824)"  _tab "byte   " _tab "PEHGCOMP " _tab  "%2f   " _tab `""What was the highest grade of regular school...completed before receiving...'s GED?""' _n  ///                                                                                                                                                                
"_column(826)"  _tab "byte   " _tab "PECYC    " _tab  "%2f   " _tab `""How many years of college credit has...completed?""' _n  ///                                                                                                                                                                                                  
"_column(834)"  _tab "byte   " _tab "PXDIPGED " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(836)"  _tab "byte   " _tab "PXHGCOMP " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(838)"  _tab "byte   " _tab "PXCYC    " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(846)"  _tab "double " _tab "PWCMPWGT " _tab  "%10.4f" _tab `""Composited final weight. Used to create BLS's published labor force statistics""' _n  ///                                                                                                                                                                     
"_column(856)"  _tab "int    " _tab "PEIO1ICD " _tab  "%4f   " _tab `""Industry code for primary job""' _n  ///                                                                                                                                                                                                                      
"_column(860)"  _tab "int    " _tab "PEIO1OCD " _tab  "%4f   " _tab `""Occupation code for primary job.""' _n  ///                                                                                                                                                                                                                   
"_column(864)"  _tab "int    " _tab "PEIO2ICD " _tab  "%4f   " _tab `""Industry code for second job.""' _n  ///                                                                                                                                                                                                                      
"_column(868)"  _tab "int    " _tab "PEIO2OCD " _tab  "%4f   " _tab `""Occupation code for second job.""' _n  ///                                                                                                                                                                                                                    
"_column(872)"  _tab "byte   " _tab "PRIMIND1 " _tab  "%2f   " _tab `""Intermediate industry recode (job 1)""' _n  ///                                                                                                                                                                                                               
"_column(874)"  _tab "byte   " _tab "PRIMIND2 " _tab  "%2f   " _tab `""Intermediate industry recode (job 2)""' _n  ///                                                                                                                                                                                                               
"_column(876)"  _tab "byte   " _tab "PEAFWHN1 " _tab  "%2f   " _tab `""When did you serve?""' _n  ///                                                                                                                                                                                                                                
"_column(878)"  _tab "byte   " _tab "PEAFWHN2 " _tab  "%2f   " _tab `""When did you serve?""' _n  ///                                                                                                                                                                                                                                
"_column(880)"  _tab "byte   " _tab "PEAFWHN3 " _tab  "%2f   " _tab `""When did you serve?""' _n  ///                                                                                                                                                                                                                                
"_column(882)"  _tab "byte   " _tab "PEAFWHN4 " _tab  "%2f   " _tab `""When did you serve?""' _n  ///                                                                                                                                                                                                                                
"_column(884)"  _tab "byte   " _tab "PXAFEVER " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(886)"  _tab "byte   " _tab "PELNDAD  " _tab  "%2f   " _tab `""Line number of father""' _n  ///                                                                                                                                                                                                                              
"_column(888)"  _tab "byte   " _tab "PELNMOM  " _tab  "%2f   " _tab `""Line number of mother""' _n  ///                                                                                                                                                                                                                              
"_column(890)"  _tab "byte   " _tab "PEDADTYP " _tab  "%2f   " _tab `""Type of father""' _n  ///                                                                                                                                                                                                                                     
"_column(892)"  _tab "byte   " _tab "PEMOMTYP " _tab  "%2f   " _tab `""Type of mother""' _n  ///                                                                                                                                                                                                                                     
"_column(894)"  _tab "byte   " _tab "PECOHAB  " _tab  "%2f   " _tab `""Line number of cohabiting partner""' _n  ///                                                                                                                                                                                                                  
"_column(896)"  _tab "byte   " _tab "PXLNDAD  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(898)"  _tab "byte   " _tab "PXLNMOM  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(900)"  _tab "byte   " _tab "PXDADTYP " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(902)"  _tab "byte   " _tab "PXMOMTYP " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(904)"  _tab "byte   " _tab "PXCOHAB  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(906)"  _tab "byte   " _tab "PEDISEAR " _tab  "%2f   " _tab `""Is...deaf or does ...have serious difficulty hearing?""' _n  ///                                                                                                                                                                                              
"_column(908)"  _tab "byte   " _tab "PEDISEYE " _tab  "%2f   " _tab `""Is...blind or does...have serious difficulty seeing even when wearing glasses?""' _n  ///                                                                                                                                                                     
"_column(910)"  _tab "byte   " _tab "PEDISREM " _tab  "%2f   " _tab `""Because of a physical, mental, or emotional condition, does...have serious difficulty concentrating, remembering, or making decisions?""' _n  ///                                                                                                             
"_column(912)"  _tab "byte   " _tab "PEDISPHY " _tab  "%2f   " _tab `""Does...have serious difficulty walking or climbing stairs?""' _n  ///                                                                                                                                                                                         
"_column(914)"  _tab "byte   " _tab "PEDISDRS " _tab  "%2f   " _tab `""Does...have difficulty dressing or bathing?""' _n  ///                                                                                                                                                                                                        
"_column(916)"  _tab "byte   " _tab "PEDISOUT " _tab  "%2f   " _tab `""Because of a physical, mental, or emotional condition, does...have difficulty doing errands alone such as visiting a doctor’s office or shopping?""' _n  ///                                                                                                
"_column(918)"  _tab "byte   " _tab "PRDISFLG " _tab  "%2f   " _tab `""Does this person have any of these disability conditions?""' _n  ///                                                                                                                                                                                          
"_column(920)"  _tab "byte   " _tab "PXDISEAR " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(922)"  _tab "byte   " _tab "PXDISEYE " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(924)"  _tab "byte   " _tab "PXDISREM " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(926)"  _tab "byte   " _tab "PXDISPHY " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(928)"  _tab "byte   " _tab "PXDISDRS " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(930)"  _tab "byte   " _tab "PXDISOUT " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(932)"  _tab "byte   " _tab "HXFAMINC " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(934)"  _tab "byte   " _tab "PRDASIAN " _tab  "%2f   " _tab `""Detailed Asian race recode""' _n  ///                                                                                                                                                                                                                         
"_column(936)"  _tab "byte   " _tab "PEPDEMP1 " _tab  "%2f   " _tab `""Does this person usually have any paid employees?""' _n  ///                                                                                                                                                                                                  
"_column(938)"  _tab "byte   " _tab "PTNMEMP1 " _tab  "%2f   " _tab `""Excluding all owners, how many paid employees does this person usually have?""' _n  ///                                                                                                                                                                       
"_column(940)"  _tab "byte   " _tab "PEPDEMP2 " _tab  "%2f   " _tab `""Does this person usually have any paid employees?""' _n  ///                                                                                                                                                                                                  
"_column(942)"  _tab "byte   " _tab "PTNMEMP2 " _tab  "%2f   " _tab `""Excluding all owners, how many paid employees does this person usually have?""' _n  ///                                                                                                                                                                       
"_column(944)"  _tab "byte   " _tab "PECERT1  " _tab  "%2f   " _tab `""Does...have a currently active professional certification or a state or industry license?""' _n  ///                                                                                                                                                          
"_column(946)"  _tab "byte   " _tab "PECERT2  " _tab  "%2f   " _tab `""Were any of …s certifications or licenses issued by the federal, state, or local government?""' _n  ///                                                                                                                                                     
"_column(948)"  _tab "byte   " _tab "PECERT3  " _tab  "%2f   " _tab `""Earlier you told me that you had a currently active professional certification or license.  Is your certification or license required for your …""' _n  ///                                                                                                 
"_column(950)"  _tab "byte   " _tab "PXCERT1  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(952)"  _tab "byte   " _tab "PXCERT2  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(954)"  _tab "byte   " _tab "PXCERT3  " _tab  "%2f   " _tab `""Allocation flag""' _n  ///                                                                                                                                                                                                                                    
"_column(1001)" _tab "byte   " _tab "PENXTPR  " _tab  "%2f   " _tab `""Line number of person being interviewed""' _n  ///                                                                                                                                                                                                            
"_column(1003)" _tab "byte   " _tab "PENXTPR3 " _tab  "%2f   " _tab `""Is this self or proxy?""' _n  ///                                                                                                                                                                                                                             
"_column(1005)" _tab "byte   " _tab "PEA1     " _tab  "%2f   " _tab `""(Have/Has) (you/ name) smoked at least 100 cigarettes in (your/his/her) entire life? 100 cigarettes = approximately 5 packs""' _n  ///                                                                                                                        
"_column(1007)" _tab "int    " _tab "PEA2     " _tab  "%3f   " _tab `""How old (were/was) (you/name) when (you/he/she) first started smoking cigarettes FAIRLY REGULARLY?""' _n  ///                                                                                                                                                 
"_column(1010)" _tab "int    " _tab "PEA2A    " _tab  "%3f   " _tab `""You said that (you/name) never smoked regularly.  How old (were/was) (you/name) the first time (you/he/she) smoked part or all of a cigarette?""' _n  ///                                                                                                     
"_column(1013)" _tab "byte   " _tab "PEA3     " _tab  "%2f   " _tab `""(Do/Does) (you/name) now smoke cigarettes every day, some days, or not at all?""' _n  ///                                                                                                                                                                     
"_column(1015)" _tab "int    " _tab "PTB1     " _tab  "%3f   " _tab `""On the average, about how many cigarettes do you now smoke each day?""' _n  ///                                                                                                                                                                               
"_column(1018)" _tab "byte   " _tab "PEB1A    " _tab  "%2f   " _tab `""Would you say that, on average, you now smoke more or less than 20 cigarettes each day?""' _n  ///                                                                                                                                                            
"_column(1020)" _tab "byte   " _tab "PEB2     " _tab  "%2f   " _tab `""Do you usually smoke menthol or non-menthol cigarettes?""' _n  ///                                                                                                                                                                                            
"_column(1022)" _tab "byte   " _tab "PEB5ANUM " _tab  "%2f   " _tab `""How soon after you wake up do you typically smoke your first cigarette of the day? (number)""' _n  ///                                                                                                                                                        
"_column(1024)" _tab "byte   " _tab "PEB5AUNT " _tab  "%2f   " _tab `""How soon after you wake up do you typically smoke your first cigarette of the day? (unit)""' _n  ///                                                                                                                                                          
"_column(1026)" _tab "byte   " _tab "PEB5B    " _tab  "%2f   " _tab `""Would you say you smoke your first cigarette of the day within the first 30 minutes?""' _n  ///                                                                                                                                                               
"_column(1028)" _tab "byte   " _tab "PEBA6A   " _tab  "%2f   " _tab `""Do you usually buy your own cigarettes?""' _n  ///                                                                                                                                                                                                            
"_column(1030)" _tab "byte   " _tab "PEB6A    " _tab  "%2f   " _tab `""Do you USUALLY buy your cigarettes by the pack or by the carton?""' _n  ///                                                                                                                                                                                   
"_column(1032)" _tab "double " _tab "PTB6B    " _tab  "%5f   " _tab `""What price did you pay for the LAST pack of cigarettes you bought? Please report the cost after using discounts or coupons.""' _n  ///                                                                                                                        
"_column(1037)" _tab "double " _tab "PTB6C    " _tab  "%6f   " _tab `""What price did you pay for the LAST carton of cigarettes you bought? Please report the cost after using discounts or coupons.""' _n  ///                                                                                                                      
"_column(1043)" _tab "byte   " _tab "PEB6C4   " _tab  "%2f   " _tab `""Did you use coupons, rebates, or any other special promotions when you bought your LAST (B6a fill PACK/CARTON) of cigarettes?""' _n  ///                                                                                                                      
"_column(1045)" _tab "byte   " _tab "PEB6D1   " _tab  "%2f   " _tab `""Did you buy your LAST (pack/carton) of cigarettes in (fill respondents state of residence) or in some other state?""' _n  ///                                                                                                                                 
"_column(1047)" _tab "byte   " _tab "PEB6D21  " _tab  "%2f   " _tab `""In what other state did you buy your LAST (pack/carton) of cigarettes?""' _n  ///                                                                                                                                                                             
"_column(1049)" _tab "byte   " _tab "PEB6D3   " _tab  "%2f   " _tab `""Did you buy you LAST (pack/carton) of cigarettes from an Indian reservation?""' _n  ///                                                                                                                                                                       
"_column(1051)" _tab "byte   " _tab "PEB6DOTH " _tab  "%2f   " _tab `""Was the Other Way in which you purchased your LAST (pack/carton) of cigarettes:""' _n  ///                                                                                                                                                                    
"_column(1053)" _tab "byte   " _tab "PEB6E1   " _tab  "%2f   " _tab `""In the LAST 2 months, have you bought any SINGLE or INDIVIDUAL cigarettes?""' _n  ///                                                                                                                                                                         
"_column(1055)" _tab "byte   " _tab "PEB6E31  " _tab  "%2f   " _tab `""Did you buy your LAST SINGLE or INDIVIDUAL cigarette in [fill respondents state of residence] or in some other state or country?""' _n  ///                                                                                                                   
"_column(1057)" _tab "int    " _tab "PRB6E32A " _tab  "%3f   " _tab `""In what OTHER state or country did you buy your LAST SINGLE OR INDIVIDUAL cigarette?""' _n  ///                                                                                                                                                               
"_column(1060)" _tab "byte   " _tab "PEB6E4   " _tab  "%2f   " _tab `""In the LAST 2 months, have you bought loose tobacco to roll-your-own cigarettes?""' _n  ///                                                                                                                                                                   
"_column(1062)" _tab "byte   " _tab "PEB7C    " _tab  "%2f   " _tab `""For how long have you smoked EVERY DAY?""' _n  ///                                                                                                                                                                                                            
"_column(1064)" _tab "byte   " _tab "PEB7C2   " _tab  "%2f   " _tab `""Have you EVER smoked MENTHOL cigarettes for 6 months or more?""' _n  ///                                                                                                                                                                                      
"_column(1066)" _tab "byte   " _tab "PEB7C3   " _tab  "%2f   " _tab `""For how long (have you smoked/did you smoke) MENTHOL cigarettes?""' _n  ///                                                                                                                                                                                   
"_column(1068)" _tab "byte   " _tab "PEB8     " _tab  "%2f   " _tab `""Around this time 12 MONTHS AGO, were you smoking cigarettes every day, some days, or not at all?""' _n  ///                                                                                                                                                   
"_column(1070)" _tab "int    " _tab "PTB9     " _tab  "%3f   " _tab `""Around this time 12 months ago, on the average about how many cigarettes did you smoke each day?""' _n  ///                                                                                                                                                   
"_column(1073)" _tab "byte   " _tab "PEB10A   " _tab  "%2f   " _tab `""Around this time 12 months age, on how many of 30 days in the month did you smoke cigarettes?""' _n  ///                                                                                                                                                      
"_column(1075)" _tab "int    " _tab "PTB10B   " _tab  "%3f   " _tab `""On the average, on those (fill entry B10a) days, how many cigarettes did you usually smoke each day?""' _n  ///                                                                                                                                               
"_column(1078)" _tab "byte   " _tab "PEC1     " _tab  "%2f   " _tab `""On how many of the past 30 days did you smoke cigarettes?""' _n  ///                                                                                                                                                                                          
"_column(1080)" _tab "byte   " _tab "PEC1I    " _tab  "%2f   " _tab `""Would you say you smoked on at least 12 days in the past 30 days?""' _n  ///                                                                                                                                                                                  
"_column(1082)" _tab "int    " _tab "PTC1A    " _tab  "%3f   " _tab `""On the average, on those (fill entry C1) days, how many cigarettes did you usually smoke each day?""' _n  ///                                                                                                                                                 
"_column(1085)" _tab "byte   " _tab "PEC2     " _tab  "%2f   " _tab `""Do you usually smoke menthol or non-menthol cigarettes?""' _n  ///                                                                                                                                                                                            
"_column(1087)" _tab "byte   " _tab "PEC5ANUM " _tab  "%2f   " _tab `""On the days that you smoke, how soon after you wake up do you typically smoke your first cigarette of the day? (number)""' _n  ///                                                                                                                            
"_column(1089)" _tab "byte   " _tab "PEC5AUNT " _tab  "%2f   " _tab `""On the days that you smoke, how soon after you wake up do you typically smoke your first cigarette of the day? (unit)""' _n  ///                                                                                                                              
"_column(1091)" _tab "byte   " _tab "PEC5B    " _tab  "%2f   " _tab `""On the days that you smoke, would you say you smoke your first cigarette of the day within the first 30 minutes?""' _n  ///                                                                                                                                   
"_column(1093)" _tab "byte   " _tab "PECA6A   " _tab  "%2f   " _tab `""Do you usually buy your own cigarettes?""' _n  ///                                                                                                                                                                                                            
"_column(1095)" _tab "byte   " _tab "PEC6A    " _tab  "%2f   " _tab `""Do you USUALLY buy your cigarettes by the pack or by the carton?""' _n  ///                                                                                                                                                                                   
"_column(1097)" _tab "double " _tab "PTC6B    " _tab  "%5f   " _tab `""What price did you pay for the LAST pack of cigarettes you bought? Please report the cost after using discounts or coupons.""' _n  ///                                                                                                                        
"_column(1102)" _tab "double " _tab "PTC6C    " _tab  "%6f   " _tab `""What price did you pay for the LAST carton of cigarettes you bought? Please report the cost after using discounts or coupons.""' _n  ///                                                                                                                      
"_column(1108)" _tab "byte   " _tab "PEC6C4   " _tab  "%2f   " _tab `""Did you use coupons, rebates, or any other special promotions when you bought your LAST (pack/carton) of cigarettes?""' _n  ///                                                                                                                               
"_column(1110)" _tab "byte   " _tab "PEC6D1   " _tab  "%2f   " _tab `""Did you buy your LAST (pack/carton) of cigarettes in (fill respondent's state of residence) or in some other state?""' _n  ///                                                                                                                                
"_column(1112)" _tab "byte   " _tab "PEC6D21  " _tab  "%2f   " _tab `""In what other state did you buy your LAST (pack/carton) of cigarettes?""' _n  ///                                                                                                                                                                             
"_column(1114)" _tab "byte   " _tab "PEC6D3   " _tab  "%2f   " _tab `""Did you buy your LAST (pack/carton) of cigarettes from an Indian reservation?""' _n  ///                                                                                                                                                                      
"_column(1116)" _tab "byte   " _tab "PEC6DOTH " _tab  "%2f   " _tab `""Was the 'Other Way' in which you purchased your Last (pack/carton) of cigarettes.""' _n  ///                                                                                                                                                                  
"_column(1118)" _tab "byte   " _tab "PEC6E1   " _tab  "%2f   " _tab `""In the LAST 2 months, have you bought any SINGLE or INDIVIDUAL cigarettes?""' _n  ///                                                                                                                                                                         
"_column(1120)" _tab "byte   " _tab "PEC6E31  " _tab  "%2f   " _tab `""Did you buy your LAST SINGLE or INDIVIDUAL cigarette in (fill respondents state of residence) or in some other state or other country?""' _n  ///                                                                                                             
"_column(1122)" _tab "int    " _tab "PRC6E32A " _tab  "%3f   " _tab `""In what OTHER state or country did you buy your LAST SINGLE OR INDIVIDUAL cigarette?""' _n  ///                                                                                                                                                               
"_column(1125)" _tab "byte   " _tab "PEC6E4   " _tab  "%2f   " _tab `""In the LAST 2 months, have you bought loose tobacco to roll-your-own cigarettes?""' _n  ///                                                                                                                                                                   
"_column(1127)" _tab "byte   " _tab "PEC7A    " _tab  "%2f   " _tab `""Have you EVER smoked cigarettes EVERY DAY for at least 6 months?""' _n  ///                                                                                                                                                                                   
"_column(1129)" _tab "byte   " _tab "PEC7D    " _tab  "%2f   " _tab `""For how long did you smoke EVERY DAY?""' _n  ///                                                                                                                                                                                                              
"_column(1131)" _tab "byte   " _tab "PEC7D2   " _tab  "%2f   " _tab `""Have you EVER smoked MENTHOL cigarettes for 6 months or more?""' _n  ///                                                                                                                                                                                      
"_column(1133)" _tab "byte   " _tab "PEC7D3   " _tab  "%2f   " _tab `""For how long (have you smoked/did you smoke) MENTHOL cigarettes?""' _n  ///                                                                                                                                                                                   
"_column(1135)" _tab "byte   " _tab "PTC7E    " _tab  "%2f   " _tab `""When you last smoked every day, on average how many cigarettes did you smoke each day?""' _n  ///                                                                                                                                                             
"_column(1137)" _tab "byte   " _tab "PEC8     " _tab  "%2f   " _tab `""Around this time 12 MONTHS AGO, were you smoking cigarettes every day, some days, or not at all?""' _n  ///                                                                                                                                                   
"_column(1139)" _tab "int    " _tab "PTC9     " _tab  "%3f   " _tab `""Around this time 12 months ago, on the average about how many cigarettes did you smoke each day?""' _n  ///                                                                                                                                                   
"_column(1142)" _tab "byte   " _tab "PEC10A   " _tab  "%2f   " _tab `""Around this time 12 months age, on how many of 30 days in the month did you smoke cigarettes?""' _n  ///                                                                                                                                                      
"_column(1144)" _tab "int    " _tab "PTC10B   " _tab  "%3f   " _tab `""On the average, on those (fill entry c10a) days, how many cigarettes did you usually smoke each day?""' _n  ///                                                                                                                                               
"_column(1147)" _tab "byte   " _tab "PEDa     " _tab  "%2f   " _tab `""During the PAST 12 MONTHS, have you TRIED to QUIT smoking COMPLETELY?""' _n  ///                                                                                                                                                                              
"_column(1149)" _tab "byte   " _tab "PEDB     " _tab  "%2f   " _tab `""Have you EVER TRIED to QUIT smoking COMPLETELY?""' _n  ///                                                                                                                                                                                                    
"_column(1151)" _tab "byte   " _tab "PED1R    " _tab  "%2f   " _tab `""During the PAST 12 MONTHS, have you stopped smoking for one day or longer BECAUSE YOU WERE TRYING TO QUIT SMOKING?""' _n  ///                                                                                                                                 
"_column(1153)" _tab "byte   " _tab "PED3     " _tab  "%2f   " _tab `""How many TIMES during the past 12 months have you stopped smoking for one day or longer BECAUSE YOU WERE TRYING TO QUIT SMOKING?""' _n  ///                                                                                                                   
"_column(1155)" _tab "byte   " _tab "PED3B    " _tab  "%2f   " _tab `""Would you say that during the past 12 months it was MORE THAN 3 TIMES that you have stopped smoking for one day or longer BECAUSE YOU WERE TRYING TO QUIT SMOKING/TRIED to QUIT smoking COMPLETELY?""' _n  ///                                                
"_column(1157)" _tab "byte   " _tab "PED6NUM  " _tab  "%2f   " _tab `""During the PAST 12 MONTHS, what is the length of this single quit attempt where you stopped smoking because you were TRYING to quit smoking? (number)""' _n  ///                                                                                              
"_column(1159)" _tab "byte   " _tab "PED6UNT  " _tab  "%2f   " _tab `""During the PAST 12 MONTHS, what is the length of this single quit attempt where you stopped smoking because you were TRYING to quit smoking? (unit)""' _n  ///                                                                                                
"_column(1161)" _tab "byte   " _tab "PED6B    " _tab  "%2f   " _tab `""Was it more or less than one week?""' _n  ///                                                                                                                                                                                                                 
"_column(1163)" _tab "byte   " _tab "PED6CNUM " _tab  "%2f   " _tab `""Thinking of those attempts during the past 12 months, what was the length of time of the ONE attempt that lasted the longest? (number)""' _n  ///                                                                                                             
"_column(1165)" _tab "byte   " _tab "PED6CUNT " _tab  "%2f   " _tab `""Thinking of those attempts during the past 12 months, what was the length of time of the ONE attempt that lasted the longest? (unit)""' _n  ///                                                                                                               
"_column(1167)" _tab "byte   " _tab "PED6C2   " _tab  "%2f   " _tab `""Was it more or less than one week?""' _n  ///                                                                                                                                                                                                                 
"_column(1169)" _tab "byte   " _tab "PED7R    " _tab  "%2f   " _tab `""DURING THE PAST 12 MONTHS, have you made a serious attempt to stop smoking because you were TRYING to quit – even if you stopped for less than a day?""' _n  ///                                                                                            
"_column(1171)" _tab "byte   " _tab "PED8R    " _tab  "%2f   " _tab `""Have you EVER made a serious attempt to stop smoking because you were 'TRYING to quit'; even if you stopped for less than a day?""' _n  ///                                                                                                                   
"_column(1173)" _tab "byte   " _tab "PEE1A123 " _tab  "%2f   " _tab `""Thinking back to the (LAST TIME/time) you tried to QUIT smoking in the past 12 months: Did you use ANY of the following PRODUCTS: A NICOTINE … patch, gum, lozenge, nasal spray or inhaler?""' _n  ///                                                      
"_column(1175)" _tab "byte   " _tab "PEE1A7AB " _tab  "%2f   " _tab `""Thinking back to the (LAST TIME/time) you tried to QUIT smoking in the past 12 months: Did you use ANY of the following PRODUCTS: A prescription pill, called Chantix, Varenicline, Zyban, Bupropion, or Wellbutrin?""' _n  ///                               
"_column(1177)" _tab "byte   " _tab "PEE1B1   " _tab  "%2f   " _tab `""Thinking back to the (last time/time) you tried to QUIT smoking in the past 12 months. Did you use ANY of the following: A telephone help line or quit line?""' _n  ///                                                                                       
"_column(1179)" _tab "byte   " _tab "PEE1B2   " _tab  "%2f   " _tab `""Thinking back to the (last time/time) you tried to QUIT smoking in the past 12 months. Did you use ANY of the following: One-on-one IN-PERSON counseling by a health professional?""' _n  ///                                                                 
"_column(1181)" _tab "byte   " _tab "PEE1B3   " _tab  "%2f   " _tab `""Thinking back to the (last time/time) you tried to QUIT smoking in the past 12 months. Did you use ANY of the following: A stop smoking clinic, class, or support group?""' _n  ///                                                                           
"_column(1183)" _tab "byte   " _tab "PEE1B5   " _tab  "%2f   " _tab `""Thinking back to the (last time/time) you tried to QUIT smoking in the past 12 months. Did you use ANY of the following: Internet or a web-based program or tool including smartphone apps and text messaging programs?""' _n  ///                            
"_column(1185)" _tab "byte   " _tab "PEE1C2   " _tab  "%2f   " _tab `""The (last time/time) you tried to QUIT smoking in the past 12 months: Did you do ANY of the following: Try to quit by SWITCHING to smokeless tobacco such as chewing tobacco, snuff, or snus?""' _n  ///                                                      
"_column(1187)" _tab "byte   " _tab "PEE1C2B  " _tab  "%2f   " _tab `""The (last time/time) you tried to QUIT smoking in the past 12 months. Did you do ANY of the following: Try to quit by SWITCHING to regular cigars, cigarillos, little filtered cigars or any pipes filled with tobacco?""' _n  ///                            
"_column(1189)" _tab "byte   " _tab "PEE1C2C  " _tab  "%2f   " _tab `""The (last time/time) you tried to QUIT smoking in the past 12 months. Did you do ANY of the following: Try to quit by SWITCHING to electronic or E-cigarettes? You may also know them as vape-pens, e-hookah, vapes or mods.""' _n  ///                       
"_column(1191)" _tab "byte   " _tab "PEE1C2D1 " _tab  "%2f   " _tab `""Did you switch to? Cigars, cigarillos, little filtered cigars.""' _n  ///                                                                                                                                                                                     
"_column(1193)" _tab "byte   " _tab "PEE1C2D2 " _tab  "%2f   " _tab `""Did you switch to? Regular pipes filled with tobacco.""' _n  ///                                                                                                                                                                                              
"_column(1195)" _tab "byte   " _tab "PEE1C2D3 " _tab  "%2f   " _tab `""Did you switch to? Water or hookah (pronounced who-kah) pipes filled with tobacco.""' _n  ///                                                                                                                                                                 
"_column(1197)" _tab "byte   " _tab "PEE1CZ2C " _tab  "%2f   " _tab `""The (LAST TIME/TIME) you tried to quit smoking in the past 12 months, did you try to quit by SWITCHING to electronic or E-Cigarettes? You may also know them as vape-pens, e-hookah, vapes or mods.""' _n  ///                                                
"_column(1199)" _tab "byte   " _tab "PEF1A    " _tab  "%2f   " _tab `""In the PAST 12 MONTHS, have you seen a medical doctor?""' _n  ///                                                                                                                                                                                             
"_column(1201)" _tab "byte   " _tab "PEF1B    " _tab  "%2f   " _tab `""During the PAST 12 MONTHS, did any medical doctor ADVISE you to stop smoking?""' _n  ///                                                                                                                                                                      
"_column(1203)" _tab "byte   " _tab "PEG1     " _tab  "%2f   " _tab `""Are you seriously considering quitting smoking within the next 6 months?""' _n  ///                                                                                                                                                                           
"_column(1205)" _tab "byte   " _tab "PEG2     " _tab  "%2f   " _tab `""Are you planning to quit within the next 30 days?""' _n  ///                                                                                                                                                                                                  
"_column(1207)" _tab "byte   " _tab "PEG3     " _tab  "%2f   " _tab `""Overall, on a scale from 1 to 10 where 1 is NOT AT ALL interested and 10 is EXTREMELY interested, how interested are you in quitting smoking?""' _n  ///                                                                                                      
"_column(1209)" _tab "byte   " _tab "PEG4     " _tab  "%2f   " _tab `""If you did try to quit smoking altogether in the next 6 months, how LIKELY do you think you would be to succeed --not at all, a little likely, somewhat likely or very likely?""' _n  ///                                                                     
"_column(1211)" _tab "byte   " _tab "PEH1NUM  " _tab  "%2f   " _tab `""About how long has it been since you COMPLETELY quit smoking cigarettes? (number)""' _n  ///                                                                                                                                                                  
"_column(1213)" _tab "byte   " _tab "PEH1UNT  " _tab  "%2f   " _tab `""About how long has it been since you COMPLETELY quit smoking cigarettes? (unit)""' _n  ///                                                                                                                                                                    
"_column(1215)" _tab "byte   " _tab "PEH1B    " _tab  "%2f   " _tab `""In the PAST 12 months, was H1 the longest time you stopped smoking cigarettes because you were trying to quit?""' _n  ///                                                                                                                                     
"_column(1217)" _tab "byte   " _tab "PEH1CNUM " _tab  "%2f   " _tab `""During the PAST 12 MONTHS, what WAS the LONGEST length of time you stopped smoking because you were TRYING to quit smoking... (number)""' _n  ///                                                                                                             
"_column(1219)" _tab "byte   " _tab "PEH1CUnt " _tab  "%2f   " _tab `""During the PAST 12 MONTHS, what WAS the LONGEST length of time you stopped smoking because you were TRYING to quit smoking... (unit)""' _n  ///                                                                                                               
"_column(1221)" _tab "byte   " _tab "PEH2     " _tab  "%2f   " _tab `""Have you EVER smoked cigarettes EVERY DAY for at least 6 months?""' _n  ///                                                                                                                                                                                   
"_column(1223)" _tab "byte   " _tab "PEH5     " _tab  "%2f   " _tab `""For how long did you smoke EVERY DAY?""' _n  ///                                                                                                                                                                                                              
"_column(1225)" _tab "byte   " _tab "PTH5A    " _tab  "%2f   " _tab `""When you last smoked every day, on average how many cigarettes did you smoke each day?""' _n  ///                                                                                                                                                             
"_column(1227)" _tab "byte   " _tab "PEH6     " _tab  "%2f   " _tab `""Around this time 12 MONTHS AGO, were you smoking cigarettes every day, some days, or not at all?""' _n  ///                                                                                                                                                   
"_column(1229)" _tab "byte   " _tab "PTH6A    " _tab  "%2f   " _tab `""Around this time 12 MONTHS AGO, on the average, about how many cigarettes did you smoke each day?""' _n  ///                                                                                                                                                  
"_column(1231)" _tab "byte   " _tab "PEH6B    " _tab  "%2f   " _tab `""Around this time 12 MONTHS AGO, on how many of 30 days in the month did you smoke cigarettes?""' _n  ///                                                                                                                                                      
"_column(1233)" _tab "byte   " _tab "PTH6C    " _tab  "%2f   " _tab `""On the average, on those (Fill PEH6b entry), how many cigarettes did you usually smoke each day?""' _n  ///                                                                                                                                                   
"_column(1235)" _tab "byte   " _tab "PEH6C2   " _tab  "%2f   " _tab `""We are still talking about Around this time 12 months ago. Thinking back to the 12 MONTHS BEFORE YOU QUIT SMOKING CIGARETTES, during that time, did you usually smoke menthol or non-menthol cigarettes?""' _n  ///                                           
"_column(1237)" _tab "byte   " _tab "PEH6C4   " _tab  "%2f   " _tab `""Have you EVER smoked MENTHOL cigarettes for 6 months or more?""' _n  ///                                                                                                                                                                                      
"_column(1239)" _tab "byte   " _tab "PEH6C5   " _tab  "%2f   " _tab `""For how long have you smoked MENTHOL cigarettes?""' _n  ///                                                                                                                                                                                                   
"_column(1241)" _tab "byte   " _tab "PEH6D123 " _tab  "%2f   " _tab `""Now I would like to ask about HOW you went about completely quitting smoking.  When you quit smoking completely, did you use ANY of the following PRODUCTS: A NICOTINE…patch, gum, lozenge, nasal spray or inhaler?""' _n  ///                              
"_column(1243)" _tab "byte   " _tab "PEH6D7AB " _tab  "%2f   " _tab `""Now I would like to ask about HOW you went about completely quitting smoking.  When you quit smoking completely, did you use ANY of the following PRODUCTS: A prescription pill, called Chantix, Varenicline, Zyban, Bupropion, or Wellbutrin?""' _n  ///     
"_column(1245)" _tab "byte   " _tab "PEH6E1   " _tab  "%2f   " _tab `""When you quit smoking completely, did you use ANY of the following: A telephone help line or quit line?""' _n  ///                                                                                                                                            
"_column(1247)" _tab "byte   " _tab "PEH6E2   " _tab  "%2f   " _tab `""When you quit smoking completely, did you use ANY of the following: One-on-one IN-PERSON counseling by a health professional?""' _n  ///                                                                                                                      
"_column(1249)" _tab "byte   " _tab "PEH6E3   " _tab  "%2f   " _tab `""When you quit smoking completely, did you use ANY of the following: A stop smoking clinic, class, or support group?""' _n  ///                                                                                                                                
"_column(1251)" _tab "byte   " _tab "PEH6E5   " _tab  "%2f   " _tab `""When you quit smoking completely, did you use ANY of the following: Internet or a web-based program or tool including smartphone apps and text messaging programs?""' _n  ///                                                                                 
"_column(1253)" _tab "byte   " _tab "PEH6FA2  " _tab  "%2f   " _tab `""When you quit smoking completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to smokeless tobacco such as chewing tobacco, snuff, or snus?""' _n  ///                                            
"_column(1255)" _tab "byte   " _tab "PEH6FA2B " _tab  "%2f   " _tab `""When you quit smoking completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to regular cigars, cigarillos, little filtered cigars or ANY pipes filled with tobacco?""' _n  ///                  
"_column(1257)" _tab "byte   " _tab "PEH6FA2C " _tab  "%2f   " _tab `""When you quit smoking completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to electronic or E-Cigarettes? You may also know them as vape-pens, e-hookahs, vapes or mods.""' _n  ///            
"_column(1259)" _tab "byte   " _tab "PEH6FA2D1" _tab  "%2f   " _tab `""Did you switch to? Cigars, cigarillos, little filtered cigars.""' _n  ///                                                                                                                                                                                     
"_column(1261)" _tab "byte   " _tab "PEH6FA2D2" _tab  "%2f   " _tab `""Did you switch to? Regular pipes filled with tobacco.""' _n  ///                                                                                                                                                                                              
"_column(1263)" _tab "byte   " _tab "PEH6FA2D3" _tab  "%2f   " _tab `""Did you switch to? Water or hookah pipes filled with tobacco.""' _n  ///                                                                                                                                                                                      
"_column(1265)" _tab "byte   " _tab "PEH6FAZ2C" _tab  "%2f   " _tab `""When you quit smoking completely, did you try to quit by SWITCHING to electronic or E-cigarettes? You may also know them as vape-pens, e-hookahs, vapes or mods.""' _n  ///                                                                                   
"_column(1267)" _tab "byte   " _tab "PEH61A   " _tab  "%2f   " _tab `""In the 12 MONTHS BEFORE you COMPLETELY quit smoking, did you SEE a medical doctor?""' _n  ///                                                                                                                                                                 
"_column(1269)" _tab "byte   " _tab "PEH61B   " _tab  "%2f   " _tab `""During the 12 MONTHS BEFORE you completely quit smoking, did any medical doctor ADVISE you to stop smoking?""' _n  ///                                                                                                                                        
"_column(1271)" _tab "byte   " _tab "PEH8ANUM " _tab  "%2f   " _tab `""During the 12 MONTHS before you quit smoking, how soon after you woke up did you typically smoke your first cigarette of the day? (number)""' _n  ///                                                                                                         
"_column(1273)" _tab "byte   " _tab "PEH8AUNT " _tab  "%2f   " _tab `""During the 12 MONTHS before you quit smoking, how soon after you woke up did you typically smoke your first cigarette of the day? (unit)""' _n  ///                                                                                                           
"_column(1275)" _tab "byte   " _tab "PEH8B    " _tab  "%2f   " _tab `""During the 12 months before you quit smoking, would you say you smoked your first cigarette of the day within the first 30 minutes of awakening?""' _n  ///                                                                                                   
"_column(1277)" _tab "byte   " _tab "PEH11A   " _tab  "%2f   " _tab `""Thinking back to the 12 MONTHS BEFORE YOU COMPLETELY QUIT SMOKING CIGARETTES. During that time, DID YOU USUALLY SMOKE menthol or non-menthol cigarettes?""' _n  ///                                                                                           
"_column(1279)" _tab "byte   " _tab "PEH11C   " _tab  "%2f   " _tab `""Have you EVER smoked MENTHOL cigarettes for 6 months or more?""' _n  ///                                                                                                                                                                                      
"_column(1281)" _tab "byte   " _tab "PEH11D   " _tab  "%2f   " _tab `""For how long did you smoked MENTHOL cigarettes?""' _n  ///                                                                                                                                                                                                    
"_column(1283)" _tab "byte   " _tab "PEJ1a1   " _tab  "%2f   " _tab `""(Have/Has) (you/name) EVER used any of the following EVEN ONE TIME? ... A regular cigar or cigarillo OR a little filtered cigar?""' _n  ///                                                                                                                   
"_column(1285)" _tab "byte   " _tab "PEJ1a2   " _tab  "%2f   " _tab `""(Have/Has) (you/name) EVER used any of the following EVEN ONE TIME? ... A regular pipe filled with tobacco?""' _n  ///                                                                                                                                        
"_column(1287)" _tab "byte   " _tab "PEJ1A3   " _tab  "%2f   " _tab `""(Have/Has) (you/name) EVER used any of the following EVEN ONE TIME? ... a water pipe or hookah (who-kah) pipe filled with tobacco?""' _n  ///                                                                                                                 
"_column(1289)" _tab "byte   " _tab "PEJ1A3_5 " _tab  "%2f   " _tab `""(Have/Has) (you/name) EVER used E-cigarettes EVEN ONE TIME?""' _n  ///                                                                                                                                                                                        
"_column(1291)" _tab "byte   " _tab "PEJ1A4   " _tab  "%2f   " _tab `""(Have/Has) (you/name) EVER used any of the following EVEN ONE TIME? ... Smokeless tobacco, such as moist snuff, dip, spit, chew tobacco or snus?""' _n  ///                                                                                                   
"_column(1293)" _tab "byte   " _tab "PEJ1A5   " _tab  "%2f   " _tab `""(Have/Has) (you/name) EVER used disolvable tobacco EVEN ONE TIME?""' _n  ///                                                                                                                                                                                  
"_column(1295)" _tab "byte   " _tab "PEJ2A1   " _tab  "%2f   " _tab `""(Do you/Does name) NOW smoke regular cigars or cigarillos or little filtered cigars every day, some days or not at all?""' _n  ///                                                                                                                            
"_column(1297)" _tab "byte   " _tab "PEJ2B1   " _tab  "%2f   " _tab `""On how many of the past 30 days did you smoke regular cigars or cigarillos or little filtered cigars?""' _n  ///                                                                                                                                              
"_column(1299)" _tab "byte   " _tab "PEJ2A2   " _tab  "%2f   " _tab `""(Do you/Does name) NOW smoke a regular pipe every day, some days or not at all?""' _n  ///                                                                                                                                                                    
"_column(1301)" _tab "byte   " _tab "PEJ2B2   " _tab  "%2f   " _tab `""On how many of the past 30 days did you smoke a regular pipe?""' _n  ///                                                                                                                                                                                      
"_column(1303)" _tab "byte   " _tab "PEJ2A3   " _tab  "%2f   " _tab `""(Do you/Does name) NOW use a water pipe or hookah pipe filled with tobacco every day, some days or not at all?""' _n  ///                                                                                                                                     
"_column(1305)" _tab "byte   " _tab "PEJ2B3   " _tab  "%2f   " _tab `""On how many of the past 30 days did you use a water pipe or hookah pipe filled with tobacco?""' _n  ///                                                                                                                                                       
"_column(1307)" _tab "byte   " _tab "PEJ2A3_5 " _tab  "%2f   " _tab `""(Do you /Does name) NOW use an E-cigarette every day, some days or not at all?""' _n  ///                                                                                                                                                                     
"_column(1309)" _tab "byte   " _tab "PEJ2B3_5 " _tab  "%2f   " _tab `""On how many of the past 30 days did you use an E-cigarette?""' _n  ///                                                                                                                                                                                        
"_column(1311)" _tab "byte   " _tab "PEJ2A4   " _tab  "%2f   " _tab `""(Do you /Does name) NOW use smokeless tobacco such as moist snuff, dip, spit, chew tobacco or snus every day, some days or not at all?""' _n  ///                                                                                                             
"_column(1313)" _tab "byte   " _tab "PEJ2B4   " _tab  "%2f   " _tab `""On how many of the past 30 days did you use smokeless tobacco?""' _n  ///                                                                                                                                                                                     
"_column(1315)" _tab "byte   " _tab "PEJ2A5   " _tab  "%2f   " _tab `""(Do you /Does name) NOW use dissolvable tobacco every day, some days or not at all?""' _n  ///                                                                                                                                                                
"_column(1317)" _tab "byte   " _tab "PEJ2B5   " _tab  "%2f   " _tab `""On how many of the past 30 days did you use dissolvable tobacco?""' _n  ///                                                                                                                                                                                   
"_column(1319)" _tab "byte   " _tab "PEJA     " _tab  "%2f   " _tab `""During the past 30 days, what BRAND of smokeless tobacco (If necessary: moist snuff, dip, spit, chew or snus) did you use MOST OFTEN?""' _n  ///                                                                                                              
"_column(1321)" _tab "byte   " _tab "PEJB     " _tab  "%2f   " _tab `""During the PAST 30 days, what type of CIGAR did you use MOST OFTEN?""' _n  ///                                                                                                                                                                                
"_column(1323)" _tab "byte   " _tab "PEJC     " _tab  "%2f   " _tab `""During the PAST 30 days, what BRAND of CIGAR did you smoke MOST OFTEN?""' _n  ///                                                                                                                                                                             
"_column(1325)" _tab "byte   " _tab "PEJNFLVIN" _tab  "%2f   " _tab `""Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol,or other flavors.""' _n  ///                                                                                                                           
"_column(1327)" _tab "byte   " _tab "PEJNFLVR1" _tab  "%2f   " _tab `""Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you smoke a cigar is it usually flavored?""' _n  ///                                                                          
"_column(1329)" _tab "byte   " _tab "PEJNFLA1B" _tab  "%2f   " _tab `""Is it usually menthol or mint flavored?""' _n  ///                                                                                                                                                                                                            
"_column(1331)" _tab "byte   " _tab "PEJNFLA1C" _tab  "%2f   " _tab `""Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?""' _n  ///                                                                                                                                                       
"_column(1333)" _tab "byte   " _tab "PEJNFLA1D" _tab  "%2f   " _tab `""Is it usually some other type of flavor?""' _n  ///                                                                                                                                                                                                           
"_column(1335)" _tab "byte   " _tab "PEJNFLVR2" _tab  "%2f   " _tab `""Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you smoke a regular pipe filled with tobacco is it usually flavored?""' _n  ///                                               
"_column(1337)" _tab "byte   " _tab "PEJNFLA2B" _tab  "%2f   " _tab `""Is it usually menthol or mint flavored?""' _n  ///                                                                                                                                                                                                            
"_column(1339)" _tab "byte   " _tab "PEJNFLA2C" _tab  "%2f   " _tab `""Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?""' _n  ///                                                                                                                                                       
"_column(1341)" _tab "byte   " _tab "PEJNFLA2D" _tab  "%2f   " _tab `""Is it usually some other type of flavor?""' _n  ///                                                                                                                                                                                                           ""' _n  ///                      
"_column(1343)" _tab "byte   " _tab "PEJNFLVR3" _tab  "%2f   " _tab `""Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you smoke a water/hookah pipe filled with tobacco is it usually flavored?""' _n  ///                                          
"_column(1345)" _tab "byte   " _tab "PEJNFLA3B" _tab  "%2f   " _tab `""Is it usually menthol or mint flavored?""' _n  ///                                                                                                                                                                                                            
"_column(1347)" _tab "byte   " _tab "PEJNFLA3C" _tab  "%2f   " _tab `""Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?""' _n  ///                                                                                                                                                       
"_column(1349)" _tab "byte   " _tab "PEJNFLA3D" _tab  "%2f   " _tab `""Is it usually some other type of flavor?""' _n  ///                                                                                                                                                                                                           
"_column(1351)" _tab "byte   " _tab "PEJNFLV35" _tab  "%2f   " _tab `""Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you use an E-cigarette is it usually flavored?""' _n  ///                                                                     
"_column(1353)" _tab "byte   " _tab "PEJNFA35A" _tab  "%2f   " _tab `""Is it usually tobacco flavored?""' _n  ///                                                                                                                                                                                                                    
"_column(1355)" _tab "byte   " _tab "PEJNFA35B" _tab  "%2f   " _tab `""Is it usually menthol or mint flavored?""' _n  ///                                                                                                                                                                                                            
"_column(1357)" _tab "byte   " _tab "PEJNFA35C" _tab  "%2f   " _tab `""Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?""' _n  ///                                                                                                                                                       
"_column(1359)" _tab "byte   " _tab "PEJNFA35D" _tab  "%2f   " _tab `""Is it usually some other type of flavor?""' _n  ///                                                                                                                                                                                                           
"_column(1361)" _tab "byte   " _tab "PEJNFVB35" _tab  "%2f   " _tab `""When you use an e-cigarette, is it usually tobacco flavored?""' _n  ///                                                                                                                                                                                       
"_column(1363)" _tab "byte   " _tab "PEJNFLVR4" _tab  "%2f   " _tab `""Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you use smokeless tobacco is it usually flavored?""' _n  ///                                                                  
"_column(1365)" _tab "byte   " _tab "PEJNFLA4B" _tab  "%2f   " _tab `""Is it usually menthol or mint flavored?""' _n  ///                                                                                                                                                                                                            
"_column(1367)" _tab "byte   " _tab "PEJNFLA4C" _tab  "%2f   " _tab `""Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?""' _n  ///                                                                                                                                                       
"_column(1369)" _tab "byte   " _tab "PEJNFLA4D" _tab  "%2f   " _tab `""Is it usually some other type of flavor?""' _n  ///                                                                                                                                                                                                           
"_column(1371)" _tab "byte   " _tab "PEJECIGRA" _tab  "%2f   " _tab `""Do you use e-cigarettes because you can use them at times when or in places where smoking cigarettes isn’t allowed?""' _n  ///                                                                                                                              
"_column(1373)" _tab "byte   " _tab "PEJECIGRD" _tab  "%2f   " _tab `""Do you use e-cigarettes to help you quit smoking cigarettes?""' _n  ///                                                                                                                                                                                       
"_column(1375)" _tab "byte   " _tab "PEJECIG2 " _tab  "%2f   " _tab `""Which of the following best describes the type of e-cigarette you currently use?""' _n  ///                                                                                                                                                                   
"_column(1377)" _tab "byte   " _tab "PEJECIG3 " _tab  "%2f   " _tab `""Do you usually buy your own {e-cigarettes/e-cigarette cartridges/e-liquid}?""' _n  ///                                                                                                                                                                        
"_column(1379)" _tab "byte   " _tab "PEJECIG4 " _tab  "%2f   " _tab `""How do you usually buy your own {e-cigarettes/e-cigarette cartridges/e-liquid}?""' _n  ///                                                                                                                                                                    
"_column(1381)" _tab "byte   " _tab "PEJCOST1 " _tab  "%2f   " _tab `""Do you usually buy {e-cigarettes/e-cigarette cartridges/bottles of e-liquid} by the box or pack, or as {single e-cigarettes/single e-cigarette cartridges/a single bottle of e-liquid}?""' _n  ///                                                            
"_column(1383)" _tab "double " _tab "PTJCOST2 " _tab  "%5f   " _tab `""What price did you pay for the LAST BOX OR PACK of {e-cigarettes/e-cigarette cartridges/bottles of e-liquid} you bought?  Please report the cost after using discounts or coupons.""' _n  ///                                                                 
"_column(1388)" _tab "int    " _tab "PEJCOST3 " _tab  "%3f   " _tab `""How many {e-cigarettes/e-cigarette cartridges/bottles of e-liquid} came in the LAST BOX OR PACK you bought?""' _n  ///                                                                                                                                        
"_column(1391)" _tab "double " _tab "PTJCOST4 " _tab  "%5f   " _tab `""What price did you pay for the LAST {e-cigarette/e-cigarette cartridge/bottle of e-liquid} you bought?  Please report the cost after using discounts or coupons.""' _n  ///                                                                                   
"_column(1396)" _tab "int    " _tab "PEJCOST5 " _tab  "%4f   " _tab `""How many MILLILITERS of liquid were in a SINGLE bottle you LAST bought?""' _n  ///                                                                                                                                                                            
"_column(1400)" _tab "byte   " _tab "PEJD11   " _tab  "%2f   " _tab `""About how long has it been since you COMPLETELY quit smoking cigars, cigarillos or little filter cigars? (number)""' _n  ///                                                                                                                                  
"_column(1402)" _tab "byte   " _tab "PEJD21   " _tab  "%2f   " _tab `""About how long has it been since you COMPLETELY quit smoking cigars, cigarillos or little filter cigars? (unit)""' _n  ///                                                                                                                                    
"_column(1404)" _tab "byte   " _tab "PEJD12   " _tab  "%2f   " _tab `""About how long has it been since you COMPLETELY quit smoking a regular pipe filled with tobacco? (number)""' _n  ///                                                                                                                                          
"_column(1406)" _tab "byte   " _tab "PEJD22   " _tab  "%2f   " _tab `""About how long has it been since you COMPLETELY quit smoking a regular pipe filled with tobacco? (unit)""' _n  ///                                                                                                                                            
"_column(1408)" _tab "byte   " _tab "PEJD13   " _tab  "%2f   " _tab `""About how long has it been since you COMPLETELY quit smoking a water pipe or hookah pipe filled with tobacco? (number)""' _n  ///                                                                                                                             
"_column(1410)" _tab "byte   " _tab "PEJD23   " _tab  "%2f   " _tab `""About how long has it been since you COMPLETELY quit smoking a water pipe or hookah pipe filled with tobacco? (unit)""' _n  ///                                                                                                                               
"_column(1412)" _tab "byte   " _tab "PEJD13_5 " _tab  "%2f   " _tab `""About how long has it been since you COMPLETELY quit using E-cigarettes? (number)""' _n  ///                                                                                                                                                                  
"_column(1414)" _tab "byte   " _tab "PEJD23_5 " _tab  "%2f   " _tab `""About how long has it been since you COMPLETELY quit using E-cigarettes? (unit)""' _n  ///                                                                                                                                                                    
"_column(1416)" _tab "byte   " _tab "PEJD14   " _tab  "%2f   " _tab `""About how long has it been since you COMPLETELY quit using a smokeless tobacco? (number)""' _n  ///                                                                                                                                                           
"_column(1418)" _tab "byte   " _tab "PEJD24   " _tab  "%2f   " _tab `""About how long has it been since you COMPLETELY quit using a smokeless tobacco? (unit)""' _n  ///                                                                                                                                                             
"_column(1420)" _tab "byte   " _tab "PEJD31   " _tab  "%2f   " _tab `""In total, how many years (have you smoked/did you smoke) cigars or cigarillos or little filtered cigars?""' _n  ///                                                                                                                                           
"_column(1422)" _tab "byte   " _tab "PEJD32   " _tab  "%2f   " _tab `""In total, how many years (have you smoked/did you smoke) a regular pipe filled with tobacco?""' _n  ///                                                                                                                                                       
"_column(1424)" _tab "byte   " _tab "PEJD33   " _tab  "%2f   " _tab `""In total, how many years (have you smoked/did you smoke) a water pipe or hookah pipe filled with tobacco?""' _n  ///                                                                                                                                          
"_column(1426)" _tab "byte   " _tab "PEJD33_5 " _tab  "%2f   " _tab `""In total, how many years (have you used/did you use) an E-cigarette?""' _n  ///                                                                                                                                                                               
"_column(1428)" _tab "byte   " _tab "PEJD34   " _tab  "%2f   " _tab `""In total, how many years (have you used/did you use) smokeless tobacco?""' _n  ///                                                                                                                                                                            
"_column(1430)" _tab "byte   " _tab "PEJFECGRA" _tab  "%2f   " _tab `""Did you use E-cigarettes because you could use them at times when or in places where smoking cigarettes wasn't allowed?""' _n  ///                                                                                                                            
"_column(1432)" _tab "byte   " _tab "PEJFECGRD" _tab  "%2f   " _tab `""Did you use e-cigarettes to help you quit smoking cigarettes? ""' _n  ///                                                                                                                                                                                     
"_column(1434)" _tab "byte   " _tab "PEJFECG2 " _tab  "%2f   " _tab `""Which of the following best describes the type of e-cigarette you used to use?  If you used more than one type, please think of the one you used most often.""' _n  ///                                                                                       
"_column(1436)" _tab "byte   " _tab "PEJ3A1   " _tab  "%2f   " _tab `""How soon after you wake up do you typically (fill text from PRJ3A1F recode)? (number)""' _n  ///                                                                                                                                                              
"_column(1438)" _tab "byte   " _tab "PEJ3A2   " _tab  "%2f   " _tab `""How soon after you wake up do you typically (fill text from PRJ3A1F recode)? (unit)""' _n  ///                                                                                                                                                                
"_column(1440)" _tab "byte   " _tab "PEJ3D    " _tab  "%2f   " _tab `""Would you say you first (fill text from PRJ3DF recode) within the first 30 minutes of awakening?""' _n  ///                                                                                                                                                   
"_column(1442)" _tab "byte   " _tab "PEJ3F1   " _tab  "%2f   " _tab `""In the 12 months BEFORE YOU COMPLETELY QUIT (Fill text from PRJ3F1F recode), how soon after you woke up did you typically (Fill text from PRJ3F1F recode)? (number)""' _n  ///                                                                                
"_column(1444)" _tab "byte   " _tab "PEJ3F2   " _tab  "%2f   " _tab `""In the 12 months BEFORE YOU COMPLETELY QUIT (Fill text from PRJ3F1F recode), how soon after you woke up did you typically (Fill text from PRJ3F1F recode)? (unit)""' _n  ///                                                                                  
"_column(1446)" _tab "byte   " _tab "PEJ3G    " _tab  "%2f   " _tab `""Would you say you first used (Fill text from PRJ3GF recode) within the first 30 minutes of awakening?""' _n  ///                                                                                                                                              
"_column(1448)" _tab "byte   " _tab "PEJ4     " _tab  "%2f   " _tab `""During the PAST 12 MONTHS, have you stopped (Fill text from PRJ4F recode) for one day or longer BECAUSE YOU WERE TRYING TO QUIT?""' _n  ///                                                                                                                   
"_column(1450)" _tab "byte   " _tab "PEJ6BNUM " _tab  "%2f   " _tab `""Thinking of ANY attempts to stop (fill text from PRJ6BNMF) because you were trying to quit, during the past 12 MONTHS, what is the LONGEST length of time of the ONE attempt that lasted the longest? (number)""' _n  ///                                     
"_column(1452)" _tab "byte   " _tab "PEJ6BUNT " _tab  "%2f   " _tab `""Thinking of ANY attempts to stop (fill text from PRJ6BNMF) because you were trying to quit, during the past 12 MONTHS, what is the LONGEST length of time of the ONE attempt that lasted the longest? (unit)""' _n  ///                                       
"_column(1454)" _tab "byte   " _tab "PEJ7CINT " _tab  "%2f   " _tab `""The LAST TIME you tried to QUIT smoking CIGARS in the past 12 months: Did you:""' _n  ///                                                                                                                                                                     
"_column(1456)" _tab "byte   " _tab "PEJ7C    " _tab  "%2f   " _tab `""The LAST TIME you tried to QUIT smoking CIGARS in the past 12 months: Did you: Try to quit by SWITCHING to smokeless tobacco such as chewing  tobacco, snuff, or snus?""' _n  ///                                                                             
"_column(1458)" _tab "byte   " _tab "PEJ7D    " _tab  "%2f   " _tab `""The LAST TIME you tried to QUIT smoking CIGARS in the past 12 months: Did you: Try to quit by SWITCHING to electronic or E-cigarettes?""' _n  ///                                                                                                             
"_column(1460)" _tab "byte   " _tab "PEJ7ALTIN" _tab  "%2f   " _tab `""When you quit smoking CIGARS completely, did you do ANY of the following, whether or not you think they were effective:""' _n  ///                                                                                                                            
"_column(1462)" _tab "byte   " _tab "PEJ7CALT " _tab  "%2f   " _tab `""When you quit smoking CIGARS completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to smokeless tobacco such as chewing tobacco, snuff, or snus?""' _n  ///                                     
"_column(1464)" _tab "byte   " _tab "PEJ7DALT " _tab  "%2f   " _tab `""When you quit smoking CIGARS completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to electronic or E-cigarette?""' _n  ///                                                                     
"_column(1466)" _tab "byte   " _tab "PEK1A    " _tab  "%2f   " _tab `""Do you mainly work indoors or outdoors?""' _n  ///                                                                                                                                                                                                            
"_column(1468)" _tab "byte   " _tab "PEK1B    " _tab  "%2f   " _tab `""Do you mainly work in an office building, your own home, in someone else's home, or in another indoor place?""' _n  ///                                                                                                                                       
"_column(1470)" _tab "byte   " _tab "PEK1B11  " _tab  "%2f   " _tab `""In which State (including DC), do you work?""' _n  ///                                                                                                                                                                                                        
"_column(1472)" _tab "byte   " _tab "PEK1B2   " _tab  "%2f   " _tab `""When you work INDOORS: Do you mainly work in an office building, in your own home, in someone else's home, or in another indoor place?""' _n  ///                                                                                                             
"_column(1474)" _tab "byte   " _tab "PEK1C1   " _tab  "%2f   " _tab `""In which State (including DC), do you work on your main indoor job or business?""' _n  ///                                                                                                                                                                    
"_column(1476)" _tab "byte   " _tab "PEK2A    " _tab  "%2f   " _tab `""Is smoking restricted in ANY WAY at your place of work?""' _n  ///                                                                                                                                                                                            
"_column(1478)" _tab "byte   " _tab "PEK3A    " _tab  "%2f   " _tab `""Which of these best describes the smoking policy at your place of work for INDOOR PUBLIC OR COMMON AREAS, such as lobbies, rest rooms, and lunch rooms?""' _n  ///                                                                                            
"_column(1480)" _tab "byte   " _tab "PEK3B    " _tab  "%2f   " _tab `""Which of these best describes the smoking policy at your place of work for INDOOR WORK AREAS?""' _n  ///                                                                                                                                                      
"_column(1482)" _tab "byte   " _tab "PEK3C    " _tab  "%2f   " _tab `""During the PAST TWO WEEKS, has anyone smoked in the area in which you work?""' _n  ///                                                                                                                                                                        
"_column(1484)" _tab "byte   " _tab "PEK3B1   " _tab  "%2f   " _tab `""Which of these best describes the vaping or e-cigarette policy at your place of work for INDOOR PUBLIC OR COMMON AREAS AND INDOOR WORK AREAS?""' _n  ///                                                                                                      
"_column(1486)" _tab "byte   " _tab "PEK3C1   " _tab  "%2f   " _tab `""During the PAST TWO WEEKS, has anyone vaped or used e-cigarettes in the area in which you work?""' _n  ///                                                                                                                                                    
"_column(1488)" _tab "byte   " _tab "PEK4     " _tab  "%2f   " _tab `""Which statement best describes the rules about smoking INSIDE YOUR HOME?""' _n  ///                                                                                                                                                                           
"_column(1490)" _tab "byte   " _tab "PEK4A    " _tab  "%2f   " _tab `""Which statement best describes the rules about vaping or using e-cigarettes INSIDE YOUR HOME?""' _n  ///                                                                                                                                                      
"_column(1492)" _tab "byte   " _tab "PEK5A    " _tab  "%2f   " _tab `""In buildings with MULTIPLE apartments or living areas, do you THINK that smoking should be ... ALLOWED INSIDE ALL apartments or living areas, ALLOWED inside SOME apartments ..., or NOT ALLOWED at ALL inside apartments?""' _n  ///                         
"_column(1494)" _tab "byte   " _tab "PEK6B    " _tab  "%2f   " _tab `""In indoor work areas, do you THINK that smoking SHOULD be allowed in ALL areas, allowed in SOME areas, or NOT allowed at ALL?""' _n  ///                                                                                                                      
"_column(1496)" _tab "byte   " _tab "PEK6C    " _tab  "%2f   " _tab `""Inside bars, cocktail lounges, and clubs, do you THINK that smoking SHOULD be allowed in ALL areas, allowed in SOME areas, or NOT allowed at ALL?""' _n  ///                                                                                                  
"_column(1498)" _tab "byte   " _tab "PEK6G    " _tab  "%2f   " _tab `""Inside casinos, do you THINK that smoking SHOULD be allowed in ALL areas, allowed in SOME areas, or NOT allowed at ALL?""' _n  ///                                                                                                                            
"_column(1500)" _tab "byte   " _tab "PEK6H    " _tab  "%2f   " _tab `""Inside a car, when there are other people present, do you THINK that smoking SHOULD...""' _n  ///                                                                                                                                                             
"_column(1502)" _tab "byte   " _tab "PEK6H2   " _tab  "%2f   " _tab `""If children are present inside the car, do you think that smoking SHOULD...""' _n  ///                                                                                                                                                                        
"_column(1504)" _tab "byte   " _tab "PEK8     " _tab  "%2f   " _tab `""In the past 6 months, have you seen messages in newspapers or on television that say that a Federal Court has ordered tobacco companies to make statements about the dangers of smoking cigarettes?""' _n  ///                                                
"_column(1506)" _tab "byte   " _tab "PEK9INTRO" _tab  "%2f   " _tab `""The last few questions are about heated tobacco products. Some people refer to these as heat-not-burn tobacco products. These heat TOBACCO STICKS or CAPSULES to produce a vapor. They are different from e-cigar.....""' _n  ///                             
"_column(1508)" _tab "byte   " _tab "PEK9     " _tab  "%2f   " _tab `""Before today, have you heard of heated tobacco products?""' _n  ///                                                                                                                                                                                           
"_column(1510)" _tab "byte   " _tab "PEK10    " _tab  "%2f   " _tab `""Have you ever tried a heated tobacco product, even just one time?""' _n  ///                                                                                                                                                                                  
"_column(1512)" _tab "byte   " _tab "PES78    " _tab  "%2f   " _tab `""Respondent relationship recode - relationship of respondent to the sample person""' _n  ///                                                                                                                                                                   
"_column(1514)" _tab "byte   " _tab "PESINTTP " _tab  "%2f   " _tab `""In what language was the interview conducted for this person?""' _n  ///                                                                                                                                                                                      
"_column(1516)" _tab "byte   " _tab "PES81A   " _tab  "%2f   " _tab `""Method of Interview""' _n  ///                                                                                                                                                                                                                                
"_column(1518)" _tab "byte   " _tab "INTRVIEW " _tab  "%2f   " _tab `""Interview Status Recode""' _n  ///                                                                                                                                                                                                                            
"_column(1520)" _tab "byte   " _tab "HRMODE   " _tab  "%2f   " _tab `""Method of Interview""' _n  ///                                                                                                                                                                                                                                
"_column(1522)" _tab "byte   " _tab "SMOKSTAT " _tab  "%2f   " _tab `""Type of smoker recode""' _n  ///                                                                                                                                                                                                                              
"_column(1524)" _tab "byte   " _tab "PRS35    " _tab  "%2f   " _tab `""Respondent and Smoker Type""' _n  ///                                                                                                                                                                                                                         
"_column(1526)" _tab "byte   " _tab "PRS60    " _tab  "%2f   " _tab `""Self responding 'Not at all' smokers- smoking less than or equal to 1 year or don't know""' _n  ///                                                                                                                                                           
"_column(1528)" _tab "byte   " _tab "PRS64    " _tab  "%2f   " _tab `""Who is responding for the supplement""' _n  ///                                                                                                                                                                                                               
"_column(1530)" _tab "byte   " _tab "PRS65    " _tab  "%2f   " _tab `""Monthly Labor Force recode of Self respondents""' _n  ///                                                                                                                                                                                                     
"_column(1532)" _tab "byte   " _tab "PRS66    " _tab  "%2f   " _tab `""Employed self respondents' class of worker on first job""' _n  ///                                                                                                                                                                                            
"_column(1534)" _tab "byte   " _tab "PRJ3A1F  " _tab  "%2f   " _tab `""Recode from fill in PEJ3a1 and PEJ3a2 to determine which tobacco product is being discussed in PEJ3a1 and PEJ3a2""' _n  ///                                                                                                                                   
"_column(1536)" _tab "byte   " _tab "PRJ3DF   " _tab  "%2f   " _tab `""Recode from fill in PEJ3d to determine which tobacco product is being discussed in PEJ3d""' _n  ///                                                                                                                                                           
"_column(1538)" _tab "byte   " _tab "PRJ3F1F  " _tab  "%2f   " _tab `""Recode from fill in PEJ3f1 and PEJ3f2 to determine which tobacco product is being discussed in PEJ3f1 and PEJ3f2""' _n  ///                                                                                                                                   
"_column(1540)" _tab "byte   " _tab "PRJ3GF   " _tab  "%2f   " _tab `""Recode from fill in PEJ3g to determine which tobacco product is being discussed in PEJ3g""' _n  ///                                                                                                                                                           
"_column(1542)" _tab "byte   " _tab "PRJ4F    " _tab  "%2f   " _tab `""Recode from fill in PEJ4 to determine which tobacco product is being discussed in PEJ4""' _n  ///                                                                                                                                                             
"_column(1544)" _tab "byte   " _tab "PRJ6BNMF " _tab  "%2f   " _tab `""Recode from fill in PEJ6bnum and PEJ6bunt to see which tobacco product is being discussed in PEJ6bnum and PEJ6bunt""' _n  ///                                                                                                                                 
"_column(1546)" _tab "byte   " _tab "PRSIFLG  " _tab  "%2f   " _tab `""Recode identifies person answering their own questions on the shorter proxy path.""' _n  ///                                                                                                                                                                  
"_column(1548)" _tab "double " _tab "PWNRWGT  " _tab  "%10.4f" _tab `""Nonresponse weight""' _n  ///                                                                                                                                                                                                                                 
"_column(1558)" _tab "double " _tab "PWSRWGT  " _tab  "%10.4f" _tab `""Self response weight""' _n  ///                                                                                                                                                                                                                               
"_column(1568)" _tab "byte   " _tab "PEELGFLG " _tab  "%2f   " _tab `""Eligibility Flag""' _n  ///                                                                                                                                                                                                                                   
"}"
set more on
file close dictionary 

//*****************************************************************************************
// Read CPS May 2019 file

quietly infile using dictionary.dct, using ("may19pub.dat") clear

replace PUERNH1C = PUERNH1C / 100 if PUERNH1C > 0
replace PEERNH2 = PEERNH2 / 100 if PEERNH2 > 0
replace PEERNH1O = PEERNH1O / 100 if PEERNH1O > 0
replace PRERNHLY = PRERNHLY / 100 if PRERNHLY > 0
replace PRERNWA = PRERNWA / 100 if PRERNWA > 0
replace PEERN = PEERN / 100 if PEERN > 0
replace PUERN2 = PUERN2 / 100 if PUERN2 > 0

replace PTB6B = PTB6B /100 if PTB6B > 0
replace PTB6C = PTB6C /100 if PTB6C > 0

replace PTC6B = PTC6B /100 if PTC6B > 0
replace PTC6C = PTC6C /100 if PTC6C > 0

replace PTJCOST2 = PTJCOST2 /100 if PTJCOST2 > 0
replace PTJCOST4 = PTJCOST4 /100 if PTJCOST4 > 0

describe

save "may19pub_beta" , replace

erase "dictionary.dct"
