set linesize 200
/****************************************************************************************#
#*                                                                                       #
#* Purpose: STATA program to create one permanent DTA file with the CPS July 2018,       #     
#*          January 2019, and May 2019 data with their corresponding replicate weights   #
#*                                                                                       #
#*        The program reads the files cps1819pub_beta.dta and cps1819srrep_beta.dta      #
#*        The output file is cps1819pub_with_srreps_beta.dta                             # 
#*                                                                                       #
#*****************************************************************************************/

*********************************************************************************************************
* Set working directory
* Input and output files are saved here
*********************************************************************************************************

cd "\\westat.com\DFS\NCIDCCPS\DCCPS - Global\Scientific Projects\TUS-CPS\Statistician\ifc\STATA work\prg"

**********************************************************************************************************



use "cps1819pub_beta", clear

merge 1:1 HRYEAR4 HRMONTH QSTNUM OCCURNUM using "cps1819srrep_beta.dta"

describe

tabulate _merge

/* Divide weights by number of months (surveys) being combined        */
/* PWSRWGT is the weight from the main survey file.                   */
/* RepWgt0 is the same as PWSRWGT                                     */
/* RepWgt1-RepWgt160 are the replicate weights                        */


foreach wgt of varlist PWSRWGT RepWgt0-RepWgt160 {
  replace   `wgt' = `wgt' /3
}

save "cps1819pub_with_srreps_beta", replace