set linesize 200
/****************************************************************************************#
#*                                                                                       #
#* Purpose: STATA program to create one permanent DTA file with the CPS July 2018,       #     
#*          January 2019, and May 2019 replicate weight file                             #
#*                                                                                       #
#*        The program reads the files jul18srrep.dat, jan19srrep.dat, and may19srrep.dat #
#*        The output file is cps1819srrep_beta.dta.                                      # 
#*                                                                                       #
#*          The program does NOT use STATA dictionaries                                  #
#*                                                                                       #
#*****************************************************************************************/


******************************************************************************
* Set working directory
* Input and output files are saved here
*****************************************************************************

cd "\\westat.com\DFS\NCIDCCPS\DCCPS - Global\Scientific Projects\TUS-CPS\Statistician\ifc\STATA work\prg - dct"


//*****************************************************************************************
// Create dictionary

file open dictionary  using ".\dictionary.dct", write replace
set more off

file write dictionary   /// 
"infile dictionary { " _n ///
"_column(1)"    _tab   "long"    _tab   "QSTNUM"    _tab   "%5f"     _tab   `""Unique household identifier    ""' _n  ///
"_column(6)"    _tab   "int"     _tab   "OCCURNUM"  _tab   "%2f"     _tab   `""Unique person identifier       ""' _n  ///
"_column(8)"    _tab   "double"  _tab   "RepWgt0"   _tab   "%10.4f"  _tab   `""Self Resp Sample Weight        ""' _n  ///
"_column(18)"   _tab   "double"  _tab   "RepWgt1"   _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #1  ""' _n  ///
"_column(28)"   _tab   "double"  _tab   "RepWgt2"   _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #2  ""' _n  ///
"_column(38)"   _tab   "double"  _tab   "RepWgt3"   _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #3  ""' _n  ///
"_column(48)"   _tab   "double"  _tab   "RepWgt4"   _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #4  ""' _n  ///
"_column(58)"   _tab   "double"  _tab   "RepWgt5"   _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #5  ""' _n  ///
"_column(68)"   _tab   "double"  _tab   "RepWgt6"   _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #6  ""' _n  ///
"_column(78)"   _tab   "double"  _tab   "RepWgt7"   _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #7  ""' _n  ///
"_column(88)"   _tab   "double"  _tab   "RepWgt8"   _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #8  ""' _n  ///
"_column(98)"   _tab   "double"  _tab   "RepWgt9"   _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #9  ""' _n  ///
"_column(108)"  _tab   "double"  _tab   "RepWgt10"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #10 ""' _n  ///
"_column(118)"  _tab   "double"  _tab   "RepWgt11"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #11 ""' _n  ///
"_column(128)"  _tab   "double"  _tab   "RepWgt12"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #12 ""' _n  ///
"_column(138)"  _tab   "double"  _tab   "RepWgt13"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #13 ""' _n  ///
"_column(148)"  _tab   "double"  _tab   "RepWgt14"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #14 ""' _n  ///
"_column(158)"  _tab   "double"  _tab   "RepWgt15"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #15 ""' _n  ///
"_column(168)"  _tab   "double"  _tab   "RepWgt16"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #16 ""' _n  ///
"_column(178)"  _tab   "double"  _tab   "RepWgt17"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #17 ""' _n  ///
"_column(188)"  _tab   "double"  _tab   "RepWgt18"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #18 ""' _n  ///
"_column(198)"  _tab   "double"  _tab   "RepWgt19"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #19 ""' _n  ///
"_column(208)"  _tab   "double"  _tab   "RepWgt20"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #20 ""' _n  ///
"_column(218)"  _tab   "double"  _tab   "RepWgt21"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #21 ""' _n  ///
"_column(228)"  _tab   "double"  _tab   "RepWgt22"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #22 ""' _n  ///
"_column(238)"  _tab   "double"  _tab   "RepWgt23"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #23 ""' _n  ///
"_column(248)"  _tab   "double"  _tab   "RepWgt24"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #24 ""' _n  ///
"_column(258)"  _tab   "double"  _tab   "RepWgt25"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #25 ""' _n  ///
"_column(268)"  _tab   "double"  _tab   "RepWgt26"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #26 ""' _n  ///
"_column(278)"  _tab   "double"  _tab   "RepWgt27"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #27 ""' _n  ///
"_column(288)"  _tab   "double"  _tab   "RepWgt28"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #28 ""' _n  ///
"_column(298)"  _tab   "double"  _tab   "RepWgt29"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #29 ""' _n  ///
"_column(308)"  _tab   "double"  _tab   "RepWgt30"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #30 ""' _n  ///
"_column(318)"  _tab   "double"  _tab   "RepWgt31"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #31 ""' _n  ///
"_column(328)"  _tab   "double"  _tab   "RepWgt32"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #32 ""' _n  ///
"_column(338)"  _tab   "double"  _tab   "RepWgt33"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #33 ""' _n  ///
"_column(348)"  _tab   "double"  _tab   "RepWgt34"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #34 ""' _n  ///
"_column(358)"  _tab   "double"  _tab   "RepWgt35"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #35 ""' _n  ///
"_column(368)"  _tab   "double"  _tab   "RepWgt36"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #36 ""' _n  ///
"_column(378)"  _tab   "double"  _tab   "RepWgt37"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #37 ""' _n  ///
"_column(388)"  _tab   "double"  _tab   "RepWgt38"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #38 ""' _n  ///
"_column(398)"  _tab   "double"  _tab   "RepWgt39"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #39 ""' _n  ///
"_column(408)"  _tab   "double"  _tab   "RepWgt40"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #40 ""' _n  ///
"_column(418)"  _tab   "double"  _tab   "RepWgt41"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #41 ""' _n  ///
"_column(428)"  _tab   "double"  _tab   "RepWgt42"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #42 ""' _n  ///
"_column(438)"  _tab   "double"  _tab   "RepWgt43"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #43 ""' _n  ///
"_column(448)"  _tab   "double"  _tab   "RepWgt44"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #44 ""' _n  ///
"_column(458)"  _tab   "double"  _tab   "RepWgt45"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #45 ""' _n  ///
"_column(468)"  _tab   "double"  _tab   "RepWgt46"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #46 ""' _n  ///
"_column(478)"  _tab   "double"  _tab   "RepWgt47"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #47 ""' _n  ///
"_column(488)"  _tab   "double"  _tab   "RepWgt48"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #48 ""' _n  ///
"_column(498)"  _tab   "double"  _tab   "RepWgt49"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #49 ""' _n  ///
"_column(508)"  _tab   "double"  _tab   "RepWgt50"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #50 ""' _n  ///
"_column(518)"  _tab   "double"  _tab   "RepWgt51"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #51 ""' _n  ///
"_column(528)"  _tab   "double"  _tab   "RepWgt52"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #52 ""' _n  ///
"_column(538)"  _tab   "double"  _tab   "RepWgt53"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #53 ""' _n  ///
"_column(548)"  _tab   "double"  _tab   "RepWgt54"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #54 ""' _n  ///
"_column(558)"  _tab   "double"  _tab   "RepWgt55"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #55 ""' _n  ///
"_column(568)"  _tab   "double"  _tab   "RepWgt56"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #56 ""' _n  ///
"_column(578)"  _tab   "double"  _tab   "RepWgt57"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #57 ""' _n  ///
"_column(588)"  _tab   "double"  _tab   "RepWgt58"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #58 ""' _n  ///
"_column(598)"  _tab   "double"  _tab   "RepWgt59"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #59 ""' _n  ///
"_column(608)"  _tab   "double"  _tab   "RepWgt60"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #60 ""' _n  ///
"_column(618)"  _tab   "double"  _tab   "RepWgt61"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #61 ""' _n  ///
"_column(628)"  _tab   "double"  _tab   "RepWgt62"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #62 ""' _n  ///
"_column(638)"  _tab   "double"  _tab   "RepWgt63"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #63 ""' _n  ///
"_column(648)"  _tab   "double"  _tab   "RepWgt64"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #64 ""' _n  ///
"_column(658)"  _tab   "double"  _tab   "RepWgt65"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #65 ""' _n  ///
"_column(668)"  _tab   "double"  _tab   "RepWgt66"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #66 ""' _n  ///
"_column(678)"  _tab   "double"  _tab   "RepWgt67"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #67 ""' _n  ///
"_column(688)"  _tab   "double"  _tab   "RepWgt68"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #68 ""' _n  ///
"_column(698)"  _tab   "double"  _tab   "RepWgt69"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #69 ""' _n  ///
"_column(708)"  _tab   "double"  _tab   "RepWgt70"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #70 ""' _n  ///
"_column(718)"  _tab   "double"  _tab   "RepWgt71"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #71 ""' _n  ///
"_column(728)"  _tab   "double"  _tab   "RepWgt72"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #72 ""' _n  ///
"_column(738)"  _tab   "double"  _tab   "RepWgt73"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #73 ""' _n  ///
"_column(748)"  _tab   "double"  _tab   "RepWgt74"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #74 ""' _n  ///
"_column(758)"  _tab   "double"  _tab   "RepWgt75"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #75 ""' _n  ///
"_column(768)"  _tab   "double"  _tab   "RepWgt76"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #76 ""' _n  ///
"_column(778)"  _tab   "double"  _tab   "RepWgt77"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #77 ""' _n  ///
"_column(788)"  _tab   "double"  _tab   "RepWgt78"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #78 ""' _n  ///
"_column(798)"  _tab   "double"  _tab   "RepWgt79"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #79 ""' _n  ///
"_column(808)"  _tab   "double"  _tab   "RepWgt80"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #80 ""' _n  ///
"_column(818)"  _tab   "double"  _tab   "RepWgt81"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #81 ""' _n  ///
"_column(828)"  _tab   "double"  _tab   "RepWgt82"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #82 ""' _n  ///
"_column(838)"  _tab   "double"  _tab   "RepWgt83"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #83 ""' _n  ///
"_column(848)"  _tab   "double"  _tab   "RepWgt84"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #84 ""' _n  ///
"_column(858)"  _tab   "double"  _tab   "RepWgt85"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #85 ""' _n  ///
"_column(868)"  _tab   "double"  _tab   "RepWgt86"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #86 ""' _n  ///
"_column(878)"  _tab   "double"  _tab   "RepWgt87"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #87 ""' _n  ///
"_column(888)"  _tab   "double"  _tab   "RepWgt88"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #88 ""' _n  ///
"_column(898)"  _tab   "double"  _tab   "RepWgt89"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #89 ""' _n  ///
"_column(908)"  _tab   "double"  _tab   "RepWgt90"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #90 ""' _n  ///
"_column(918)"  _tab   "double"  _tab   "RepWgt91"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #91 ""' _n  ///
"_column(928)"  _tab   "double"  _tab   "RepWgt92"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #92 ""' _n  ///
"_column(938)"  _tab   "double"  _tab   "RepWgt93"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #93 ""' _n  ///
"_column(948)"  _tab   "double"  _tab   "RepWgt94"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #94 ""' _n  ///
"_column(958)"  _tab   "double"  _tab   "RepWgt95"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #95 ""' _n  ///
"_column(968)"  _tab   "double"  _tab   "RepWgt96"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #96 ""' _n  ///
"_column(978)"  _tab   "double"  _tab   "RepWgt97"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #97 ""' _n  ///
"_column(988)"  _tab   "double"  _tab   "RepWgt98"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #98 ""' _n  ///
"_column(998)"  _tab   "double"  _tab   "RepWgt99"  _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #99 ""' _n  ///
"_column(1008)" _tab   "double"  _tab   "RepWgt100" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #100""' _n  ///
"_column(1018)" _tab   "double"  _tab   "RepWgt101" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #101""' _n  ///
"_column(1028)" _tab   "double"  _tab   "RepWgt102" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #102""' _n  ///
"_column(1038)" _tab   "double"  _tab   "RepWgt103" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #103""' _n  ///
"_column(1048)" _tab   "double"  _tab   "RepWgt104" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #104""' _n  ///
"_column(1058)" _tab   "double"  _tab   "RepWgt105" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #105""' _n  ///
"_column(1068)" _tab   "double"  _tab   "RepWgt106" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #106""' _n  ///
"_column(1078)" _tab   "double"  _tab   "RepWgt107" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #107""' _n  ///
"_column(1088)" _tab   "double"  _tab   "RepWgt108" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #108""' _n  ///
"_column(1098)" _tab   "double"  _tab   "RepWgt109" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #109""' _n  ///
"_column(1108)" _tab   "double"  _tab   "RepWgt110" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #110""' _n  ///
"_column(1118)" _tab   "double"  _tab   "RepWgt111" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #111""' _n  ///
"_column(1128)" _tab   "double"  _tab   "RepWgt112" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #112""' _n  ///
"_column(1138)" _tab   "double"  _tab   "RepWgt113" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #113""' _n  ///
"_column(1148)" _tab   "double"  _tab   "RepWgt114" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #114""' _n  ///
"_column(1158)" _tab   "double"  _tab   "RepWgt115" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #115""' _n  ///
"_column(1168)" _tab   "double"  _tab   "RepWgt116" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #116""' _n  ///
"_column(1178)" _tab   "double"  _tab   "RepWgt117" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #117""' _n  ///
"_column(1188)" _tab   "double"  _tab   "RepWgt118" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #118""' _n  ///
"_column(1198)" _tab   "double"  _tab   "RepWgt119" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #119""' _n  ///
"_column(1208)" _tab   "double"  _tab   "RepWgt120" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #120""' _n  ///
"_column(1218)" _tab   "double"  _tab   "RepWgt121" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #121""' _n  ///
"_column(1228)" _tab   "double"  _tab   "RepWgt122" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #122""' _n  ///
"_column(1238)" _tab   "double"  _tab   "RepWgt123" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #123""' _n  ///
"_column(1248)" _tab   "double"  _tab   "RepWgt124" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #124""' _n  ///
"_column(1258)" _tab   "double"  _tab   "RepWgt125" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #125""' _n  ///
"_column(1268)" _tab   "double"  _tab   "RepWgt126" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #126""' _n  ///
"_column(1278)" _tab   "double"  _tab   "RepWgt127" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #127""' _n  ///
"_column(1288)" _tab   "double"  _tab   "RepWgt128" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #128""' _n  ///
"_column(1298)" _tab   "double"  _tab   "RepWgt129" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #129""' _n  ///
"_column(1308)" _tab   "double"  _tab   "RepWgt130" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #130""' _n  ///
"_column(1318)" _tab   "double"  _tab   "RepWgt131" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #131""' _n  ///
"_column(1328)" _tab   "double"  _tab   "RepWgt132" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #132""' _n  ///
"_column(1338)" _tab   "double"  _tab   "RepWgt133" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #133""' _n  ///
"_column(1348)" _tab   "double"  _tab   "RepWgt134" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #134""' _n  ///
"_column(1358)" _tab   "double"  _tab   "RepWgt135" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #135""' _n  ///
"_column(1368)" _tab   "double"  _tab   "RepWgt136" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #136""' _n  ///
"_column(1378)" _tab   "double"  _tab   "RepWgt137" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #137""' _n  ///
"_column(1388)" _tab   "double"  _tab   "RepWgt138" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #138""' _n  ///
"_column(1398)" _tab   "double"  _tab   "RepWgt139" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #139""' _n  ///
"_column(1408)" _tab   "double"  _tab   "RepWgt140" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #140""' _n  ///
"_column(1418)" _tab   "double"  _tab   "RepWgt141" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #141""' _n  ///
"_column(1428)" _tab   "double"  _tab   "RepWgt142" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #142""' _n  ///
"_column(1438)" _tab   "double"  _tab   "RepWgt143" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #143""' _n  ///
"_column(1448)" _tab   "double"  _tab   "RepWgt144" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #144""' _n  ///
"_column(1458)" _tab   "double"  _tab   "RepWgt145" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #145""' _n  ///
"_column(1468)" _tab   "double"  _tab   "RepWgt146" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #146""' _n  ///
"_column(1478)" _tab   "double"  _tab   "RepWgt147" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #147""' _n  ///
"_column(1488)" _tab   "double"  _tab   "RepWgt148" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #148""' _n  ///
"_column(1498)" _tab   "double"  _tab   "RepWgt149" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #149""' _n  ///
"_column(1508)" _tab   "double"  _tab   "RepWgt150" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #150""' _n  ///
"_column(1518)" _tab   "double"  _tab   "RepWgt151" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #151""' _n  ///
"_column(1528)" _tab   "double"  _tab   "RepWgt152" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #152""' _n  ///
"_column(1538)" _tab   "double"  _tab   "RepWgt153" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #153""' _n  ///
"_column(1548)" _tab   "double"  _tab   "RepWgt154" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #154""' _n  ///
"_column(1558)" _tab   "double"  _tab   "RepWgt155" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #155""' _n  ///
"_column(1568)" _tab   "double"  _tab   "RepWgt156" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #156""' _n  ///
"_column(1578)" _tab   "double"  _tab   "RepWgt157" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #157""' _n  ///
"_column(1588)" _tab   "double"  _tab   "RepWgt158" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #158""' _n  ///
"_column(1598)" _tab   "double"  _tab   "RepWgt159" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #159""' _n  ///
"_column(1608)" _tab   "double"  _tab   "RepWgt160" _tab   "%10.4f"  _tab   `""Self Resp Replicate Weight #160""' _n  ///
"}"
set more on
file close dictionary 

//*****************************************************************************************
// Read CPS July 2018 file replicate weights

quietly infile using dictionary.dct, using ("jul18srrep.dat") clear
  
generate HRYEAR4 = 2018
generate HRMONTH = 7

table HRYEAR4 HRMONTH
                                                                                                                                                                                
* describe                                                                                                                                                                        
                                                                                                                                                                                
save "temp_jul18srrep_beta", replace


//*****************************************************************************************
// Read CPS January 2019 file replicate weights

quietly infile using dictionary.dct, using ("jan19srrep.dat") clear                                                                                               

generate HRYEAR4 = 2019
generate HRMONTH = 1

table HRYEAR4 HRMONTH
                                                                                                                                                                                
* describe                                                                                                                                                                        
                                                                                                                                                                                
save "temp_jan19srrep_beta", replace


//*****************************************************************************************
// Read CPS May 2019 file replicate weights

quietly infile using dictionary.dct, using ("may19srrep.dat") clear

generate HRYEAR4 = 2019
generate HRMONTH = 5

table HRYEAR4 HRMONTH
                                                                                                                                                                                
* describe                                                                                                                                                                        
                                                                                                                                                                                
save "temp_may19srrep_beta", replace

clear

//*****************************************************************************************
// Combine July 2018, January 2019, and May 2019  replicate weight file


use "temp_jul18srrep_beta"
append using "temp_jan19srrep_beta"
append using "temp_may19srrep_beta"

sort HRYEAR4 HRMONTH QSTNUM OCCURNUM

table HRYEAR4 HRMONTH

describe

save "cps1819srrep_beta", replace

erase "temp_jul18srrep_beta.dta"
erase "temp_jan19srrep_beta.dta"
erase "temp_may19srrep_beta.dta"

erase "dictionary.dct"
