options(width = 120)
#*********************************************************************************#
#*                                                                                #
#* Purpose: R program to create permanent R .RDS data set                         #
#*          harmonzd_tus_cps_1992_through_2019_beta.RDS                           #
#*          with the Harmonized TUS CPS 1992 through 2019 data                    #
#*                                                                                #
#*   Notes: The program uses the package readr                                    #
#                                                                                 #
#*********************************************************************************#

##############################################################################################################
# Set working directories
##############################################################################################################

setwd("//westat.com/DFS/NCIDCCPS/DCCPS - Global/Scientific Projects/TUS-CPS/Statistician/ifc/R work/prg/3. Harmonized data")
getwd()

##############################################################################################################
# Load libraries
#
library(readr)


##############################################################################################################
## Create data dictionary with varaible names, witdths, type and labels
##############################################################################################################

data_diccionary <-
'SurWave      1       2     numeric     "Survey wave"
SurYear      3       6     numeric     "Survey year"
SurMonth     7       8     numeric     "Survey month"
SpanHome     9       10    numeric     "Is Spanish the only language spoken by all members of this household who are 15 years of age or older"
HMOwnRnt     11      11    numeric     "Are your living quarters..."
FamInc       12      13    numeric     "Family income"
HHNum        14      15    numeric     "Number of persons in household"
OwnBsFrm     16      17    numeric     "Does anyone in this household have a business or a farm?"
Region       18      18    numeric     "Region"
FIPS         19      20    numeric     "State (FIPS Code)"
State        21      40    character   "State"
StCounty     41      45    numeric     "State/County"
MetStat      46      46    numeric     "Metropolitan status"
Age          47      48    numeric     "Age"
Sex          49      49    numeric     "Sex"
AFEver       50      51    numeric     "Did you ever serve on active duty in the U.S. Armed Forces"
Race92       52      52    numeric     "Race (1992-2002)"
Race03       53      54    numeric     "Race (2003 and later)"
Hispan       55      55    numeric     "Hispanic or non-Hispanic"
Marital      56      57    numeric     "Marital status"
Edu          58      59    numeric     "Highest level of school completed or degree received"
EmplStat     60      61    numeric     "Employment status"
Natvty       62      64    numeric     "Country of birth"
NatvtyM      65      67    numeric     "Mother-s country of birth"
NatvtyF      68      70    numeric     "Father-s Country of birth"
Citizen      71      71    numeric     "Citizenship status"
YearInUS     72      74    numeric     "Years in U.S."
AGEINUS      75      77    numeric     "Immigrant-s age of entry"
AbsntRsn     78      79    numeric     "What is the main reason you were absent from work last week"
AbsntPay     80      81    numeric     "Are you being paid by your employer for any of the time off last week"
MULTJOBS     82      83    numeric     "Do you have more than one job"
OTWK         84      85    numeric     "Last week, did you work any overtime or extra hours (at your main job) that you do not usually work"
OTWKAMT      86      91    numeric     "Calculated weekly overtime amount"
ChildNum     92      93    numeric     "Number of children <18 years of age"
Child        94      95    numeric     "Presence of own children <18 years of age by selected age group"
Child2       96      97    numeric     "Any own children 0-2 years of age"
Child5       98      99    numeric     "Any own children 3-5 years of age"
Child13      100     101   numeric     "Any own children 6-13 years of age"
Child17      102     103   numeric     "Any own children 14-17 years of age"
WRKCLSS1     104     105   numeric     "Individual class of worker code on first job"
WRKCLSS2     106     107   numeric     "Individual class of worker code on second job"
IND1DT95     108     109   numeric     "Detailed industry recode - job 1 (1995-2002)"
IND1DT03     110     111   numeric     "Detailed industry recode - job 1 (2003 and later)"
IND2DT95     112     113   numeric     "Detailed industry recode - job 2 (1995-2002)"
IND2DT03     114     115   numeric     "Detailed industry recode - job 2 (2003 and later)"
OCC1DT95     116     117   numeric     "Detailed occupation recode - job 1 (1995-2002)"
OCC1DT03     118     119   numeric     "Detailed occupation recode - job 1 (2003 and later)"
OCC2DT95     120     121   numeric     "Detailed occupation recode - job 2 (1995-2002)"
OCC2DT03     122     123   numeric     "Detailed occupation recode - job 2 (2003 and later)"
IND1MJ95     124     125   numeric     "Major industry recode - job 1 (1995-2002)"
IND1MJ03     126     127   numeric     "Major industry recode - job 1 (2003 and later)"
IND2MJ95     128     129   numeric     "Major industry recode - job 2 (1995-2002)"
IND2MJ03     130     131   numeric     "Major industry recode - job 2 (2003 and later)"
OCC1MJ95     132     133   numeric     "Major occupation recode - job 1 (1995-2002)"
OCC1MJ03     134     135   numeric     "Major occupation recode - job 1 (2003 and later)"
OCC2MJ95     136     137   numeric     "Major occupation recode - job 2 (1995-2002)"
OCC2MJ03     138     139   numeric     "Major occupation recode - job 2 (2003 and later)"
RecordID     140     161   character   "Record ID (Unique within survey month)"
QSTNUM       162     166   numeric     "Unique household identifier (Unique within survey month)"
OCCURNUM     167     180   numeric     "Unique person identifier (Unique within survey month)"
Cig100       181     182   numeric     "Smoked 100 cigarettes in entire life"
CigAge       183     184   numeric     "Age first started smoking cigarettes fairly regularly"
CIGAGEX      185     186   numeric     "Age first started smoking cigarettes (never smoked regularly)"
CgStCry      187     189   numeric     "State or country lived when first smoked part or all of a cigarette"
CgStCryX     190     192   numeric     "State or country lived when first smoked part or all of a cigarette (never smoked regularly)"
CigNow       193     194   numeric     "Now smoke cigarettes every day, some days or not at all"
CIGSTAT      195     196   numeric     "Current cigarette smoking status"
CPDD         197     198   numeric     "Number of cigarettes smoke a day (every day smokers)"
CPDD20       199     200   numeric     "On average, now smoke more or less than 20 cigarettes each day (every day smokers*)"
CIGDAY       201     202   numeric     "On how many of the past 30 days did you smoke cigarettes (some day smokers)"
CIGDAY20     203     204   numeric     "Would you say you smoked on at least 12 days in the past 30 days (some day smokers*)"
CPDS         205     206   numeric     "On days smoked, number of cigarettes smoke a day (some day smokers)"
CigType      207     208   numeric     "Type of cigarette (menthol/non-menthol, current smokers)"
TTFC         209     212   numeric     "Time to first cigarette, minutes (current smokers)"
TTFC30       213     214   numeric     "Smoke first cigarette of the day within first 30 minutes (current smokers)"
BUYCIG       215     216   numeric     "Do you usually buy your own cigarettes? (current smokers)"
BUYPKCR      217     218   numeric     "Do you usually buy your cigarettes by the pack or by the carton? (current smokers)"
PRICELPK     219     222   numeric     "Price paid for last pack of cigarettes (current smokers)"
PRICELCR     223     227   numeric     "Price paid for last carton of cigarettes (current smokers)"
DISCNTS      228     229   numeric     "Did you use coupons, rebates, or any other special promotions when you bought your last (pack/carton) of cigarettes"
CIGWHERE     230     231   numeric     "Where last (pack/carton) purchased (current smokers)"
CIGSTATE     232     233   numeric     "State where purchased last (pack/carton) (current smokers)"
CIGINDRS     234     235   numeric     "Buy last (pack/carton) of cigarettes from an Indian reservation (current smokers)"
CIGOTWAY     236     237   numeric     "Other way purchased last (pack/carton) of cigarettes (current smokers)"
SNGLCIG      238     239   numeric     "In the last 2 months, have you bought (or traded for) any single or individual cigarette (current smokers)"
SNGLPRCE     240     243   numeric     "Price paid for last  single or individual cigarette (current smokers)"
SNGLWHER     244     245   numeric     "Where last single or individual cigarette purchased (current smokers)"
SNGLSTCT     246     248   numeric     "State (or country) where purchased last single or individual cigarette (current smokers)"
YRSSMKDC     249     250   numeric     "Number of years smoked every day (every day smokers)"
YRSSMKDG     251     252   numeric     "For how long have you smoked every day (every day smokers)"
YRSSMKDH     253     255   numeric     "Number of years smoked every day (harmonized, every day smokers)"
MENTHREG     256     257   numeric     "Have you ever smoked menthol cigarettes for 6 months or more (current smokers)"
MENTHGRP     258     259   numeric     "For how long (have you smoked/did you smoke) menthol cigarettes (current smokers)"
MENTHOL      260     261   numeric     "Menthol use (constructed, current smokers"
SDEVRDLY     262     263   numeric     "Ever smoked cigarettes every day for at least 6 months (some day smokers)"
SDEVRCIG     264     265   numeric     "When you last smoked every day, on average how many cigarettes did you smoke daily (some day smokers)"
SDYRSDLY     266     269   numeric     "Years since smoked every day (some day smokers)"
SDYRSMKC     270     271   numeric     "Years smoked every day (some day smokers)"
SDYRSMKG     272     273   numeric     "For how long have you smoked every day? (some day smokers)"
CIGSTA12     274     275   numeric     "Around this time 12 months ago, were you smoking cigarettes every day, some days or not at all? (current smokers)"
CPDD12       276     277   numeric     "Around this time 12 months ago, number of cigarettes smoked a day (current smoker, every day smokers 12 months ago)"
CIGDAY12     278     279   numeric     "Around this time 12 months ago, number of the past 30 days smoked cigarettes (some day smokers 12 months ago)"
CPDS12       280     281   numeric     "Around this time 12 months ago, number of cigarettes smoked a day (current smoker, some day smokers 12 months ago)"
EVSTP1DD     282     283   numeric     "Have you ever stopped smoking for one day or longer because you were trying to quit smoking? (every day smokers)"
PYSTP1DD     284     285   numeric     "During the past 12 months, have you stopped smoking for one day or longer because you were trying to quit smoking? (every day smokers)"
XPYSTPDN     286     287   numeric     "How many times during the past 12 months have you stopped smoking for one day or longer because you were trying to quit smoking? (every day smokers)"
XPYSTPDC     288     289   numeric     "How many times during the past 12 months have you stopped smoking for one day or longer because you were trying to quit smoking? (every day smokers)"
PYMLTDU      290     294   numeric     "During the past 12 months, what is the longest length of time you stopped smoking because you were trying to quit smoking? (every day smokers, number of months, not truncated)"
PYMLTD       295     298   numeric     "During the past 12 months, what is the longest length of time you stopped smoking because you were trying to quit smoking? (every day smokers, number of months)"
EVTRYQD      299     300   numeric     "Have you ever made a serious attempt to stop smoking because you were trying to quit - even if you stopped for less than a day? (every day smokers)"
PYTRYQD      301     302   numeric     "During the past 12 months, have you made a serious attempt to stop smoking because you were trying to quit <even if you stopped for less than a day>? (every day smokers)"
EVSTP1DS     303     304   numeric     "Have you ever stopped smoking for one day or longer because you were trying to quit smoking? (some days smokers, 12+ days)"
PYSTP1DS     305     306   numeric     "During the past 12 months, have you stopped smoking for one day or longer because you were trying to quit smoking? (some days smokers, 12+ days)"
XPYSTPSN     307     310   numeric     "How many times during the past 12 months have you stopped smoking for one day or longer because you were trying to quit smoking? (some days smokers, 12+ days)"
XPYSTPSC     311     312   numeric     "How many times during the past 12 months have you stopped smoking for one day or longer because you were trying to quit smoking? (some days smokers, 12+ days)"
PYMLTHSU     313     317   numeric     "During the past 12 months, what is the longest length of time you stopped smoking because you were trying to quit smoking? (some days smokers, 12+ days, number of months, not truncated)"
PYMLTHS      318     321   numeric     "During the past 12 months, what is the longest length of time you stopped smoking because you were trying to quit smoking? (some days smokers, 12+ days, number of months)"
EVTRYQS      322     323   numeric     "Have you ever made a serious attempt to stop smoking because you were trying to quit - even if you stopped for less than a day? (some days smokers, 12+ days)"
PYTRYQS      324     325   numeric     "During the past 12 months, have you made a serious attempt to stop smoking because you were trying to quit <even if you stopped for less than a day>? (some days smokers, 12+ days)"
PYQUITSD     326     327   numeric     "During the past 12 months, have you tried to quit smoking completely? (some days smokers, < 12 days)"
EVTRYQCS     328     329   numeric     "Have you ever tried to quit smoking completely? (some days smokers, < 12 days)"
PYMLTLSU     330     335   numeric     "During the past 12 months, what is the longest length of time you stopped smoking because you were trying to quit smoking? (some days smokers, < 12 days, number of months, not truncated)"
PYMLTLS      336     339   numeric     "During the past 12 months, what is the longest length of time you stopped smoking because you were trying to quit smoking? (some days smokers, < 12 days, number of months)"  
PYQTNRT1     340     341   numeric     "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use a nicotine patch?"
PYQTNRT2     342     343   numeric     "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use a nicotine gum or nicotine lozenge?"
PYQTNRT3     344     345   numeric     "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use a nicotine nasal spray or nicotine inhaler?"
PYQTNRT4     346     347   numeric     "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use a prescription pill?"
PYQTHLP1     348     349   numeric     "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use a telephone help line or quit line?"
PYQTHLP2     350     351   numeric     "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use a stop smoking clinic, class or support group?"
PYQTHLP3     352     353   numeric     "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use one-on-one counseling?"
PYQTHLP4     354     355   numeric     "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use help or support from friends or family?"
PYQTHLP5     356     357   numeric     "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use the internet or World Wide Web/web-based program?"
PYQTHLP6     358     359   numeric     "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use books, pamphlets, videos or other materials?"
PYQTHLP7     360     361   numeric     "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use acupuncture or hypnosis?"
PYQHLP7A     362     363   numeric     "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Which did you use acupuncture or hypnosis or both?"
PYQTPTN1     364     365   numeric     "The (last time/time) you tried to quit smoking in the past 12 months. Did you try to quit by gradually cutting back on cigarettes?"
PYQTPTN2     366     367   numeric     "The (last time/time) you tried to quit smoking in the past 12 months. Did you try to quit by switching to chewing tobacco, snuff, <snus>, cigars or pipes?"
PYQTPTN3     368     369   numeric     "The (last time/time) you tried to quit smoking in the past 12 months. Did you switch to a lighter cigarette in order to try to quit?"
PYQTPTN4     370     371   numeric     "The (last time/time) you tried to quit smoking in the past 12 months. Did you try to give up cigarettes all at once?"
PYQPTN4A     372     373   numeric     "The (last time/time) you tried to quit smoking in the past 12 months. When you tried to quit all at once, would you say you tried to quit -cold turkey-"
PYQTPTN5     374     375   numeric     "The (last time/time) you tried to quit smoking in the past 12 months. Did you try to quit by switching to electronic or e-cigarettes?"
DOCSEEN      376     377   numeric     "In the past year/12 months have you seen a medical doctor?"
DOCADVYR     378     379   numeric     "During the past year/12 months, did any medical doctor advise you to stop smoking?"
DOCADVQL     380     381   numeric     "In the past 12 months, when a medical doctor advised you to quit smoking, did the doctor also suggest that you call or use a telephone help line or quit line?"
DOCADVEV     382     383   numeric     "Has a medical doctor ever advised you to stop smoking?"
DDSSEEN      384     385   numeric     "In the past year/12 months have you seen a dentist?"
DDSADVYR     386     387   numeric     "During the past year/12 months, did any dentist advise you to stop smoking?"
DDSADVQL     388     389   numeric     "In the past 12 months, when a dentist advised you to quit smoking, did the dentist also suggest that you call or use a telephone help line or quit line?"
DDSADVEV     390     391   numeric     "Has a dentist ever advised you to stop smoking?"
INTQT6MO     392     393   numeric     "Are you seriously considering stopping/quitting smoking within the next 6 months?"
INTQT30D     394     395   numeric     "Are you planning to stop/quit within the next 30 days?"
INTRQUIT     396     397   numeric     "Overall, on a scale from 1 to 10 where 1 is not at all interested and 10 is extremely interested, how interested are you in quitting smoking?"
QUITSUCS     398     399   numeric     "If you did try to quit smoking altogether in the next 6 months, how likely do you think you would be to succeed..."
FMEVRDLY     400     401   numeric     "Ever smoked cigarettes every day for at least 6 months (former smokers)"
FMYRSDLY     402     406   numeric     "Years since smoked every day (former smokers who smoked every day for at least 6 months)"
FMEVRCIG     407     408   numeric     "When you last smoked every day, on average how many cigarettes did you smoke daily? (former smokers who smoked every day for at least 6 months)"
FMYRSMKC     409     410   numeric     "Years smoked every day (former smokers who smoked every day for at least 6 months)"
FMYRSMKG     411     412   numeric     "Years smoked every day (former smokers who smoked every day for at least 6 months)"
FMLOTQT      413     417   numeric     "About how long has it been since you completely stopped smoking cigarettes (years, former smokers)"
FMLOTQTC     418     419   numeric     "About how long has it been since you completely stopped smoking cigarettes (categorical, former smokers)"
FMCGST12     420     421   numeric     "Around this time 12 months ago, were you smoking cigarettes every day, some days or not at all? (former smokers who quit within the past year)"
FMCPDD12     422     423   numeric     "Around this time 12 months ago, on the average, about how many cigarettes did you smoke each day? (former smokers who quit within the past year, every day smokers around 12 months ago)"
FMCIGD12     424     425   numeric     "Around this time 12 months ago, on how many of 30 days in the month did you smoke cigarettes? (former smokers who quit within the past year, some day smokers around 12 months ago)"
FMCPDS12     426     427   numeric     "On the average, on those days, how many cigarettes did you usually smoke each day? (former smokers who quit within the past year, some day smokers around 12 months ago)"
FMMNTHUB     428     429   numeric     "Type of cigarette (menthol/non-menthol, former smokers who quit within the past 5 years)"
FMMNTHRG     430     431   numeric     "Ever smoked menthol cigarettes (former smokers who quit within the past 5 years)"
FMMNTHGP     432     433   numeric     "How long did you smoke menthol cigarettes (former smokers who quit within the past 5 years and smoked menthol)"
FMQTNRT1     434     435   numeric     "When you quit smoking completely did you use a nicotine patch (former smokers who quit within the past 3 years)?"
FMQTNRT2     436     437   numeric     "When you quit smoking completely did you use a nicotine gum or nicotine lozenge? (former smokers who quit within the past 3 years)"
FMQTNRT3     438     439   numeric     "When you quit smoking completely did you use a nicotine nasal spray or nicotine inhaler? (former smokers who quit within the past 3 years)"
FMQTNRT4     440     441   numeric     "When you quit smoking completely did you use a prescription pill? (former smokers who quit within the past 3 years)"
FMQTHLP1     442     443   numeric     "When you quit smoking completely did you use a telephone help line or quit line? (former smokers who quit within the past 3 years)"
FMQTHLP2     444     445   numeric     "When you quit smoking completely did you use a stop smoking clinic, class or support group? (former smokers who quit within the past 3 years)"
FMQTHLP3     446     447   numeric     "When you quit smoking completely did you use one-on-one counseling? (former smokers who quit within the past 3 years)"
FMQTHLP4     448     449   numeric     "When you quit smoking completely did you use help or support from friends or family? (former smokers who quit within the past 3 years)"
FMQTHLP5     450     451   numeric     "When you quit smoking completely did you use the internet or World Wide Web/web-based program? (former smokers who quit within the past 3 years)"
FMQTHLP6     452     453   numeric     "When you quit smoking completely did you use books, pamphlets, videos or other materials? (former smokers who quit within the past 3 years)"
FMQTHLP7     454     455   numeric     "When you quit smoking completely did you use acupuncture or hypnosis? (former smokers who quit within the past 3 years)"
FMQHLP7A     456     457   numeric     "When you quit smoking completely which did you use acupuncture or hypnosis or both? (former smokers who quit within the past 3 years)"
FMQTPTN1     458     459   numeric     "When you quit smoking completely did you try to quit by gradually cutting back on cigarettes? (former smokers who quit within the past 3 years)"
FMQTPTN2     460     461   numeric     "When you quit smoking completely did you try to quit by switching to chewing tobacco, snuff, <snus>, cigars or pipes? (former smokers who quit within the past 3 years)"
FMQTPTN3     462     463   numeric     "When you quit smoking completely did you switch to a -lighter- cigarette in order to try to quit? (former smokers who quit within the past 3 years)"
FMQTPTN4     464     465   numeric     "When you quit smoking completely did you try to give up cigarettes all at once? (former smokers who quit within the past 3 years)"
FMQPTN4A     466     467   numeric     "When you quit smoking completely, when you tried to quit all at once, would you say you tried to quit -cold turkey-? (former smokers who quit within the past 3 years)"
FMQTPTN5     468     469   numeric     "When you quit smoking completely did you try to quit by switching to electronic or e-cigarettes? (former smokers who quit within the past 3 years)"
FMDOCSEE     470     471   numeric     "In the 12 months before you completely quit smoking did you see a medical doctor? (former smokers who quit within the past 3 years)"
FMDOCADV     472     473   numeric     "During the 12 months before you completely quit smoking, did any medical doctor advise you to stop smoking? (former smokers who quit within the past 3 years)"
FMTTFC       474     477   numeric     "During the year before your quit smoking, time to first cigarette, minutes (former smokers who quit within the past 3 years)"
FMTTFC30     478     479   numeric     "During the year before your quit smoking, smoke first cigarette of the day within first 30 minutes (former smokers who quit within the past 3 years)"
PIPEEVER     480     481   numeric     "Ever used pipes <regular pipe filled with tobacco>?"
CIGREVER     482     483   numeric     "Ever used cigars <regular cigar, cigarillos or little filtered cigars>?"
CHEWEVER     484     485   numeric     "Ever used chewing tobacco?"
SNFFEVER     486     487   numeric     "Ever used snuff?"
HOOKEVER     488     489   numeric     "Ever used a water or hookah pipe filled with tobacco?"
SMKLEVER     490     491   numeric     "Ever used smokeless tobacco?"
ECIGEVER     492     493   numeric     "Ever used e-cigarettes?"
PIPENow      494     495   numeric     "Now use pipes <regular pipe filled with tobacco>?"
CIGRNow      496     497   numeric     "Now use cigars <regular cigar, cigarillos or little filtered cigars>?"
CHEWNow      498     499   numeric     "Now use chewing tobacco?"
SNFFNow      500     501   numeric     "Now use snuff?"
HOOKNow      502     503   numeric     "Now use a water or hookah pipe filled with tobacco?"
SMKLNow      504     505   numeric     "Now use smokeless tobacco?"
ECIGNow      506     507   numeric     "Now use e-cigarettes?"
PIPENow2     508     509   numeric     "Now use pipes <regular pipe filled with tobacco>?"
CIGRNow2     510     511   numeric     "Now use cigars <regular cigar, cigarillos or little filtered cigars>?"
CHEWNow2     512     513   numeric     "Now use chewing tobacco?"
SNFFNow2     514     515   numeric     "Now use snuff?"
HOOKNow2     516     517   numeric     "Now use a water or hookah pipe filled with tobacco?"
SMKLNow2     518     519   numeric     "Now use smokeless tobacco?"
ECIGNow2     520     521   numeric     "Now use e-cigarettes?"
PIPECURR     522     523   numeric     "Current pipe <regular pipe filled with tobacco> use status"
CIGRCURR     524     525   numeric     "Current cigar <regular cigar, cigarillos or little filtered cigars> use status"
CHEWCURR     526     527   numeric     "Current chewing tobacco use status"
SNFFCURR     528     529   numeric     "Current snuff use status"
HOOKCURR     530     531   numeric     "Current water or hookah pipe filled with tobacco use status"
SMKLCURR     532     533   numeric     "Current smokeless tobacco use status"
ECIGCURR     534     535   numeric     "Current e-cigarette use status"
PIPESTAT     536     537   numeric     "Current pipe <regular pipe filled with tobacco> use status"
CIGRSTAT     538     539   numeric     "Current cigar <regular cigar, cigarillos or little filtered cigars> use status"
CHEWSTAT     540     541   numeric     "Current chewing tobacco use status"
SNFFSTAT     542     543   numeric     "Current snuff use status"
HOOKSTAT     544     545   numeric     "Current water or hookah pipe filled with tobacco use status"
SMKLSTAT     546     547   numeric     "Current smokeless tobacco use status"
ECIGSTAT     548     549   numeric     "Current e-cigarette use status"
PIPEDAY      550     551   numeric     "On how many of the past 30 days did you use pipes? (some day users)"
CIGRDAY      552     553   numeric     "On how many of the past 30 days did you use cigars? (some day users)"
CHEWDAY      554     555   numeric     "On how many of the past 30 days did you use chewing tobacco? (some day users)"
SNFFDAY      556     557   numeric     "On how many of the past 30 days did you use snuff? (some day users)"
HOOKDAY      558     559   numeric     "On how many of the past 30 days did you use a water or hookah pipe filled with tobacco? (some day users)"
SMKLDAY      560     561   numeric     "On how many of the past 30 days did you use smokeless tobacco? (some day users)"
ECIGDAY      562     563   numeric     "On how many of the past 30 days did you use e-cigarettes? (some day users)"
PIPELOTQ     564     567   numeric     "About how long has it been since you completely quit smoking a regular pipe filled with tobacco? (years, former pipe smokers)"
CIGRLOTQ     568     571   numeric     "About how long has it been since you completely quit smoking cigars, cigarillos or little filtered cigars? (years, former cigar smokers)"
HOOKLOTQ     572     575   numeric     "About how long has it been since you completely quit smoking a water or hookah pipe filled with tobacco? (years, former hookah smokers)"
SMKLLOTQ     576     579   numeric     "About how long has it been since you completely quit using smokeless tobacco? (years, former smokeless users)"
ECIGLOTQ     580     583   numeric     "About how long has it been since you completely quit using e-cigarettes? (years, former e-cigarette users)"
PIPEYRS      584     585   numeric     "In total, how many years (have you smoked/did you smoke) a regular pipe filled with tobacco? (ever pipe smokers)"
CIGRYRS      586     587   numeric     "In total, how many years (have you smoked/did you smoke) cigars or cigarillos or little filtered cigars? (ever cigar smokers)"
HOOKYRS      588     589   numeric     "In total, how many years (have you smoked/did you smoke) a water or hookah pipe filled with tobacco? (ever hookah smokers)"
SMKLYRS      590     591   numeric     "In total, how many years (have you used/did you use) smokeless tobacco? (ever smokeless users)"
ECIGYRS      592     593   numeric     "In total, how many years (have you used/did you use) e-cigarettes? (ever e-cigarette users)"
CIGRTYPE     594     595   numeric     "During the past 30 days, what type of cigar did you use most often?"
CIGRFLVR     596     597   numeric     "When you smoke a cigar is it usually flavored?"
PIPEFLVR     598     599   numeric     "When you smoke a regular pipe filled with tobacco is it usually flavored?"
HOOKFLVR     600     601   numeric     "When you smoke a water/hookah pipe filled with tobacco is it usually flavored"
SMKLFLVR     602     603   numeric     "When you use smokeless tobacco is it usually flavored"
ECIGFLVR     604     605   numeric     "When you use an e-cigarette is it usually flavored?"
ECIGBRDG     606     607   numeric     "Do you use e-cigarettes because you can use them at times when or in places where smoking cigarettes isnt allowed?"
ECIGTOQT     608     609   numeric     "Do you use e-cigarettes to help you quit smoking cigarettes?"
FMECIGBR     610     611   numeric     "Did you use e-cigarettes because you could use them at times when or in places where smoking cigaretteswasnt allowed?"
FMECIGQT     612     613   numeric     "Did you use e-cigarettes to help you quit smoking cigarettes?"
TTFOTP       614     617   numeric     "Time to first other tobacco product, minutes (current users)"
TTFOTP30     618     619   numeric     "Use first other tobacco product of the day within first 30 minutes (current users)"
FMTTFOTP     620     623   numeric     "In the 12 months before you quit, time to first other tobacco product, minutes (former users)"
FMTTFO30     624     625   numeric     "In the 12 months before you quit, use first other tobacco product of the day within first 30 minutes (former users)"
PYSTPOTP     626     627   numeric     "During the past 12 months, have you stopped using other tobacco product for one day or longer because you were trying to quit? (every day and some days >11 users)"
PYLTOTP      628     631   numeric     "During the past 12 months, what is the longest length of time you stopped using other tobacco product because you were trying to quit? (every day and some days >11 users, number of months)"
WKAREA92     632     633   numeric     "Which of these best describes the area in which you work most of the time? (1992-2002 only)"
WKAREA03     634     635   numeric     "Which of these best describes the area in which you work most of the time? (2003-2007 only)"
WKINDPLC     636     637   numeric     "Indoor place mainly work (2003-2007 only)"
WKSTATE      638     639   numeric     "In which state, do you work on your main job or business (2003-2007 only)"
WKAREA10     640     641   numeric     "Do you mainly work indoors or outdoors? (2010 and later)"
WKINDPL1     642     643   numeric     "Indoor place mainly work (2010 and later)"
WKSTATE1     644     645   numeric     "In which state do you work (2010 and later)"
WKINDPL2     646     647   numeric     "Indoor place mainly work (2010 and later)"
WKSTATE2     648     649   numeric     "In which state do you work on your main indoor job or business (2010 and later)"
WKPOLICY     650     651   numeric     "Does your place of work have an official policy that restricts smoking in any way?"
WKPOLIND     652     653   numeric     "Smoking policy for indoor public or common areas such as lobbies, rest rooms and lunch rooms"
WKPOLWRK     654     655   numeric     "Smoking policy for work areas"
WORKBAN      656     657   numeric     "Smoking policy at work (constructed)"
WKSTPSMK     658     659   numeric     "Within the past 12 months, has your employer offered any stop smoking program or help to quit smoking"
WKSMK2WK     660     661   numeric     "During the past two weeks has anyone smoked in the area in which you work?"
ATSMKRST     662     663   numeric     "In restaurants, do you think that smoking should be:"
ATSMKHSP     664     665   numeric     "In hospitals, do you think that smoking should be:"
ATSMKIWA     666     667   numeric     "In indoor work areas, do you think that smoking should be:"
ATSMKBAR     668     669   numeric     "In bars and cocktail lounges (and clubs), do you think that smoking should be:"
ATSMKISP     670     671   numeric     "In indoor sporting events, do you think that smoking should be:"
ATSMKISM     672     673   numeric     "In indoor shopping malls, do you think that smoking should be:"
ATSMKPLY     674     675   numeric     "On outdoor children-s - playgrounds and sports fields, do you think that smoking should be:"
ATSMKCAS     676     677   numeric     "Inside casinos, do you think that smoking should be:"
ATSMCARO     678     679   numeric     "Inside a car, when there are other people present, do you think that smoking should..."
ATSMCARC     680     681   numeric     "If children are present inside the car, do you think that smoking should..."
HMSMKPOL     682     683   numeric     "Home smoking rules"
MUHSMPOL     684     685   numeric     "In buildings with multiple apartments or living areas, do you think that smoking should be: "
ATMINBUY     686     687   numeric     "In your opinion, how easy is it for minors to buy cigarettes and other tobacco products in your community?"
ATSAMPLE     688     689   numeric     "Do you think that giving away free sample by tobacco companies should be:"
ATTOBADV     690     691   numeric     "Do you think advertising of tobacco products should be:"
SRWeight     692     693   numeric     "Self Response Weight"'


###############################################################################
# Location of CPS 1992 through 2019 replicate weights 06-19
###############################################################################


cps.data <- "./harmonzd.tus_cps.1992.through.2019.dat"


###############################################################################
# Create data dictionary
###############################################################################
tmp_file <- tempfile()
writeLines(data_diccionary, tmp_file)
data_diccionary_table <- read.table(tmp_file,sep="", col.names = c("variable", "initial_position","final_position", "type", "label"))

### Set varaible type numeric to "n" and characeter to "c"
levels(data_diccionary_table$type)<-c("c","n")
data_diccionary_tabletype <- as.character(data_diccionary_table$type)
### Create list for varaible name and type 
names(data_diccionary_tabletype) <-  data_diccionary_table$variable
data_diccionary_tabletype <- as.list(data_diccionary_tabletype)


###############################################################################
##  Read CPS 1992 to 2019 harmonized data 
##


harmonzd_tus_cps_1992_through_2019_beta  <- as.data.frame(read_fwf(cps.data, 
 col_positions = fwf_positions( data_diccionary_table$initial_position, 
                 data_diccionary_table$final_position,
                  col_names= data_diccionary_table$variable),
                 col_types = data_diccionary_tabletype  )) 




###############################################################################
## Attaching labels
###############################################################################
for (i in 1:length(data_diccionary_table$variable))
{
  attr(harmonzd_tus_cps_1992_through_2019_beta[,i],"label") <- data_diccionary_table$label[i]
}
dim(harmonzd_tus_cps_1992_through_2019_beta)


###############################################################################
## Modify varaibles
###############################################################################
harmonzd_tus_cps_data    <- harmonzd_tus_cps_1992_through_2019_beta[
                                                  order(harmonzd_tus_cps_1992_through_2019_beta$SurYear,
                                                        harmonzd_tus_cps_1992_through_2019_beta$SurMonth,
                                                        harmonzd_tus_cps_1992_through_2019_beta$RecordID),]


attach(harmonzd_tus_cps_1992_through_2019_beta)

YearInUS <- ifelse(YearInUS>0,YearInUS/10,YearInUS)
AGEINUS  <- ifelse(AGEINUS>0,  AGEINUS/10, AGEINUS)
OTWKAMT  <- ifelse(OTWKAMT>0, OTWKAMT/100, OTWKAMT)

PRICELPK  <- ifelse(PRICELPK>0, PRICELPK/100, PRICELPK)
PRICELCR  <- ifelse(PRICELCR>0, PRICELCR/100, PRICELCR)
SNGLPRCE  <- ifelse(SNGLPRCE>0, SNGLPRCE/100, SNGLPRCE)
SDYRSDLY  <- ifelse(SDYRSDLY>0, SDYRSDLY/100, SDYRSDLY)

PYMLTDU  <- ifelse(PYMLTDU>0,  PYMLTDU /100, PYMLTDU)
PYMLTD   <- ifelse(PYMLTD>0,   PYMLTD  /100, PYMLTD)
XPYSTPSN <- ifelse(XPYSTPSN>0, XPYSTPSN/100, XPYSTPSN)

PYMLTHSU <- ifelse(PYMLTHSU>0, PYMLTHSU/100, PYMLTHSU)
PYMLTHS  <- ifelse(PYMLTHS>0,  PYMLTHS /100, PYMLTHS)
PYMLTLSU <- ifelse(PYMLTLSU>0, PYMLTLSU/100, PYMLTLSU)
PYMLTLS  <- ifelse(PYMLTLS>0,  PYMLTLS /100, PYMLTLS)

FMYRSDLY <- ifelse(FMYRSDLY>0, FMYRSDLY/100, FMYRSDLY)
FMLOTQT  <- ifelse(FMLOTQT>0,  FMLOTQT /100, FMLOTQT)

PIPELOTQ <- ifelse(PIPELOTQ>0, PIPELOTQ /100, PIPELOTQ)
PIPELOTQ <- ifelse(PIPELOTQ>0, PIPELOTQ /100, PIPELOTQ)
HOOKLOTQ <- ifelse(HOOKLOTQ>0, HOOKLOTQ /100, HOOKLOTQ)

SMKLLOTQ <- ifelse(SMKLLOTQ>0, SMKLLOTQ /100, SMKLLOTQ)
ECIGLOTQ <- ifelse(ECIGLOTQ>0, ECIGLOTQ /100, ECIGLOTQ)
PYLTOTP <-  ifelse(PYLTOTP>0, PYLTOTP /100, PYLTOTP)


detach(harmonzd_tus_cps_1992_through_2019_beta)


str(harmonzd_tus_cps_1992_through_2019_beta, list.len=ncol(harmonzd_tus_cps_1992_through_2019_beta))

###############################################################################
## Saving the CPS 1992 through 2019 data
###############################################################################


saveRDS(harmonzd_tus_cps_1992_through_2019_beta, file = "./harmonzd_tus_cps_1992_through_2019_beta.RDS")


