/********************************************************************************/;
/* Program: harmonzd.tus_cps.1992.through.2023.sas                              */;
/*    Date: May 2025                                                            */;
/*                                                                              */;
/* Purpose: SAS program to create permanent SAS dataset from the 1992-2023      */;
/*          harmonized data file.                                               */;
/*                                                                              */;
/*   Notes: The Filename, Libname and Include statements need to be modified    */;
/*          to match location of the data files and the format progam.          */;
/*                                                                              */;
/* Modifications                                                                */;
/*                                                                              */;
/********************************************************************************/;
Filename Harmon "harmonzd.tus_cps.1992.through.2023.dat" lrecl=728;
Libname  MyLib  ".";

%Include "harmonzd.tus_cps.1992.through.2023.formats.sas";

Data MyLib.Harmon;
  Infile Harmon;
  Input @001 SurWave  2.
        @003 SurYear  4.      
        @007 SurMonth 2.
        @009 SpanHome 2.
        @011 HMOwnRnt 1.
        @012 FamInc   2.
        @014 HHNum    2.
        @016 OwnBsFrm 2.
        @018 Region   1.
        @019 FIPS     2.
        @021 State    $Char20.
        @041 StCounty 5.
        @046 MetStat  1.
        @047 Age      2.
        @049 Sex      1.
        @050 AFEver   2.
        @052 Race92   1.
        @053 Race03   2.
        @055 DTAsian  2.
        @057 Hispan   1.
        @058 DTHisp92 2.
        @060 DTHisp03 2.
        @062 DTHisp14 2.
        @064 Marital  2.
        @066 COHab    1.
        @067 Edu      2.
        @069 EmplStat 2.
        @071 Natvty   3.
        @074 NatvtyM  3.
        @077 NatvtyF  3.
        @080 Citizen  1.
        @081 YEARINUS 3.
        @084 AgeInUS  3.
        @087 ABSNTRSN 2.
        @089 ABSNTPAY 2.
        @091 MULTJOBS 2.
        @093 OTWk     2.
        @095 OTWkAMT  6.
        @101 CHILDNUM 2.
        @103 CHILD    2.
        @105 CHILD2   2.
        @107 CHILD5   2.
        @109 CHILD13  2.
        @111 CHILD17  2.
        @113 WRKCLSS1 2.
        @115 WRKCLSS2 2.
        @117 IND1DT95 2.
        @119 IND1DT03 2.
        @121 IND2DT95 2.
        @123 IND2DT03 2.
        @125 OCC1DT95 2.
        @127 OCC1DT03 2.
        @129 OCC2DT95 2.
        @131 OCC2DT03 2.
        @133 IND1MJ95 2.
        @135 IND1MJ03 2.
        @137 IND2MJ95 2.
        @139 IND2MJ03 2.
        @141 OCC1MJ95 2.
        @143 OCC1MJ03 2.
        @145 OCC2MJ95 2.
        @147 OCC2MJ03 2.
        @149 RecordID $Char22.
        @171 QSTNUM   5.
        @176 OCCURNUM 2.

        @181 Cig100   2.
        @183 CigAge   2.
        @185 CigAgeX  2.
        @187 CGSTCRY  3.
        @190 CGSTCRYX 3.
        @193 CIGNOW   2.
        @195 CIGSTAT  2.
        @197 CPDD     2.
        @199 CPDD20   2.
        @201 CIGDAY   2.
        @203 CIGDAY20 2.
        @205 CPDS     2.
        @207 CIGTYPE  2.
        @209 TTFC     4.
        @213 TTFC30   2.
        @215 BUYCIG   2.
        @217 BUYPKCR  2.
        @219 PRICELPK 4.
        @223 PRICELCR 5.
        @228 DISCNTS  2.
        @230 CIGWHERE 2.
        @232 CIGSTATE 2.
        @234 CIGINDRS 2.
        @236 CIGOTWAY 2.
        @238 SNGLCIG  2.
        @240 SNGLPRCE 4.
        @244 SNGLWHER 2.
        @246 SNGLSTCT 3.
        @249 LOOSETOB 2.
        @251 YRSSMKDC 2.
        @253 YRSSMKDG 2.
        @255 YRSSMKDH 3.
        @258 MENTHREG 2.
        @260 MENTHGRP 2.
        @262 MENTHOL  2. 
        @264 SDEVRDLY 2.
        @266 SDEVRCIG 2.
        @268 SDYRSDLY 4.
        @272 SDYRSMKC 2.
        @274 SDYRSMKG 2.
        @276 CIGSTA12 2.
        @278 CPDD12   2.
        @280 CIGDAY12 2.
        @282 CPDS12   2.
      
        @284 EVSTP1DD 2.
        @286 PYSTP1DD 2.
        @288 XPYSTPDN 2.
        @290 XPYSTPDC 2.
        @292 PYMLTDU  5.
        @297 PYMLTD   4.
        @301 EVTRYQD  2.
        @303 PYTRYQD  2.
        @305 EVSTP1DS 2.
        @307 PYSTP1DS 2.
        @309 XPYSTPSN 4.
        @313 XPYSTPSC 2.
        @315 PYMLTHSU 5.
        @320 PYMLTHS  4.
        @324 EVTRYQS  2.
        @326 PYTRYQS  2.
        @328 PYQUITSD 2.
        @330 EVTRYQCS 2.
        @332 PYMLTLSU 6.
        @338 PYMLTLS  4.
        @342 PYQTNRT1 2.
        @344 PYQTNRT2 2.
        @346 PYQTNRT3 2.
        @348 PYQTNRT4 2.
        @350 PYQTHLP1 2.
        @352 PYQTHLP2 2.
        @354 PYQTHLP3 2.
        @356 PYQTHLP4 2.
        @358 PYQTHLP5 2.
        @360 PYQTHLP6 2.
        @362 PYQTHLP7 2.
        @364 PYQHLP7A 2.
        @366 PYQTPTN1 2.
        @368 PYQTPTN2 2.
        @370 PYQTPTN3 2.
        @372 PYQTPTN4 2.
        @374 PYQPTN4A 2.
        @376 PYQTPTN5 2.
      
        @378 DOCSEEN  2.
        @380 DOCADVYR 2.
        @382 DOCADVQL 2.
        @384 DOCADVEV 2.
        @386 DDSSEEN  2.
        @388 DDSADVYR 2.
        @390 DDSADVQL 2.
        @392 DDSADVEV 2.
      
        @394 INTQT6MO 2.
        @396 INTQT30D 2.
        @398 INTRQUIT 2.
        @400 QUITSUCS 2.
      
        @402 FMEVRDLY 2.
        @404 FMYRSDLY 5.
        @409 FMEVRCIG 2.
        @411 FMYRSMKC 2.
        @413 FMYRSMKG 2.
        @415 FMLOTQT  5.
        @420 FMLOTQTC 2.
        @422 FMCGST12 2.
        @424 FMCPDD12 2.
        @426 FMCIGD12 2.
        @428 FMCPDS12 2.
        @430 FMMNTHUB 2.
        @432 FMMNTHRG 2.
        @434 FMMNTHGP 2.
        @436 FMQTNRT1 2.
        @438 FMQTNRT2 2.
        @440 FMQTNRT3 2.
        @442 FMQTNRT4 2.
        @444 FMQTHLP1 2.
        @446 FMQTHLP2 2.
        @448 FMQTHLP3 2.
        @450 FMQTHLP4 2.
        @452 FMQTHLP5 2.
        @454 FMQTHLP6 2.
        @456 FMQTHLP7 2.
        @458 FMQHLP7A 2.
        @460 FMQTPTN1 2.
        @462 FMQTPTN2 2.
        @464 FMQTPTN3 2.
        @466 FMQTPTN4 2.
        @468 FMQPTN4A 2.
        @470 FMQTPTN5 2.
        @472 FMDOCSEE 2.
        @474 FMDOCADV 2.
        @476 FMTTFC   4.
        @480 FMTTFC30 2.

        @482 PIPEEVER 2.
        @484 CIGREVER 2.
        @486 CHEWEVER 2.
        @488 SNFFEVER 2.
        @490 HOOKEVER 2.
        @492 SMKLEVER 2.
        @494 ECIGEVER 2.
        @496 PIPENOW  2.
        @498 CIGRNOW  2.
        @500 CHEWNOW  2.
        @502 SNFFNOW  2.
        @504 HOOKNOW  2.
        @506 SMKLNOW  2.
        @508 ECIGNOW  2.

        @510 PIPENOW2 2.
        @512 CIGRNOW2 2.
        @514 CHEWNOW2 2.
        @516 SNFFNOW2 2.
        @518 HOOKNOW2 2.
        @520 SMKLNOW2 2.
        @522 ECIGNOW2 2.
        @524 PIPECURR 2.
        @526 CIGRCURR 2.
        @528 CHEWCURR 2.
        @530 SNFFCURR 2.
        @532 HOOKCURR 2.
        @534 SMKLCURR 2.
        @536 ECIGCURR 2.
        @538 PIPESTAT 2.
        @540 CIGRSTAT 2.
        @542 CHEWSTAT 2.
        @544 SNFFSTAT 2.
        @546 HOOKSTAT 2.
        @548 SMKLSTAT 2.
        @550 ECIGSTAT 2.
        @552 PIPEDAY  2.
        @554 CIGRDAY  2.
        @556 CHEWDAY  2.
        @558 SNFFDAY  2.
        @560 HOOKDAY  2.
        @562 SMKLDAY  2.
        @564 ECIGDAY  2.
        @566 PIPELOTQ 4.
        @570 CIGRLOTQ 4.
        @574 HOOKLOTQ 4.
        @578 SMKLLOTQ 4.
        @582 ECIGLOTQ 4.
        @586 PIPEYRS  2.
        @588 CIGRYRS  2.
        @590 HOOKYRS  2.
        @592 SMKLYRS  2.
        @594 ECIGYRS  2.
        @596 CIGRTYPE 2.
        @598 CIGRFLVR 2.
        @600 PIPEFLVR 2.
        @602 HOOKFLVR 2.
        @604 SMKLFLVR 2.
        @606 ECIGFLVR 2.
        @608 ECIGBRDG 2.
        @610 ECIGTOQT 2.
        @612 ECIGTYPE 2.
        @614 BUYECIG  2.
        @616 BUYPKECG 2.
        @618 PRCEBOX  4.
        @622 NUMECIGS 2.
        @624 PRCESNGL 4.
        @628 ECIGVOL  3.
        @631 FMECIGBR 2.
        @633 FMECIGQT 2.
        @635 TTFOTP   4.
        @639 TTFOTP30 2.
        @641 FMTTFOTP 4.
        @645 FMTTFO30 2.
        @647 PYSTPOTP 2.
        @649 PYLTOTP  4.

        @653 WKAREA92 2.
        @655 WKAREA03 2.
        @657 WKINDPLC 2.
        @659 WKSTATE  2.
        @661 WKAREA10 2.
        @663 WKINDPL1 2.
        @665 WKSTATE1 2.
        @667 WKINDPL2 2.
        @669 WKSTATE2 2.
        @671 WKPOLICY 2.
        @673 WKPOLIND 2.
        @675 WKPOLWRK 2.
        @677 WORKBAN  2.
        @679 WKSTPSMK 2.
        @681 WKSMK2WK 2.
        @683 WKPOLECG 2.
        @685 WKSMK2EC 2.
        @687 ATSMKRST 2.
        @689 ATSMKHSP 2.
        @691 ATSMKIWA 2.
        @693 ATSMKBAR 2.
        @695 ATSMKISP 2.
        @697 ATSMKISM 2.
        @699 ATSMKPLY 2.
        @701 ATSMKCAS 2.
        @703 ATSMCARO 2.
        @705 ATSMCARC 2.
        @707 HMSMKPOL 2.
        @709 HMECGPOL 2.
        @711 MUHSMPOL 2.
        @713 ATMINBUY 2.
        @715 ATSAMPLE 2.
        @717 ATTOBADV 2.
        @719 SRWEIGHT 10.;
        
  If YEARINUS Not In (.,-1) Then YEARINUS=YEARINUS/10;
  If AgeInUS Not In (.,-1,-9) Then AgeInUS=AgeInUS/10;
  
  If OTWKAMT Not In (.,-1) Then OTWKAMT=OTWKAMT/100;
  
  If PRICELPK Not In (.,-9,-3,-2,-1) Then PRICELPK=PRICELPK/100;
  If PRICELCR Not In (.,-9,-3,-2,-1) Then PRICELCR=PRICELCR/100;
  If SNGLPRCE Not In (.,-9,-3,-2,-1) Then SNGLPRCE=SNGLPRCE/100;
  If SDYRSDLY Not In (.,-9,-3,-2,-1) Then SDYRSDLY=SDYRSDLY/100;
  If FMYRSDLY Not In (.,-9,-3,-2,-1) Then FMYRSDLY=FMYRSDLY/100;
  If FMLOTQT Not In (.,-9,-3,-2,-1) Then FMLOTQT=FMLOTQT/100;
  If XPYSTPSN Not In (.,-9,-3,-2,-1) Then XPYSTPSN=XPYSTPSN/100;
  If PYMLTHS Not In (.,-9,-3,-2,-1) Then PYMLTHS=PYMLTHS/100;
  If PYMLTLSU Not In (.,-9,-3,-2,-1) Then PYMLTLSU=PYMLTLSU/100;
  If PYMLTLS Not In (.,-9,-3,-2,-1) Then PYMLTLS=PYMLTLS/100;
  If PYMLTHSU Not In (.,-9,-3,-2,-1) Then PYMLTHSU=PYMLTHSU/100;
  If PYMLTD Not In (.,-9,-3,-2,-1) Then PYMLTD=PYMLTD/100;
  If PYMLTDU Not In (.,-9,-3,-2,-1) Then PYMLTDU=PYMLTDU/100;
  If CIGRLOTQ Not In (.,-99,-9,-3,-2,-1) Then CIGRLOTQ=CIGRLOTQ/100;
  If PIPELOTQ Not In (.,-99,-9,-3,-2,-1) Then PIPELOTQ=PIPELOTQ/100;
  If HOOKLOTQ Not In (.,-99,-9,-3,-2,-1) Then HOOKLOTQ=HOOKLOTQ/100;
  If SMKLLOTQ Not In (.,-99,-9,-3,-2,-1) Then SMKLLOTQ=SMKLLOTQ/100;
  If ECIGLOTQ Not In (.,-99,-9,-3,-2,-1) Then ECIGLOTQ=ECIGLOTQ/100;
  If PRCEBOX Not In (-9,-3,-2,-1,.) Then PRCEBOX=PRCEBOX/100;
  If PRCESNGL Not In (-9,-3,-2,-1,.) Then PRCESNGL=PRCESNGL/100;
  If PYLTOTP Not In (.,-99,-9,-3,-2,-1) Then PYLTOTP=PYLTOTP/100;
  SRWEIGHT=SRWEIGHT/10000;
  
  Attrib SurWave Label = "Survey wave" Format=SurWaveF.;
  Attrib SurMonth Label = "Survey month" Format=SurMontF.;
  Attrib SurYear Label = "Survey year";
  Attrib SPANHOME Label = "Is Spanish the only language spoken by all members of this household who are 15 years of age or older" Format=SPANHOMF.;
  Attrib HmOwnRnt Label = "Are your living quarters..." Format=HmOwnRnF.;
  Attrib FamInc Label = "Family income" Format=FamIncF.; 
  Attrib OWNBSFRM Label = "Does anyone in this household have a business or a farm?" Format=OWNBSFRF.;
  Attrib HHNum Label = "Number of persons in household";
  Attrib Region Label = "Region" Format=RegionF.;
  Attrib FIPS Label = "State (FIPS Code)" Format=FIPSF.;
  Attrib State Label = "State"; 
  Attrib StCounty Label = "State/County" Format=StCountF.;
  Attrib MetStat Label = "Metropolitan status" Format=MetStatF.;
  Attrib Age Label = "Age" Format=AgeF.;
  Attrib Sex Label = "Sex" Format=SexF.;
  Attrib AFEver Label = "Did you ever serve on active duty in the U.S. Armed Forces" Format=AFEverF.;
  Attrib Race92 Label = "Race (1992-2002)" Format=Race92F.;
  Attrib Race03 Label = "Race (2003 and later)" Format=Race03F.;
  Attrib DTAsian Label = "Detailed Asian Race Recode (2014 and later)" Format=DTAsianF.;
  Attrib Hispan Label = "Hispanic or non-Hispanic" Format=HispanF.;
  Attrib DTHisp92 Label = "Origin or Descent (1992-2002)" Format=DTHis92F.;
  Attrib DTHisp03 Label = "Detailed Hispanic Origin Group (2003-2011)" Format=DTHis03F.;
  Attrib DTHisp14 Label = "Detailed Hispanic Origin Group (2014 and later)" Format=DTHis14F.;
  Attrib Marital Label = "Marital status" Format=MaritalF.;
  Attrib Cohab Label = "Cohabiting Partner (2010 and later)" Format=CohabF.;
  Attrib Edu Label = "Highest level of school completed or degree received" Format=EduF.;
  Attrib EmplStat Label = "Employment status" Format=EmplStaF.;
  Attrib Natvty  Label = "Country of birth" Format=NatvtyF.;
  Attrib NatvtyM Label = "Mother's country of birth" Format=NatvtyF.;
  Attrib NatvtyF Label = "Father's Country of birth" Format=NatvtyF.;
  Attrib Citizen Label = "Citizenship status" Format=CitizenF.;
  Attrib YearInUS Label = "Years in U.S." Format=YEARINUF.;
  Attrib AGEINUS Label = "Immigrant's age of entry" Format=AgeInUSF.;
  Attrib AGEINUS Label = "Immigrant's age of entry";
  Attrib AbsntRsn Label = "What is the main reason you were absent from work last week" Format=AbsntRsF.;
  Attrib AbsntPay Label = "Are you being paid by your employer for any of the time off last week" Format=AbsntPaF.;
  Attrib MULTJOBS Label = "Do you have more than one job" Format=MULTJOBF.;
  Attrib OTWK Label = "Last week, did you work any overtime or extra hours (at your main job) that you do not usually work" Format=OTWKF.;
  Attrib OTWKAMT Label = "Calculated weekly overtime amount";
  Attrib Child Label = "Presence of own children <18 years of age by selected age group" Format=ChildF.;
  Attrib ChildNum Label = "Number of children <18 years of age";
  Attrib Child2   Label = "Any own children 0-2 years of age" Format=ChildRF.;
  Attrib Child5   Label = "Any own children 3-5 years of age" Format=ChildRF.;  
  Attrib Child13  Label = "Any own children 6-13 years of age" Format=ChildRF.;
  Attrib Child17  Label = "Any own children 14-17 years of age" Format=ChildRF.;
  Attrib WRKCLSS1 Label = "Individual class of worker code on first job" Format=WRKCLSSF.;
  Attrib WRKCLSS2 Label = "Individual class of worker code on second job" Format=WRKCLSSF.;
  Attrib IND1DT95 Label = "Detailed industry recode - job 1 (1995-2002)" Format=INDDT95F.;
  Attrib IND1DT03 Label = "Detailed industry recode - job 1 (2003 and later)" Format=INDDT03F.;
  Attrib IND2DT95 Label = "Detailed industry recode - job 2 (1995-2002)" Format=INDDT95F.;
  Attrib IND2DT03 Label = "Detailed industry recode - job 2 (2003 and later)" Format=INDDT03F.;
  Attrib OCC1DT95 Label = "Detailed occupation recode - job 1 (1995-2002)" Format=OCCDT95F.;
  Attrib OCC1DT03 Label = "Detailed occupation recode - job 1 (2003 and later)" Format=OCCDT03F.;
  Attrib OCC2DT95 Label = "Detailed occupation recode - job 2 (1995-2002)" Format=OCCDT95F.;
  Attrib OCC2DT03 Label = "Detailed occupation recode - job 2 (2003 and later)" Format=OCCDT03F.;
  Attrib IND1MJ95 Label = "Major industry recode - job 1 (1995-2002)" Format=INDMJ95F.;
  Attrib IND1MJ03 Label = "Major industry recode - job 1 (2003 and later)" Format=INDMJ03F.;
  Attrib IND2MJ95 Label = "Major industry recode - job 2 (1995-2002)" Format=INDMJ95F.;
  Attrib IND2MJ03 Label = "Major industry recode - job 2 (2003 and later)" Format=INDMJ03F.;
  Attrib OCC1MJ95 Label = "Major occupation recode - job 1 (1995-2002)" Format=OCCMJ95F.;
  Attrib OCC1MJ03 Label = "Major occupation recode - job 1 (2003 and later)" Format=OCCMJ03F.;
  Attrib OCC2MJ95 Label = "Major occupation recode - job 2 (1995-2002)" Format=OCCMJ95F.;
  Attrib OCC2MJ03 Label = "Major occupation recode - job 2 (2003 and later)" Format=OCCMJ03F.;
  Attrib RecordID Label = "Record ID (Unique within survey month)";
  Attrib QSTNUM Label = "Unique household identifier (Unique within survey month)";
  Attrib OCCURNUM Label = "Unique person identifier (Unique within survey month)";
  Attrib Cig100 Label = "Smoked 100 cigarettes in entire life" Format=YesNoF.;
  Attrib CigAge Label = "Age first started smoking cigarettes fairly regularly" Format=CigAgeF.;
  Attrib CIGAGEX Label = "Age first started smoking cigarettes (never smoked regularly)" Format=CIGAGEXF.;
  Attrib CgStCry Label = "State or country lived when first smoked part or all of a cigarette" Format=CgStCryF.;
  Attrib CgStCryX Label = "State or country lived when first smoked part or all of a cigarette (never smoked regularly)" Format=CgStCryF.;
  Attrib CigNow Label = "Now smoke cigarettes every day, some days or not at all" Format=CigNowF.;
  Attrib CIGSTAT Label = "Current cigarette smoking status" Format=CigStatF.;
  Attrib CPDD Label = "Number of cigarettes smoke a day (every day smokers)" Format=CPDDF.;
  Attrib CPDD20 Label = "On average, now smoke more or less than 20 cigarettes each day (every day smokers*)" Format=CPDD20F.;
  Attrib CIGDAY Label = "On how many of the past 30 days did you smoke cigarettes (some day smokers)" Format=CIGDAYF.;
  Attrib CIGDAY20 Label = "Would you say you smoked on at least 12 days in the past 30 days (some day smokers*)" Format=CIGDAY2F.;
  Attrib CPDS Label = "On days smoked, number of cigarettes smoke a day (some day smokers)" Format=CPDSF.;
  Attrib CigType Label = "Type of cigarette (menthol/non-menthol, current smokers)" Format=CigTypeF.;
  Attrib TTFC Label = "Time to first cigarette, minutes (current smokers)" Format=TTFCF.;
  Attrib TTFC30 Label = "Smoke first cigarette of the day within first 30 minutes (current smokers)" Format=TTFC30F.;
  Attrib BUYCIG Label = "Do you usually buy your own cigarettes? (current smokers)" Format=BUYCIGF.;
  Attrib BUYPKCR Label = "Do you usually buy your cigarettes by the pack or by the carton? (current smokers)" Format=BUYPKCRF.;
  Attrib PRICELPK Label = "Price paid for last pack of cigarettes (current smokers)";
  Attrib PRICELCR Label = "Price paid for last carton of cigarettes (current smokers)";
  Attrib DISCNTS Label = "Did you use coupons, rebates, or any other special promotions when you bought your last (pack/carton) of cigarettes" Format=DISCNTSF.;
  Attrib CIGWHERE Label = "Where last (pack/carton) purchased (current smokers)" Format=CIGWHERF.;
  Attrib CIGSTATE Label = "State where purchased last (pack/carton) (current smokers)" Format=CIGStF.; 
  Attrib CIGINDRS Label = "Buy last (pack/carton) of cigarettes from an Indian reservation (current smokers)" Format=CIGINDRF.;
  Attrib CIGOTWAY Label = "Other way purchased last (pack/carton) of cigarettes (current smokers)" Format=CIGOTWAF.;
  Attrib SNGLCIG Label = "In the last 2 months, have you bought (or traded for) any single or individual cigarette (current smokers)" Format=SNGLCIGF.;
  Attrib SNGLPRCE Label = "Price paid for last  single or individual cigarette (current smokers)";
  Attrib SNGLWHER Label = "Where last single or individual cigarette purchased (current smokers)" Format=SNGLWHEF.;
  Attrib SNGLSTCT Label = "State (or country) where purchased last single or individual cigarette (current smokers)" Format=SNGLSTCF.;
  Attrib LOOSETOB Label = "In the LAST 2 months, have you bought loose tobacco to roll-your-own cigarettes?" Format=LOOSETOF.;
  Attrib YRSSMKDC Label = "Number of years smoked every day (every day smokers)" Format=YRSSMKCF.;
  Attrib YRSSMKDG Label = "For how long have you smoked every day (every day smokers)" Format=YRSSMKGF.;
  Attrib YRSSMKDH Label = "Number of years smoked every day (harmonized, every day smokers)" Format=YRSSMKCF.;
  Attrib MENTHREG Label = "Have you ever smoked menthol cigarettes for 6 months or more (current smokers)" Format=MENTHREF.;
  Attrib MENTHGRP Label = "For how long (have you smoked/did you smoke) menthol cigarettes (current smokers)" Format=MENTHGRF.;
  Attrib MENTHOL  Label = "Menthol use (constructed, current smokers)" Format=MENTHOLF.;
  Attrib SDEVRDLY Label = "Ever smoked cigarettes every day for at least 6 months (some day smokers)" Format=SDEVRDLF.;
  Attrib SDEVRCIG Label = "When you last smoked every day, on average how many cigarettes did you smoke daily (some day smokers)" Format=SDEVRCIF.;
  Attrib SDYRSDLY Label = "Years since smoked every day (some day smokers)" Format=SDYRSDLF.;
  Attrib SDYRSMKC Label = "Years smoked every day (some day smokers)" Format=SDYRSMCF.;
  Attrib SDYRSMKG Label = "For how long have you smoked every day? (some day smokers)" Format=SDYRSMGF.;
  Attrib CIGSTA12 Label = "Around this time 12 months ago, were you smoking cigarettes every day, some days or not at all? (current smokers)" Format=CIGSTA1F.;
  Attrib CPDD12 Label = "Around this time 12 months ago, number of cigarettes smoked a day (current smoker, every day smokers 12 months ago)" Format=CPDDF.;
  Attrib CIGDAY12 Label = "Around this time 12 months ago, number of the past 30 days smoked cigarettes (some day smokers 12 months ago)" Format=CIGDAYF.;
  Attrib CPDS12 Label = "Around this time 12 months ago, number of cigarettes smoked a day (current smoker, some day smokers 12 months ago)" Format=CPDSF.;
  Attrib EVSTP1DD Label = "Have you ever stopped smoking for one day or longer because you were trying to quit smoking? (every day smokers)" Format=EVSTP1DF.;
  Attrib PYSTP1DD Label = "During the past 12 months, have you stopped smoking for one day or longer because you were trying to quit smoking? (every day smokers)" Format=PYSTP1DF.;
  Attrib XPYSTPDN Label = "How many times during the past 12 months have you stopped smoking for one day or longer because you were trying to quit smoking? (every day smokers)" Format=XPYSTPNF.;
  Attrib XPYSTPDC Label = "How many times during the past 12 months have you stopped smoking for one day or longer because you were trying to quit smoking? (every day smokers)" Format=XPYSTPCF.;
  Attrib PYMLTD   Label = "During the past 12 months, what is the longest length of time you stopped smoking because you were trying to quit smoking? (every day smokers, number of months)" Format=PYMLTDF.;
  Attrib PYMLTDU  Label = "During the past 12 months, what is the longest length of time you stopped smoking because you were trying to quit smoking? (every day smokers, number of months, not truncated)" Format=PYMLTDF.;
  Attrib PYQUITSD Label = "During the past 12 months, have you tried to quit smoking completely? (some days smokers, < 12 days)" Format=PYQUITSF.;
  Attrib EVTRYQCS Label = "Have you ever tried to quit smoking completely? (some days smokers, < 12 days)" Format=EVTRQCF.;
  Attrib PYMLTLS  Label = "During the past 12 months, what is the longest length of time you stopped smoking because you were trying to quit smoking? (some days smokers, < 12 days, number of months)" Format=PYMLTLSF.;
  Attrib PYMLTLSU Label = "During the past 12 months, what is the longest length of time you stopped smoking because you were trying to quit smoking? (some days smokers, < 12 days, number of months, not truncated)" Format=PYMLTLSF.;
  Attrib EVSTP1DS Label = "Have you ever stopped smoking for one day or longer because you were trying to quit smoking? (some days smokers, 12+ days)" Format=EVSTP1DF.;
  Attrib PYSTP1DS Label = "During the past 12 months, have you stopped smoking for one day or longer because you were trying to quit smoking? (some days smokers, 12+ days)" Format=PYSTP1DF.;
  Attrib XPYSTPSN Label = "How many times during the past 12 months have you stopped smoking for one day or longer because you were trying to quit smoking? (some days smokers, 12+ days)" Format=XPYSTPNF.;
  Attrib XPYSTPSC Label = "How many times during the past 12 months have you stopped smoking for one day or longer because you were trying to quit smoking? (some days smokers, 12+ days)" Format=XPYSTPCF.;
  Attrib PYMLTHS  Label = "During the past 12 months, what is the longest length of time you stopped smoking because you were trying to quit smoking? (some days smokers, 12+ days, number of months)" Format=PYMLTHSF.;
  Attrib PYMLTHSU Label = "During the past 12 months, what is the longest length of time you stopped smoking because you were trying to quit smoking? (some days smokers, 12+ days, number of months, not truncated)" Format=PYMLTHSF.;
  Attrib EVTRYQD  Label = "Have you ever made a serious attempt to stop smoking because you were trying to quit - even if you stopped for less than a day? (every day smokers)" Format=EVTRYQDF.;
  Attrib PYTRYQD  Label = "During the past 12 months, have you made a serious attempt to stop smoking because you were trying to quit <even if you stopped for less than a day>? (every day smokers)" Format=PYTRYQDF.;
  Attrib EVTRYQS  Label = "Have you ever made a serious attempt to stop smoking because you were trying to quit - even if you stopped for less than a day? (some days smokers, 12+ days)" Format=EVTRYQDF.;
  Attrib PYTRYQS  Label = "During the past 12 months, have you made a serious attempt to stop smoking because you were trying to quit <even if you stopped for less than a day>? (some days smokers, 12+ days)" Format=PYTRYQSF.;
  Attrib PYQTNRT1 Label = "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use a nicotine patch?" Format=PYQTNRTF.;
  Attrib PYQTNRT2 Label = "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use a nicotine gum or nicotine lozenge?" Format=PYQTNRTF.;
  Attrib PYQTNRT3 Label = "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use a nicotine nasal spray or nicotine inhaler?" Format=PYQTNRTF.;
  Attrib PYQTNRT4 Label = "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use a prescription pill?" Format=PYQTNRTF.;
  Attrib PYQTHLP1 Label = "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use a telephone help line or quit line?" Format=PYQTHLPF.;
  Attrib PYQTHLP2 Label = "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use a stop smoking clinic, class or support group?" Format=PYQTHLPF.;
  Attrib PYQTHLP3 Label = "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use one-on-one counseling?" Format=PYQTHLPF.;
  Attrib PYQTHLP4 Label = "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use help or support from friends or family?" Format=PYQTHLPF.;
  Attrib PYQTHLP5 Label = "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use the internet or World Wide Web/web-based program?" Format=PYQTHLPF.;
  Attrib PYQTHLP6 Label = "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use books, pamphlets, videos or other materials?" Format=PYQTHLPF.;
  Attrib PYQTHLP7 Label = "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Did you use acupuncture or hypnosis?" Format=PYQTHLPF.;
  Attrib PYQHLP7A Label = "Thinking back to the (last time/time) you tried to quit smoking in the past 12 months. Which did you use acupuncture or hypnosis or both?" Format=PYQHLP7F.;
  Attrib PYQTPTN1 Label = "The (last time/time) you tried to quit smoking in the past 12 months. Did you try to quit by gradually cutting back on cigarettes?" Format=PYQTPTNF.;
  Attrib PYQTPTN2 Label = "The (last time/time) you tried to quit smoking in the past 12 months. Did you try to quit by switching to chewing tobacco, snuff, <snus>, cigars or pipes?" Format=PYQTPTNF.;
  Attrib PYQTPTN3 Label = "The (last time/time) you tried to quit smoking in the past 12 months. Did you switch to a 'lighter' cigarette in order to try to quit?" Format=PYQTPTNF.;
  Attrib PYQTPTN4 Label = "The (last time/time) you tried to quit smoking in the past 12 months. Did you try to give up cigarettes all at once?" Format=PYQTPTNF.;
  Attrib PYQPTN4A Label = "The (last time/time) you tried to quit smoking in the past 12 months. When you tried to quit all at once, would you say you tried to quit 'cold turkey'" Format=PYQPTN4F.;
  Attrib PYQTPTN5 Label = "The (last time/time) you tried to quit smoking in the past 12 months. Did you try to quit by switching to electronic or e-cigarettes?" Format=PYQTPTNF.;
  Attrib DOCSEEN  Label = "In the past year/12 months have you seen a medical doctor?" Format=DOCSEENF.;
  Attrib DOCADVYR Label = "During the past year/12 months, did any medical doctor advise you to stop smoking?" Format=DOCADVYF.;
  Attrib DOCADVQL Label = "In the past 12 months, when a medical doctor advised you to quit smoking, did the doctor also suggest that you call or use a telephone help line or quit line?" Format=DOCADVQF.;
  Attrib DOCADVEV Label = "Has a medical doctor ever advised you to stop smoking?" Format=DOCADVEF.;
  Attrib DDSSEEN  Label = "In the past year/12 months have you seen a dentist?" Format=DDSSEENF.;
  Attrib DDSADVYR Label = "During the past year/12 months, did any dentist advise you to stop smoking?" Format=DDSADVYF.;
  Attrib DDSADVQL Label = "In the past 12 months, when a dentist advised you to quit smoking, did the dentist also suggest that you call or use a telephone help line or quit line?" Format=DDSADVQF.;
  Attrib DDSADVEV Label = "Has a dentist ever advised you to stop smoking?" Format=DDSADVEF.;
  Attrib INTQT6MO Label = "Are you seriously considering stopping/quitting smoking within the next 6 months?" Format=INTQT6MF.;
  Attrib INTQT30D Label = "Are you planning to stop/quit within the next 30 days?" Format=INTQT30F.;
  Attrib INTRQUIT Label = "Overall, on a scale from 1 to 10 where 1 is not at all interested and 10 is extremely interested, how interested are you in quitting smoking?" Format=INTRQUIF.;
  Attrib QUITSUCS Label = "If you did try to quit smoking altogether in the next 6 months, how likely do you think you would be to succeed..." Format=QUITSUCF.;
  Attrib FMEVRDLY Label = "Ever smoked cigarettes every day for at least 6 months (former smokers)" Format=FMEVRDLF.;   
  Attrib FMYRSDLY Label = "Years since smoked every day (former smokers who smoked every day for at least 6 months)" Format=FMYRSDLF.;
  Attrib FMEVRCIG Label = "When you last smoked every day, on average how many cigarettes did you smoke daily? (former smokers who smoked every day for at least 6 months)" Format=FMEVRCIF.;
  Attrib FMYRSMKC Label = "Years smoked every day (former smokers who smoked every day for at least 6 months)" Format=FMYRSMCF.;
  Attrib FMYRSMKG Label = "Years smoked every day (former smokers who smoked every day for at least 6 months)" Format=FMYRSMGF.;
  Attrib FMLOTQT  Label = "About how long has it been since you completely stopped smoking cigarettes (years, former smokers)" Format=FMLOTQTF.;
  Attrib FMLOTQTC Label = "About how long has it been since you completely stopped smoking cigarettes (categorical, former smokers)" Format=FMLOTQCF.;
  Attrib FMCGST12 Label = "Around this time 12 months ago, were you smoking cigarettes every day, some days or not at all? (former smokers who quit within the past year)" Format=FMCGST1F.;
  Attrib FMCPDD12 Label = "Around this time 12 months ago, on the average, about how many cigarettes did you smoke each day? (former smokers who quit within the past year, every day smokers around 12 months ago)" Format=FMCPDD1F.;
  Attrib FMCIGD12 Label = "Around this time 12 months ago, on how many of 30 days in the month did you smoke cigarettes? (former smokers who quit within the past year, some day smokers around 12 months ago)" Format=FMCIGD1F.;
  Attrib FMCPDS12 Label = "On the average, on those days, how many cigarettes did you usually smoke each day? (former smokers who quit within the past year, some day smokers around 12 months ago)" Format=FMCPDS1F.;  
  Attrib FMMNTHUB Label = "Type of cigarette (menthol/non-menthol, former smokers who quit within the past 5 years/former smokers)" Format=FMMNTHUF.;
  Attrib FMMNTHRG Label = "Ever smoked menthol cigarettes (former smokers)" Format=FMMNTHRF.;
  Attrib FMMNTHGP Label = "How long did you smoke menthol cigarettes (former smokers who smoked menthol)" Format=FMMNTHGF.;  
  Attrib FMQTNRT1 Label = "When you quit smoking completely did you use a nicotine patch (former smokers who quit within the past [5,3] years)?" Format=FMQTNRTF.;
  Attrib FMQTNRT2 Label = "When you quit smoking completely did you use a nicotine gum or nicotine lozenge? (former smokers who quit within the past [5,3] years)" Format=FMQTNRTF.;
  Attrib FMQTNRT3 Label = "When you quit smoking completely did you use a nicotine nasal spray or nicotine inhaler? (former smokers who quit within the past [5,3] years)" Format=FMQTNRTF.;
  Attrib FMQTNRT4 Label = "When you quit smoking completely did you use a prescription pill? (former smokers who quit within the past [5,3,1] year(s))" Format=FMQTNRTF.;
  Attrib FMQTHLP1 Label = "When you quit smoking completely did you use a telephone help line or quit line? (former smokers who quit within the past [5,3,1] year(s))" Format=FMQTHLPF.;
  Attrib FMQTHLP2 Label = "When you quit smoking completely did you use a stop smoking clinic, class or support group? (former smokers who quit within the past [5,3,1] year(s))" Format=FMQTHLPF.;
  Attrib FMQTHLP3 Label = "When you quit smoking completely did you use one-on-one counseling? (former smokers who quit within the past [5,3,1] year(s))" Format=FMQTHLPF.;
  Attrib FMQTHLP4 Label = "When you quit smoking completely did you use help or support from friends or family? (former smokers who quit within the past [5,3] years)" Format=FMQTHLPF.;
  Attrib FMQTHLP5 Label = "When you quit smoking completely did you use the internet or World Wide Web/web-based program? (former smokers who quit within the past [5,3,1] year(s))" Format=FMQTHLPF.;
  Attrib FMQTHLP6 Label = "When you quit smoking completely did you use books, pamphlets, videos or other materials? (former smokers who quit within the past [5,3] year(s))" Format=FMQTHLPF.;
  Attrib FMQTHLP7 Label = "When you quit smoking completely did you use acupuncture or hypnosis? (former smokers who quit within the past [5,3] years)" Format=FMQTHLPF.;
  Attrib FMQHLP7A Label = "When you quit smoking completely which did you use acupuncture or hypnosis or both? (former smokers who quit within the past [5,3] years)" Format=FMQHLP7F.;  
  Attrib FMQTPTN1 Label = "When you quit smoking completely did you try to quit by gradually cutting back on cigarettes? (former smokers who quit within the past [5,3] years)" Format=PYQTPTNF.;
  Attrib FMQTPTN2 Label = "When you quit smoking completely did you try to quit by switching to chewing tobacco, snuff, <snus>, cigars or pipes? (former smokers who quit within the past [5,3,1] year(s))" Format=PYQTPTNF.;
  Attrib FMQTPTN3 Label = "When you quit smoking completely did you switch to a 'lighter' cigarette in order to try to quit? (former smokers who quit within the past [5,3] years)" Format=PYQTPTNF.;
  Attrib FMQTPTN4 Label = "When you quit smoking completely did you try to give up cigarettes all at once? (former smokers who quit within the past [5,3] years)" Format=PYQTPTNF.;
  Attrib FMQPTN4A Label = "When you quit smoking completely, when you tried to quit all at once, would you say you tried to quit 'cold turkey'? (former smokers who quit within the past [5,3] years)" Format=PYQPTN4F.;
  Attrib FMQTPTN5 Label = "When you quit smoking completely did you try to quit by switching to electronic or e-cigarettes? (former smokers who quit within the past [3,1] year(s))" Format=PYQTPTNF.;
  Attrib FMDOCSEE Label = "In the 12 months before you completely quit smoking did you see a medical doctor? (former smokers who quit within the past [3,1] year(s))" Format=FMDOCSEF.;
  Attrib FMDOCADV Label = "During the 12 months before you completely quit smoking, did any medical doctor advise you to stop smoking? (former smokers who quit within the past [3,1] year(s))" Format=FMDOCADF.;
  Attrib FMTTFC   Label = "During the year before your quit smoking, time to first cigarette, minutes (former smokers who quit within the past [5,3,1] year(s))" Format=FMTTFCF.;  
  Attrib FMTTFC30 Label = "During the year before your quit smoking, smoke first cigarette of the day within first 30 minutes (former smokers who quit within the past [5,3,1] year(s))" Format=FMTTFC3F.;
  Attrib PIPEEVER Label = "Ever used pipes <regular pipe filled with tobacco>?" Format=OTPEVERF.;
  Attrib CIGREVER Label = "Ever used cigars <regular cigar, cigarillos or little filtered cigars>?" Format=OTPEVERF.;
  Attrib CHEWEVER Label = "Ever used chewing tobacco?" Format=OTPEVERF.;
  Attrib SNFFEVER Label = "Ever used snuff?" Format=OTPEVERF.;
  Attrib HOOKEVER Label = "Ever used a water or hookah pipe filled with tobacco?" Format=OTPEVERF.;
  Attrib SMKLEVER Label = "Ever used smokeless tobacco?" Format=OTPEVERF.;
  Attrib ECIGEVER Label = "Ever used e-cigarettes?" Format=OTPEVERF.;
  Attrib PIPENow  Label = "Now use pipes <regular pipe filled with tobacco>?" Format=OTPNowF.;
  Attrib CIGRNow  Label = "Now use cigars <regular cigar, cigarillos or little filtered cigars>?" Format=OTPNowF.;
  Attrib CHEWNow  Label = "Now use chewing tobacco?" Format=OTPNowF.;
  Attrib SNFFNow  Label = "Now use snuff?" Format=OTPNowF.;
  Attrib HOOKNow  Label = "Now use a water or hookah pipe filled with tobacco?" Format=OTPNowF.;
  Attrib SMKLNow  Label = "Now use smokeless tobacco?"  Format=OTPNowF.;
  Attrib ECIGNow  Label = "Now use e-cigarettes?"  Format=OTPNowF.;
  Attrib PIPENow2 Label = "Now use pipes <regular pipe filled with tobacco>?" Format=OTPNow2F.;
  Attrib CIGRNow2 Label = "Now use cigars <regular cigar, cigarillos or little filtered cigars>?" Format=OTPNow2F.;
  Attrib CHEWNow2 Label = "Now use chewing tobacco?" Format=OTPNow2F.;
  Attrib SNFFNow2 Label = "Now use snuff?" Format=OTPNow2F.;
  Attrib HOOKNow2 Label = "Now use a water or hookah pipe filled with tobacco?" Format=OTPNow2F.;
  Attrib SMKLNow2 Label = "Now use smokeless tobacco?" Format=OTPNow2F.;
  Attrib ECIGNow2 Label = "Now use e-cigarettes?" Format=OTPNow2F.;
  Attrib PIPECURR Label = "Current pipe <regular pipe filled with tobacco> use status" Format=OTPCurrF.;
  Attrib CIGRCURR Label = "Current cigar <regular cigar, cigarillos or little filtered cigars> use status" Format=OTPCurrF.;
  Attrib CHEWCURR Label = "Current chewing tobacco use status" Format=OTPCurrF.;
  Attrib SNFFCURR Label = "Current snuff use status" Format=OTPCurrF.;
  Attrib HOOKCURR Label = "Current water or hookah pipe filled with tobacco use status" Format=OTPCurrF.;
  Attrib SMKLCURR Label = "Current smokeless tobacco use status" Format=OTPCurrF.;
  Attrib ECIGCURR Label = "Current e-cigarette use status" Format=OTPCurrF.;
  Attrib PIPESTAT Label = "Current pipe <regular pipe filled with tobacco> use status" Format=OTPStatF.;
  Attrib CIGRSTAT Label = "Current cigar <regular cigar, cigarillos or little filtered cigars> use status" Format=OTPStatF.;
  Attrib CHEWSTAT Label = "Current chewing tobacco use status" Format=OTPStatF.;
  Attrib SNFFSTAT Label = "Current snuff use status" Format=OTPStatF.;
  Attrib HOOKSTAT Label = "Current water or hookah pipe filled with tobacco use status" Format=OTPStatF.;
  Attrib SMKLSTAT Label = "Current smokeless tobacco use status" Format=OTPStatF.;
  Attrib ECIGSTAT Label = "Current e-cigarette use status" Format=OTPStatF.;
  Attrib PIPEDAY  Label = "On how many of the past 30 days did you use pipes? (some day users)" Format=OTPDAYF.;
  Attrib CIGRDAY  Label = "On how many of the past 30 days did you use cigars? (some day users)" Format=OTPDAYF.;
  Attrib CHEWDAY  Label = "On how many of the past 30 days did you use chewing tobacco? (some day users)" Format=OTPDAYF.;
  Attrib SNFFDAY  Label = "On how many of the past 30 days did you use snuff? (some day users)" Format=OTPDAYF.;
  Attrib HOOKDAY  Label = "On how many of the past 30 days did you use a water or hookah pipe filled with tobacco? (some day users)" Format=OTPDAYF.;
  Attrib SMKLDAY  Label = "On how many of the past 30 days did you use smokeless tobacco? (some day users)" Format=OTPDAYF.;
  Attrib ECIGDAY  Label = "On how many of the past 30 days did you use e-cigarettes? (some day users)" Format=OTPDAYF.;
  Attrib PIPELOTQ Label = "About how long has it been since you completely quit smoking a regular pipe filled with tobacco? (years, former pipe smokers)" Format=OTPLOTQF.;
  Attrib CIGRLOTQ Label = "About how long has it been since you completely quit smoking cigars, cigarillos or little filtered cigars? (years, former cigar smokers)" Format=OTPLOTQF.;
  Attrib HOOKLOTQ Label = "About how long has it been since you completely quit smoking a water or hookah pipe filled with tobacco? (years, former hookah smokers)" Format=OTPLOTQF.;
  Attrib SMKLLOTQ Label = "About how long has it been since you completely quit using smokeless tobacco? (years, former smokeless users)" Format=OTPLOTQF.;
  Attrib ECIGLOTQ Label = "About how long has it been since you completely quit using e-cigarettes? (years, former e-cigarette users)" Format=OTPLOTQF.;
  Attrib PIPEYRS  Label = "In total, how many years (have you smoked/did you smoke) a regular pipe filled with tobacco? (ever pipe smokers)" Format=OTPYrsF.;
  Attrib CIGRYRS  Label = "In total, how many years (have you smoked/did you smoke) cigars or cigarillos or little filtered cigars? (ever cigar smokers)" Format=OTPYrsF.;
  Attrib HOOKYRS  Label = "In total, how many years (have you smoked/did you smoke) a water or hookah pipe filled with tobacco? (ever hookah smokers)" Format=OTPYrsF.;
  Attrib SMKLYRS  Label = "In total, how many years (have you used/did you use) smokeless tobacco? (ever smokeless users)" Format=OTPYrsF.;
  Attrib ECIGYRS  Label = "In total, how many years (have you used/did you use) e-cigarettes? (ever e-cigarette users)" Format=OTPYrsF.;
  Attrib CIGRTYPE Label = "During the past 30 days, what type of cigar did you use most often?" Format=CIGRTYPF.;  
  Attrib CIGRFLVR Label = "When you smoke a cigar is it usually flavored?" Format=OTPFlvF.;
  Attrib PIPEFLVR Label = "When you smoke a regular pipe filled with tobacco is it usually flavored?" Format=OTPFlvF.;
  Attrib HOOKFLVR Label = "When you smoke a water/hookah pipe filled with tobacco is it usually flavored" Format=OTPFlvF.;
  Attrib SMKLFLVR Label = "When you use smokeless tobacco is it usually flavored" Format=OTPFlvF.;
  Attrib ECIGFLVR Label = "When you use an e-cigarette is it usually flavored?" Format=OTPFlvF.;  
  Attrib ECIGBRDG Label = "Do you use e-cigarettes because you can use them at times when or in places where smoking cigarettes isn't allowed?" Format=OTPBrdgF.;
  Attrib ECIGTOQT Label = "Do you use e-cigarettes to help you quit smoking cigarettes?" Format=OTPQTF.;  
  Attrib ECIGTYPE Label = "Which of the following best describes the type of e-cigarette you currently use?" Format=ECIGTYPF.;
  Attrib BUYECIG Label = "Do you usually buy your own {e-cigarettes / e-cigarette <pods or> cartridges / e-liquid}? (current users)" Format=BuyEcigF.;
  Attrib BUYPKECG Label = "Do you usually buy {e-cigarettes/e-cigarette <pods or> cartridges/bottles of e-liquid} by the box or pack, or as {single e-cigarettes/single e-cigarette <pods or> cartridges/a single bottle of e-liquid}?" Format=BUYPKECF.;  
  Attrib PRCEBOX Label = "What price did you pay for the LAST BOX OR PACK of {e-cigarettes / e-cigarette <pods or> cartridges / bottles of e-liquid} you bought? (current users)";
  Attrib NUMECIGS Label = "How many {e-cigarettes / e-cigarette <pods or> cartridges / bottles of e-liquid} came in the LAST BOX OR PACK you bought? (current users)" Format=NUMECIGF.;
  Attrib PRCESNGL Label = "What price did you pay for the LAST {e-cigarette / e-cigarette <pod or> cartridge / bottle of e-liquid} you bought? (current users)" Format=PRCESNGF.;
  Attrib ECIGVOL Label = "How many MILLILITERS of liquid were in a SINGLE bottle you LAST bought? (current users)" Format=ECIGVOLF.;
  Attrib FMECIGBR Label = "Did you use e-cigarettes because you could use them at times when or in places where smoking cigarettes wasn't allowed?" Format=OTPBrdgF.;
  Attrib FMECIGQT Label = "Did you use e-cigarettes to help you quit smoking cigarettes?" Format=OTPQTF.;
  Attrib TTFOTP   Label = "Time to first other tobacco product, minutes (current users)" Format=TTFOTPF.;
  Attrib TTFOTP30 Label = "Use first other tobacco product of the day within first 30 minutes (current users)" Format=TTFO30F.;
  Attrib FMTTFOTP Label = "In the 12 months before you quit, time to first other tobacco product, minutes (former users)" Format=FMTTFOTF.;
  Attrib FMTTFO30 Label = "In the 12 months before you quit, use first other tobacco product of the day within first 30 minutes (former users)" Format=FMTTFO3F.;
  Attrib PYSTPOTP Label = "During the past 12 months, have you stopped using other tobacco product for one day or longer because you were trying to quit? (every day and some days >11 users)" Format=PYSTPOTF.;
  Attrib PYLTOTP  Label = "During the past 12 months, what is the longest length of time you stopped using other tobacco product because you were trying to quit? (every day and some days >11 users, number of months)" Format=PYLTOTPF.;
  Attrib WKAREA92 Label = "Which of these best describes the area in which you work most of the time? (1992-2002 only)" Format=WKAREA9F.;
  Attrib WKAREA03 Label = "Which of these best describes the area in which you work most of the time? (2003-2007 only)" Format=WKAREA0F.;
  Attrib WKINDPLC Label = "Indoor place mainly work (2003-2007 only)" Format=WKINDPLF.;
  Attrib WKSTATE  Label = "In which state, do you work on your main job or business (2003-2007 only)" Format=WKSTATEF.;
  Attrib WKAREA10 Label = "Do you mainly work indoors or outdoors? (2010 and later)" Format=WKAREA1F.;
  Attrib WKINDPL1 Label = "Indoor place mainly work (2010 and later)" Format=WKINDPLF.;
  Attrib WKSTATE1 Label = "In which state do you work (2010 and later)" Format=WKSTATEF.;
  Attrib WKINDPL2 Label = "Indoor place mainly work (2010 and later)" Format=WKINDPLF.;
  Attrib WKSTATE2 Label = "In which state do you work on your main indoor job or business (2010 and later)" Format=WKSTATEF.;
  Attrib WKPOLICY Label = "Does your place of work have an official policy that restricts smoking in any way?" Format=WKPOLICF.;
  Attrib WKPOLIND Label = "Smoking policy for indoor public or common areas such as lobbies, rest rooms and lunch rooms" Format=WKPOLINF.;
  Attrib WKPOLWRK Label = "Smoking policy for work areas" Format=WKPOLWRF.;
  Attrib WORKBAN  Label = "Smoking policy at work (constructed)" Format=WORKBANF.;
  Attrib WKSTPSMK Label = "Within the past 12 months, has your employer offered any stop smoking program or help to quit smoking" Format=WKSTPSMF.;
  Attrib WKSMK2WK Label = "During the past two weeks has anyone smoked in the area in which you work?" Format=WKSMK2WF.;
  Attrib WKPOLECG Label = "Which of these best describes the vaping or e-cigarette policy at your place of work for INDOOR PUBLIC OR COMMON AREAS AND INDOOR WORK AREAS? (2018 and later)" Format=WKPOLECF.;
  Attrib WKSMK2EC Label = "During the PAST TWO WEEKS, has anyone vaped or used e-cigarettes in the area in which you work?" Format=WKSMK2EF.;
  Attrib ATSMKRST Label = "In restaurants, do you think that smoking should be:" Format=ATSMKF.;
  Attrib ATSMKHSP Label = "In hospitals, do you think that smoking should be:" Format=ATSMKF.;
  Attrib ATSMKIWA Label = "In indoor work areas, do you think that smoking should be:" Format=ATSMKF.;
  Attrib ATSMKBAR Label = "In bars and cocktail lounges (and clubs), do you think that smoking should be:" Format=ATSMKF.;
  Attrib ATSMKISP Label = "In indoor sporting events, do you think that smoking should be:" Format=ATSMKF.;
  Attrib ATSMKISM Label = "In indoor shopping malls, do you think that smoking should be:" Format=ATSMKF.;
  Attrib ATSMKPLY Label = "On outdoor children's - playgrounds and sports fields, do you think that smoking should be:" Format=ATSMKF.;
  Attrib ATSMKCAS Label = "Inside casinos, do you think that smoking should be:" Format=ATSMCASF.;
  Attrib ATSMCARO Label = "Inside a car, when there are other people present, do you think that smoking should..." Format=ATSMCARF.;
  Attrib ATSMCARC Label = "If children are present inside the car, do you think that smoking should..." Format=ATSMCARF.;
  Attrib HMSMKPOL Label = "Home smoking rules" Format=HMSMKPOF.;
  Attrib HMECGPOL Label = "Which statement best describes the rules about vaping or using e-cigarettes INSIDE YOUR HOME?" Format=HMECGPOF.;  
  Attrib MUHSMPOL Label = "In buildings with multiple apartments or living areas, do you think that smoking should be: " Format=MUHSMPOF.;
  Attrib ATMINBUY Label = "In your opinion, how easy is it for minors to buy cigarettes and other tobacco products in your community?" Format=ATMINBUF.;
  Attrib ATSAMPLE Label = "Do you think that giving away free sample by tobacco companies should be:" Format=ATSAMPLF.;
  Attrib ATTOBADV Label = "Do you think advertising of tobacco products should be:" Format=ATTOBADF.;   
  Attrib SRWeight Label = "Self Response Weight";
Run;

Proc Contents Data=MyLib.Harmon VarNum;
  Title1 "Tobacco Use Supplement to the Current Population Survey";
  Title2 "Harmonized Data File: harmonzd.tus_cps.1992.through.2023.dat";    
Run;
